﻿Type clsControl       '控件类
   nHwnd As hWnd       '句柄
   IDC  As Long        '本控件的IDC 号 从 1001 开始，每创建1个控件就 +1
   nName As String         '控件名称，代码中使用
   Caption As String        '窗口文字 utf8编码
   Font As String       '字体，Utf8 格式 ，控件中绘制文本的字体，格式为：字体,字号,加粗,斜体,下划线,删除线  中间用英文豆号分割，可以省略参数 默认为：宋体,9,0,0,0,0  自动响应系统DPI创建字体大小。
   ControlName As String   '控件类型名称
   IsTab As Long        '是不是允许使用Tab
   Index As Long =-1       '控件数组索引，小于零表示非控件数组
   nLeft As Long
   nTop As Long
   nWidth As Long
   nHeight As Long
   ForeColor As Long =&H197F7F7F        '保存颜色值，事件里用，格式：&H01020304  02.03.04为7F时，01值0到30是系统色（25为不使用）其它时候是A通道，GDI+需要 02 04 里值对调
   BackColor  As Long =&H197F7F7F        '保存颜色值，事件里用，格式：&H01020304  02.03.04为7F时，01值0到30是系统色（25为不使用）其它时候是A通道，GDI+需要 02 04 里值对调
   ForeColorHot As Long =&H197F7F7F  '热点字色 格式：&H01020304  02.03.04为7F时，01值0到30是系统色（25为不使用）其它时候是A通道，GDI+需要 02 04 里值对调
   BackColorHot As Long =&H197F7F7F' 热点底色 格式：&H01020304  02.03.04为7F时，01值0到30是系统色（25为不使用）其它时候是A通道，GDI+需要 02 04 里值对调
   Style As UInteger  '     '样式，主要用于虚拟控件，各个控件定义不同
   cTi As Long   '控件对应 控件工具箱索引
   pValue(1 To 100) As String    '控件属性属性值 utf8编码，为了支持大字符
   IsSelected As Long   '是不是被多选中，副的选中
End Type
Type ColProType '控件属性类
   sName  As String   '属性英文名称
   uName As String    '名称，大写，用来不区分大小写对比查找
   zName As String    '属性中文名称
   sHelp As String   '帮助文档
   Default As String '默认值 ，新建控件用
   AllList As String '所有值，提供选择
   nType As Long     '类型，0：数字 1：文本 2：选择 3：颜色 4：字体 5：图像 6：图标
End Type
Type ColEventType '控件事件
   sName As String '事件英文名称
   uName As String '名称，大写，用来不区分大小写对比查找
   Param As String '参数表，带前后 () 和返回类型
   sHelp As String '注解或帮助文档
   tMsg As String  '消息值（在控件DLL中识辨处理用）在 CODE_FORM 模板中要替换的目标 {目标}
   gCall As String  '调用事件代码，要代替的代码，其中 {$1} 是事件合成名称，必须由IDE合成后替换
   nNew As String  '新建事件时插入的代码
End Type
Type ColToolType '控件工具
   sName  As String   '名称，大小写
   uName As String    '名称，大写，用来不区分大小写对比查找
   sTips As String   '鼠标提示，在控件显示区提示用
   Folder As String  '控件配置文件夹名，不带路径。路径固定为：app.path + Languages\语言\Control
   ClassFile As String '控件类文件名，在 Folder 文件夹里的类声明文件名
   sVale As Long   '字体图标值，在控件显示区显示用
   Feature As Long '特征 =0 不使用 =1 主窗口 =2 普通控件  =3 虚拟控件有界面 =4 虚拟控件无界面
   Only As Long      '是否是唯一的，就是一个窗口只能有1个此控件
   ProList(1 To 100) As ColProType '最多100个属性
   plU As Long  '属性个数
   EveList(1 To 100) As ColEventType '最多100个事件
   elU As Long  '事件个数
   library As Any Ptr '处理 DLL 模块地址
   initialization As Sub()
   Edit_ControlPropertyAlter As Function(hWndForm As hWnd, hWndList As hWnd, nType As Long, value As String, default As String, AllList As String) As String
   Edit_AddControls As Function(cw As CWindow Ptr,hParent AS HWND,cID As ULong ,Caption As CWSTR, x As Long, y As Long, w As Long, h As Long,WndProc As Any Ptr) As HWND
   Edit_SetControlProperty As Function(Control As Any Ptr ,ColTool As ColToolType Ptr, nFile As String, ki As Long) As Long
   Edit_OnPaint As Function(gg As yGDI,Control As Any Ptr,ColTool As ColToolType Ptr,WinCc As Long,nFile As String  ) as Long  '描绘控件
   Compile_ExplainControl As Function(Control As  Any Ptr, ColTool As ColToolType Ptr, ProWinCode As String, ussl() As String, ByRef IDC As Long, DECLARESdim As String, Form_clName as String, nFile As String) as Long '创建控件
End Type

Dim Shared GetWinFontLog As Function(mFont As String) As hFont
Dim Shared IsEventComparison As Function(Control As clsControl, ColTool As ColToolType, ii As Long,ff As Long,nFile As String, aa As String,Form_clName As String ) As Long
Dim Shared SetTextStyleVale As Sub(Control As clsControl, ColTool As ColToolType, ki As Long, i As Long, vv As String, tTy As String)
Dim Shared GetColToolProIndex As Function(ColTool As ColToolType, proName As String) As Long
Dim Shared TextAddWindowStyle As Function(tStyle As String, aStyle As String) As String
Dim Shared TextRemoveWindowStyle As Function(tStyle As String, rStyle As String) As String 
Dim Shared GetColorText As Function(nText As String) As Long  
Dim Shared GetColorTextCode As Function(nText As String) As String   
Dim Shared IsStyleAllON As Function(AllStyle As String, cStyle As String) As Long   
Dim Shared IsStyleAllOFF As Function(AllStyle As String, cStyle As String) As Long    
Dim Shared GetStyleValeOR As Function(sNameOR As String, EX As Long = 0) As UInteger    
Dim Shared GetStyleOR As Function(sNameOR As String, EX As Long = 0) As String     
Dim Shared Insert_code As Sub(ProWinCode As String, mark As String, InCode As String,Eline As Long =0)      
Dim Shared ExplainControlPublic As Function(Form_clName As String, Control As clsControl, clName As String,ii As Long ,uName As String,clType As Long ,clStyle as String ,clExStyle As String , clPro As String, VIRTUAL_CONTROL_EVENTS As String) As Long 

Sub initialization() Export '初始化
   '当 VFB5 主软件加载本DLL后，主动调用一下此函数，可以在此做初始化代码
   Dim library As Any Ptr = GetModuleHandle(null) 'EXE 模块句柄
   GetWinFontLog = DyLibSymbol(library, "GETWINFONTLOG") '有没有存在样式，需要全部都没有才成立，返回非0，
   IsEventComparison = DyLibSymbol(library, "ISEVENTCOMPARISON") '有没有存在样式，需要全部都没有才成立，返回非0，
   SetTextStyleVale = DyLibSymbol(library, "SETTEXTSTYLEVALEEX") '修改文本样式值
   GetColToolProIndex = DyLibSymbol(library, "GETCOLTOOLPROINDEXEX") '获取控件工具箱上属性名称对应的索引
   TextAddWindowStyle = DyLibSymbol(library, "TEXTADDWINDOWSTYLE") '给文本样式列表中增加样式
   TextRemoveWindowStyle = DyLibSymbol(library, "TEXTREMOVEWINDOWSTYLE") '移除文本样式列表中的样式
   GetColorText = DyLibSymbol(library, "GETCOLORTEXT") '样式符合，转换为颜色值,系统色为 SYS,1
   GetColorTextCode = DyLibSymbol(library, "GETCOLORTEXTCODE") '转换字符样式为代码
   IsStyleAllON = DyLibSymbol(library, "ISSTYLEALLON") '有没有存在样式，需要全部都有才成立，返回非0，
   IsStyleAllOFF = DyLibSymbol(library, "ISSTYLEALLOFF") '有没有存在样式，需要全部都没有才成立，返回非0，
   GetStyleValeOR = DyLibSymbol(library, "GETSTYLEVALEOR") '获取所有样式值组合,EX=0 所有 =1 扩展 =2非扩展
   GetStyleOR = DyLibSymbol(library, "GETSTYLEOR") '获取所有样式值组合,EX=0 所有 =1 扩展 =2非扩展
   Insert_code = DyLibSymbol(library, "INSERT_CODE") '插入代码
   ExplainControlPublic = DyLibSymbol(library, "EXPLAINCONTROLPUBLIC") ''处理公共部分，已处理返回0，未处理返回非0
   
   
End Sub


Function Edit_AddControls(cw As CWindow Ptr,hParent AS HWND,IDC As ULong ,Caption As CWSTR, x As Long, y As Long, w As Long, h As Long,WndProc As Any Ptr) As HWND Export '增加1个控件 
   '编辑：窗口刚被打开，需要新建，返回新建后的控件窗口句柄
   'cw      基于CWindow创建，这是当前窗口的 CWindow 指针
   'hParent 父窗口句柄
   'IDC     控件IDC号
   'Caption 控件标题
   'xywh    位置
   'WndProc 主窗口处理消息的函数地址(窗口消息回调函数)

   Function = cw->AddControl("LABEL", hParent, IDC, Caption, x, y, w, h, WS_CHILD, , , WndProc)

End Function

Function Edit_SetControlProperty(ByRef Control As clsControl, ByRef ColTool As ColToolType, nFile As String, ki As Long) As Long Export '设置控件属性
   '编辑：新创建控件、修改控件属性后，都调用1次
   'Control  窗口中的控件
   'ColTool  当前控件配置和属性
   'nFile    当前工程主文件名，带文件夹，用来提取路径用。
   'ki       被修改的属性索引，=0为全部
   Dim hWndControl As hWnd = Control.nHwnd
   Dim vv As String, cvv As CWSTR, i As Long
   
   For i = 1 To ColTool.plU
      vv = Control.pValue(i) '值是 Utf8 格式
      cvv.UTF8 = YF_Replace(vv, Chr(3, 1), vbCrLf)
      '先设置通用部分
      Select Case ColTool.ProList(i).uName
         Case "CAPTION"
            if ColTool.uName <> "STATUSBAR" Then
               SetWindowTextW hWndControl, cvv.vptr
            End if
            Control.Caption = YF_Replace(vv, Chr(3, 1), vbCrLf)
         Case "ENABLED"
            
         Case "VISIBLE"
            
         Case "ICON"
            Dim pa As String = FF_FilePath(nFile)
            Dim svv As String, fvv As Long = InStr(vv, "|")
            if fvv = 0 Then svv = vv Else svv = Left(vv, fvv -1)
            Dim hIcon As HICON = LoadImage(Null, pa & "images\" & Utf8toStr(svv), IMAGE_ICON, 0, 0, LR_DEFAULTSIZE Or LR_LOADFROMFILE)
            If hIcon Then
               hIcon = AfxSetWindowIcon(hWndControl, ICON_SMALL, hIcon)
               If hIcon Then DestroyIcon(hIcon)
            End If
         Case "LEFT"
            'If ci > 0 Then  '只有控件才设置，主窗口不设置
            'Control.nLeft = ValInt(vv)
            'FF_Control_SetLoc hWndControl, AfxScaleX(Control.nLeft), AfxScaleY(Control.nTop)
            'End If
         Case "TOP"   '只有控件才设置，主窗口不设置
            'If ci > 0 Then
            'Control.nTop = ValInt(vv)
            'FF_Control_SetLoc hWndControl, AfxScaleX(Control.nLeft), AfxScaleY(Control.nTop)
            'End If
         Case "WIDTH"
            If ki = i And ColTool.Feature <> 4 Then
               Control.nWidth = ValInt(vv)
               FF_Control_SetSize hWndControl, AfxScaleX(Control.nWidth), AfxScaleY(Control.nHeight)
            End If
         Case "HEIGHT"
            If ki = i And ColTool.Feature <> 4 Then
               Control.nHeight = ValInt(vv)
               FF_Control_SetSize hWndControl, AfxScaleX(Control.nWidth), AfxScaleY(Control.nHeight)
            End If
         Case "CHILD"
         Case "MOUSEPOINTER"
         Case "FORECOLOR"
            Control.ForeColor = GetColorText(vv)
         Case "BACKCOLOR"
            Control.BackColor = GetColorText(vv)
         Case "TAG"
         Case "TAB"
         Case "ACCEPTFILES"
         Case "INDEX"
         Case "FONT"
            Dim tFont As HFONT = GetWinFontLog(vv)
            SendMessage hWndControl, WM_SETFONT, Cast(wParam, tFont), True
            Control.Font = vv
         Case "TOOLTIPBALLOON"
         Case "TOOLTIP"
'==============     以上是公共设置，下面是每个控件私有设置    =================   
         Case "FORECOLORHOT"
         Case "BACKCOLORHOT"
         Case "TEXTALIGN"
            Dim sy As UInteger = ValUInt(vv)
            Control.Style = (Control.Style And &HFF00FFFF) Or (sy Shl 16)
         Case "STYLE"
            Dim sy As UInteger = ValUInt(vv)
            Control.Style = (Control.Style And &H00FFFFFF) Or (sy Shl 24)
         Case "PREFIX"
            If UCase(vv) = "TRUE" Then Control.Style Or= &H4 Else Control.Style And= Not &H4
         Case "ELLIPSIS"
            If UCase(vv) = "TRUE" Then Control.Style Or= &H8 Else Control.Style And= Not &H8
         Case "ENABLED"
            If UCase(vv) = "TRUE" Then Control.Style Or= &H1 Else Control.Style And= Not &H1
         Case "VISIBLE"
            If UCase(vv) = "TRUE" Then Control.Style Or= &H2 Else Control.Style And= Not &H2
      End Select
   Next
   Function = 0
End Function
Type StyleFormType
   hWndForm As hWnd
   hWndList As hWnd
   nType As Long
   value As String Ptr
   default As String Ptr 
   AllList As String Ptr 
   Rvalue As String    '返回值
End Type 

Function Edit_ControlPropertyAlter(hWndForm As hWnd, hWndList As hWnd, nType As Long, value As String, default As String, AllList As String) As String Export  ' 控件属性修改
   '编辑：用户点击窗口属性，修改属性时，1--6由EXE处理，7 或其它由本DLL处理
   'hWndForm   EXE 主窗口句柄
   'hWndList   控件属性显示窗口句柄（是List控件）
   'nType      类型，由 Attribute.ini 里设置，7 或其它由本DLL处理
   'value      当前的值
   'default    默认值，由 Attribute.ini 里设置
   'AllList    所有值，由 Attribute.ini 里设置
   Select Case nType  '这里根据需要编写
      Case 7
         Dim aa As StyleFormType
'         aa.hWndForm = hWndForm
'         aa.hWndList = hWndList
'         aa.nType = nType
'         aa.value = @value
'         aa.default = @default
'         aa.AllList = @AllList
'         aa.Rvalue = value
'         StyleForm.Show hWndForm, True, Cast(Integer, @aa)
         Function = aa.Rvalue
   End Select
End Function
Function Edit_OnPaint(gg As yGDI, Control As clsControl, ColTool As ColToolType, WinCc As Long, nFile As String) as Long Export '描绘控件
   '编辑：当被刷新窗口，需要重绘控件时，窗口和实控件由系统绘画，不需要我们在这里处理，虚拟控件必须由此画出来。
   'gg    目标， 画在这个缓冲里。
   'Control  窗口中的控件
   'ColTool  当前控件配置和属性
   'WinCc    主窗口底色，不是本控件底色
   'nFile    当前工程主文件名，带文件夹，用来提取路径用。
   '返回非0  将会立即结束描绘操作，就是在此之后的控件就不会画了。按照最底层的控件先画。
   
   '样式结构：&H01020304  01主样式 02对齐 03 04 选项 &H1=允许 &H2=显示 &H4=前缀 &H8=省略号
   Dim cc As Long ,p As Long 
   cc = GetCodeColorGDIplue(Control.BackColor)
   gg.gpBrush cc
   
   cc = GetCodeColorGDIplue(Control.ForeColor)
   If ((Control.Style And &HFF000000) Shr 24) = 1 Then
      gg.GpPen 1, cc
   Else
      gg.GpPen 0
   End If
   gg.gpDrawFrame Control.nLeft, Control.nTop, Control.nWidth, Control.nHeight
   
   cc = GetCodeColorGDI(Control.ForeColor)
   If cc <> -1 Then gg.SetColor cc
   Dim wszText As CWStr
   wszText.UTF8 = Control.Caption
   
   'Windows使用带有dt_wordbreak和dt_expandtabs参数的drawtext绘制带有ss_left、cc_center和ss_right样式的标签。其他样式必须使用dt_单线，而不是换行。
   Dim As Long lWrapMode = DT_SINGLELINE
   Dim As Long lFormat
   
   Select Case (Control.Style And &H00FF0000) Shr 16
      Case 7 '下居中
         lFormat = DT_CENTER Or DT_BOTTOM
      Case 6 '下左对齐
         lFormat = DT_LEFT Or DT_BOTTOM
      Case 8 ' 下右对齐
         lFormat = DT_RIGHT Or DT_BOTTOM
      Case 4 '置中
         lFormat = DT_CENTER Or DT_VCENTER
      Case 3 '中左对齐
         lFormat = DT_LEFT Or DT_VCENTER
      Case 5 '中右对齐
         lFormat = DT_RIGHT Or DT_VCENTER
      Case 1 '居中
         lFormat = DT_CENTER Or DT_TOP
         lWrapMode = DT_WORDBREAK
      Case 0 ' 左对齐
         lFormat = DT_LEFT Or DT_TOP
         lWrapMode = DT_WORDBREAK
      Case 2 '右对齐
         lFormat = DT_RIGHT Or DT_TOP
         lWrapMode = DT_WORDBREAK
   End Select
   If (Control.Style And &H4) = 0 Then lFormat Or= DT_NOPREFIX
   If (Control.Style And &H8) Then lFormat Or= DT_WORD_ELLIPSIS
   lFormat = lFormat Or lWrapMode Or DT_EXPANDTABS
   Dim evv() As String
   vbSplit(Utf8toStr(Control.Font), ",", evv())
   ReDim Preserve evv(5)
   evv(0) = YF_Replace(evv(0), "微软雅黑", "Microsoft YaHei")  '为了在英文系统中可以正常显示，必须把中文字体名换英文
   evv(0) = YF_Replace(evv(0), "宋体", "SimSun")
   evv(0) = YF_Replace(evv(0), "黑体", "SimHei")
   evv(0) = YF_Replace(evv(0), "新宋体", "NSimSun")
   evv(0) = YF_Replace(evv(0), "仿宋", "FangSong")
   evv(0) = YF_Replace(evv(0), "楷体", "KaiTi")
   evv(0) = YF_Replace(evv(0), "微软正黑", "Microsoft JhengHei")
   evv(0) = YF_Replace(evv(0), "隶书", "LiSu")
   evv(0) = YF_Replace(evv(0), "幼圆", "YouYuan")
   evv(0) = YF_Replace(evv(0), "华文细黑", "STXihei")
   evv(0) = YF_Replace(evv(0), "华文行楷", "STXingkai")
   evv(0) = YF_Replace(evv(0), "华文新魏", "STXinwei")      '已经尽力了，其它字体就无法预料了。
   gg.Font evv(0), ValInt(evv(1)), ValInt(evv(2)), ValInt(evv(3)), ValInt(evv(4)), ValInt(evv(5))
   gg.DrawTextS Control.nLeft, Control.nTop, Control.nWidth, Control.nHeight, wszText, lFormat
   
   Function = 0
End Function
Function Compile_ExplainControl(Control As clsControl, ColTool As ColToolType, ProWinCode As String, ussl() As String, ByRef IDC As Long, DECLARESdim As String, Form_clName as String, nFile As String) as Long Export '解释控件，制造创建控件和事件的代码
   '编译：解释控件 ，注意：编译处理字符全部为 UTF8 编码。Control和ColTool里的是 A字符。
   'Control      窗口中的控件
   'ColTool      当前控件配置和属性
   'ProWinCode   处理后的窗口代码，最初由窗口加载窗口模板处理，然后分发给其它控件。填充处理
   'ussl()       已特殊处理过的用户写的窗口代码，主要用来识辨事件
   'IDC          控件IDC，每个控件唯一，VFB自动累计1，我们代码也可以累计
   'DECLARESdim  全局变量定义，整个工程的定义都在此处
   'Form_clName  主窗口类名，最初由窗口设置，方便后面控件使用。
   'nFile        窗口文件名，用在事件调用注释，出错时可以提示源文件地方，避免提示临时文件。
   
   
   '创建控件 ------------------------------
   Dim ii As Long
   Dim As String clClName,clName,clStyle,clExStyle,clPro
   Dim VIRTUAL_CONTROL_EVENTS As String = vbCrLf '虚拟控件事件
   Dim As Long clType '为了解释代码里用，>=100 为虚拟控件  100=LABEL 1=TEXT
   clName = StrToUtf8(Control.nName)
   If Control.Index > -1 Then clName &= "(" & Control.Index & ")"
   clClName = "LABEL"
   clType = 100
   
   For ii = 1 To ColTool.plU
      if ExplainControlPublic(Form_clName, Control, clName, ii, ColTool.ProList(ii).uName, clType, clStyle, clExStyle, clPro, VIRTUAL_CONTROL_EVENTS) Then '处理公共部分，已处理返回0，未处理返回非0
         Select Case ColTool.ProList(ii).uName
               'Case "NAME"  '名称\1\用来代码中识别对象的名称
               'Case "INDEX"  '数组索引\0\控件数组中的控件位置的索引数字。值小于零表示不是控件数组
               'Case "CAPTION"  '文本\1\显示的文本\Label\
               'Case "TEXT"  '文本\1\显示的文本\Label\
               'Case "ENABLED"  '允许\2\创建控件时最初是否允许操作。\True\True,False
               'Case "VISIBLE"  '显示\2\创建控件时最初是显示或隐藏。\True\True,False
               'Case "FORECOLOR"  '文字色\3\用于在对象中显示文本和图形的前景色。\SYS,8\
               'Case "BACKCOLOR"  '背景色\3\用于在对象中显示文本和图形的背景色。\SYS,15\
               'Case "FONT"  '字体\4\用于此对象的文本字体。\微软雅黑,9,0\
               'Case "LEFT"  '位置X\0\左边缘和父窗口的左边缘之间的距离。自动响应DPI缩放\0\
               'Case "TOP"  '位置Y\0\内部上边缘和父窗口的顶部边缘之间的距离。自动响应DPI缩放\0\
               'Case "WIDTH"  '宽度\0\窗口宽度，100%DPI时的像素单位，自动响应DPI缩放。\100\
               'Case "HEIGHT"  '高度\0\窗口高度，100%DPI时的像素单位，自动响应DPI缩放。\20\
               'Case "LAYOUT"
               'Case "MOUSEPOINTER"  '鼠标指针\2\鼠标在窗口上的形状\0 - 默认\0 - 默认,1 - 后台运行,2 - 标准箭头,3 - 十字光标,4 - 箭头和问号,5 - 文本工字光标,6 - 不可用禁止圈,7 - 移动,8 - 双箭头↙↗,9 - 双箭头↑↓,10 - 双箭头向↖↘,11 - 双箭头←→,12 - 垂直箭头,13 - 沙漏,14 - 手型
               'Case "TAG"  '附加\1\私有自定义文本与控件关联。\\
               'Case "TAB"  '导航\2\当用户按下TAB键时可以接收键盘焦点。\False\True,False
               'Case "TOOLTIP"  '提示\1\一个提示，当鼠标光标悬停在控件时显示它。\\
               'Case "TOOLTIPBALLOON"  '气球样式\2\一个气球样式显示工具提示。\False\True,False
               'Case "ACCEPTFILES"  '拖放\2\窗口是否接受拖放文件。\False\True,False
               '==============     以上是公共设置，下面是每个控件私有设置    =================
            Case "STYLE"  '样式\2\指示控件边界的外观和行为。\0 - 无边框\0 - 无边框,1 - 细边框,2 - 半边框,3 - 凹边框,4 - 凸边框
               Dim sy As UInteger = ValUInt(Control.pValue(ii))
               clPro &= "      fp->Style = (fp->Style And &H00FFFFFF) Or (Cast(UInteger," & sy & ") Shl 24)" & vbCrLf
            Case "TEXTALIGN"  '对齐\2\将在控件上显示的文本的对齐方式。\0 - 左对齐\0 - 左对齐,1 - 居中,2 - 右对齐,3 - 中左对齐,4 - 置中,5 - 中右对齐,6 - 下左对齐,7 - 下居中,8 - 下右对齐
               Dim sy As UInteger = ValUInt(Control.pValue(ii))
               If sy > 8 Then sy = 8
               clPro &= "      fp->Style = (fp->Style And &HFF00FFFF) Or (Cast(UInteger," & sy & ") Shl 16)" & vbCrLf
            Case "PREFIX"
               If UCase(Control.pValue(ii)) = "TRUE" Then clPro &= "      fp->Style Or= &H4 " & vbCrLf Else clPro &= "      fp->Style And= Not &H4 " & vbCrLf
            Case "ELLIPSIS"
               If UCase(Control.pValue(ii)) = "TRUE" Then clPro &= "      fp->Style Or= &H8 " & vbCrLf Else clPro &= "      fp->Style And= Not &H8 " & vbCrLf
         End Select
      End if
   Next
   
   '当主窗口销毁，通知每个控件类（包括虚拟控件），做必要的卸载工作，因为窗口类是全局的，不会因为窗口销毁而销毁。
   Insert_code(ProWinCode, "'[CALL_WM_DESTROY]", _
      "            " & Form_clName & "." & clName & ".hWndForm = hWndForm" & vbCrLf & _
      "            " & Form_clName & "." & clName & ".Destructor")
   
   
   Dim CONTROL_CODExx As String
   If clType < 100 Then
      '真实控件========
      CONTROL_CODExx &= "   hWndControl = pWindow->AddControl(""" & clClName & """, hWnd, " & IDC & ", """ & YF_Replace(Control.Caption, Chr(34), Chr(34, 34)) & """, " & _
         Control.nLeft & ", " & Control.nTop & ", " & Control.nWidth & ", " & Control.nHeight & "," & YF_Replace(clStyle, ",", " Or ") & " ," & YF_Replace(clExStyle, ",", " Or ") & _
         " , , Cast(Any Ptr, @" & StrToUtf8(Form_clName) & "_CODEPROCEDURE))" & vbCrLf
      CONTROL_CODExx &= "   If hWndControl Then " & vbCrLf
      CONTROL_CODExx &= "      Dim fp As FormControlsPro_TYPE ptr = new FormControlsPro_TYPE" & vbCrLf
      CONTROL_CODExx &= "      vfb_Set_Control_Ptr(hWndControl,fp)" & vbCrLf
   Else
      '虚拟控件，直接画窗口的 ============
      CONTROL_CODExx &= "   fp->VrControls = new FormControlsPro_TYPE '" & StrToUtf8("创建虚拟控件链表") & vbCrLf
      CONTROL_CODExx &= "   fp = fp->VrControls" & vbCrLf
      CONTROL_CODExx &= "   If fp Then " & vbCrLf
      CONTROL_CODExx &= "      This." & clName & ".hWndForm = hWnd " & vbCrLf
   End If
   CONTROL_CODExx &= "      fp->hWndParent = hWnd" & vbCrLf
   CONTROL_CODExx &= "      fp->Index = " & Control.Index & vbCrLf
   CONTROL_CODExx &= "      fp->IDC = " & IDC & vbCrLf
   CONTROL_CODExx &= "      fp->nText = """ & YF_Replace(Control.Caption, Chr(34), Chr(34, 34)) & """" & vbCrLf
   CONTROL_CODExx &= "      fp->ControlType = " & clType & vbCrLf
   'If clType < 100 Then CONTROL_CODExx &= "      This." & clName & ".hWnd = hWndControl " & vbCrLf  '真实控件========
   CONTROL_CODExx &= "      This." & clName & ".IDC =" & IDC & vbCrLf
   '控件特殊设置=====
   Select Case ColTool.uName
      Case "WEBBROWSER"
         clPro = "      DIM pwb AS CWebCtx Ptr = This." & clName & ".Create(pWindow," & IDC & ", " & Control.nLeft & ", " & Control.nTop & ", " & Control.nWidth & ", " & Control.nHeight & "," & YF_Replace(clStyle, ",", " Or ") & " ," & YF_Replace(clExStyle, ",", " Or ") & ")" & vbCrLf & clPro
         For ii = 1 To ColTool.elU
            Dim sim As String '事件函数名组合
            sim = " " & StrToUtf8(UCase(Form_clName & "_" & Control.nName & "_" & ColTool.EveList(ii).sName)) & "("
            Dim ff As Long
            for fi As Long = 0 To UBound(ussl)
               If left(ussl(fi), 1) <> "'" AndAlso InStr(ussl(fi), sim) > 0 Then
                  ff = fi + 1
                  Exit for
               End If
            Next
            If ff > 0 Then
               if IsEventComparison(Control, ColTool, ii, ff, nFile, ussl(ff -1), Form_clName) Then Return 3 '检查事件是不是正确
               clPro &= "      pwb->" & ColTool.EveList(ii).gCall & "(""" & ColTool.EveList(ii).sName & """, @" & _
                  StrToUtf8(UCase(Form_clName & "_" & Control.nName & "_" & ColTool.EveList(ii).sName)) & ")" & vbCrLf
            end if
         Next
      Case "WININET", "SQLITE3"
         For ii = 1 To ColTool.elU
            Dim sim As String '事件函数名组合
            sim = " " & StrToUtf8(UCase(Form_clName & "_" & Control.nName & "_" & ColTool.EveList(ii).sName)) & "("
            Dim ff As Long
            for fi As Long = 0 To UBound(ussl)
               If left(ussl(fi), 1) <> "'" AndAlso InStr(ussl(fi), sim) > 0 Then
                  ff = fi + 1
                  Exit for
               End If
            Next
            If ff > 0 Then
               if IsEventComparison(Control, ColTool, ii, ff, nFile, ussl(ff -1), Form_clName) Then Return 3 '检查事件是不是正确
               clPro &= "      This." & clName & ".SetEventProc(""" & ColTool.EveList(ii).sName & """,@" & StrToUtf8(UCase(Form_clName & "_" & Control.nName & "_" & ColTool.EveList(ii).sName)) & ")" & vbCrLf
            end if
         Next
      Case "WINHOOK"
         For ii = 1 To ColTool.elU
            Dim sim As String '事件函数名组合
            sim = " " & StrToUtf8(UCase(Form_clName & "_" & Control.nName & "_" & ColTool.EveList(ii).sName)) & "("
            Dim ff As Long
            for fi As Long = 0 To UBound(ussl)
               If left(ussl(fi), 1) <> "'" AndAlso InStr(ussl(fi), sim) > 0 Then
                  ff = fi + 1
                  Exit for
               End If
            Next
            If ff > 0 Then
               if IsEventComparison(Control, ColTool, ii, ff, nFile, ussl(ff -1), Form_clName) Then Return 3 '检查事件是不是正确
               Dim pp As String, cp As String
               Select Case ColTool.EveList(ii).tMsg
                  Case "KEYBOARDPROC"
                     pp = "WH_KEYBOARD" : cp = "GetCurrentThreadId"
                  Case "LOWLEVELKEYBOARDPROC"
                     pp = "WH_KEYBOARD_LL" : cp = "0"
                  Case "MOUSEPROC"
                     pp = "WH_MOUSE" : cp = "GetCurrentThreadId"
                  Case "LOWLEVELMOUSEPROC"
                     pp = "WH_MOUSE_LL" : cp = "0"
                  Case "CALLWNDPROC"
                     pp = "WH_CALLWNDPROC" : cp = "GetCurrentThreadId"
                  Case "CALLWNDRETPROC"
                     pp = "WH_CALLWNDPROCRET" : cp = "GetCurrentThreadId"
                  Case "DEBUGPROC"
                     pp = "WH_DEBUG" : cp = "GetCurrentThreadId"
                  Case "FOREGROUNDIDLEPROC"
                     pp = "WH_FOREGROUNDIDLE" : cp = "GetCurrentThreadId"
                  Case "GETMSGPROC"
                     pp = "WH_GETMESSAGE" : cp = "GetCurrentThreadId"
                  Case "MESSAGEPROC"
                     pp = "WH_MSGFILTER" : cp = "GetCurrentThreadId"
                  Case "SHELLPROC"
                     pp = "WH_SHELL" : cp = "GetCurrentThreadId"
               End Select
               clPro &= "      This." & clName & ".sHook(" & pp & ")=SetWindowsHookEx(" & pp & ",Cast(Any Ptr,@" & StrToUtf8(UCase(Form_clName & "_" & Control.nName & "_" & ColTool.EveList(ii).sName)) & "),NULL," & cp & ")" & vbCrLf
            end if
         Next
   end Select
   CONTROL_CODExx &= clPro
   CONTROL_CODExx &= "   End IF" & vbCrLf
   if ColTool.uName = "TOPMENU" Then
      CONTROL_CODExx &= StrToUtf8("   .GetClientRect(hWnd, @rcParent) '加窗口菜单后引起客户区大小改变，必须重新获取") & vbCrLf & _
         "   rcParent.Right = AfxUnscaleX(rcParent.Right) " & vbCrLf & _
         "   rcParent.Bottom = AfxUnscaleX(rcParent.Bottom)" & vbCrLf
      Insert_code(ProWinCode, "'[Create control top]", CONTROL_CODExx)
   Else
      Insert_code(ProWinCode, "'[Create control]", CONTROL_CODExx)
      
   End if
   
   '事件处理 ------------------------------
   Dim LeaveHoverI As Long
   '控件事件
   Dim As Long MENUmin ,MENUmax '工具栏需要
   If clType < 100 Then  '真实控件事件
      For ii = 1 To ColTool.elU
         Dim sim As String '事件函数名组合
         sim = " " & StrToUtf8(UCase(Form_clName & "_" & Control.nName & "_" & ColTool.EveList(ii).sName)) & "("
         Dim ff As Long
         for fi As Long = 0 To UBound(ussl)
            If left(ussl(fi), 1) <> "'" AndAlso InStr(ussl(fi), sim) > 0 Then
               ff = fi + 1
               Exit for
            End If
         Next
         If ff > 0 Then
            if IsEventComparison(Control, ColTool, ii, ff, nFile, ussl(ff -1), Form_clName) Then Return 3 '检查事件是不是正确
            Select Case ColTool.EveList(ii).tMsg
               Case "STN_CLICKED", "STN_DBLCLK", "STN_DISABLE", "STN_ENABLE", "BN_CLICKED", "BN_KILLFOCUS", "BN_SETFOCUS", _
                     "EN_CHANGE", "EN_ERRSPACE", "EN_HSCROLL", "EN_KILLFOCUS", "EN_MAXTEXT", "EN_SETFOCUS", "EN_UPDATE", "EN_VSCROLL", _
                     "CBN_CLOSEUP", "CBN_DBLCLK", "CBN_DROPDOWN", "CBN_EDITCHANGE", "CBN_EDITUPDATE", "CBN_ERRSPACE", "CBN_KILLFOCUS", _
                     "CBN_SELCHANGE", "CBN_SELENDCANCEL", "CBN_SELENDOK", "CBN_SETFOCUS", "STN_CLICKED", "STN_DISABLE", _
                     "LBN_SELCHANGE", "LBN_DBLCLK", "LBN_ERRSPACE", "LBN_KILLFOCUS", "LBN_SELCANCEL", "LBN_SETFOCUS"
                  ProWinCode = YF_Replace(ProWinCode, "'{CONTROL_WM_COMMAND}", "         Dim As Long IDC =LoWord(wParam) ,CODE = HiWord(wParam)")
                  Dim CONTROL_WM_COMMAND As String = "          If IDC = " & IDC & " And CODE = " & ColTool.EveList(ii).tMsg & " Then  ' " & clName & vbCrLf
                  If Right(ColTool.EveList(ii).Param, 1) = ")" Then '是SUB
                     CONTROL_WM_COMMAND &= "             " & sim
                  Else
                     CONTROL_WM_COMMAND &= "              tLResult = " & sim
                  end if
                  If Control.Index > -1 Then CONTROL_WM_COMMAND &= Control.Index & ","
                  CONTROL_WM_COMMAND &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  If Right(ColTool.EveList(ii).Param, 1) <> ")" Then CONTROL_WM_COMMAND &= "            If tLResult Then Return tLResult" & vbCrLf
                  CONTROL_WM_COMMAND &= "           End If"
                  Insert_code(ProWinCode, "'[CONTROL_WM_COMMAND]", CONTROL_WM_COMMAND)
               Case "TCN_SELCHANGE", "TCN_KEYDOWN", "TCN_SELCHANGING", "UDN_DELTAPOS", _
                     "EN_CORRECTTEXT", "EN_DROPFILES", "EN_MSGFILTER", "EN_OLEOPFAILED", "EN_PROTECTED", "EN_REQUESTRESIZE", "EN_SAVECLIPBOARD", "EN_SELCHANGE", "EN_STOPNOUNDO", _
                     "LVN_BEGINDRAG", "LVN_BEGINLABELEDIT", "LVN_BEGINRDRAG", "LVN_COLUMNCLICK", "LVN_DELETEALLITEMS", "LVN_DELETEITEM", "LVN_ITEMACTIVATE", _
                     "LVN_ENDLABELEDIT", "LVN_GETDISPINFO", "LVN_INSERTITEM", "LVN_ITEMCHANGED", "LVN_ITEMCHANGING", "LVN_KEYDOWN", _
                     "TVN_BEGINDRAG", "TVN_BEGINLABELEDIT", "TVN_DELETEITEM", "TVN_ENDLABELEDIT", "TVN_GETDISPINFO", "TVN_ITEMEXPANDED", _
                     "TVN_ITEMEXPANDING", "TVN_KEYDOWN", "TVN_SELCHANGED", "TVN_SELCHANGING", "NM_CUSTOMDRAW", "NM_RELEASEDCAPTURE", "DTN_DATETIMECHANGE", _
                     "DTN_CLOSEUP", "DTN_DROPDOWN", "DTN_FORMAT", "DTN_FORMATQUERY", "DTN_USERSTRING", "DTN_WMKEYDOWN", "NM_KILLFOCUS", _
                     "NM_SETFOCUS", "MCN_SELCHANGE", "MCN_SELECT", "MCN_GETDAYSTATE", "MCN_VIEWCHANGE", "IPN_FIELDCHANGED", "TRBN_THUMBPOSCHANGING"
                  Dim CONTROLS_NOTIFY As String = "         If (FLY_pNotify->idFrom = " & IDC & ") And (FLY_pNotify->Code = " & ColTool.EveList(ii).tMsg & ") Then" & vbCrLf
                  If Right(ColTool.EveList(ii).Param, 1) = ")" Then '是SUB
                     CONTROLS_NOTIFY &= "             " & sim
                  Else
                     CONTROLS_NOTIFY &= "              tLResult = " & sim
                  end if
                  If Control.Index > -1 Then CONTROLS_NOTIFY &= Control.Index & ","
                  CONTROLS_NOTIFY &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  If Right(ColTool.EveList(ii).Param, 1) <> ")" Then CONTROLS_NOTIFY &= "            If tLResult Then Return tLResult" & vbCrLf
                  CONTROLS_NOTIFY &= "         End If"
                  Insert_code(ProWinCode, "'[CONTROLS_NOTIFY]", CONTROLS_NOTIFY)
               Case "TBN_DROPDOWN", "NM_CLICK", "NM_DBLCLK", "NM_RCLICK", "NM_RDBLCLK" '工具栏
                  Dim CONTROLS_NOTIFY As String = "         If (FLY_pNotify->idFrom = " & IDC & ") And (FLY_pNotify->Code = " & ColTool.EveList(ii).tMsg & ") Then" & vbCrLf
                  CONTROLS_NOTIFY &= "             tLResult = " & sim
                  If Control.Index > -1 Then CONTROLS_NOTIFY &= Control.Index & ","
                  CONTROLS_NOTIFY &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  CONTROLS_NOTIFY &= "            If tLResult Then Return tLResult" & vbCrLf
                  CONTROLS_NOTIFY &= "         End If"
                  Insert_code(ProWinCode, "'[CONTROLS_NOTIFY]", CONTROLS_NOTIFY)
               Case "WM_COMMAND" '目前就工具栏需要这个
                  Dim VIRTUAL_CONTROL_EVENTS As String = "   If wMsg = " & ColTool.EveList(ii).tMsg & " Then " & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "      Dim wID As ULong = LoWord(wParam)" & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "      If wID >= " & MENUmin & " And wID <= " & MENUmax & " Then" & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "         " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "        " & sim
                  If Control.Index > -1 Then VIRTUAL_CONTROL_EVENTS &= Control.Index & ","
                  VIRTUAL_CONTROL_EVENTS &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "      End If " & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "   End If " & vbCrLf
                  Insert_code(ProWinCode, "'[VIRTUAL_CONTROL_EVENTS]", VIRTUAL_CONTROL_EVENTS)
               Case "CUSTOM"
                  dim CALL_CONTROL_CUSTOM As String = "    If IDC = " & IDC & " Then  ' " & clName & vbCrLf
                  CALL_CONTROL_CUSTOM &= "       tLResult = " & sim
                  If Control.Index > -1 Then CALL_CONTROL_CUSTOM &= Control.Index & ","
                  CALL_CONTROL_CUSTOM &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  CALL_CONTROL_CUSTOM &= "       If tLResult Then Return tLResult" & vbCrLf
                  CALL_CONTROL_CUSTOM &= "    End If" & vbCrLf
                  Insert_code(ProWinCode, "'[CALL_CONTROL_CUSTOM]", CALL_CONTROL_CUSTOM)
               Case "OWNERDRAW"
                  ProWinCode = YF_Replace(ProWinCode, "'{FORM_WM_DRAWITEM}", "      Case WM_DRAWITEM" & vbCrLf & "         Dim lpdis As DRAWITEMSTRUCT Ptr = Cast(Any Ptr, lParam)" )
                  Dim FORM_WM_DRAWITEM As String = "         If Cast(Long, wParam) = " & IDC & "  Then ' " & clName & vbCrLf
                  FORM_WM_DRAWITEM &= "           tLResult = " & sim
                  If Control.Index > -1 Then FORM_WM_DRAWITEM &= Control.Index & ","
                  FORM_WM_DRAWITEM &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  FORM_WM_DRAWITEM &= "           If tLResult Then Return tLResult" & vbCrLf
                  FORM_WM_DRAWITEM &= "         End If" & vbCrLf
                  Insert_code(ProWinCode, "'[FORM_WM_DRAWITEM]", FORM_WM_DRAWITEM)
               Case "WM_HSCROLL" '特殊处理 ,需要在父窗口处理
                  
                  Select Case ColTool.uName
                     Case "TOPMENU"  '滚动条必须要处理的事件
                        Dim tstr as String = "           " & sim
                        If Control.Index > -1 Then tstr &= Control.Index & ","
                        tstr &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                        ProWinCode = YF_Replace(ProWinCode, "            '{" & Form_clName & "." & clName & "}" & vbCrLf, tstr)
                     Case "SLIDER"
                        Dim FORM_WM_HSCROLL As String  = "         If GetDlgCtrlId(Cast(HWND,lParam)) = " & IDC & " Then  ' " & clName & vbCrLf
                        FORM_WM_HSCROLL &= "           " & sim
                        If Control.Index > -1 Then FORM_WM_HSCROLL &= Control.Index & ","
                        FORM_WM_HSCROLL &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                        FORM_WM_HSCROLL &= "          End If" & vbCrLf
                        Insert_code(ProWinCode, "'[FORM_WM_HSCROLL]", FORM_WM_HSCROLL)
                  End Select
                  
               Case "WM_VSCROLL"
                  Select Case ColTool.uName
                     Case "VSCROLL"  '滚动条必须要处理的事件
                        Dim tstr as String = "           " & sim
                        If Control.Index > -1 Then tstr &= Control.Index & ","
                        tstr &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                        ProWinCode = YF_Replace(ProWinCode, "            '{" & Form_clName & "." & clName & "}" & vbCrLf, tstr)
                     Case "SLIDER"
                       Dim FORM_WM_VSCROLL as String = "         If GetDlgCtrlId(Cast(HWND,lParam)) = " & IDC & " Then  ' " & clName & vbCrLf
                        FORM_WM_VSCROLL &= "           " & sim
                        If Control.Index > -1 Then FORM_WM_VSCROLL &= Control.Index & ","
                        FORM_WM_VSCROLL &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                        FORM_WM_VSCROLL &= "          End If" & vbCrLf
                        Insert_code(ProWinCode, "'[FORM_WM_VSCROLL]", FORM_WM_VSCROLL)
                  End Select
               Case "WM_MEASUREITEM"
                  dim VIRTUAL_CONTROL_EVENTS As String = "   If wMsg = " & ColTool.EveList(ii).tMsg & " Then " & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "      If wParam = " & IDC & " Then" & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "         " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "        tLResult = " & sim
                  If Control.Index > -1 Then VIRTUAL_CONTROL_EVENTS &= Control.Index & ","
                  VIRTUAL_CONTROL_EVENTS &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "        If tLResult Then Return tLResult" & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "      End If " & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "   End If " 
                  Insert_code(ProWinCode, "'[VIRTUAL_CONTROL_EVENTS]", VIRTUAL_CONTROL_EVENTS)
               Case Else
                  If ColTool.EveList(ii).tMsg = "WM_MOUSEHOVER" Then LeaveHoverI Or= 1
                  If ColTool.EveList(ii).tMsg = "WM_MOUSELEAVE" Then LeaveHoverI Or= 10
                  Dim ca As String = "      Case " & ColTool.EveList(ii).tMsg & " ''' "
                  Dim other As String = "          If IDC = " & IDC & " Then  ' " & clName & vbCrLf
                  If Right(ColTool.EveList(ii).Param, 1) <> ")" Then '这是函数
                     other &= "          tLResult = " & sim
                     If Control.Index > -1 Then other &= Control.Index & ","
                     other &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                     other &= "          If tLResult Then Return tLResult" & vbCrLf
                  Else   '这是过程
                     other &= "             " & sim
                     If Control.Index > -1 Then other &= Control.Index & ","
                     other &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  End If
                  other &= "          End If" & vbCrLf
                  ff = InStr(ProWinCode, ca)
                  If ff = 0 Then '不存在
                     Insert_code(ProWinCode, "'[CONTROL_CASE_OTHER]", ca & vbCrLf & other)
                  Else '已经有了
                     ProWinCode = Left(ProWinCode, ff + Len(ca) -1) & vbCrLf & other & Mid(ProWinCode, ff + Len(ca))
                  End If
            End Select
         End If
      Next
   Else      '虚拟控件，直接画窗口的
      For ii = 1 To ColTool.elU
         Dim sim As String '事件函数名组合
         sim = " " & StrToUtf8(UCase(Form_clName & "_" & Control.nName & "_" & ColTool.EveList(ii).sName)) & "("
         Dim ff As Long
         for fi As Long = 0 To UBound(ussl)
            If left(ussl(fi), 1) <> "'" AndAlso InStr(ussl(fi), sim) > 0 Then
               ff = fi + 1
               Exit for
            End If
         Next
         If ff > 0 Then
            if IsEventComparison(Control, ColTool, ii, ff, nFile, ussl(ff -1), Form_clName) Then Return 3 '检查事件是不是正确
            Select Case ColTool.uName
               Case "WEBBROWSER" '
                  '事件安排在属性设置里
               Case "IMAGELIST"
                  '不需要事件Param
               Case "WININET", "SQLITE3"
                  '不需要事件Param
               Case "WINHOOK"
                  '事件安排在属性设置里
               Case "TIMER"
                  dim FORM_WM_TIMER As String = "          If wParam = " & IDC & " Then" & vbCrLf
                  FORM_WM_TIMER &= "             " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf
                  FORM_WM_TIMER &= "             KillTimer(hWndForm, " & IDC & ")" & vbCrLf
                  FORM_WM_TIMER &= "            " & sim
                  If Control.Index > -1 Then FORM_WM_TIMER &= Control.Index & ","
                  FORM_WM_TIMER &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  FORM_WM_TIMER &= "             If " & Form_clName & "." & clName & ".Enabled = True Then " & Form_clName & "." & clName & ".Enabled = True" & vbCrLf
                  FORM_WM_TIMER &= "          End if " & vbCrLf
                  Insert_code(ProWinCode, "'[FORM_WM_TIMER]", FORM_WM_TIMER)
               Case "TRAYICO"
                  Dim VIRTUAL_CONTROL_EVENTS As String 
                  Select Case ColTool.EveList(ii).tMsg
                     Case "CUSTOM"
                        VIRTUAL_CONTROL_EVENTS &= "   If wMsg = " & Form_clName & "." & clName & ".CallMsg + WM_User  Then " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "       tLResult = " & sim
                        If Control.Index > -1 Then VIRTUAL_CONTROL_EVENTS &= Control.Index & ","
                        VIRTUAL_CONTROL_EVENTS &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "       If tLResult Then Return tLResult" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "   End If " & vbCrLf
                     Case Else
                        VIRTUAL_CONTROL_EVENTS &= "   If wMsg = " & Form_clName & "." & clName & ".CallMsg + WM_User  Then " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "      If LOWORD(lParam) = " & ColTool.EveList(ii).tMsg & " Then" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "        " & sim
                        If Control.Index > -1 Then VIRTUAL_CONTROL_EVENTS &= Control.Index & ","
                        VIRTUAL_CONTROL_EVENTS &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "      End If " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "   End If " & vbCrLf
                        
                  End Select
                  Insert_code(ProWinCode, "'[VIRTUAL_CONTROL_EVENTS]", VIRTUAL_CONTROL_EVENTS)
            Case "TOPMENU", "POPUPMENU"
                  Dim VIRTUAL_CONTROL_EVENTS As String 
                  Select Case ColTool.EveList(ii).tMsg
                     Case "WM_COMMAND"
                        VIRTUAL_CONTROL_EVENTS &= "   If wMsg = " & ColTool.EveList(ii).tMsg & " Then " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "      Dim wID As ULong = LoWord(wParam)" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "      If wID >= " & MENUmin & " And wID <= " & MENUmax & " Then" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "         " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "        " & sim
                        If Control.Index > -1 Then VIRTUAL_CONTROL_EVENTS &= Control.Index & ","
                        VIRTUAL_CONTROL_EVENTS &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "      End If " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "   End If " & vbCrLf
                     Case "WM_MEASUREITEM"
                        VIRTUAL_CONTROL_EVENTS &= "   If wMsg = " & ColTool.EveList(ii).tMsg & " Then " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "      If wParam = 0 Then" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "         Dim lPmis As MEASUREITEMSTRUCT Ptr = Cast(Any Ptr, lParam)" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "         If lPmis->CtlType = ODT_MENU AndAlso lPmis->itemID >= " & MENUmin & " AndAlso lPmis->itemID <= " & MENUmax & " Then" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "            " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "           " & sim
                        If Control.Index > -1 Then VIRTUAL_CONTROL_EVENTS &= Control.Index & ","
                        VIRTUAL_CONTROL_EVENTS &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "         End If " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "      End If " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "   End If " & vbCrLf
                     Case "WM_DRAWITEM"
                        VIRTUAL_CONTROL_EVENTS &= "   If wMsg = " & ColTool.EveList(ii).tMsg & " Then " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "      If wParam = 0 Then" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "         Dim lPdis As DRAWITEMSTRUCT Ptr = Cast(Any Ptr, lParam)" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "         If lPdis->CtlType = ODT_MENU AndAlso lPdis->itemID >= " & MENUmin & " AndAlso lPdis->itemID <= " & MENUmax & " Then" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "            " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "           tLResult = " & sim
                        If Control.Index > -1 Then VIRTUAL_CONTROL_EVENTS &= Control.Index & ","
                        VIRTUAL_CONTROL_EVENTS &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "           If tLResult Then Return tLResult" & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "         End If " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "      End If " & vbCrLf
                        VIRTUAL_CONTROL_EVENTS &= "   End If " & vbCrLf
                  End Select
                  Insert_code(ProWinCode, "'[VIRTUAL_CONTROL_EVENTS]", VIRTUAL_CONTROL_EVENTS)
               Case Else
                  dim VIRTUAL_CONTROL_EVENTS As String = "   If wMsg = " & ColTool.EveList(ii).tMsg & " Then " & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "      " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "      Dim As Long xPos =GET_X_LPARAM(lParam),yPos =GET_Y_LPARAM(lParam)" & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "      If " & Form_clName & "." & clName & ".HitTest(xPos,yPos) Then" & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "         " & sim
                  If Control.Index > -1 Then VIRTUAL_CONTROL_EVENTS &= Control.Index & ","
                  VIRTUAL_CONTROL_EVENTS &= ColTool.EveList(ii).gCall & "  " & nFile & ff -1 & "]" & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "      End if " & vbCrLf
                  VIRTUAL_CONTROL_EVENTS &= "   End If " & vbCrLf
                  Insert_code(ProWinCode, "'[VIRTUAL_CONTROL_EVENTS]", VIRTUAL_CONTROL_EVENTS)
            End Select
         End If
      Next
      Select Case ColTool.uName
         Case "TIMER"
            Insert_code(ProWinCode, "'[DELETE_USER_TIMERS]", "         KillTimer hWndForm, " & IDC)
         Case "WEBBROWSER" 'CTRL_WEBBROWSER '特殊的IE控件
         case Else
            if ColTool.Feature <> 4 Then
               '描绘虚拟控件，最底层的控件先画
               Insert_code(ProWinCode, "'[DRAWINGVIRTUALCONTROLS]",_
                "            " & Form_clName & "." & clName & ".hWndForm = hWndForm " & vbCrLf & "            " & Form_clName & "." & clName & ".Drawing(gg,hWndForm,WinCc)  ",1 )
            end if
      End Select
   End If
   If LeaveHoverI > 0 Then
      dim CONTROL_LEAVEHOVER As String = "          If IDC = " & IDC & " Then  ' " & clName & vbCrLf
      CONTROL_LEAVEHOVER &= "             Dim entTrack As tagTRACKMOUSEEVENT" & vbCrLf
      CONTROL_LEAVEHOVER &= "             entTrack.cbSize = SizeOf(tagTRACKMOUSEEVENT)" & vbCrLf
      If LeaveHoverI = 11 Then
         CONTROL_LEAVEHOVER &= "             entTrack.dwFlags = TME_LEAVE Or TME_HOVER" & vbCrLf
      ElseIf LeaveHoverI = 10 Then
         CONTROL_LEAVEHOVER &= "             entTrack.dwFlags = TME_LEAVE " & vbCrLf
      Else
         CONTROL_LEAVEHOVER &= "             entTrack.dwFlags =  TME_HOVER" & vbCrLf
      End If
      CONTROL_LEAVEHOVER &= "             entTrack.hwndTrack = hWndControl" & vbCrLf
      CONTROL_LEAVEHOVER &= "             entTrack.dwHoverTime = HOVER_DEFAULT" & vbCrLf
      CONTROL_LEAVEHOVER &= "             TrackMouseEvent @entTrack" & vbCrLf
      CONTROL_LEAVEHOVER &= "          End IF" & vbCrLf
      Insert_code(ProWinCode, "'[CONTROL_LEAVEHOVER]", CONTROL_LEAVEHOVER)
   End If
   
   '成功返回0，失败非0
   Function = 0
End Function


Function GetCodeColorGDI(coColor As Long) As Long  '把控件特殊颜色值，转换为 GDI 色  ,返回-1 为不使用或默认
  If (&H00FFFFFF And coColor) = &H7F7F7F Then
      Dim f As Long = Cast(UInteger, (&HFF000000 And coColor)) Shr 24
      If f=25 Then  Return -1   '不使用或默认值 
      If f < 31 Then 
          Return GetSysColor(f)  
      End If  
  End If
  Function = (&H00FFFFFF And coColor) '去掉 A 通道
End Function
Function GetCodeColorGDIplue(coColor As Long) As Long  '把控件特殊颜色值，转换为 GDI+ 色  ,返回0 为不使用或默认
  Dim tColor As Long = coColor 
  If (&H00FFFFFF And coColor) = &H7F7F7F Then
      Dim f As Long = Cast(UInteger, (&HFF000000 And coColor)) Shr 24
      If f = 25 Then Return 0  ' 不使用或默认值 
      If f < 31 Then 
          tColor = GetSysColor(f) Or &HFF000000 '增加 A通道，不透明，不然是全透明  
      End If  
  End If 
  '因为保存的是GDI 的颜色，GDI+ 需要调换
  Dim As UInteger c1 =(&H00FF0000 And tColor),c2 = (&H000000FF And tColor) ,c3 =(&HFF00FF00 And tColor)
  c1 Shr= 16
  c2 Shl= 16 
  Function = c1 Or c2 Or c3  
End Function
























