﻿'这里是控件主模块 ==================
'  VisualFreeBasic 控件工作流程
'VFB启动时扫描控件文件夹里的每个文件夹，每个文件夹其中一个为 控件DLL，也就是本工程生产的DLL
'第1步：动态加载DLL
'第2步：检查DLL输出函数，都存在继续下一步，否则认为不是 控件DLL 就卸载DLL
'第3步：调用  initialization  来确定协议版本，不符合的就VFB会提示需要多少版本的。并且卸载DLL
'第4步：调用  SetControlProperty 由 DLL来加载控件属性
'当打开一个工程用到本控件时，调用 Edit_AddControls 加载控件到 窗口编辑器
'用户修改或加载控件后，调用 Edit_SetControlProperty 来设置 窗口编辑器中控件 属性
'若控件有特殊属性需要在线处理，调用 Edit_ControlPropertyAlter 来设置，此时由本DLL负责处理，比如 菜单编辑
'当虚拟控件需要绘画时，调用 Edit_OnPaint 来画控件，实体控件是系统负责画，就不需要了。
'编译软件时，调用 Compile_ExplainControl 解析控件，把控件属性翻译成具体代码。
'而控件类是提供给代码调用的。


Function initialization() As Long Export '初始化
                        '当 VFB5 主软件加载本DLL后，主动调用一下此函数，可以在此做初始化代码
   SetFunctionAddress() '设置函数地址
   Function = 6 '返回协议版本号，不同协议（发生接口变化）不能通用，会发生崩溃等问题，因此VFB主软件会判断此版本号，不匹配就不使用本控件。
End Function
Function SetControlProperty(ByRef ColTool As ColToolType) As Long Export '设置控件工具属性。
   '处理多国语言 -----  如果本控件不支持多国语言，可以删除
   Dim op     As pezi Ptr     = GetOpAPP()
   Dim ExeApp As APP_TYPE Ptr = GetExeAPP()
   vfb_LoadLanguage(ExeApp->Path & "Languages\" & op->Languages & "\Languages.txt" ,App.EXEName)
   
   '设置控件基本属性 --------------
   ColTool.sName     = "Form"                 'Name      控件名称，必须英文
   ColTool.sTips     = vfb_LangString("窗口") 'Tips      鼠标停留在控件图标上提示的内容
   ColTool.uName     = UCase(ColTool.sName)
   ColTool.sVale     = &HE73E        'Ico       字体图标的字符值，字体文件在：VisualFreeBasic5\Settings\iconfont.ttf  如果有 *.ico 文件则优先显示图标文件，而不是字体图标。
   ColTool.Feature   = 1             'Feature   特征 =0 不使用 =1 主窗口(只能有1个，且永远在第一个) =2 普通控件（有窗口句柄） =3 虚拟控件有界面（无句柄） =4 虚拟控件无界面（组件）
   ColTool.ClassFile = "ClsForm.inc" 'ClassFile 控件类文件名
   ColTool.Only      = 01            'Only      是否是唯一的，就是一个窗口只能有1个此控件
   ColTool.GROUP     = ""            'Group     分组名称，2个中文到4个最佳，属于多个分组，用英文豆号分割
   
   '设置控件的属性（窗口编辑器里的属性和选项，写代码的属性是控件类负责，代码提示则在帮助里修改。）和事件（代码编辑时可选的事件）
   '从配置文件中读取属性和事件，必须保证和DLL同文件下的 Attribute.ini Event.ini 配置文件正常
   '若不想用配置文件，也可以直接用代码赋值配置。
   'language <>0支持多国语言，会去VFB主语言文件里读取语言，修改配置里的文字。
   If AttributeOREvent(ColTool ,True) Then Return -1 '返回 -1 表示发生问题，VFB将会直接退出。
   
   Function = 0 '返回 排序号，控件在 IDE 中控件列表的先后位置，必须从2开始，主窗口 Form=0  Pointer=1 ，其它 2--n  从小到大排列
End Function


Function Edit_AddControls(cw As CWindow Ptr,hParent As hWnd,IDC As ULong ,Caption As CWSTR, x As Long, y As Long, w As Long, h As Long,WNDPROC As Any Ptr) As hWnd Export '增加1个控件 
   '编辑：窗口刚被打开，需要新建，返回新建后的控件窗口句柄
   'cw      基于CWindow创建，这是当前窗口的 CWindow 指针
   'hParent 父窗口句柄
   'cID     控件IDC号
   'Caption 控件标题
   'xywh    位置
   'WndProc 主窗口处理消息的函数地址(窗口消息回调函数)

   Function = cw->Create(hParent, Caption, WNDPROC, 0, 0, w, h,  WS_CHILD , WS_EX_LEFT Or WS_EX_LTRREADING Or WS_EX_RIGHTSCROLLBAR ) ' Or WS_EX_NOACTIVATE 
                                                                ' WS_OVERLAPPEDWINDOW Or WS_CLIPSIBLINGS Or WS_CLIPCHILDREN  Or      Or WS_EX_CONTROLPARENT
End Function

Function Edit_SetControlProperty(ByRef Control As clsControl, ByRef ColTool As ColToolType, ki As Long) As Long Export '设置控件属性
   '编辑：新创建控件、修改控件属性后，都调用1次
   'Control  窗口中的控件
   'ColTool  当前控件配置和属性
   'ki       被修改的属性索引，=0为全部
   Dim hWndControl As hWnd = Control.nHwnd
   Dim vv As String, cvv As CWSTR, i As Long
   
   For i = 1 To ColTool.plU
      vv = Control.pValue(i) '值是 Utf8 格式
      cvv.UTF8 = YF_Replace(vv, Chr(3, 1), vbCrLf)
      '先设置通用部分
      Select Case ColTool.ProList(i).uName
         Case "CAPTION"
            if ColTool.uName <> "STATUSBAR" Then
               SetWindowTextW hWndControl, cvv.vptr
            End if
            Control.Caption = YF_Replace(vv, Chr(3, 1), vbCrLf)
         Case "ICON"
            Dim pa As String = GetProRunFile(0,4)
            Dim svv As String, fvv As Long = InStr(vv, "|")
            if fvv = 0 Then svv = vv Else svv = Left(vv, fvv -1)
            Dim hIcon As HICON 
'            PrintA "icon",svv 
            if Len(svv) Then 
              hIcon = LoadImage(NULL, pa & "images\" & Utf8toStr(svv), IMAGE_ICON, 0, 0, LR_DEFAULTSIZE Or LR_LOADFROMFILE)
            Else
              Dim eApp As APP_TYPE Ptr = GetExeAPP()
              hIcon = LoadImage(Null, eapp->Path & "Settings\img\Default.ico", IMAGE_ICON, 0, 0, LR_DEFAULTSIZE Or LR_LOADFROMFILE)
             
            End if 
            If hIcon Then
               hIcon = AfxSetWindowIcon(hWndControl, ICON_SMALL, hIcon)
               If hIcon Then DestroyIcon(hIcon)
            End If
         Case "LEFT"
            
         Case "TOP"   '只有控件才设置，主窗口不设置
            
         Case "WIDTH"
               Control.nWidth = ValInt(vv)
               FF_Control_SetSize hWndControl, AfxScaleX(Control.nWidth), AfxScaleY(Control.nHeight)
               Dim As Long w,h
               FF_Control_GetSize hWndControl, w, h
               Control.nWidth = AfxUnscaleX(w)  '窗口有最小尺寸限制的
         Case "HEIGHT"
               Control.nHeight = ValInt(vv)
               FF_Control_SetSize hWndControl, AfxScaleX(Control.nWidth), AfxScaleY(Control.nHeight)
               Dim As Long w,h
               FF_Control_GetSize hWndControl, w, h
               Control.nWidth = AfxUnscaleX(w)  '窗口有最小尺寸限制的
         Case "MOUSEPOINTER"
         Case "FORECOLOR"
            Control.ForeColor = GetColorText(vv)
            
         Case "BACKCOLOR"
            Control.BackColor = GetColorText(vv)
            SetClassLongPtr hWndControl, GCLP_HBRBACKGROUND, Cast(Integer, CreateSolidBrush(GetCodeColorGDI(Control.BackColor)  ))
'            Dim pWindow As CWindow Ptr = AfxCWindowPtr(Control.nHwnd)
'            DeleteObject pWindow->Brush  '销毁以前的
'            pWindow->Brush = CreateSolidBrush(Control.BackColor)            
         Case "TAG"
'         Case "TAB"
         Case "ACCEPTFILES"
         Case "INDEX"
         Case "FONT"
            Dim tFont As HFONT = GetWinFontLog(vv)
            
            SendMessage hWndControl, WM_SETFONT, Cast(wParam, tFont), True
            Control.Font = vv
         Case "TOOLTIPBALLOON"
         Case "TOOLTIP"
            '==============     以上是公共设置，下面是每个控件私有设置    =================
         Case "NAME"
         Case "ENABLED"
            SetTextStyleVale(Control, ColTool, ki, i, IIf(Trim(UCase(vv)) = "TRUE", "False", "True"), "WS_DISABLED")  '修改文本样式值
         Case "VISIBLE"
            '编辑状态，都是显示的。
            'SetTextStyleVale(wc, cTi, ki, i, ci, vv, "WS_VISIBLE")  '修改文本样式值
         Case "CLASSSTYLE"
            'Dim pWindow As CWindow Ptr = AfxCWindowPtr(Control.nHwnd)
            'pWindow->ClassStyle = GetStyleValeOR(vv)
         Case "WINSTYLE"
            Dim ws As UInteger = GetStyleValeOR(vv, 2)
            ws And= Not (WS_MINIMIZE)   '编辑状态时，不允许最大和最小化
            ws And= Not (WS_ICONIC)
            ws And= Not (WS_MAXIMIZE)
            ws And= Not (WS_DISABLED)
            ws Or= WS_VISIBLE Or WS_POPUP Or WS_CLIPSIBLINGS Or WS_CLIPCHILDREN
            AfxSetWindowStyle Control.nHwnd, ws
            ws = GetStyleValeOR(vv, 1)
            ws Or= WS_EX_NOACTIVATE  '不激活
            AfxSetWindowExStyle Control.nHwnd,ws 
            If ki <> i Then Exit Select
            Dim wi As Long = GetColToolProIndex(ColTool, "STYLE")
            If wi > 0 Then
               Dim vi As Long
               If IsStyleAllOFF(vv, "WS_BORDER,WS_CAPTION,WS_THICKFRAME,WS_TILEDWINDOW,WS_EX_CLIENTEDGE,WS_EX_WINDOWEDGE,WS_EX_STATICEDGE,WS_EX_DLGMODALFRAME") Then
                  vi = 1
               ElseIf IsStyleAllOFF(vv, "WS_CAPTION,WS_THICKFRAME,WS_TILEDWINDOW,WS_EX_CLIENTEDGE,WS_EX_WINDOWEDGE,WS_EX_STATICEDGE,WS_EX_DLGMODALFRAME") And IsStyleAllON(vv, "WS_BORDER") Then
                  vi = 2
               ElseIf IsStyleAllOFF(vv, "WS_CAPTION,WS_THICKFRAME,WS_TILEDWINDOW,WS_EX_CLIENTEDGE,WS_EX_WINDOWEDGE,WS_EX_STATICEDGE") And IsStyleAllON(vv, "WS_EX_DLGMODALFRAME") Then
                  vi = 3
               ElseIf IsStyleAllOFF(vv, "WS_EX_CLIENTEDGE,WS_EX_WINDOWEDGE,WS_EX_STATICEDGE,WS_EX_DLGMODALFRAME,WS_EX_TOOLWINDOW") And IsStyleAllON(vv, "WS_BORDER,WS_CAPTION,WS_THICKFRAME,WS_SYSMENU,WS_MAXIMIZEBOX,WS_MINIMIZEBOX") Then
                  vi = 4
               ElseIf IsStyleAllOFF(vv, "WS_EX_CLIENTEDGE,WS_EX_WINDOWEDGE,WS_EX_STATICEDGE,WS_EX_DLGMODALFRAME") And IsStyleAllON(vv, "WS_BORDER,WS_CAPTION,WS_SYSMENU,WS_EX_TOOLWINDOW") Then
                  vi = 5
               End If
               If vi > 0 Then Control.pValue(wi) = StrToUtf8(FF_Parse(ColTool.ProList(wi).AllList, ",", vi))
            End If
            
            wi = GetColToolProIndex(ColTool, "Enabled") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllOFF(vv, "WS_DISABLED"), "True", "False")
            'wi = GetColToolProIndex(ColTool, "Visible") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_VISIBLE"), "True", "False")
            wi = GetColToolProIndex(ColTool, "Child") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_CHILD"), "True", "False")
            wi = GetColToolProIndex(ColTool, "MdiChild") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_EX_MDICHILD"), "True", "False")
            wi = GetColToolProIndex(ColTool, "TitleBar") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_CAPTION"), "True", "False")
            wi = GetColToolProIndex(ColTool, "SizeBox") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_SIZEBOX") Or IsStyleAllON(vv, "WS_THICKFRAME"), "True", "False")
            wi = GetColToolProIndex(ColTool, "SysMenu") : If wi > 0 Then Control.PVALUE(wi) = IIf(IsStyleAllON(vv, "WS_SYSMENU"), "True", "False")
            wi = GetColToolProIndex(ColTool, "MaximizeBox") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_MAXIMIZEBOX"), "True", "False")
            wi = GetColToolProIndex(ColTool, "MinimizeBox") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_MINIMIZEBOX"), "True", "False")
            wi = GetColToolProIndex(ColTool, "Help") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_EX_CONTEXTHELP"), "True", "False")
            wi = GetColToolProIndex(ColTool, "Hscroll") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_HSCROLL"), "True", "False")
            wi = GetColToolProIndex(ColTool, "Vscroll") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_VSCROLL"), "True", "False")
            wi = GetColToolProIndex(ColTool, "Tab") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_EX_CONTROLPARENT"), "True", "False")
            wi = GetColToolProIndex(ColTool, "TopMost") : If wi > 0 Then Control.pValue(wi) = IIf(IsStyleAllON(vv, "WS_EX_TOPMOST"), "True", "False")
            wi = GetColToolProIndex(ColTool, "WindowState")
            If wi > 0 Then
               Dim vi As Long
               If IsStyleAllON(vv, "WS_VISIBLE") = 0 Then
                  vi = 4
               ElseIf IsStyleAllON(vv, "WS_ICONIC") Or IsStyleAllON(vv, "WS_MINIMIZE") Then
                  vi = 2
               ElseIf IsStyleAllON(vv, "WS_MAXIMIZE") Then
                  vi = 3
               Else
                  vi = 1
               End If
               Control.pValue(wi) = StrToUtf8(FF_Parse(ColTool.ProList(wi).AllList, ",", vi))
            End If
         Case "STYLE"
            If ki <> i Then Exit Select
            Dim wi As Long = GetColToolProIndex(ColTool, "WINSTYLE")
            Dim xi As Long
            If wi = 0 Then Exit Select
            Select Case ValInt(vv)
               Case 0  '无边框
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPSIBLINGS") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPCHILDREN") '增加
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_BORDER") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_CAPTION") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_THICKFRAME") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_SIZEBOX") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_OVERLAPPEDWINDOW") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_TILEDWINDOW") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_CLIENTEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_WINDOWEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_STATICEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_DLGMODALFRAME") '移除
                  xi = GetColToolProIndex(ColTool, "TitleBar") : If xi > 0 Then Control.pValue(xi) = "False"
                  xi = GetColToolProIndex(ColTool, "SizeBox") : If xi > 0 Then Control.pValue(xi) = "False"
               Case 1  '细边框
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_BORDER") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPSIBLINGS") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPCHILDREN") '增加
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_CAPTION") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_THICKFRAME") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_SIZEBOX") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_OVERLAPPEDWINDOW") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_TILEDWINDOW") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_CLIENTEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_WINDOWEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_STATICEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_DLGMODALFRAME") '移除
                  xi = GetColToolProIndex(ColTool, "TitleBar") : If xi > 0 Then Control.pValue(xi) = "False"
                  xi = GetColToolProIndex(ColTool, "SizeBox") : If xi > 0 Then Control.pValue(xi) = "False"
               Case 2  '3D边框
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_CAPTION") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_THICKFRAME") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_SIZEBOX") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_OVERLAPPEDWINDOW") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_TILEDWINDOW") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_CLIENTEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_WINDOWEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_STATICEDGE") '移除
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_EX_DLGMODALFRAME") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPSIBLINGS") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPCHILDREN") '增加
                  xi = GetColToolProIndex(ColTool, "TitleBar") : If xi > 0 Then Control.pValue(xi) = "False"
                  xi = GetColToolProIndex(ColTool, "SizeBox") : If xi > 0 Then Control.pValue(xi) = "False"
               Case 3  '常规窗口
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_BORDER") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CAPTION") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_SIZEBOX") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_SYSMENU") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_MAXIMIZEBOX") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_MINIMIZEBOX") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPSIBLINGS") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPCHILDREN") '增加
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_CLIENTEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_WINDOWEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_STATICEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_DLGMODALFRAME") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_TOOLWINDOW") '移除
                  xi = GetColToolProIndex(ColTool, "TitleBar") : If xi > 0 Then Control.pValue(xi) = "True"
                  xi = GetColToolProIndex(ColTool, "SizeBox") : If xi > 0 Then Control.pValue(xi) = "True"
                  xi = GetColToolProIndex(ColTool, "SysMenu") : If xi > 0 Then Control.pValue(xi) = "True"
                  xi = GetColToolProIndex(ColTool, "MaximizeBox") : If xi > 0 Then Control.pValue(xi) = "True"
                  xi = GetColToolProIndex(ColTool, "MinimizeBox") : If xi > 0 Then Control.pValue(xi) = "True"
                  
               Case 4  '工具窗口
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_BORDER") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CAPTION") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_SYSMENU") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_EX_TOOLWINDOW") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPSIBLINGS") '增加
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CLIPCHILDREN") '增加
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_THICKFRAME") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_SIZEBOX") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_CLIENTEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_WINDOWEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_STATICEDGE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_EX_DLGMODALFRAME") '移除
                  xi = GetColToolProIndex(ColTool, "TitleBar") : If xi > 0 Then Control.pValue(xi) = "True"
                  xi = GetColToolProIndex(ColTool, "SysMenu") : If xi > 0 Then Control.pValue(xi) = "True"
            End Select

         Case "STARTPOSITION"
         Case "CHILD"        
            Dim wi As Long = GetColToolProIndex(ColTool, "WINSTYLE")
            If wi > 0 Then
               If Trim(UCase(vv)) = "TRUE" Then
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_CHILD")   '增加
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_POPUP") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_OVERLAPPED") '移除
               Else
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_CHILD") '移除
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_POPUP")   '增加
               End If
            End If
         Case "MDICHILD"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_EX_MDICHILD")  '修改文本样式值
         Case "TITLEBAR"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_CAPTION")  '修改文本样式值
         Case "SIZEBOX"
            Dim wi As Long = GetColToolProIndex(ColTool, "WINSTYLE")
            If wi > 0 Then
               If Trim(UCase(vv)) = "TRUE" Then
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_SIZEBOX")   '增加
               Else
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_SIZEBOX") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_THICKFRAME")   '增加
               End If
            End If
         Case "TOPMOST"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_EX_TOPMOST")  '修改文本样式值
         Case "SYSMENU"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_SYSMENU")  '修改文本样式值
         Case "MAXIMIZEBOX"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_MAXIMIZEBOX")  '修改文本样式值
         Case "MINIMIZEBOX"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_MINIMIZEBOX")  '修改文本样式值
         Case "HELP"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_EX_CONTEXTHELP")  '修改文本样式值
         Case "HSCROLL"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_HSCROLL")  '修改文本样式值
         Case "VSCROLL"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_VSCROLL")  '修改文本样式值
         Case "TAB"
            SetTextStyleVale(Control, ColTool, ki, i, vv, "WS_EX_CONTROLPARENT")  '修改文本样式值
         Case "MINWIDTH"
         Case "MINHEIGHT"
         Case "MAXWIDTH"
         Case "MAXHEIGHT"
         Case "WINDOWSTATE"
            If ki <> i Then Exit Select
            Dim wi As Long = GetColToolProIndex(ColTool, "WINSTYLE")
            Dim xi As Long
            If wi = 0 Then Exit Select
            Select Case ValInt(vv)
               Case 0  '正常
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_ICONIC") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_MINIMIZE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_MAXIMIZE") '移除
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_VISIBLE") '新增
               Case 1  '最小化
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_ICONIC") '移除
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_MINIMIZE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_MAXIMIZE") '移除
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_VISIBLE") '新增
               Case 2  '最大化
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_ICONIC") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_MINIMIZE") '移除
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_MAXIMIZE") '移除
                  Control.pValue(wi) = TextAddWindowStyle(Control.pValue(wi), "WS_VISIBLE") '新增
               Case 3 '  隐藏
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_ICONIC") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_MINIMIZE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_MAXIMIZE") '移除
                  Control.pValue(wi) = TextRemoveWindowStyle(Control.pValue(wi), "WS_VISIBLE") '新增
            End Select
         Case "MOUSEPASS"
         Case "TRANSPER"
         Case "TRANSCOLOR"
      End Select
   Next
   Function = 0
End Function

Function Edit_ControlPropertyAlter(hWndForm As hWnd, hWndList As hWnd, nType As Long, value As String, default As String, AllList As String, nName As String, FomName As String) As Long Export  ' 控件属性修改
   '编辑：用户点击窗口属性，修改属性时，1--6由EXE处理，7 或其它由本DLL处理
   'hWndForm   EXE 主窗口句柄
   'hWndList   控件属性显示窗口句柄（是List控件）Dim z As ZString Ptr = Cast(Any Ptr ,FF_ListBox_GetItemData(aa.hWndList,Index)) '当前属性值
   'nType      类型，由 Attribute.ini 里设置，7 或其它由本DLL处理
   'value      当前的值
   'default    默认值，由 Attribute.ini 里设置
   'AllList    所有值，由 Attribute.ini 里设置
   Select Case nType   '这里根据需要编写
      Case 100
         Dim aa As StyleFormType
         aa.hWndForm = hWndForm
         aa.hWndList = hWndList
         aa.nType = nType
         aa.value = @value
         aa.default = @default
         aa.AllList = @AllList
         aa.Rvalue = value
         aa.nName = nName : aa.FomName = FomName '当前被编辑的控件名和窗口名
         StyleForm.Show hWndForm, True, Cast(Integer, @aa)
         value = aa.Rvalue
         Function = len(value)
   End Select
End Function
Function Edit_OnPaint(gg As yGDI, Control As clsControl, ColTool As ColToolType, WinCc As Long, nFile As String) as Long Export '描绘控件
   '编辑：当被刷新窗口，需要重绘控件时，窗口和实控件由系统绘画，不需要我们在这里处理，虚拟控件必须由此画出来。
   'gg    目标， 画在这个缓冲里。
   'Control  窗口中的控件
   'ColTool  当前控件配置和属性
   'WinCc    主窗口底色，不是本控件底色
   'nFile    当前工程主文件名，带文件夹，用来提取路径用。
   '返回非0  将会立即结束描绘操作，就是在此之后的控件就不会画了。按照最底层的控件先画。
   
   '主窗口不需要画什么 
   
   Function = 0
End Function
Function Compile_ExplainControl(Control As clsControl ,ColTool As ColToolType ,ProWinCode As String ,ussl() As String ,ByRef IDC As Long ,DECLARESdim As String ,Form_clName As String ,nFile As String) As Long Export '解释控件，制造创建控件和事件的代码
   '编译：解释控件 ，注意：编译处理字符全部为 UTF8 编码。Control和ColTool里的是 A字符。
   'Control      窗口中的控件
   'ColTool      当前控件配置和属性
   'ProWinCode   处理后的窗口代码，最初由窗口加载窗口模板处理，然后分发给其它控件。填充处理
   'ussl()       已特殊处理过的用户写的窗口代码，主要用来识辨事件
   'IDC          控件IDC，每个控件唯一，VFB自动累计1，我们代码也可以累计
   'DECLARESdim  全局变量定义，整个工程的定义都在此处
   'Form_clName  主窗口类名，最初由窗口设置，方便后面控件使用。
   'nFile        窗口文件名，用在事件调用注释，出错时可以提示源文件地方，避免提示临时文件。
   
   Dim eApp As APP_TYPE Ptr = GetExeAPP()
   Dim Pwc  As String       = GetTextFileStr(eApp->Path & "Settings\app\CODE_FORM.txt") '读取窗口模板
   if Len(Pwc) < 50 Then
      MsgBox(GetMainWinHandle() ,"加载模板文件失败！" & vbCrLf & eApp->Path & "Settings\app\CODE_FORM.txt" , _
         MB_OK Or MB_ICONERROR Or MB_DEFBUTTON1 Or MB_APPLMODAL)
      Return 100
   End If
   ProWinCode = StrToUtf8("'" & String(77 ,45) & vbCrLf & _
      "' 由 VisualFreeBasic "          & eapp->ProductMajor                         & "."    & eapp->ProductMinor & "." & eapp->ProductRevision & " 生成的源代码" & vbCrLf & _
      "' 生成时间："                   & Format(Now ,"yyyy年mm月dd日 hh时mm分ss秒") & vbCrLf & _
      "' 更多信息请访问 www.yfvb.com " & vbCrLf         & _
      "'"                              & String(77 ,45) & vbCrLf & vbCrLf) & Pwc
   
   Form_clName = StrToUtf8(Control.nName)
   
   Dim F_STYLE As String ,ii As Long
   '创建控件 ------------------------------
   For ii = 1 To ColTool.plU
      Select Case ColTool.ProList(ii).uName
         Case "NAME"
            
         Case "CLASSSTYLE" '类样式
            Dim ptt As String = IIf(len(Control.pValue(ii)) = 0 ,"0" ,YF_Replace(Control.pValue(ii) ,"," ," Or "))
            if ptt = "CS_DBLCLKS Or CS_HREDRAW Or CS_VREDRAW" Then
               ptt = ""
            Else
               ptt = "pWindow->ClassStyle = " & ptt
            End if
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_CLASSSTYLE}" ,ptt)
         Case "WINSTYLE" '窗口样式
            F_STYLE = Control.pValue(ii)
         Case "CLASSNAME" '
            Dim pp As String = Control.pValue(ii)
            if Len(pp) = 0 Then
               Dim kg As ZString * 100
               GetProRunFileEx(0 ,5 ,@kg)
               pp = StrToUtf8(kg & "_" & Control.nName)
            End If
            ProWinCode = YF_Replace(ProWinCode ,"{CLASSNAME}" ,pp)
         Case "STYLE" '外观
         Case "ICON"  '图标
            Dim ficon As String = *FileToResourceName(Control.PVALUE(ii))
            If Len(ficon) = 0 Then ficon = "AAAAA_APPICON"
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_BIGICON}" ,"LoadImage(app.hInstance, """ & ficon & """, IMAGE_ICON, 48, 48, LR_SHARED)")
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_SMALLICON}" ,"LoadImage(app.hInstance, """ & ficon & """, IMAGE_ICON, 32, 32, LR_SHARED)")
         Case "CAPTION" '标题
            Dim CaptionTxt As String = GetTextToOutText(Control.PVALUE(ii)) '为编译输出文本转换输出文本，可能是多国语言，转换为多国语言字符
            ProWinCode = YF_Replace(ProWinCode ,"""{CAPTION}""" ,CaptionTxt)
         Case "ENABLED"
            If UCase(Control.PVALUE(ii)) <> "TRUE" Then F_STYLE = TextAddWindowStyle(F_STYLE ,"WS_DISABLED")
            
            'Case "VISIBLE"
            'If UCase(Control.pValue(ii)) = "TRUE" Then F_STYLE = TextAddWindowStyle(F_STYLE, "WS_VISIBLE")
            
         Case "STARTPOSITION" '  启动位置
            Select Case ValInt(Control.pValue(ii))
               Case 0
                  ProWinCode = YF_Replace(ProWinCode ,"{STARTPOSITION}" ,"")
               Case 1
                  ProWinCode = YF_Replace(ProWinCode ,"{STARTPOSITION}" ,"pWindow->Center")
               Case 2
                  ProWinCode = YF_Replace(ProWinCode ,"{STARTPOSITION}" ,"pWindow->Center(NULL, hWndParent)")
            End Select
         Case "LEFT" '位置X
            ProWinCode = YF_Replace(ProWinCode ,"{NLEFT}" ,Control.pValue(ii))
         Case "TOP" '位置Y
            ProWinCode = YF_Replace(ProWinCode ,"{NTOP}" ,Control.pValue(ii))
         Case "WIDTH" '宽度
            ProWinCode = YF_Replace(ProWinCode ,"{NWIDTH}" ,Control.pValue(ii))
         Case "HEIGHT" '高度
            ProWinCode = YF_Replace(ProWinCode ,"{NHEIGHT}" ,Control.pValue(ii))
         Case "CHILD"    '子窗口
         Case "MDICHILD" 'MDI子窗
            ProWinCode = YF_Replace(ProWinCode ,"{ISMDIFORM}" ,Control.pValue(ii))
         Case "TOPMOST"
         Case "TITLEBAR"    '标题栏
         Case "SIZEBOX"     '尺寸边框
         Case "SYSMENU"     '系统菜单
         Case "MAXIMIZEBOX" '最大按钮
         Case "MINIMIZEBOX" '最小按钮
         Case "HELP"        '帮助按钮
         Case "HSCROLL"     '滚动条H
         Case "VSCROLL"     '滚动条V
         Case "MINWIDTH"    '最小宽度
            Dim vv As Long = ValInt(Control.pValue(ii))
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_MINWIDTH}" ,IIf(vv = 0 ,"" ,"FLY_pMinMaxInfo->ptMinTrackSize.x = AfxScaleX(" & vv & ")"))
         Case "MINHEIGHT" '最小高度
            Dim vv As Long = ValInt(Control.PVALUE(ii))
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_MINHEIGHT}" ,IIf(vv = 0 ,"" ,"FLY_pMinMaxInfo->ptMinTrackSize.y = AfxScaleY(" & vv & ")"))
         Case "MAXWIDTH" '最大宽度
            Dim vv As Long = ValInt(Control.pValue(ii))
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_MAXWIDTH}" ,IIf(vv = 0 ,"" ,"FLY_pMinMaxInfo->ptMaxTrackSize.x = AfxScaleX(" & vv & ")"))
         Case "MAXHEIGHT" '最大高度
            Dim vv As Long = ValInt(Control.pValue(ii))
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_MAXHEIGHT}" ,IIf(vv = 0 ,"" ,"FLY_pMinMaxInfo->ptMaxTrackSize.y = AfxScaleY(" & vv & ")"))
         Case "WINDOWSTATE" '可见状态
            Select Case ValInt(Control.pValue(ii))
               Case 0
                  ProWinCode = YF_Replace(ProWinCode ,"{FORM_SHOWSTATE}" ,"SW_SHOWNORMAL")
               Case 1
                  ProWinCode = YF_Replace(ProWinCode ,"{FORM_SHOWSTATE}" ,"SW_MINIMIZE")
               Case 2
                  ProWinCode = YF_Replace(ProWinCode ,"{FORM_SHOWSTATE}" ,"SW_MAXIMIZE")
               Case 3
                  ProWinCode = YF_Replace(ProWinCode ,"{FORM_SHOWSTATE}" ,"SW_HIDE")
            End Select
         Case "NOACTIVATE" 
            If UCase(Control.PVALUE(ii)) = "TRUE" Then
               F_STYLE = TextAddWindowStyle(F_STYLE ,"WS_EX_NOACTIVATE")
               Insert_code(ProWinCode ,"'[Other events in main window]" ,!"Case WM_MOUSEACTIVATE \r\n         Return MA_NOACTIVATE")
               ProWinCode = YF_Replace(ProWinCode ,"'{FORM_WS_EX_NOACTIVATE2}" ,"   cp[1]= IIf(IsWindow(hWnd) ,Cast(Integer , hWnd ), -1)")
               ProWinCode = YF_Replace(ProWinCode ,"'{FORM_WS_EX_NOACTIVATE3}" ,"   Declare Sub {FORM_NAME}_thread_WS_EX_NOACTIVATE(cp As Integer Ptr)")
               ProWinCode = YF_Replace(ProWinCode ,"'{FORM_WS_EX_NOACTIVATE}" ,"   Dim cp(1) as Integer,i as Long " & vbCrLf & _
                  "   cp(0)=UserData" & vbCrLf & _
                  "   Threaddetach ThreadCreate(Cast(Any Ptr,@{FORM_NAME}_thread_WS_EX_NOACTIVATE),Cast(Any Ptr,@cp(0))) " & vbCrLf & _
                  "   For i=1 To 100"               & vbCrLf                            & _
                  "      AfxDoEvents"               & vbCrLf                            & _
                  "      Sleep 10"                  & vbCrLf                            & _
                  "      If cp(1) Then Exit For "   & vbCrLf                            & _
                  "   Next "                        & vbCrLf                            & _
                  "   If cp(1)=-1 Then cp(1)=0"     & vbCrLf                            & _
                  "   Function = Cast(hWnd,cp(1)) " & vbCrLf                            & _
                  "End Function"                    & vbCrLf                            & _
                  "Sub {FORM_NAME}_thread_WS_EX_NOACTIVATE(cp As Integer Ptr)" & vbCrLf & _
                  "    {FORM_NAME}.Show_WS_EX_NOACTIVATE(cp)" & vbCrLf                  & _
                  "End Sub"                                   & vbCrLf                  & _
                  "Function {FORM_NAME}_Class_Form.Show_WS_EX_NOACTIVATE(cp As Integer Ptr ) As .hWnd" & vbCrLf & _
                  "   Dim hWndParent As .hWnd , Modal As Boolean = True, UserData As Integer = cp[0]")
            End If
         Case "REPEAT" '多开
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_REPEAT}" ,IIf(UCase(Control.PVALUE(ii)) = "TRUE" ,"This.Repeat = True" ,""))
         Case "MOUSEPASS" '鼠标穿透
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_MOUSEPASS}" ,IIf(UCase(Control.pValue(ii)) = "TRUE" ,"This.MousePass = True" ,""))
         Case "TRANSPER" '透明度
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_TRANSPER}" ,IIf(ValInt(Control.pValue(ii)) = 0 ,"" ,"This.TransPer = " & Control.pValue(ii)))
         Case "TRANSCOLOR" '透明颜色
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_TRANSCOLOR}" ,"This.TransColor = GetCodeColorGDI(&H" & Hex(GetColorText(Control.pValue(ii)) ,8) & ")" & vbCrLf & _
               "   fp->TransColor = &H" & Hex(GetColorText(Control.pValue(ii)) ,8))
         Case "MOUSEPOINTER" '指针
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_MOUSEPOINTER}" ,"This.MousePointer = " & ValInt(Control.pValue(ii)))
         Case "BACKCOLOR" '背景色
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_BACKCOLOR}" ,"This.BackColor = GetCodeColorGDI(&H" & Hex(GetColorText(Control.pValue(ii)) ,8) & ")" & vbCrLf & _
               "SetClassLongPtr hWnd, GCLP_HBRBACKGROUND, Cast(Integer, CreateSolidBrush(fp->BackColor))" & vbCrLf & _
               "   fp->BackColor = &H" & Hex(GetColorText(Control.pValue(ii)) ,8))
         Case "TAG" '附加
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_TAG}" ,IIf(Len(Control.pValue(ii)) = 0 ,"" ,"This.Tag = """ & YF_Replace(Control.pValue(ii) ,Chr(34) ,Chr(34 ,34)) & """"))
         Case "TAB" '导航
            If UCase(Control.pValue(ii)) = "TRUE" Then
               F_STYLE = TextAddWindowStyle(F_STYLE ,"WS_EX_CONTROLPARENT")
            Else
               F_STYLE = TextRemoveWindowStyle(F_STYLE ,"WS_EX_CONTROLPARENT")
            End If
         Case "TOOLTIP" '提示\1\一个提示，当鼠标光标悬停在控件时显示它。\\
            If Len(Control.PVALUE(ii)) = 0 Then
               ProWinCode = YF_Replace(ProWinCode ,"{FORM_TOOLTIP}" ,"")
            Else
               Dim ss As String = YF_Replace(Control.PVALUE(ii) ,Chr(34) ,Chr(34 ,34))
               If IsMultiLanguage() Then 'IsMultiLanguage 后面加()才表示使用函数，不然就是函数指针。
                  ss = YF_Replace(ss ,Chr(3 ,1) ,"{CRLF}")
                  ss = "vfb_LangString(""" & ss & """)"
               Else
                  ss = """" & YF_Replace(ss ,Chr(3 ,1) ,""" & vbCrLf & """) & """"
               End If
               ProWinCode = YF_Replace(ProWinCode ,"{FORM_TOOLTIP}" ,"This.ToolTip = " & ss)
            End If
         Case "TOOLTIPBALLOON" '气球样式\2\一个气球样式显示工具提示。\False\True,False
            ProWinCode = YF_Replace(ProWinCode ,"{FORM_TOOLTIPBALLOON}" ,IIf(Control.PVALUE(ii) <> "True" ,"" ,"This.ToolTipBalloon = " & Control.PVALUE(ii)))
         Case "ACCEPTFILES" '拖放\2\窗口是否接受拖放文件。\False\True,False
            If UCase(Control.pValue(ii)) = "TRUE" Then
               F_STYLE = TextAddWindowStyle(F_STYLE ,"WS_EX_ACCEPTFILES")
            Else
               F_STYLE = TextRemoveWindowStyle(F_STYLE ,"WS_EX_ACCEPTFILES")
            End If
         Case "SHADOW"
            Dim vw As Long = ValInt(Control.pValue(ii))
            If vw > 0 Then
               Insert_code(ProWinCode ,"'[Create window shadow]" , _
                  "    FLY_yfvb_CREATEWINDOWSHADOW(hWndForm) 'FLY_yfvb_CREATEWINDOWSHADOW(hWnd)")
               Dim SHADOWEVENTS As String = GetTextFileStr(eApp->Path & "Settings\app\ShadowEvents.txt") '读取事件
               if Len(SHADOWEVENTS) < 50 Then
                  MsgBox(GetMainWinHandle() ,"加载模板文件失败！" & vbCrLf & eApp->Path & "Settings\app\ShadowEvents.txt" , _
                     MB_OK Or MB_ICONERROR Or MB_DEFBUTTON1 Or MB_APPLMODAL)
                  Return 100
               End if
               Select Case vw
                  Case 1
                     SHADOWEVENTS = YF_Replace(SHADOWEVENTS ,"{offsets}" ,"8")
                  Case 2
                     SHADOWEVENTS = YF_Replace(SHADOWEVENTS ,"{offsets}" ,"10")
                  Case 3
                     SHADOWEVENTS = YF_Replace(SHADOWEVENTS ,"{offsets}" ,"12")
                  Case 4
                     SHADOWEVENTS = YF_Replace(SHADOWEVENTS ,"{offsets}" ,"15")
                  Case 5
                     SHADOWEVENTS = YF_Replace(SHADOWEVENTS ,"{offsets}" ,"20")
               End Select
               Insert_code(ProWinCode ,"'[CALL_FORM_CUSTOM]" ,SHADOWEVENTS) '处理虚拟控件事件
               
            End if
            
      End Select
   Next
   ProWinCode = YF_Replace(ProWinCode ,"{FORM_NAME}" ,Form_clName)
   F_STYLE    = TextRemoveWindowStyle(F_STYLE ,"WS_VISIBLE")  '避免创建时就立即显示，产生闪1下。
   F_STYLE    = TextRemoveWindowStyle(F_STYLE ,"WS_ICONIC")   '必须由显示控制，不能由样式控制
   F_STYLE    = TextRemoveWindowStyle(F_STYLE ,"WS_MINIMIZE") '
   F_STYLE    = TextRemoveWindowStyle(F_STYLE ,"WS_MAXIMIZE") '
   ProWinCode = YF_Replace(ProWinCode ,"{FORM_EX_STYLE}" ,GetStyleOR(F_STYLE ,1))
   ProWinCode = YF_Replace(ProWinCode ,"{FORM_STYLE}" ,GetStyleOR(F_STYLE ,2))
   ' Printa "事件处理"
   '事件处理 ------------------------------
   Dim LeaveHover As String ,LeaveHoverI As Long
   For ii = 1 To ColTool.elU
      Dim sim  As String '事件函数名组合
      Dim nfff As String '定位用的行号
      sim = " " & StrToUtf8(UCase(Control.nName & "_" & ColTool.EveList(ii).sName)) & "("
      Dim ff As Long
      for fi As Long = 0 To UBound(ussl)
         If Left(ussl(fi) ,1) <> "'" AndAlso InStr(ussl(fi) ,sim) > 0 Then
            ff = fi + 1
            Exit for
         End If
      Next
      If ff > 0 Then
         sim = YF_Replace(ColTool.EveList(ii).gCall ,"{$1}" ,sim)
         sim = YF_Replace(sim ,"{CRLF}" ,vbCrLf)
         If ColTool.EveList(ii).tMsg = "{FORM_WM_MOUSEHOVER}" Then LeaveHoverI Or= 1
         If ColTool.EveList(ii).tMsg = "{FORM_WM_MOUSELEAVE}" Then LeaveHoverI Or= 10
         nfff = "  " & nFile & ff -1 & "]"
         if IsEventComparison(Control ,ColTool ,ii ,ff ,nFile ,ussl(ff -1) ,Form_clName) Then Return 3 '检查事件是不是正确
      Else
         sim  = ""
         nfff = ""
      End If
      Select Case ColTool.EveList(ii).tMsg
         Case "{FORM_WM_HSCROLL}" '需要特殊处理
            Insert_code(ProWinCode ,"'[FORM_WM_HSCROLL]" ,sim & nfff)
         Case "{FORM_WM_VSCROLL}" '需要特殊处理
            Insert_code(ProWinCode ,"'[FORM_WM_VSCROLL]" ,sim & nfff)
         Case "{FORM_SHOWN}"
            Insert_code(ProWinCode ,"'[FORM_SHOWN]" ,sim & nfff)
         Case "{FORM_WM_CREATE}"
            Insert_code(ProWinCode ,"'[Create control end]" ,sim & nfff ,1)
         Case "{CALL_FORM_WM_DESTROY}"
            Insert_code(ProWinCode ,"'[CALL_FORM_WM_DESTROY]" ,sim & nfff)
         Case "{FORM_WM_COMMAND}"
            Insert_code(ProWinCode ,"'[FORM_WM_COMMAND]" ,sim & nfff)
         Case "{FORM_WM_NOTIFY}"
            Insert_code(ProWinCode ,"'[FORM_WM_NOTIFY]" ,sim & nfff)
         Case "{FORM_PAINT_START}"
            Insert_code(ProWinCode ,"'[FORM_PAINT_START]" ,sim & nfff)
         Case "{FORM_PAINT_END}"
            Insert_code(ProWinCode ,"'[FORM_PAINT_END]" ,sim & nfff)
         Case "{CALL_FORM_CUSTOM}"
            Insert_code(ProWinCode ,"'[CALL_FORM_CUSTOM]" ,sim & nfff)
         Case "{FORM_WM_MOUSEMOVE}"
            Insert_code(ProWinCode ,"'[CALL_FORM_WM_MOUSEMOVE]" ,sim & nfff)
         Case Else
            Insert_code(ProWinCode ,"'[Other events in main window]" ,sim & nfff)
      End Select
   Next
   If LeaveHoverI > 0 Then
      LeaveHover = StrToUtf8("   '启用鼠标出窗口检查")                       & vbCrLf
      LeaveHover &= "          Dim entTrack As tagTRACKMOUSEEVENT"           & vbCrLf
      LeaveHover &= "          entTrack.cbSize = SizeOf(tagTRACKMOUSEEVENT)" & vbCrLf
      If LeaveHoverI = 11 Then
         LeaveHover &= "          entTrack.dwFlags = TME_LEAVE Or TME_HOVER " & vbCrLf
      ElseIf LeaveHoverI = 10 Then
         LeaveHover &= "          entTrack.dwFlags = TME_LEAVE  " & vbCrLf
      Else
         LeaveHover &= "          entTrack.dwFlags = TME_HOVER " & vbCrLf
      End If
      LeaveHover &= "          entTrack.hwndTrack = hWndForm"        & vbCrLf
      LeaveHover &= "          entTrack.dwHoverTime = HOVER_DEFAULT" & vbCrLf
      LeaveHover &= "          TrackMouseEvent @entTrack"            & vbCrLf
      Insert_code(ProWinCode ,"'[CALL_FORM_WM_MOUSEMOVE]" ,LeaveHover)
   End If
   
   '成功返回0，失败非0
   Function = 0
End Function



























