/*
 * Decompiled with CFR 0.152.
 */
package io.zhile.research.intellij.ier.common;

import com.intellij.ide.Prefs;
import io.zhile.research.intellij.ier.common.EvalRecord;
import io.zhile.research.intellij.ier.common.Resetter;
import java.util.prefs.Preferences;

public class PreferenceRecord
implements EvalRecord {
    private static final String DEFAULT_VALUE = null;
    private final String type = "PREFERENCE";
    private final String key;
    private final String value;
    private final boolean isRaw;

    public PreferenceRecord(String key) {
        this(key, false);
    }

    public PreferenceRecord(String key, boolean isRaw) {
        this.key = key;
        this.isRaw = isRaw;
        this.value = isRaw ? Preferences.userRoot().get(key, DEFAULT_VALUE) : Prefs.get((String)key, (String)DEFAULT_VALUE);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void reset() throws Exception {
        if (this.isRaw) {
            Preferences.userRoot().remove(this.key);
        } else {
            Prefs.remove((String)this.key);
        }
        Resetter.syncPrefs();
    }

    public String toString() {
        return "PREFERENCE: " + this.key + " = " + (null == this.value ? "" : this.value);
    }
}

