/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.xml;

import com.genuitec.eclipse.core.ui.contentassist.AssistUtils;
import com.genuitec.eclipse.core.ui.contentassist.PathCompletionProposal;
import com.genuitec.eclipse.core.util.JavaMetaUtils;
import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.j2eedt.core.IWebProject;
import com.genuitec.eclipse.j2eedt.core.Messages;
import com.genuitec.eclipse.j2eedt.ui.J2EEUICore;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.w3c.dom.Text;

public class MEXMLContentAssistProcessor
extends XMLContentAssistProcessor {
    private IProject project;
    private IJavaProject jProject;
    private ISourceViewer viewer;
    protected String matchString;
    protected int offset;
    protected boolean isQuoted;
    private int position;

    public MEXMLContentAssistProcessor(ISourceViewer viewer) {
        this.viewer = viewer;
    }

    protected void initProposals(ContentAssistRequest contentAssistRequest) {
        this.matchString = contentAssistRequest.getMatchString();
        this.offset = contentAssistRequest.getRegion().getStart() + contentAssistRequest.getDocumentRegion().getStart();
        this.isQuoted = this.matchString.startsWith("\"");
        if (this.isQuoted) {
            this.matchString = this.matchString.substring(1);
            ++this.offset;
        }
        this.position = 0;
    }

    protected void initPCDATAProposals(ContentAssistRequest contentAssistRequest) {
        if (contentAssistRequest.getNode() instanceof Text) {
            this.offset = contentAssistRequest.getDocumentRegion().getStart();
            this.position = contentAssistRequest.getReplacementBeginPosition() - this.offset;
            this.matchString = contentAssistRequest.getNode().getNodeValue();
        } else {
            IStructuredDocumentRegion previous = contentAssistRequest.getDocumentRegion().getPrevious();
            if (previous.getFirstRegion().getType().equals("XML_CONTENT")) {
                this.offset = previous.getStart();
                this.matchString = previous.getText();
                this.position = this.matchString.length();
            } else {
                this.offset = previous.getEnd();
                this.matchString = "";
                this.position = 0;
            }
        }
    }

    protected void addClassNamesProposals(ContentAssistRequest contentAssistRequest) {
        this.initProposals(contentAssistRequest);
        int position = this.matchString.length();
        if (Util.isNullOrEmpty((String)this.matchString)) {
            this.setErrorMessage(Messages.MEXMLContentAssistProcessor_error_mesaage);
        } else {
            Collection collection = AssistUtils.getProposals((String)this.matchString, (int)position, (int)this.offset, (IEvaluationContext)this.getJavaProject().newEvaluationContext(), (int)17);
            for (CompletionProposal proposal : collection) {
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        }
    }

    protected int[] getReplaceStartLength(boolean attribute) {
        int replaceLength;
        String trimmed = this.matchString.trim();
        int replaceStart = this.offset;
        if (!attribute) {
            replaceStart += Util.isNullOrEmpty((String)trimmed) ? this.position : this.matchString.indexOf(trimmed);
            replaceLength = trimmed.length();
        } else {
            replaceLength = this.matchString.length();
        }
        return new int[]{replaceStart, replaceLength};
    }

    protected void addListProposals(ContentAssistRequest contentAssistRequest, Collection<String> names, boolean attribute, Image image) {
        String trimmed = this.matchString.trim();
        int[] replace = this.getReplaceStartLength(attribute);
        int replaceStart = replace[0];
        int replaceLength = replace[1];
        Pattern pattern = Pattern.compile(trimmed, 2);
        for (String name : names) {
            if (!pattern.matcher(name).find()) continue;
            contentAssistRequest.addProposal((ICompletionProposal)new CompletionProposal(name, replaceStart, replaceLength, name.length(), image, null, null, null));
        }
    }

    protected void addWebRootResources(String string, ContentAssistRequest req, IWebProject project, boolean attribute) {
        int[] replace = this.getReplaceStartLength(attribute);
        int replaceStart = replace[0];
        int replaceLength = replace[1];
        if (project != null) {
            try {
                IVirtualFolder webroot = project.getComponent().getRootFolder();
                String trimmed = string.trim();
                if (trimmed.length() == 0) {
                    IVirtualResource[] resources = webroot.members();
                    int i = 0;
                    while (i < resources.length) {
                        IVirtualResource resource = resources[i];
                        ICompletionProposal proposal = MEXMLContentAssistProcessor.createResourceProposal(replaceStart, replaceLength, resource, webroot);
                        req.addProposal(proposal);
                        ++i;
                    }
                } else {
                    int i = string.indexOf(trimmed);
                    String pathString = string.substring(i);
                    Path path = new Path(pathString);
                    path.makeRelative();
                    String lastSegment = path.segmentCount() > 0 ? path.lastSegment().toLowerCase() : "";
                    IVirtualFolder container = path.segmentCount() > 1 ? webroot.getFolder(path.removeLastSegments(1)) : webroot;
                    if (container != null && container.exists()) {
                        IVirtualResource[] resources = container.members();
                        int j = 0;
                        while (j < resources.length) {
                            IVirtualResource resource = resources[j];
                            if (resource.getName().toLowerCase().startsWith(lastSegment)) {
                                if (resource.getType() == 32 && resource.getName().equalsIgnoreCase(lastSegment)) {
                                    IVirtualFolder c = (IVirtualFolder)resource;
                                    IVirtualResource[] reses = c.members();
                                    int k = 0;
                                    while (k < reses.length) {
                                        IVirtualResource res = reses[k];
                                        ICompletionProposal proposal = MEXMLContentAssistProcessor.createResourceProposal(replaceStart, replaceLength, res, webroot);
                                        req.addProposal(proposal);
                                        ++k;
                                    }
                                } else {
                                    ICompletionProposal proposal = MEXMLContentAssistProcessor.createResourceProposal(replaceStart, replaceLength, resource, webroot);
                                    req.addProposal(proposal);
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            catch (CoreException e) {
                J2EEUICore.getDefault().log(e);
            }
        }
    }

    private static ICompletionProposal createResourceProposal(int replaceStart, int replaceLength, IVirtualResource resource, IVirtualFolder webroot) {
        IPath path = resource.getProjectRelativePath().removeFirstSegments(webroot.getProjectRelativePath().segmentCount());
        String absolutePath = path.makeAbsolute().toString();
        return new PathCompletionProposal(absolutePath, replaceStart, replaceLength, absolutePath.substring(1), null, null, !(resource instanceof IContainer));
    }

    protected IJavaProject getJavaProject() {
        if (this.project == null) {
            this.getProject();
        }
        return this.jProject;
    }

    protected IProject getProject() {
        if (this.project == null) {
            IDocument document = this.viewer.getDocument();
            IStructuredModel existingModelForRead = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (existingModelForRead != null) {
                Path path = new Path(existingModelForRead.getBaseLocation());
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                if (resource != null && resource.isAccessible()) {
                    this.project = resource.getProject();
                    this.jProject = JavaMetaUtils.getJavaProject((IProject)this.project);
                }
                existingModelForRead.releaseFromRead();
            }
        }
        return this.project;
    }
}

