/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.ui.taglib;

import com.genuitec.eclipse.core.util.Util;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class DefaultTLDNamespaceSettings {
    public static final String PREF_KEY = "defaultTldInfo";
    public static final String USE_PRJPREF_KEY = "useProjectTldPrefs";
    private static final String NO_PROJECT_KEY = "NO_PROJECT_KEY";
    private static final String PREF_NODE_KEY = "com.genuitec.eclipse.j2eedt.ui";
    private static Preferences DEFAULT_PREFS = new DefaultScope().getNode("com.genuitec.eclipse.j2eedt.ui");
    private static Preferences CONFIGURATION_PREFS = new ConfigurationScope().getNode("com.genuitec.eclipse.j2eedt.ui");
    private static Preferences INSTANCE_PREFS = new InstanceScope().getNode("com.genuitec.eclipse.j2eedt.ui");
    private static HashMap maps = new HashMap();
    private static String defaultPrefValue;

    static {
        DefaultTLDNamespaceSettings.initializeDefaults();
    }

    private static void initializeDefaults() {
        HashMap<String, String> defaultUri2prefixMap = new HashMap<String, String>();
        defaultUri2prefixMap.put("http://java.sun.com/jsp/jstl/core", "c");
        defaultUri2prefixMap.put("http://java.sun.com/jsp/jstl/xml", "x");
        defaultUri2prefixMap.put("http://java.sun.com/jsp/jstl/fmt", "fmt");
        defaultUri2prefixMap.put("http://java.sun.com/jsp/jstl/sql", "sql");
        defaultUri2prefixMap.put("http://java.sun.com/jsp/jstl/functions", "fn");
        defaultUri2prefixMap.put("http://struts.apache.org/tags-bean", "bean");
        defaultUri2prefixMap.put("http://struts.apache.org/tags-html", "html");
        defaultUri2prefixMap.put("http://struts.apache.org/tags-logic", "logic");
        defaultUri2prefixMap.put("http://struts.apache.org/tags-nested", "nested");
        defaultUri2prefixMap.put("http://struts.apache.org/tags-tiles", "tiles");
        defaultUri2prefixMap.put("http://java.sun.com/jsf/core", "f");
        defaultUri2prefixMap.put("http://java.sun.com/jsf/html", "h");
        defaultPrefValue = DefaultTLDNamespaceSettings.map2PrefValue(defaultUri2prefixMap);
    }

    public static boolean isUseProjectSettings(IProject theProject) {
        boolean result = false;
        if (theProject != null) {
            Preferences prefs = DefaultTLDNamespaceSettings.getPrefs(theProject);
            result = prefs.getBoolean(USE_PRJPREF_KEY, false);
        }
        return result;
    }

    public static void setUseProjectSettings(IProject theProject, boolean theVal) {
        if (theProject != null) {
            Preferences prefs = DefaultTLDNamespaceSettings.getPrefs(theProject);
            if (theVal) {
                prefs.putBoolean(USE_PRJPREF_KEY, true);
            } else {
                prefs.remove(USE_PRJPREF_KEY);
            }
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    public static String getTLDURIForDefaultNamespace(IProject theProject, String thePrefix) {
        return DefaultTLDNamespaceSettings.getDefaultNamespaceForTLDURI(theProject, thePrefix);
    }

    public static String getDefaultNamespaceForTLDURI(IProject theProject, String theTLDURI) {
        if (Util.isNullOrEmpty((String)theTLDURI)) {
            return null;
        }
        boolean useProjectScopeOnly = DefaultTLDNamespaceSettings.isUseProjectSettings(theProject);
        return DefaultTLDNamespaceSettings.getDefaultNamespaceForTLDURI(theProject, theTLDURI, useProjectScopeOnly);
    }

    public static String getDefaultNamespaceForTLDURI(IProject theProject, String theTLDURI, boolean useProjectScopeOnly) {
        if (Util.isNullOrEmpty((String)theTLDURI)) {
            return null;
        }
        return DefaultTLDNamespaceSettings.lookup(theProject, theTLDURI, useProjectScopeOnly, true);
    }

    private static String lookup(IProject theProject, String theTLDURI, boolean useProjectScopeOnly, boolean shouldLoad) {
        String result = null;
        Object key = DefaultTLDNamespaceSettings.makeHashKey(theProject);
        HashMap projectPrefMap = (HashMap)maps.get(key);
        if (projectPrefMap == null) {
            if (shouldLoad) {
                DefaultTLDNamespaceSettings.load(theProject);
                result = DefaultTLDNamespaceSettings.lookup(theProject, theTLDURI, useProjectScopeOnly, false);
            } else if (!useProjectScopeOnly) {
                result = DefaultTLDNamespaceSettings.lookup(null, theTLDURI, useProjectScopeOnly, true);
            }
        } else {
            result = !useProjectScopeOnly && theProject != null ? DefaultTLDNamespaceSettings.lookup(null, theTLDURI, false, false) : (String)projectPrefMap.get(theTLDURI);
        }
        return result;
    }

    public static void setDefaultTLDURIForNamespace(IProject theProject, String theTLDURI, String theNSPrefix) {
        Object key = DefaultTLDNamespaceSettings.makeHashKey(theProject);
        HashMap projectPrefMap = (HashMap)maps.get(key);
        if (projectPrefMap == null) {
            projectPrefMap = DefaultTLDNamespaceSettings.load(theProject);
        }
        projectPrefMap.put(theTLDURI, theNSPrefix);
        projectPrefMap.put(theNSPrefix, theTLDURI);
    }

    protected static void restoreDefaults(IProject theProjectScope) {
        Object key = DefaultTLDNamespaceSettings.makeHashKey(theProjectScope);
        maps.remove(key);
        Preferences prefs = theProjectScope != null ? DefaultTLDNamespaceSettings.getPrefs(theProjectScope) : INSTANCE_PREFS;
        prefs.remove(PREF_KEY);
        DefaultTLDNamespaceSettings.getDefaultNamespaceForTLDURI(theProjectScope, "DONT_REALLY_CARE");
    }

    public static HashMap load(IProject theProjectScope) {
        Preferences prefs = theProjectScope != null ? DefaultTLDNamespaceSettings.getPrefs(theProjectScope) : INSTANCE_PREFS;
        String prefVal = prefs.get(PREF_KEY, null);
        if (Util.isNullOrEmpty((String)prefVal)) {
            if (theProjectScope != null) {
                prefVal = INSTANCE_PREFS.get(PREF_KEY, null);
                if (Util.isNullOrEmpty((String)prefVal)) {
                    prefVal = defaultPrefValue;
                }
            } else {
                prefVal = defaultPrefValue;
            }
        }
        HashMap map = Util.isNullOrEmpty((String)prefVal) ? new HashMap() : DefaultTLDNamespaceSettings.prefValue2Map(prefVal);
        Object key = DefaultTLDNamespaceSettings.makeHashKey(theProjectScope);
        maps.put(key, map);
        return map;
    }

    public static void save(IProject theProjectScope) {
        Object key = DefaultTLDNamespaceSettings.makeHashKey(theProjectScope);
        HashMap map2save = (HashMap)maps.get(key);
        if (map2save == null) {
            return;
        }
        String prefVal = DefaultTLDNamespaceSettings.map2PrefValue(map2save);
        Preferences prefs = theProjectScope != null ? DefaultTLDNamespaceSettings.getPrefs(theProjectScope) : INSTANCE_PREFS;
        prefs.put(PREF_KEY, prefVal);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private static Object makeHashKey(IProject theProjectScope) {
        String key = theProjectScope == null ? NO_PROJECT_KEY : theProjectScope;
        return key;
    }

    private static String map2PrefValue(HashMap theMap) {
        StringBuffer buf = new StringBuffer(512);
        Iterator entries = theMap.entrySet().iterator();
        int i = 0;
        while (entries.hasNext()) {
            if (i > 0) {
                buf.append(';');
            }
            Map.Entry entry = entries.next();
            String tldURI = (String)entry.getKey();
            buf.append(tldURI);
            buf.append('=');
            String tldPrefix = (String)entry.getValue();
            buf.append(tldPrefix);
            ++i;
        }
        return buf.toString();
    }

    protected static HashMap prefValue2Map(String thePrefVal) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer toker = new StringTokenizer(thePrefVal, ";");
        while (toker.hasMoreElements()) {
            String assocString = toker.nextToken();
            int delimiterIdx = assocString.indexOf(61);
            String tldPrefix = assocString.substring(delimiterIdx + 1);
            String tldURI = assocString.substring(0, delimiterIdx);
            map.put(tldURI, tldPrefix);
            map.put(tldPrefix, tldURI);
        }
        return map;
    }

    protected static Preferences getPrefs(IProject theProject) {
        if (theProject == null) {
            return null;
        }
        IEclipsePreferences prefs = new ProjectScope(theProject).getNode(PREF_NODE_KEY);
        return prefs;
    }
}

