/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.j2eedt.ui.dialog;

import com.genuitec.eclipse.core.portability.TabFolderLayout;
import com.genuitec.eclipse.j2eedt.core.IWebProject;
import com.genuitec.eclipse.j2eedt.core.J2EEProjectUtil;
import com.genuitec.eclipse.j2eedt.core.JEEProjectManager;
import com.genuitec.eclipse.j2eedt.core.Messages;
import com.genuitec.eclipse.j2eedt.ui.taglib.DefaultTLDInfoBlock;
import com.genuitec.eclipse.j2eedt.ui.taglib.DefaultTLDNamespaceSettings;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;

public class WebProjectPropertiesPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private static String WEBPRJ_PREF_PAGE_ID = "com.genuitec.eclipse.j2ee.webproject.preferencepage";
    private StringButtonDialogField webRootDirDialogField;
    private Text webRootTextControl;
    private StringButtonDialogField webContextDialogField;
    private Text webContextText;
    private IPath fWebRootLocation;
    private ControlEnableState tldBlockEnableState;
    private SelectionButtonDialogField useProjectTldInfoDF;
    private DefaultTLDInfoBlock tldInfoBlock;
    private Control tldInfoBlockControl;
    private Button tldApplyButton;
    private Button tldDefaultsButton;

    public WebProjectPropertiesPage() {
        this.noDefaultAndApplyButton();
        WebRootLocationAdapter webRootdapter = new WebRootLocationAdapter();
        this.webRootDirDialogField = new StringButtonDialogField((IStringButtonAdapter)webRootdapter);
        this.webRootDirDialogField.setLabelText(Messages.WebProjectPropertiesPage_label_webroot);
        this.webRootDirDialogField.setButtonLabel(Messages.WebRootLocationDialog_button_config);
        this.webRootDirDialogField.setDialogFieldListener((IDialogFieldListener)webRootdapter);
        WebContextLocationAdapter contextLocationAdapter = new WebContextLocationAdapter();
        this.webContextDialogField = new StringButtonDialogField((IStringButtonAdapter)contextLocationAdapter);
        this.webContextDialogField.setLabelText(Messages.WebProjectPropertiesPage_label_contextroot);
        this.webContextDialogField.setButtonLabel(Messages.WebRootLocationDialog_button_config);
        this.webContextDialogField.setDialogFieldListener((IDialogFieldListener)contextLocationAdapter);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        IEclipsePreferences settings = J2EEProjectUtil.getProjectSettings((IProject)this.getProject());
        J2EEProjectUtil.flushProjectSettings((IEclipsePreferences)settings);
        boolean useProjectTldInfo = this.useProjectTldInfoDF.isSelected();
        DefaultTLDNamespaceSettings.setUseProjectSettings(this.getProject(), useProjectTldInfo);
        this.tldInfoBlock.performOk(true);
        return true;
    }

    protected Control createContents(Composite theParent) {
        TabFolder folder = new TabFolder(theParent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        this.createBasicPage(folder);
        this.createTldInfoPage(folder);
        return folder;
    }

    protected void createBasicPage(TabFolder theFolder) {
        TabItem item = new TabItem(theFolder, 0);
        item.setText(Messages.WebProjectPropertiesPage_tabitem_contextroot);
        Composite page = new Composite((Composite)theFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 15;
        page.setLayout((Layout)layout);
        Composite pageContent = new Composite(page, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.numColumns = 3;
        pageContent.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        pageContent.setLayoutData((Object)gd);
        this.webRootDirDialogField.doFillIntoGrid(pageContent, 3);
        this.webRootTextControl = this.webRootDirDialogField.getTextControl(pageContent);
        this.webRootTextControl.setEditable(false);
        this.webRootDirDialogField.setEnabled(true);
        this.webRootDirDialogField.setTextWithoutUpdate(this.getWebProject().getWebRootFolder().getProjectRelativePath().toString());
        LayoutUtil.setHorizontalGrabbing((Control)this.webRootTextControl);
        this.webContextDialogField.doFillIntoGrid(pageContent, 3);
        this.webContextText = this.webContextDialogField.getTextControl(pageContent);
        this.webContextText.setEditable(false);
        this.webContextDialogField.setEnabled(true);
        LayoutUtil.setHorizontalGrabbing((Control)this.webContextText);
        String ctx = this.getWebProject().getContextRoot();
        if (ctx == null) {
            ctx = "/";
        } else if (ctx.length() == 0) {
            ctx = "/";
        } else if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        this.webContextDialogField.setTextWithoutUpdate(ctx);
        Label spacer = new Label(pageContent, 8);
        gd = new GridData();
        gd.horizontalSpan = 3;
        spacer.setLayoutData((Object)gd);
        CLabel warningLabel = new CLabel(pageContent, 0);
        warningLabel.setText(Messages.WebProjectPropertiesPage_label_notice);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 1;
        warningLabel.setLayoutData((Object)gd);
        Text warningText = new Text(pageContent, 2378);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        warningText.setLayoutData((Object)gd);
        warningText.setText(Messages.WebProjectPropertiesPage_text_notice);
        item.setControl((Control)page);
    }

    protected void createTldInfoPage(TabFolder theFolder) {
        TabItem item = new TabItem(theFolder, 0);
        item.setText(Messages.WebProjectPropertiesPage_tabitem_taglibs);
        Composite page = new Composite((Composite)theFolder, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 15;
        page.setLayout((Layout)layout);
        Composite pageContent = new Composite(page, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        pageContent.setLayout((Layout)layout);
        this.useProjectTldInfoDF = new SelectionButtonDialogField(32);
        this.useProjectTldInfoDF.setLabelText(Messages.WebProjectPropertiesPage_label_tld_project_settings);
        this.useProjectTldInfoDF.doFillIntoGrid(pageContent, 1);
        this.useProjectTldInfoDF.setSelection(DefaultTLDNamespaceSettings.isUseProjectSettings(this.getProject()));
        this.useProjectTldInfoDF.setDialogFieldListener((IDialogFieldListener)new UseProjectPrefsAdapter());
        Link changeWorkspaceSettings = this.createLink(pageContent, Messages.WebProjectPropertiesPage_link_tld_configure_workspace);
        changeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Label horizontalLine = new Label(pageContent, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        horizontalLine.setFont(pageContent.getFont());
        this.tldInfoBlock = new DefaultTLDInfoBlock(this.getProject());
        this.tldInfoBlockControl = this.tldInfoBlock.createContents(pageContent, 2);
        Composite buttonBar = new Composite((Composite)this.tldInfoBlockControl, 0);
        layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        buttonBar.setLayout((Layout)layout);
        GridData gd = new GridData(128);
        gd.horizontalSpan = 2;
        buttonBar.setLayoutData((Object)gd);
        layout.numColumns += 2;
        String[] labels = JFaceResources.getStrings((String[])new String[]{"defaults", "apply"});
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        this.tldDefaultsButton = new Button(buttonBar, 8);
        this.tldDefaultsButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)this.tldDefaultsButton);
        GridData data = new GridData(256);
        Point minButtonSize = this.tldDefaultsButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        this.tldDefaultsButton.setLayoutData((Object)data);
        this.tldDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectPropertiesPage.this.tldInfoBlock.performDefaults();
            }
        });
        this.tldApplyButton = new Button(buttonBar, 8);
        this.tldApplyButton.setText(labels[1]);
        Dialog.applyDialogFont((Control)this.tldApplyButton);
        data = new GridData(256);
        minButtonSize = this.tldApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        this.tldApplyButton.setLayoutData((Object)data);
        this.tldApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectPropertiesPage.this.tldInfoBlock.performOk(true);
            }
        });
        this.tldApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(buttonBar);
        this.enableTLDContent(this.useProjectTldInfoDF.isSelected());
        item.setControl((Control)page);
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WebProjectPropertiesPage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                WebProjectPropertiesPage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    protected void doLinkActivated(Link link) {
        this.openWorkspacePreferences(null);
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = WEBPRJ_PREF_PAGE_ID;
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected void doChangeControlPressed() {
        String deploymentAssemblyPageId = "org.eclipse.wst.common.componentcore.ui.DeploymentAssemblyPage";
        IPreferencePageContainer preferencePageContainer = this.getContainer();
        if (preferencePageContainer instanceof PreferenceDialog) {
            PreferenceDialog preferenceDialog = (PreferenceDialog)preferencePageContainer;
            preferenceDialog.setSelectedNode(deploymentAssemblyPageId);
            IPreferenceNode daPreferenceNode = null;
            List nodes = preferenceDialog.getPreferenceManager().getElements(1);
            for (IPreferenceNode node : nodes) {
                if (!node.getId().equals(deploymentAssemblyPageId)) continue;
                daPreferenceNode = node;
                break;
            }
            if (daPreferenceNode != null) {
                preferenceDialog.getTreeViewer().setSelection((ISelection)new StructuredSelection(daPreferenceNode), true);
            }
        }
    }

    public IPath getWebRootLocation() {
        return this.fWebRootLocation;
    }

    public String getContextRoot() {
        String txt = this.webContextDialogField.getText();
        return txt;
    }

    protected IProject getProject() {
        IProject project = (IProject)this.getElement().getAdapter(IProject.class);
        return project;
    }

    protected IWebProject getWebProject() {
        return JEEProjectManager.createWebProject((IProject)this.getProject());
    }

    protected void enableTLDContent(boolean enable) {
        if (enable) {
            if (this.tldBlockEnableState != null) {
                this.tldBlockEnableState.restore();
                this.tldBlockEnableState = null;
            }
        } else if (this.tldBlockEnableState == null) {
            this.tldBlockEnableState = ControlEnableState.disable((Control)this.tldInfoBlockControl);
        }
    }

    private class UseProjectPrefsAdapter
    implements IDialogFieldListener {
        private UseProjectPrefsAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
            WebProjectPropertiesPage.this.enableTLDContent(WebProjectPropertiesPage.this.useProjectTldInfoDF.isSelected());
        }
    }

    private class WebContextLocationAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private WebContextLocationAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void changeControlPressed(DialogField field) {
            WebProjectPropertiesPage.this.doChangeControlPressed();
        }
    }

    private class WebRootLocationAdapter
    implements IDialogFieldListener,
    IStringButtonAdapter {
        private WebRootLocationAdapter() {
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void changeControlPressed(DialogField field) {
            WebProjectPropertiesPage.this.doChangeControlPressed();
        }
    }
}

