/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.breadcrumb.e4;

import com.genuitec.eclipse.meexplorer.MEExplorerPlugin;
import com.genuitec.eclipse.meexplorer.Messages;
import com.genuitec.eclipse.meexplorer.breadcrumb.BreadCrumbUtil;
import com.genuitec.eclipse.meexplorer.breadcrumb.MEBreadCrumbViewer;
import com.genuitec.eclipse.meexplorer.breadcrumb.e4.BreadCrumbModelManager;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;

public class BreadCrumbContainer {
    @Inject
    EModelService modelService;
    private MEBreadCrumbViewer breadcrumb;
    private Composite main;
    private Composite upper;
    private IWorkbenchWindow window;
    private MToolControl breadcrumbCtrl;

    @PostConstruct
    void createWidget(Composite parent, MToolControl toolControl) {
        this.breadcrumbCtrl = toolControl;
        MWindow mwindow = this.modelService.getTopLevelWindowFor((MUIElement)toolControl);
        if (mwindow instanceof MWindow) {
            this.window = (IWorkbenchWindow)mwindow.getContext().get(IWorkbenchWindow.class);
            MUIElement element = this.modelService.getContainer((MUIElement)toolControl);
            if (element instanceof MTrimBar && "BreadCrumbTrim".equals(((MTrimBar)element).getElementId())) {
                return;
            }
        }
        if (this.window != null && toolControl.getElementId().equals("breadcrumb.toolcontrol")) {
            this.createBreadCrumbWidget(parent);
        }
    }

    private void createBreadCrumbWidget(Composite parent) {
        this.upper = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean flushCache) {
                return new Point(0, 0);
            }
        };
        this.upper.setSize(0, 0);
        this.main = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean flushCache) {
                boolean toggleState = BreadCrumbModelManager.getInstance().getIsBreadcrumbVisible(BreadCrumbContainer.this.breadcrumbCtrl);
                Point res = toggleState ? new Point(2000, super.computeSize((int)wHint, (int)hHint, (boolean)flushCache).y) : new Point(0, super.computeSize((int)wHint, (int)hHint, (boolean)flushCache).y);
                return res;
            }
        };
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 6;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 2;
        this.main.setLayout((Layout)layout);
        this.createContextMenu(this.main);
        this.breadcrumb = new MEBreadCrumbViewer(this.window, this.breadcrumbCtrl, this.main, 0);
        this.breadcrumb.getContainer().setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        this.breadcrumbCtrl.setWidget((Object)this.main);
        parent.layout(true);
    }

    private void createContextMenu(Composite main) {
        Menu popupMenu = new Menu((Control)main);
        MenuItem newItem = new MenuItem(popupMenu, 0);
        newItem.setText(Messages.Breadcrumb_toggle_hide_label);
        main.setMenu(popupMenu);
        newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    BreadCrumbUtil.getToggleBreadCrumbCommand().executeWithChecks(new ExecutionEvent());
                }
                catch (Exception ex) {
                    MEExplorerPlugin.getDefault().log("Failed to hide the breadcrumb toolbar", ex, 4);
                }
            }
        });
    }

    @PreDestroy
    void destroy() {
        if (this.breadcrumb != null) {
            this.breadcrumb.dispose();
        }
        if (this.main != null) {
            this.main.dispose();
        }
        if (this.upper != null) {
            this.upper.dispose();
        }
    }
}

