/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.meexplorer.actions;

import com.genuitec.eclipse.core.ui.util.SearchTextControl;
import com.genuitec.eclipse.meexplorer.MEExplorerPlugin;
import com.genuitec.eclipse.meexplorer.MEExplorerSearchConstants;
import com.genuitec.eclipse.meexplorer.SearchPatternData;
import com.genuitec.eclipse.meexplorer.filter.MEFileNameFilter;
import com.genuitec.eclipse.meexplorer.navigator.FilenameFilterJob;
import com.genuitec.eclipse.meexplorer.navigator.FilteringStatusComposite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorFilterService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.swt.IFocusService;

public class MENavigatorSearchHandler
implements MEExplorerSearchConstants {
    private static final String DEFAULT_FILTERSTATUSLABEL_TEXT = "Filtering for ";
    private static final String SINGLEQUOTE_STR = "'";
    private static final String APPLYFILTER_REFRESHJOB = "ApplyFilterRefreshJob";
    private static final String CLEARFILTER_REFRESHJOB = "ClearFilterRefreshJob";
    private boolean regExpressionEnableState = false;
    private boolean caseSensitiveEnableState = false;
    private CommonViewer commonViewer;
    private boolean isFileContentSearchMode = false;
    private Job refreshJob;
    private Composite parentComposite;
    private FilteringStatusComposite filterControl;
    private SearchTextControl filterControl2;
    private static final int HISTORY_SIZE = 7;
    private static final long TREEEXPAND_TIMEOUT = 200L;
    private Map<String, SearchPatternData> filterSearchPatternDataHistory = new LinkedHashMap<String, SearchPatternData>(7);
    private ControlDecoration controlDecoration;
    private ContentAssistCommandAdapter fPatterFieldContentAssist;
    private String filterText = null;
    private long filterJobStartTime = 0L;
    private FilenameFilterJob filenameFilterJob;
    private JobChangeAdapter filterJobListener;
    private UIJob executeSearchJob;
    private boolean isFolderExcludeFilter = false;
    private long treeExpandStartTime = 0L;
    private CustomContentProposalProvider contentProposalProvider;
    private static final int EXECUTEFILTERJOB_DELAY = 1000;
    private static final String MODIFYTYPE_STR = "MODIFYTYPE";
    private static final String MODIFYTYPE_CODE = "CODE";
    public static boolean DEBUG = Platform.inDebugMode() && "true".equals(Platform.getDebugOption((String)"com.genuitec.eclipse.meexplorer/debug"));
    public static boolean DEBUG_SEARCH_PERFORMANCE = DEBUG && "true".equals(Platform.getDebugOption((String)"com.genuitec.eclipse.meexplorer/debug/searchperformance"));

    public MENavigatorSearchHandler(Composite parentComposite, CommonViewer commonViewer, FilteringStatusComposite filterControl, SearchTextControl filterControl2) {
        this.parentComposite = parentComposite;
        this.commonViewer = commonViewer;
        this.filterControl = filterControl;
        this.filterControl2 = filterControl2;
        this.createErrorDecorator();
        this.addSearchControlListeners();
        this.createFilterJobAndListener();
    }

    private void createFilterJobAndListener() {
        this.filenameFilterJob = new FilenameFilterJob("Filename filter job");
        this.createRefreshJob();
        this.filterJobListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                if (MENavigatorSearchHandler.this.filenameFilterJob.getResult() != Status.CANCEL_STATUS) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MENavigatorSearchHandler.this.runRefreshJob(MENavigatorSearchHandler.APPLYFILTER_REFRESHJOB);
                            MENavigatorSearchHandler.this.updateFilterComboHistory();
                        }
                    });
                }
            }
        };
        this.filenameFilterJob.addJobChangeListener((IJobChangeListener)this.filterJobListener);
        this.executeSearchJob = new UIJob("executeSearchJob"){

            public IStatus runInUIThread(IProgressMonitor arg0) {
                if (!MENavigatorSearchHandler.this.isFileContentSearchMode) {
                    MENavigatorSearchHandler.this.executeSearch();
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void createErrorDecorator() {
        TextContentAdapter contentAdapter = new TextContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.fPatterFieldContentAssist = new ContentAssistCommandAdapter((Control)this.filterControl2.getSearchTextControl(), (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        this.fPatterFieldContentAssist.setEnabled(false);
        this.controlDecoration = new ControlDecoration((Control)this.filterControl2, 16512);
        this.controlDecoration.setDescriptionText("");
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.controlDecoration.setImage(fieldDecoration.getImage());
        this.controlDecoration.hide();
    }

    public void initializeFilterControls() {
        ArrayList<String> patternStringList = new ArrayList<String>(7);
        patternStringList.addAll(this.filterSearchPatternDataHistory.keySet());
        try {
            this.contentProposalProvider = new CustomContentProposalProvider(patternStringList);
            ContentProposalAdapter contentProposalAdapter = new ContentProposalAdapter((Control)this.filterControl2.getSearchTextControl(), (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.contentProposalProvider, KeyStroke.getInstance((String)"Ctrl+Space"), null);
            contentProposalAdapter.setProposalAcceptanceStyle(2);
        }
        catch (ParseException ex) {
            MEExplorerPlugin.getDefault().log("Content proposal for Search field failed", ex);
        }
        if (patternStringList.size() > 0) {
            this.filterControl2.setData(MODIFYTYPE_STR, (Object)MODIFYTYPE_CODE);
            this.filterControl2.setFilterText((String)patternStringList.get(patternStringList.size() - 1));
            this.filterControl2.setData(MODIFYTYPE_STR, null);
        }
        this.updateToggleParamStatus();
    }

    private void updateToggleParamStatus() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command searchCaseSensitiveCommand = commandService.getCommand("com.genuitec.myeclipse.perspective.meexplorer.search.casesensitivecommand");
        this.caseSensitiveEnableState = (Boolean)searchCaseSensitiveCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
        Command searchRegularExpressionCommand = commandService.getCommand("com.genuitec.myeclipse.perspective.meexplorer.search.regexcommand");
        this.regExpressionEnableState = (Boolean)searchRegularExpressionCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
        Command searchFilterModeCommand = commandService.getCommand("com.genuitec.myeclipse.perspective.meexplorer.search.searchmodecommand");
        this.isFileContentSearchMode = (Boolean)searchFilterModeCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
        commandService.refreshElements(searchFilterModeCommand.getId(), null);
        Command folderFilterModeCommand = commandService.getCommand("com.genuitec.myeclipse.perspective.meexplorer.search.folderfiltertogglecommand");
        this.isFolderExcludeFilter = (Boolean)folderFilterModeCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
        commandService.refreshElements(folderFilterModeCommand.getId(), null);
    }

    private void addSearchControlListeners() {
        this.filterControl2.setSearchRunnable(new SearchTextControl.ISearchRunnable(){

            public void performSearch(String phrase) {
                MENavigatorSearchHandler.this.executeSearchJob.cancel();
                MENavigatorSearchHandler.this.executeSearch();
            }
        });
        this.filterControl.getCompositeCloseButtonLabel().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                MENavigatorSearchHandler.this.doLayoutTreeFilterStatusComposite(false);
                MENavigatorSearchHandler.this.filterJobStartTime = System.currentTimeMillis();
                MENavigatorSearchHandler.this.runRefreshJob(MENavigatorSearchHandler.CLEARFILTER_REFRESHJOB);
            }
        });
        this.filterControl2.getSearchTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                MENavigatorSearchHandler.this.validateRegex();
                if (MENavigatorSearchHandler.this.isFileContentSearchMode) {
                    return;
                }
                Object modifyType = MENavigatorSearchHandler.this.filterControl2.getData(MENavigatorSearchHandler.MODIFYTYPE_STR);
                if (modifyType == null) {
                    MENavigatorSearchHandler.this.executeSearchJob.cancel();
                    MENavigatorSearchHandler.this.executeSearchJob.schedule(1000L);
                }
            }
        });
        IFocusService fs = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        fs.addFocusTracker((Control)this.filterControl2.getSearchTextControl(), "SearchTextControl");
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateRegex() {
        if (this.isFileContentSearchMode && this.regExpressionEnableState) {
            block5: {
                try {
                    PatternConstructor.createPattern((String)this.filterControl2.getText().trim(), (boolean)this.caseSensitiveEnableState, (boolean)true);
                    break block5;
                }
                catch (PatternSyntaxException e) {
                    locMessage = e.getLocalizedMessage();
                    i = 0;
                    ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    continue;
                }
lbl12:
                // 1 sources

                this.filterControl2.setToolTipText(locMessage.substring(0, i));
                this.controlDecoration.show();
                return false;
            }
            this.hideControlDecoration();
        } else {
            this.hideControlDecoration();
        }
        return true;
    }

    private void hideControlDecoration() {
        this.controlDecoration.hide();
        this.filterControl2.setToolTipText("");
    }

    private void findSearchPatternDataFromHistory(String patternString) {
        if (this.filterSearchPatternDataHistory.containsKey(patternString)) {
            this.updateSearchSettingCommandStatus(patternString);
        }
    }

    private void updateSearchSettingCommandStatus(String patternString) {
        SearchPatternData searchPatternData = this.filterSearchPatternDataHistory.get(patternString);
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command searchCaseSensitiveCommand = commandService.getCommand("com.genuitec.myeclipse.perspective.meexplorer.search.casesensitivecommand");
            this.caseSensitiveEnableState = (Boolean)searchCaseSensitiveCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
            if (this.caseSensitiveEnableState != searchPatternData.isCaseSensitiveEnabled()) {
                HandlerUtil.toggleCommandState((Command)searchCaseSensitiveCommand);
            }
            Command searchRegularExpressionCommand = commandService.getCommand("com.genuitec.myeclipse.perspective.meexplorer.search.regexcommand");
            this.regExpressionEnableState = (Boolean)searchRegularExpressionCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
            if (this.regExpressionEnableState != searchPatternData.isRegExpressionEnabled()) {
                HandlerUtil.toggleCommandState((Command)searchRegularExpressionCommand);
            }
            Command searchFilterModeCommand = commandService.getCommand("com.genuitec.myeclipse.perspective.meexplorer.search.searchmodecommand");
            this.isFileContentSearchMode = (Boolean)searchFilterModeCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
            if (this.isFileContentSearchMode != searchPatternData.isFileContentSearchMode()) {
                searchFilterModeCommand.getHandler().execute(new ExecutionEvent());
            }
            this.isFileContentSearchMode = (Boolean)searchFilterModeCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
            this.setRegExpressionEnableState(searchPatternData.isRegExpressionEnabled());
            Command folderFilterModeCommand = commandService.getCommand("com.genuitec.myeclipse.perspective.meexplorer.search.folderfiltertogglecommand");
            this.isFolderExcludeFilter = (Boolean)folderFilterModeCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
            if (this.isFolderExcludeFilter != searchPatternData.isFolderExcludeFilter()) {
                folderFilterModeCommand.getHandler().execute(new ExecutionEvent());
            }
            this.isFolderExcludeFilter = (Boolean)folderFilterModeCommand.getState("org.eclipse.ui.commands.toggleState").getValue();
        }
        catch (ExecutionException ex) {
            MEExplorerPlugin.getDefault().log("Error occured while trying to set search settings command handler status", ex);
        }
    }

    private void updateSearchTextContentAssistSupport() {
        if (this.isFileContentSearchMode) {
            this.fPatterFieldContentAssist.setEnabled(this.regExpressionEnableState);
            if (this.regExpressionEnableState) {
                this.validateRegex();
            } else {
                this.hideControlDecoration();
            }
        } else {
            this.fPatterFieldContentAssist.setEnabled(false);
            this.hideControlDecoration();
        }
    }

    private void executeSearch() {
        if (this.controlDecoration.isVisible()) {
            return;
        }
        if (this.isFileContentSearchMode) {
            ISearchQuery searchQuery = this.createQuery();
            if (searchQuery != null) {
                NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
            }
            this.updateFilterComboHistory();
        } else {
            boolean filterCompositeVisibleState = true;
            this.filterText = this.filterControl2.getText().trim();
            if (this.filterText.isEmpty()) {
                filterCompositeVisibleState = false;
            } else {
                this.appendWildCardsToFilterText();
            }
            this.doLayoutTreeFilterStatusComposite(filterCompositeVisibleState);
            this.filterJobStartTime = System.currentTimeMillis();
            if (this.filterText != null && !this.filterText.isEmpty()) {
                this.filenameFilterJob.cancel();
                this.filenameFilterJob.initialize(this.filterText, this.isCaseSensitiveEnabled(), this.isFolderExcludeFilter());
                this.filenameFilterJob.schedule();
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MENavigatorSearchHandler.this.runRefreshJob(MENavigatorSearchHandler.CLEARFILTER_REFRESHJOB);
                        MENavigatorSearchHandler.this.updateFilterComboHistory();
                    }
                });
            }
        }
    }

    private void updateFilterComboHistory() {
        if (!this.filterSearchPatternDataHistory.containsKey(this.filterControl2.getText().trim())) {
            if (this.filterSearchPatternDataHistory.size() == 7) {
                this.filterSearchPatternDataHistory.remove(0);
            }
            SearchPatternData searchPatternData = new SearchPatternData(this.filterControl2.getText().trim(), this.isFileContentSearchMode, this.regExpressionEnableState, this.caseSensitiveEnableState, this.isFolderExcludeFilter);
            this.filterSearchPatternDataHistory.put(this.filterControl2.getText().trim(), searchPatternData);
        } else {
            this.findExistingElementAndGetonTop();
        }
        String currentText = this.filterControl2.getText();
        ArrayList<String> patternStringList = new ArrayList<String>(7);
        patternStringList.addAll(this.filterSearchPatternDataHistory.keySet());
        this.contentProposalProvider.setProposals(patternStringList);
        this.filterControl2.setData(MODIFYTYPE_STR, (Object)MODIFYTYPE_CODE);
        this.filterControl2.setFilterText(currentText);
        this.filterControl2.setData(MODIFYTYPE_STR, null);
    }

    private void findExistingElementAndGetonTop() {
        String key = this.filterControl2.getText().trim();
        if (this.filterSearchPatternDataHistory.containsKey(key)) {
            SearchPatternData searchPatternData = new SearchPatternData(key, this.isFileContentSearchMode, this.regExpressionEnableState, this.caseSensitiveEnableState, this.isFolderExcludeFilter);
            this.filterSearchPatternDataHistory.remove(key);
            this.filterSearchPatternDataHistory.put(key, searchPatternData);
        }
    }

    private void doLayoutTreeFilterStatusComposite(boolean compositeVisibleState) {
        Composite treeFilterStatusComposite = this.filterControl.getTreeFilterStatusComposite();
        if (compositeVisibleState) {
            String finalString = SINGLEQUOTE_STR + this.filterText + SINGLEQUOTE_STR;
            this.filterControl.getFilterStatusLabel().setText(DEFAULT_FILTERSTATUSLABEL_TEXT + finalString);
        }
        if (treeFilterStatusComposite.isVisible() != compositeVisibleState) {
            treeFilterStatusComposite.setVisible(compositeVisibleState);
            GridData data = (GridData)treeFilterStatusComposite.getLayoutData();
            data.exclude = !compositeVisibleState;
            treeFilterStatusComposite.setLayoutData((Object)data);
            this.parentComposite.layout(new Control[]{treeFilterStatusComposite});
        }
    }

    private void appendWildCardsToFilterText() {
        if (!this.filterText.contains("*") && !this.filterText.contains("?")) {
            this.filterText = "*" + this.filterText + "*";
        }
    }

    private void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (MENavigatorSearchHandler.this.commonViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                MEFileNameFilter filter = MENavigatorSearchHandler.this.getMEFileNameFilter();
                if (filter == null) {
                    MENavigatorSearchHandler.this.doLayoutTreeFilterStatusComposite(false);
                    return Status.OK_STATUS;
                }
                if (MENavigatorSearchHandler.this.refreshJob.getName().equals(MENavigatorSearchHandler.APPLYFILTER_REFRESHJOB) && MENavigatorSearchHandler.this.filenameFilterJob != null) {
                    filter.setResultSet(MENavigatorSearchHandler.this.filenameFilterJob.getResultSet());
                    filter.setFolderExcludeFilterState(MENavigatorSearchHandler.this.filenameFilterJob.isFolderExcludeFilter());
                } else {
                    filter.setResultSet(null);
                }
                try {
                    MENavigatorSearchHandler.this.commonViewer.getControl().setRedraw(false);
                    MENavigatorSearchHandler.this.commonViewer.refresh(true);
                    if (MENavigatorSearchHandler.this.refreshJob.getName().equals(MENavigatorSearchHandler.CLEARFILTER_REFRESHJOB)) {
                        IStructuredSelection selection = (IStructuredSelection)MENavigatorSearchHandler.this.commonViewer.getSelection();
                        MENavigatorSearchHandler.this.commonViewer.collapseAll();
                        MENavigatorSearchHandler.this.commonViewer.setSelection((ISelection)selection, true);
                    } else {
                        TreeItem[] itemsToShow = MENavigatorSearchHandler.this.commonViewer.getTree().getItems();
                        if (itemsToShow.length > 0) {
                            MENavigatorSearchHandler.this.treeExpandStartTime = System.currentTimeMillis();
                            MENavigatorSearchHandler.this.expandTree(itemsToShow);
                            MENavigatorSearchHandler.this.commonViewer.getTree().showItem(itemsToShow[0]);
                        }
                    }
                }
                finally {
                    MENavigatorSearchHandler.this.commonViewer.getControl().setRedraw(true);
                    if (DEBUG_SEARCH_PERFORMANCE) {
                        MEExplorerPlugin.getDefault().log("MyEclipse Explorer filename filtering for filterText = \"" + MENavigatorSearchHandler.this.filterText + "\" done in " + (System.currentTimeMillis() - MENavigatorSearchHandler.this.filterJobStartTime) + " milliseconds");
                    }
                    MENavigatorSearchHandler.this.filterJobStartTime = 0L;
                }
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
    }

    protected boolean expandTree(TreeItem[] itemsToShow) {
        int i = 0;
        while (i < itemsToShow.length) {
            TreeItem item = itemsToShow[i];
            Object itemData = item.getData();
            if (itemData != null) {
                TreeItem[] children;
                if (System.currentTimeMillis() - this.treeExpandStartTime > 200L) {
                    return false;
                }
                if (!item.getExpanded()) {
                    this.commonViewer.setExpandedState(itemData, true);
                }
                if ((children = item.getItems()).length > 0) {
                    this.expandTree(children);
                }
            }
            ++i;
        }
        return true;
    }

    private MEFileNameFilter getMEFileNameFilter() {
        MEFileNameFilter meFileNameFilter = this.searchinActiveFilterList();
        if (meFileNameFilter == null) {
            INavigatorFilterService filterService = this.commonViewer.getNavigatorContentService().getFilterService();
            boolean activeState = this.commonViewer.getNavigatorContentService().getFilterService().isActive("com.genuitec.eclipse.meexplorer.mefilenamefilter");
            if (!activeState) {
                ((NavigatorFilterService)filterService).addActiveFilterIds(new String[]{"com.genuitec.eclipse.meexplorer.mefilenamefilter"});
                ((NavigatorFilterService)filterService).updateViewer();
            }
            meFileNameFilter = this.searchinActiveFilterList();
        }
        return meFileNameFilter;
    }

    private MEFileNameFilter searchinActiveFilterList() {
        ViewerFilter[] viewerFilterArray = this.commonViewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (filter instanceof MEFileNameFilter) {
                return (MEFileNameFilter)filter;
            }
            ++n2;
        }
        return null;
    }

    private ISearchQuery createQuery() {
        if (this.filterControl2.getText().trim().equals("")) {
            return null;
        }
        ISelection selection = this.commonViewer.getSelection();
        IResource[] resources = this.extractAllSelection(selection);
        if (resources.length == 0) {
            return new FileSearchQuery(this.filterControl2.getText().trim(), this.regExpressionEnableState, this.caseSensitiveEnableState, FileTextSearchScope.newWorkspaceScope((String[])new String[]{"*"}, (boolean)false));
        }
        return new FileSearchQuery(this.filterControl2.getText().trim(), this.regExpressionEnableState, this.caseSensitiveEnableState, FileTextSearchScope.newSearchScope((IResource[])resources, (String[])new String[]{"*"}, (boolean)false));
    }

    private IResource[] extractAllSelection(ISelection sel) {
        Object[] selections;
        HashSet<IResource> validSelectedResources = new HashSet<IResource>();
        if (sel == null || !(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)sel;
        Object[] objectArray = selections = ss.toArray();
        int n = selections.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                validSelectedResources.add((IResource)element);
            }
            if (element instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)element;
                Object adapter = adaptable.getAdapter(IResource.class);
                validSelectedResources.add((IResource)adapter);
            }
            ++n2;
        }
        return validSelectedResources.toArray(new IResource[validSelectedResources.size()]);
    }

    private void runRefreshJob(String refreshJobKind) {
        this.refreshJob.cancel();
        if (refreshJobKind.equals(CLEARFILTER_REFRESHJOB)) {
            this.refreshJob.setName(CLEARFILTER_REFRESHJOB);
        } else {
            this.refreshJob.setName(APPLYFILTER_REFRESHJOB);
        }
        this.refreshJob.schedule();
    }

    public boolean isRegExpressionEnabled() {
        return this.regExpressionEnableState;
    }

    public void setRegExpressionEnableState(boolean regExpressionEnableState) {
        this.regExpressionEnableState = regExpressionEnableState;
        this.updateSearchTextContentAssistSupport();
    }

    public boolean isCaseSensitiveEnabled() {
        return this.caseSensitiveEnableState;
    }

    public void setCaseSensitiveEnableState(boolean caseSensitiveEnableState) {
        this.caseSensitiveEnableState = caseSensitiveEnableState;
        this.runSearch();
    }

    public boolean isFileContentSearchMode() {
        return this.isFileContentSearchMode;
    }

    public void setFileContentSearchFilterMode(boolean toggleState) {
        this.isFileContentSearchMode = toggleState;
        this.updateSearchTextContentAssistSupport();
        this.runSearch();
    }

    public Map<String, SearchPatternData> getFilterSearchPatternDataHistory() {
        return this.filterSearchPatternDataHistory;
    }

    public boolean isFolderExcludeFilter() {
        return this.isFolderExcludeFilter;
    }

    public void setFolderExcludeFilterState(boolean isFolderExcludeFilter) {
        this.isFolderExcludeFilter = isFolderExcludeFilter;
        this.runSearch();
    }

    private void runSearch() {
        if (!this.isFileContentSearchMode) {
            this.executeSearchJob.cancel();
            this.executeSearchJob.schedule();
        }
    }

    private final class CustomContentProposalProvider
    implements IContentProposalProvider {
        List<String> items;

        public CustomContentProposalProvider(List<String> items) {
            this.items = items;
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList<ContentProposal> validProposals = new ArrayList<ContentProposal>();
            for (String prop : this.items) {
                if (!prop.toLowerCase().contains(contents)) continue;
                validProposals.add(new ContentProposal(prop));
            }
            return validProposals.toArray(new IContentProposal[validProposals.size()]);
        }

        public void setProposals(List<String> proposals) {
            this.items = proposals;
        }
    }
}

