/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core.internal;

import com.genuitec.eclipse.server.core.IGenuitecServer;
import com.genuitec.eclipse.server.core.util.IDynamicVariable;
import com.genuitec.eclipse.server.core.util.IVariableProvider;
import com.genuitec.eclipse.server.core.util.VariableSubstitutionEngine;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;

public class ServerArgumentsSubstitutionEngine
extends VariableSubstitutionEngine {
    public ServerArgumentsSubstitutionEngine(IGenuitecServer server) {
        super(new VariableProvider(server));
    }

    public void addDynamicVariable(String name, IDynamicVariable dynamicVariable) {
        this.getVariableProvider().dynamicVars.put(name, dynamicVariable);
    }

    @Override
    protected VariableProvider getVariableProvider() {
        return (VariableProvider)super.getVariableProvider();
    }

    private static class EnvironmentVariableProvider
    implements IDynamicVariable {
        private EnvironmentVariableProvider() {
        }

        @Override
        public String getValue(String arg) {
            return System.getenv(arg);
        }
    }

    private static class PathAdjuster
    implements IDynamicVariable {
        private PathAdjuster() {
        }

        @Override
        public String getValue(String arg) {
            if (arg.contains(";")) {
                String[] paths = arg.split(";");
                int i = 0;
                while (i < paths.length) {
                    paths[i] = new Path(paths[i]).toOSString();
                    ++i;
                }
                StringBuilder sb = new StringBuilder();
                int i2 = 0;
                while (i2 < paths.length) {
                    if (i2 > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(paths[i2]);
                    ++i2;
                }
                return sb.toString();
            }
            return new Path(arg).toOSString();
        }
    }

    private static class VariableProvider
    implements IVariableProvider {
        private IGenuitecServer server;
        private Map<String, IDynamicVariable> dynamicVars = new HashMap<String, IDynamicVariable>();

        public VariableProvider(IGenuitecServer server) {
            this.server = server;
            this.dynamicVars.put("path", new PathAdjuster());
            this.dynamicVars.put("env", new EnvironmentVariableProvider());
        }

        @Override
        public String getStaticVariable(String name) {
            return this.server.getServerAttribute(name);
        }

        @Override
        public IDynamicVariable getDynamicVariable(String name) {
            return this.dynamicVars.get(name);
        }
    }
}

