/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.server.core;

import com.genuitec.eclipse.server.core.IGenuitecServer;
import com.genuitec.eclipse.server.core.IGenuitecServerLaunchConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IJavaRuntime;

public abstract class BaseServerLaunchConfig
implements IGenuitecServerLaunchConfig {
    protected IGenuitecServer server;

    public BaseServerLaunchConfig(IGenuitecServer server) {
        this.server = server;
    }

    @Override
    public List<IRuntimeClasspathEntry> getLaunchClasspath() throws CoreException {
        String[] cp = this.internalGetLaunchClasspath();
        ArrayList<IRuntimeClasspathEntry> result = new ArrayList<IRuntimeClasspathEntry>(cp.length);
        String[] stringArray = cp;
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (new File(str).exists()) {
                result.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(str)));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Map<String, String> getEnvironmentVars() throws CoreException {
        return null;
    }

    @Override
    public boolean shouldReplaceSystemEnvVars() {
        return false;
    }

    protected String[] internalGetLaunchClasspath() throws CoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IVMInstall getLaunchVMInstall() {
        IJavaRuntime runtime = this.server.getServer().getRuntime() != null ? (IJavaRuntime)this.server.getServer().getRuntime().loadAdapter(IJavaRuntime.class, null) : null;
        return runtime != null ? runtime.getVMInstall() : JavaRuntime.getDefaultVMInstall();
    }
}

