/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core.util;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.portability.IDEWorkbenchMessages;
import com.genuitec.eclipse.core.util.UIUtil;
import com.genuitec.eclipse.core.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.part.FileEditorInput;

public class JdtSimpleResourceOld {
    private IWizardContainer container;
    private IFile newFile;
    private IWorkbench workbench;
    private IFile f;
    InputStream content;

    public JdtSimpleResourceOld(IFile file, InputStream content, IWizardContainer container, IWorkbench workbench) {
        this.f = file;
        this.content = content;
        this.container = container;
        this.workbench = workbench;
    }

    public JdtSimpleResourceOld(IFile file, String content, IWizardContainer container, IWorkbench workbench) {
        this.f = file;
        this.content = content != null ? new ByteArrayInputStream(content.getBytes()) : new ByteArrayInputStream(new byte[0]);
        this.container = container;
        this.workbench = workbench;
    }

    public IWizardContainer getContainer() {
        return this.container;
    }

    public boolean create() {
        return this.create(false);
    }

    public boolean create(boolean openInEditor) {
        IFile file = this.createNewFile();
        if (file == null) {
            return false;
        }
        if (openInEditor) {
            IWorkbenchWindow dw = this.workbench.getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page = dw.getActivePage();
                if (page != null) {
                    page.openEditor((IEditorInput)new FileEditorInput(file), UIUtil.getEditorId(file));
                }
            }
            catch (PartInitException e) {
                DialogUtil.openError((Shell)dw.getShell(), (String)"Error", (String)e.getMessage(), (PartInitException)e);
            }
        }
        return true;
    }

    public IFile createNewFile() {
        if (this.newFile != null) {
            return this.newFile;
        }
        final IFile newFileHandle = this.f;
        final InputStream initialContents = this.getInitialContents();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                try {
                    monitor.beginTask(Util.format((String)Messages.JdtSimpleResourceOld_task_creating_file, (String)JdtSimpleResourceOld.this.f.getFullPath().toString()), 2000);
                    ContainerGenerator generator = new ContainerGenerator(JdtSimpleResourceOld.this.f.getParent().getFullPath());
                    generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    JdtSimpleResourceOld.this.createFile(newFileHandle, initialContents, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                CommonUI.getDefault().log(MessageFormat.format("Exception in {0}.getNewFile(): {1}", this.getClass().getName(), e.getTargetException()));
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)e.getTargetException().getMessage());
            }
            return null;
        }
        this.newFile = newFileHandle;
        return this.newFile;
    }

    protected InputStream getInitialContents() {
        return this.content;
    }

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        try {
            if (!fileHandle.exists()) {
                fileHandle.create(contents, false, monitor);
            } else {
                fileHandle.setContents(contents, false, true, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void selectAndReveal(IResource newResource) {
        JdtSimpleResourceOld.selectAndReveal(newResource, this.workbench.getActiveWorkbenchWindow());
    }

    public static void selectAndReveal(IResource resource, IWorkbenchWindow window) {
    }
}

