/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core;

import com.genuitec.eclipse.core.CommonUI;
import com.genuitec.eclipse.core.JavaVMUtility;
import com.genuitec.eclipse.core.LaunchConfigurationUIUtil;
import com.genuitec.eclipse.core.Messages;
import com.genuitec.eclipse.core.ui.console.CustomConsoleException;
import com.genuitec.eclipse.core.ui.console.CustomConsoleLaunch;
import com.genuitec.eclipse.core.ui.console.IConsoleColorProviderFactory;
import com.genuitec.eclipse.core.util.UIUtil;
import com.genuitec.eclipse.core.util.Util;
import com.genuitec.eclipse.profiler.ProfilerLaunchRegistry;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public final class JavaVMUIUtility
extends JavaVMUtility {
    public static Launch execute(String theClassToLaunch, String[] theClasspath, String[] theVMArgs, String[] theProgramArgs, String theWorkingDirectory, IVMInstall theVMInstallation, boolean theIsDebugFlag, String theServerType, String launchName, ISourceLocator theSourceLocator, boolean theIsShutdownFlag) throws CoreException {
        Launch launch = JavaVMUIUtility.execute(theClassToLaunch, theClasspath, theVMArgs, theProgramArgs, theWorkingDirectory, theVMInstallation, theIsDebugFlag, theServerType, launchName, theSourceLocator, theIsShutdownFlag, null, null);
        return launch;
    }

    public static Launch execute(String theClassToLaunch, String[] theClasspath, String[] theVMArgs, String[] theProgramArgs, String theWorkingDirectory, IVMInstall theVMInstallation, boolean theIsDebugFlag, String theServerType, String launchName, ISourceLocator theSourceLocator, boolean theIsShutdownFlag, Map<String, String> envVarMap, IConsoleColorProviderFactory consoleColorProviderFactory) throws CoreException {
        IVMRunner vmRunner;
        String settingsFile;
        IVMInstall vmInstall = theVMInstallation == null ? JavaVMUIUtility.getVMInstall() : theVMInstallation;
        ILaunchConfigurationWorkingCopy config = LaunchConfigurationUIUtil.getRemoteLaunchConfiguration((String)theServerType, (boolean)theIsShutdownFlag);
        if (envVarMap != null) {
            config.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envVarMap);
        }
        boolean profileMode = false;
        if (theServerType != null && !theIsShutdownFlag && (settingsFile = ProfilerLaunchRegistry.getProfilerId(theServerType)) != null) {
            profileMode = true;
            ProfilerLaunchRegistry.disableProfiler(theServerType);
            String[] args2 = new String[theVMArgs.length + 1];
            System.arraycopy(theVMArgs, 0, args2, 0, theVMArgs.length);
            args2[theVMArgs.length] = "-Dmeprofiler.settings=" + settingsFile;
            theVMArgs = args2;
        }
        CustomConsoleLaunch launch = null;
        if (vmInstall != null && (vmRunner = vmInstall.getVMRunner(theIsDebugFlag ? "debug" : "run")) != null) {
            VMRunnerConfiguration vmConfig = new VMRunnerConfiguration(theClassToLaunch, theClasspath);
            if (theVMArgs != null) {
                vmConfig.setVMArguments(theVMArgs);
            }
            if (theProgramArgs != null) {
                vmConfig.setProgramArguments(theProgramArgs);
            }
            if (theWorkingDirectory != null) {
                vmConfig.setWorkingDirectory(theWorkingDirectory);
            }
            if (theSourceLocator instanceof ISourceLookupDirector) {
                ISourceLookupDirector sourceLookup = (ISourceLookupDirector)theSourceLocator;
                sourceLookup.initializeDefaults((ILaunchConfiguration)config);
            }
            if (consoleColorProviderFactory != null) {
                try {
                    launch = new CustomConsoleLaunch((ILaunchConfiguration)config, !profileMode ? (theIsDebugFlag ? "debug" : "run") : "profile", theSourceLocator, consoleColorProviderFactory);
                }
                catch (CustomConsoleException ex) {
                    CommonUI.getDefault().log(ex);
                }
            }
            if (launch == null) {
                launch = new Launch((ILaunchConfiguration)config, !profileMode ? (theIsDebugFlag ? "debug" : "run") : "profile", theSourceLocator);
            }
            if (envVarMap != null) {
                String[] envp = DebugPlugin.getDefault().getLaunchManager().getEnvironment((ILaunchConfiguration)config);
                vmConfig.setEnvironment(envp);
            }
            vmRunner.run(vmConfig, launch, null);
        }
        return launch;
    }

    public static boolean vmIsFullJDK(String theVMName) {
        IVMInstall vmInstall = JavaVMUIUtility.getVMInstall((String)theVMName);
        if (vmInstall == null) {
            MessageDialog.openError((Shell)UIUtil.getActiveShell(), (String)Messages.JavaVMUtility_dialog_jdk_doesnt_exist_title, (String)Messages.JavaVMUtility_dialog_jdk_doesnt_exist_message);
            return false;
        }
        File rootDirectory = vmInstall.getInstallLocation();
        File checkSubDir = new File(rootDirectory, "jre");
        if (Util.isMacPlatform()) {
            checkSubDir = new File(rootDirectory, "bin");
        }
        if (!rootDirectory.exists() || !checkSubDir.exists()) {
            MessageDialog.openError((Shell)UIUtil.getActiveShell(), (String)Messages.JavaVMUtility_dialog_jdk_not_jre_title, (String)Messages.JavaVMUtility_dialog_jdk_not_jre_message);
            return false;
        }
        return true;
    }

    public static void terminate(ILaunch theLaunch, String theConsoleMessage) throws DebugException {
        if (theLaunch != null) {
            theLaunch.terminate();
            UIUtil.appendToConsole(theLaunch, theConsoleMessage);
        }
    }

    public static boolean isJava5(String theVMName) {
        String version;
        IVMInstall vmInstall = JavaVMUIUtility.getVMInstall((String)theVMName);
        if (vmInstall == null) {
            MessageDialog.openError((Shell)UIUtil.getActiveShell(), (String)Messages.JavaVMUtility_dialog_jdk_doesnt_exist_title, (String)Messages.JavaVMUtility_dialog_jdk_doesnt_exist_message);
            return false;
        }
        if (vmInstall instanceof IVMInstall2 && !Util.testVMVersion((String)(version = ((IVMInstall2)vmInstall).getJavaVersion()), (int)1, (int)5, (int)0)) {
            MessageDialog.openError((Shell)UIUtil.getActiveShell(), (String)Messages.JavaVMUtility_dialog_jdk_doesnt_exist_title, (String)Messages.JavaVMUtility_jre_not_java5);
            return false;
        }
        return true;
    }

    public static boolean isJava6(String theVMName) {
        String version;
        IVMInstall vmInstall = JavaVMUIUtility.getVMInstall((String)theVMName);
        if (vmInstall == null) {
            MessageDialog.openError((Shell)UIUtil.getActiveShell(), (String)Messages.JavaVMUtility_dialog_jdk_doesnt_exist_title, (String)Messages.JavaVMUtility_dialog_jdk_doesnt_exist_message);
            return false;
        }
        if (vmInstall instanceof IVMInstall2 && !Util.testVMVersion((String)(version = ((IVMInstall2)vmInstall).getJavaVersion()), (int)1, (int)6, (int)0)) {
            MessageDialog.openError((Shell)UIUtil.getActiveShell(), (String)Messages.JavaVMUtility_dialog_jdk_doesnt_exist_title, (String)Messages.JavaVMUtility_jre_not_java6);
            return false;
        }
        return true;
    }

    public static Launch executeCommandline(String theClassToLaunch, String[] theClasspath, String[] theVMArgs, String[] theProgramArgs, String theWorkingDirectory, IVMInstall theVMInstallation, boolean theIsDebugFlag, String theServerType, String launchName, ISourceLocator theSourceLocator, boolean theIsShutdownFlag, String theHostName, int debugPort, IConsoleColorProviderFactory consoleColorProviderFactory) throws CoreException {
        String settingsFile;
        boolean profileMode = false;
        if (theServerType != null && !theIsShutdownFlag && (settingsFile = ProfilerLaunchRegistry.getProfilerId(theServerType)) != null) {
            profileMode = true;
            ProfilerLaunchRegistry.disableProfiler(theServerType);
            String[] args2 = new String[theVMArgs.length + 1];
            System.arraycopy(theVMArgs, 0, args2, 0, theVMArgs.length);
            args2[theVMArgs.length] = "-Dmeprofiler.settings=" + settingsFile;
            theVMArgs = args2;
        }
        ILaunchConfigurationWorkingCopy config = LaunchConfigurationUIUtil.getRemoteLaunchConfiguration((String)theServerType, (boolean)theIsShutdownFlag);
        config.setAttribute("SERVER_IS_COMMAND_LINE_ATTR", true);
        config.setAttribute("SERVER_HOST_NAME_ATTR", theHostName);
        config.setAttribute("SERVER_DEBUG_PORT_ATTR", String.valueOf(debugPort));
        CustomConsoleLaunch launch = null;
        if (consoleColorProviderFactory != null) {
            try {
                launch = new CustomConsoleLaunch((ILaunchConfiguration)config, !profileMode ? (theIsDebugFlag ? "debug" : "run") : "profile", theSourceLocator, consoleColorProviderFactory);
            }
            catch (CustomConsoleException ex) {
                CommonUI.getDefault().log(ex);
            }
        }
        if (launch == null) {
            launch = new Launch((ILaunchConfiguration)config, !profileMode ? (theIsDebugFlag ? "debug" : "run") : "profile", theSourceLocator);
        }
        LaunchConfigurationUIUtil.runCommandLauncher((ILaunchConfiguration)config, (ILaunch)launch, launchName, theProgramArgs, new File(theWorkingDirectory));
        if (theIsDebugFlag) {
            LaunchConfigurationUIUtil.startDebugging((ILaunchConfiguration)config, (String)"debug", (ILaunch)launch, (IProgressMonitor)new NullProgressMonitor());
        }
        return launch;
    }
}

