/*
 * Decompiled with CFR 0.152.
 */
package com.genuitec.eclipse.core;

import com.genuitec.eclipse.core.CommonCore;
import com.genuitec.eclipse.core.FacetContribution;
import com.genuitec.eclipse.core.util.IndexedSet;
import com.genuitec.eclipse.core.util.PlatformUIUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ContributionEnablementTester
extends PropertyTester {
    private IndexedSet<String, IndexedSet<String, FacetContribution>> facetContributionsMapping = null;
    private IndexedSet<String, IndexedSet<String, FacetContribution>> perspectiveContributionsMapping = null;
    private final String EXTENSIONPOINT_CONTRIBUTIONENABLEMENT = "contributionEnablement";
    private final String ELEM_FACETCONTRIBUTIONS = "facetContributions";
    private final String ELEM_PERSPECTIVECONTRIBUTIONS = "perspectiveContributions";
    private final String ATTR_FACET_ID = "facetId";
    private final String ATTR_PERSPECTIVE_ID = "perspectiveId";
    private final String ATTR_ID = "id";
    private final String ATTR_TYPE = "type";

    public ContributionEnablementTester() {
        if (this.facetContributionsMapping == null || this.perspectiveContributionsMapping == null) {
            this.loadFacetWizardListData();
        }
    }

    private void loadFacetWizardListData() {
        IConfigurationElement[] elements;
        this.facetContributionsMapping = new IndexedSet();
        this.perspectiveContributionsMapping = new IndexedSet();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.genuitec.eclipse.core.common", "contributionEnablement");
        IConfigurationElement[] iConfigurationElementArray = elements = extensionPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            FacetContribution facetContribution;
            String contributionType;
            String contributionId;
            IConfigurationElement contribution;
            int n3;
            int n4;
            IConfigurationElement[] iConfigurationElementArray2;
            IConfigurationElement[] contributions;
            IndexedSet contributionList;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            if (iConfigurationElement.getName().equals("facetContributions")) {
                String facetId = iConfigurationElement.getAttribute("facetId");
                contributionList = null;
                if (this.facetContributionsMapping.containsKey((Object)facetId)) {
                    contributionList = (IndexedSet)this.facetContributionsMapping.getItemByKey((Object)facetId);
                } else {
                    contributionList = new IndexedSet();
                    this.facetContributionsMapping.addItemWithKey((Object)facetId, (Object)contributionList);
                }
                iConfigurationElementArray2 = contributions = iConfigurationElement.getChildren();
                n4 = contributions.length;
                n3 = 0;
                while (n3 < n4) {
                    contribution = iConfigurationElementArray2[n3];
                    contributionId = contribution.getAttribute("id");
                    contributionType = contribution.getAttribute("type");
                    if (contributionId != null) {
                        facetContribution = new FacetContribution(contributionId, contributionType);
                        contributionList.addItemWithKey((Object)contributionId, (Object)facetContribution);
                    }
                    ++n3;
                }
            } else if (iConfigurationElement.getName().equals("perspectiveContributions")) {
                String perspectiveId = iConfigurationElement.getAttribute("perspectiveId");
                contributionList = null;
                if (this.perspectiveContributionsMapping.containsKey((Object)perspectiveId)) {
                    contributionList = (IndexedSet)this.perspectiveContributionsMapping.getItemByKey((Object)perspectiveId);
                } else {
                    contributionList = new IndexedSet();
                    this.perspectiveContributionsMapping.addItemWithKey((Object)perspectiveId, (Object)contributionList);
                }
                iConfigurationElementArray2 = contributions = iConfigurationElement.getChildren();
                n4 = contributions.length;
                n3 = 0;
                while (n3 < n4) {
                    contribution = iConfigurationElementArray2[n3];
                    contributionId = contribution.getAttribute("id");
                    contributionType = contribution.getAttribute("type");
                    if (contributionId != null) {
                        facetContribution = new FacetContribution(contributionId, contributionType);
                        contributionList.addItemWithKey((Object)contributionId, (Object)facetContribution);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (args[0] != null) {
            String currentPerspectiveId;
            IndexedSet contributionList;
            String contributionId = args[0].toString();
            String contributionType = null;
            if (args.length > 1 && args[1] != null && !args[1].toString().isEmpty()) {
                contributionType = args[1].toString();
            }
            if (receiver instanceof IResource) {
                IProject project = ((IResource)receiver).getProject();
                List<String> projectFacetIdList = this.getProjectFacetIdList(project);
                for (String facetId : projectFacetIdList) {
                    FacetContribution contribution;
                    IndexedSet contributionList2 = (IndexedSet)this.facetContributionsMapping.getItemByKey((Object)facetId);
                    if (contributionList2 == null || !contributionList2.containsKey((Object)contributionId)) continue;
                    return contributionType == null || (contribution = (FacetContribution)contributionList2.getItemByKey((Object)contributionId)).getContributionType().equals(contributionType);
                }
            }
            if ((contributionList = (IndexedSet)this.perspectiveContributionsMapping.getItemByKey((Object)(currentPerspectiveId = PlatformUIUtil.getActivePage().getPerspective().getId()))) != null && contributionList.containsKey((Object)contributionId)) {
                FacetContribution contribution;
                return contributionType == null || (contribution = (FacetContribution)contributionList.getItemByKey((Object)contributionId)).getContributionType().equals(contributionType);
            }
        }
        return false;
    }

    private List<String> getProjectFacetIdList(IProject project) {
        ArrayList<String> projectFacetIdList = new ArrayList<String>();
        try {
            IFacetedProject prj = ProjectFacetsManager.create((IProject)project);
            if (prj != null) {
                Set facets = prj.getProjectFacets();
                for (IProjectFacetVersion iProjectFacetVersion : facets) {
                    projectFacetIdList.add(iProjectFacetVersion.getProjectFacet().getId());
                }
            }
        }
        catch (CoreException e) {
            CommonCore.getDefault().log("Error while getting project facets", (Throwable)e);
        }
        return projectFacetIdList;
    }
}

