/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.portal.application.JiBX_bindingMungeAdapter;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.serialize.JibxArraySerialize;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.PageData;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class Page
extends Container
implements IUnmarshallable,
IMarshallable {
    public static final String DEFAULT_PAGE = "Default";
    private PageKey pageKey;
    private String ownerType;
    private String ownerId;
    private String editPermission;
    private boolean showMaxWindow = false;
    private transient boolean modifiable;
    public static final String JiBX_bindingList = "|org.exoplatform.portal.application.JiBX_bindingFactory|";

    public Page() {
    }

    public Page(String ownerType, String ownerId, String name) {
        this.ownerType = ownerType;
        this.ownerId = ownerId;
        this.name = name;
    }

    public Page(PageData data) {
        super(data);
        this.ownerType = data.getOwnerType();
        this.ownerId = data.getOwnerId();
        this.editPermission = data.getEditPermission();
        this.showMaxWindow = data.isShowMaxWindow();
    }

    public Page(String storageId) {
        super(storageId);
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public boolean isShowMaxWindow() {
        return this.showMaxWindow;
    }

    public void setShowMaxWindow(Boolean showMaxWindow) {
        this.showMaxWindow = showMaxWindow;
    }

    public PageKey getPageKey() {
        if (this.pageKey == null) {
            this.pageKey = PageKey.parse(this.getPageId());
        }
        return this.pageKey;
    }

    public String getPageId() {
        if (this.ownerType == null || this.ownerId == null || this.name == null) {
            return null;
        }
        return this.ownerType + "::" + this.ownerId + "::" + this.name;
    }

    public void setPageId(String pageId) {
        if (pageId == null) {
            this.ownerType = null;
            this.ownerId = null;
            this.name = null;
        } else {
            int i1 = pageId.indexOf("::");
            int i2 = pageId.indexOf("::", i1 + 2);
            String ownerType = pageId.substring(0, i1);
            String ownerId = pageId.substring(i1 + 2, i2);
            String name = pageId.substring(i2 + 2);
            this.ownerType = ownerType;
            this.ownerId = ownerId;
            this.name = name;
        }
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean b) {
        this.modifiable = b;
    }

    @Override
    public PageData build() {
        List<ComponentData> children = this.buildChildren();
        return new PageData(this.storageId, this.id, this.name, this.icon, this.template, this.factoryId, this.title, this.description, this.width, this.height, Utils.safeImmutableList(this.accessPermissions), children, this.ownerType, this.ownerId, this.editPermission, this.showMaxWindow, Utils.safeImmutableList(this.moveAppsPermissions), Utils.safeImmutableList(this.moveContainersPermissions));
    }

    public String toString() {
        return "Page[ownerType=" + this.ownerType + ",ownerId=" + this.ownerId + ",name=" + this.name + "]";
    }

    public static /* synthetic */ Page JiBX_binding_newinstance_3_0(Page arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = new Page();
        }
        return arg1;
    }

    public static /* synthetic */ Page JiBX_binding_unmarshal_3_0(Page arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushTrackedObject((Object)arg1);
        while (arg2.isAt(null, "page-id")) {
            arg2.parsePastElement(null, "page-id");
        }
        while (arg2.isAt(null, "owner-type")) {
            arg2.parsePastElement(null, "owner-type");
        }
        while (arg2.isAt(null, "owner-id")) {
            arg2.parsePastElement(null, "owner-id");
        }
        Object v0 = null;
        arg1.name = arg2.parseElementText(null, "name");
        arg1.title = arg2.parseElementText(null, "title", null);
        arg1.factoryId = arg2.parseElementText(null, "factory-id", null);
        String string = arg2.parseElementText(null, "access-permissions", "Everyone");
        arg1.accessPermissions = string == null ? null : JibxArraySerialize.deserializePermissions(string);
        arg1.editPermission = arg2.parseElementText(null, "edit-permission", null);
        arg1.showMaxWindow = arg2.parseElementBoolean(null, "show-max-window", false);
        String string2 = arg2.parseElementText(null, "move-apps-permissions", "Everyone");
        arg1.moveAppsPermissions = string2 == null ? null : JibxArraySerialize.deserializePermissions(string2);
        String string3 = arg2.parseElementText(null, "move-containers-permissions", "Everyone");
        arg1.moveContainersPermissions = string3 == null ? null : JibxArraySerialize.deserializePermissions(string3);
        arg1.children = JiBX_bindingMungeAdapter.JiBX_binding_unmarshal_1_1(JiBX_bindingMungeAdapter.JiBX_binding_newinstance_1_0(arg1.children, arg2), arg2);
        arg2.popObject();
        return arg1;
    }

    @Override
    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.Page").unmarshal((Object)this, arg1);
    }

    @Override
    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.portal.config.model.Page";
    }

    public static /* synthetic */ void JiBX_binding_marshal_3_0(Page arg1, MarshallingContext arg2) throws JiBXException {
        arg2.pushObject((Object)arg1);
        MarshallingContext marshallingContext = arg2.element(0, "name", arg1.name);
        if (arg1.title != null) {
            marshallingContext = marshallingContext.element(0, "title", arg1.title);
        }
        if (arg1.factoryId != null) {
            marshallingContext = marshallingContext.element(0, "factory-id", arg1.factoryId);
        }
        if (arg1.accessPermissions != null) {
            String string = JibxArraySerialize.serializePermissions(arg1.accessPermissions);
            if (!Utility.isEqual((Object)string, (Object)"Everyone")) {
                marshallingContext = marshallingContext.element(0, "access-permissions", string);
            }
        }
        if (arg1.editPermission != null) {
            marshallingContext = marshallingContext.element(0, "edit-permission", arg1.editPermission);
        }
        boolean bl = arg1.showMaxWindow;
        if (bl) {
            marshallingContext = marshallingContext.element(0, "show-max-window", Utility.serializeBoolean((boolean)bl));
        }
        if (arg1.moveAppsPermissions != null) {
            String string = JibxArraySerialize.serializePermissions(arg1.moveAppsPermissions);
            if (!Utility.isEqual((Object)string, (Object)"Everyone")) {
                marshallingContext = marshallingContext.element(0, "move-apps-permissions", string);
            }
        }
        if (arg1.moveContainersPermissions != null) {
            String string = JibxArraySerialize.serializePermissions(arg1.moveContainersPermissions);
            if (!Utility.isEqual((Object)string, (Object)"Everyone")) {
                marshallingContext = marshallingContext.element(0, "move-containers-permissions", string);
            }
        }
        JiBX_bindingMungeAdapter.JiBX_binding_marshal_1_1(arg1.children, arg2);
        arg2.popObject();
    }

    @Override
    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.portal.config.model.Page").marshal((Object)this, arg1);
    }

    public static class PageSet
    implements IUnmarshallable,
    IMarshallable {
        private ArrayList<Page> pages = new ArrayList();
        public static final String JiBX_bindingList = "|org.exoplatform.portal.application.JiBX_bindingFactory|";

        public ArrayList<Page> getPages() {
            return this.pages;
        }

        public void setPages(ArrayList<Page> list) {
            this.pages = list;
        }

        public static /* synthetic */ PageSet JiBX_binding_newinstance_1_0(PageSet arg1, UnmarshallingContext arg2) throws JiBXException {
            if (arg1 == null) {
                arg1 = new PageSet();
            }
            return arg1;
        }

        public static /* synthetic */ PageSet JiBX_binding_unmarshal_1_0(PageSet arg1, UnmarshallingContext arg2) throws JiBXException {
            arg2.pushTrackedObject((Object)arg1);
            PageSet pageSet = arg1;
            arg1.pages = JiBX_bindingMungeAdapter.JiBX_binding_unmarshal_1_9(JiBX_bindingMungeAdapter.JiBX_binding_newinstance_1_0(arg1.pages, arg2), arg2);
            arg2.popObject();
            return arg1;
        }

        public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
            Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.Page$PageSet").unmarshal((Object)this, arg1);
        }

        public /* synthetic */ String JiBX_getName() {
            return "org.exoplatform.portal.config.model.Page$PageSet";
        }

        public static /* synthetic */ void JiBX_binding_marshal_1_0(PageSet arg1, MarshallingContext arg2) throws JiBXException {
            arg2.pushObject((Object)arg1);
            MarshallingContext marshallingContext = arg2;
            JiBX_bindingMungeAdapter.JiBX_binding_marshal_1_10(arg1.pages, arg2);
            arg2.popObject();
        }

        public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
            arg1.getMarshaller("org.exoplatform.portal.config.model.Page$PageSet").marshal((Object)this, arg1);
        }
    }
}

