/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import java.io.Serializable;
import java.util.Collection;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableUserProfileHandlerImpl
implements UserProfileHandler {
    private final ExoCache<String, UserProfile> userProfileCache;
    private final UserProfileHandler userProfileHandler;

    public CacheableUserProfileHandlerImpl(OrganizationCacheHandler organizationCacheHandler, UserProfileHandler userProfileHandler) {
        this.userProfileCache = organizationCacheHandler.getUserProfileCache();
        this.userProfileHandler = userProfileHandler;
    }

    @Override
    public void addUserProfileEventListener(UserProfileEventListener listener) {
        this.userProfileHandler.addUserProfileEventListener(listener);
    }

    @Override
    public void removeUserProfileEventListener(UserProfileEventListener listener) {
        this.userProfileHandler.removeUserProfileEventListener(listener);
    }

    @Override
    public UserProfile createUserProfileInstance() {
        return this.userProfileHandler.createUserProfileInstance();
    }

    @Override
    public UserProfile createUserProfileInstance(String userName) {
        return this.userProfileHandler.createUserProfileInstance(userName);
    }

    @Override
    public UserProfile findUserProfileByName(String userName) throws Exception {
        UserProfile userProfile = (UserProfile)this.userProfileCache.get((Serializable)((Object)userName));
        if (userProfile != null) {
            return userProfile;
        }
        userProfile = this.userProfileHandler.findUserProfileByName(userName);
        if (userProfile != null) {
            this.userProfileCache.put((Serializable)((Object)userName), (Object)userProfile);
        }
        return userProfile;
    }

    @Override
    public Collection<UserProfile> findUserProfiles() throws Exception {
        Collection<UserProfile> userProfiles = this.userProfileHandler.findUserProfiles();
        for (UserProfile userProfile : userProfiles) {
            this.userProfileCache.put((Serializable)((Object)userProfile.getUserName()), (Object)userProfile);
        }
        return userProfiles;
    }

    @Override
    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        UserProfile userProfile = this.userProfileHandler.removeUserProfile(userName, broadcast);
        if (userProfile != null) {
            this.userProfileCache.remove((Serializable)((Object)userName));
        }
        return userProfile;
    }

    @Override
    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        this.userProfileHandler.saveUserProfile(profile, broadcast);
        this.userProfileCache.put((Serializable)((Object)profile.getUserName()), (Object)profile);
    }
}

