/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.ParseException;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.stages.InlineCssImportsStage;
import com.google.caja.plugin.stages.PipelineStageTestCase;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.util.ContentType;

public class InlineCssImportsStageTest
extends PipelineStageTestCase {
    public final void testNoImports() throws Exception {
        this.assertPipeline(InlineCssImportsStageTest.job("p { color: purple }", ContentType.CSS), InlineCssImportsStageTest.job("p {\n  color: purple\n}", ContentType.CSS));
    }

    public final void testOneImport() throws Exception {
        this.addUrlToPluginEnvironment("foo.css", "p { color: purple }");
        this.assertPipeline(InlineCssImportsStageTest.job("@import 'foo.css';", ContentType.CSS), InlineCssImportsStageTest.job("p {\n  color: purple\n}", ContentType.CSS));
    }

    public final void testImportResolvedRelativeToImporter() throws Exception {
        this.addUrlToPluginEnvironment("foo/bar.css", "@import 'baz.css';");
        this.addUrlToPluginEnvironment("baz.css", "p { color: #f88 }");
        this.addUrlToPluginEnvironment("foo/baz.css", "p { color: purple }");
        this.assertPipeline(InlineCssImportsStageTest.job("@import 'foo/bar.css';", ContentType.CSS), InlineCssImportsStageTest.job("p {\n  color: purple\n}", ContentType.CSS));
    }

    public final void testMultipleImport() throws Exception {
        this.addUrlToPluginEnvironment("foo.css", "p { color: purple }");
        this.addUrlToPluginEnvironment("bar.css", "b { color: blue }");
        this.assertPipeline(InlineCssImportsStageTest.job("@import 'foo.css'; @import 'bar.css'; i { color: #ff8 }", ContentType.CSS), InlineCssImportsStageTest.job("p {\n  color: purple\n}\nb {\n  color: blue\n}\ni {\n  color: #ff8\n}", ContentType.CSS));
    }

    public final void testMediaTypesUnioned() throws Exception {
        this.addUrlToPluginEnvironment("all1.css", "a { content: 'all1' }");
        this.addUrlToPluginEnvironment("all1.css", "a { content: 'all1' }");
        this.addUrlToPluginEnvironment("all2.css", "@media all { a { content: 'all2' } }");
        this.addUrlToPluginEnvironment("all2.css", "@media all { a { content: 'all2' } }");
        this.addUrlToPluginEnvironment("multi.css", "@media print, screen { b { content: 'multi' } }");
        this.addUrlToPluginEnvironment("print.css", "@media print { p { content: 'print' } }");
        this.addUrlToPluginEnvironment("print.css", "@media print { p { content: 'print' } }");
        this.addUrlToPluginEnvironment("screen.css", "@media screen { s { content: 'screen' } }");
        this.assertPipeline(InlineCssImportsStageTest.job("@import 'print.css' screen;\n@import 'screen.css' print, screen;\n@import 'print.css' all;\n@import 'multi.css' print;\n@import 'all1.css' screen, print;\n@import 'all2.css' screen, print;\n@import 'all1.css' all;\n@import 'all2.css' all;", ContentType.CSS), InlineCssImportsStageTest.job("@media screen {\n  s {\n    content: 'screen'\n  }\n}\n@media print {\n  p {\n    content: 'print'\n  }\n}\n@media print {\n  b {\n    content: 'multi'\n  }\n}\n@media screen, print {\n  a {\n    content: 'all1'\n  }\n}\n@media screen, print {\n  a {\n    content: 'all2'\n  }\n}\na {\n  content: 'all1'\n}\n@media all {\n  a {\n    content: 'all2'\n  }\n}", ContentType.CSS));
    }

    public final void testUnresolveableImport() throws Exception {
        this.assertPipelineFails(InlineCssImportsStageTest.job("@import 'bogus.css';", ContentType.CSS), InlineCssImportsStageTest.job("@import url('bogus.css');", ContentType.CSS));
        this.assertMessage(PluginMessageType.FAILED_TO_LOAD_EXTERNAL_URL, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testCyclicImport() throws Exception {
        int i = 50;
        while (--i >= 0) {
            this.addUrlToPluginEnvironment("foo.css", "@import 'foo.css';");
        }
        this.assertPipelineFails(InlineCssImportsStageTest.job("@import 'foo.css';", ContentType.CSS), InlineCssImportsStageTest.job("@import url('foo.css');", ContentType.CSS));
        this.assertMessage(PluginMessageType.CYCLIC_INCLUDE, MessageLevel.ERROR, new MessagePart[0]);
    }

    public final void testMalformedUrl() throws Exception {
        try {
            this.assertPipelineFails(InlineCssImportsStageTest.job("@import ':::';", ContentType.CSS), InlineCssImportsStageTest.job("@import url(':::');", ContentType.CSS));
        }
        catch (ParseException ex) {
            ex.toMessageQueue(this.mq);
        }
        this.assertMessage(MessageType.MALFORMED_URI, MessageLevel.FATAL_ERROR, new MessagePart[0]);
    }

    protected boolean runPipeline(Jobs jobs) {
        return new InlineCssImportsStage().apply(jobs);
    }
}

