/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.SourceBreaks;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class PositionInferer {
    private final List<Boundary> boundaries = Lists.newLinkedList();
    private final List<Relation> relations = Lists.newLinkedList();
    private final Map<Object, Region> boundsByNode = Maps.newIdentityHashMap();
    private final SourceBreaks breaks;
    private static final int UNSPECIFIED_MAX = Integer.MAX_VALUE;
    private static final int UNSPECIFIED_MIN = FilePosition.startOfFile(InputSource.UNKNOWN).startCharInFile();

    public PositionInferer(FilePosition spanningPos) {
        this.breaks = spanningPos.getBreaks();
    }

    public void contains(Object container, Object contained) {
        Region aBounds = this.boundsForNode(container);
        Region bBounds = this.boundsForNode(contained);
        LessThanRelation left = new LessThanRelation(aBounds.start, bBounds.start);
        LessThanRelation right = new LessThanRelation(bBounds.end, aBounds.end);
        if (!((Relation)left).isSatisfied()) {
            this.relations.add(left);
        }
        if (!((Relation)right).isSatisfied()) {
            this.relations.add(right);
        }
    }

    public void precedes(Object before, Object after) {
        Region beforeBounds = this.boundsForNode(before);
        Region afterBounds = this.boundsForNode(after);
        LessThanRelation r = new LessThanRelation(beforeBounds.end, afterBounds.start);
        if (!((Relation)r).isSatisfied()) {
            this.relations.add(r);
        }
    }

    public void adjacent(Object before, Object after) {
        Region beforeBounds = this.boundsForNode(before);
        Region afterBounds = this.boundsForNode(after);
        EqualRelation r = new EqualRelation(beforeBounds.end, afterBounds.start);
        if (!((Relation)r).isSatisfied()) {
            this.relations.add(r);
        }
    }

    public void solve() {
        boolean workDone;
        LinkedList<Relation> toCheck = Lists.newLinkedList();
        do {
            workDone = false;
            Iterator<Relation> it = this.relations.iterator();
            while (it.hasNext()) {
                Relation relation = it.next();
                if (!relation.isSatisfied()) {
                    toCheck.add(relation);
                    do {
                        Relation head;
                        if (!(head = (Relation)toCheck.remove(0)).satisfy(toCheck)) continue;
                        workDone = true;
                    } while (!toCheck.isEmpty());
                }
                if (!relation.isSatisfied()) continue;
                it.remove();
            }
        } while (workDone);
        for (Boundary boundary : this.boundaries) {
            if (boundary.isSpecified()) continue;
            if (boundary.min > UNSPECIFIED_MIN) {
                boundary.max = boundary.min;
                continue;
            }
            if (boundary.max >= Integer.MAX_VALUE) continue;
            boundary.min = boundary.max;
        }
        for (Map.Entry entry : this.boundsByNode.entrySet()) {
            Object node = entry.getKey();
            Region r = (Region)entry.getValue();
            if (!r.start.isSpecified() || !r.end.isSpecified()) continue;
            this.setPosForNode(node, this.breaks.toFilePosition(r.start.min, r.end.max));
        }
    }

    protected abstract FilePosition getPosForNode(Object var1);

    protected abstract void setPosForNode(Object var1, FilePosition var2);

    private Region boundsForNode(Object o) {
        Region r = this.boundsByNode.get(o);
        if (r == null) {
            r = new Region(new Boundary(true, o), new Boundary(false, o));
            this.boundsByNode.put(o, r);
            FilePosition pos = this.getPosForNode(o);
            if (this.breaks.source().equals(pos.source())) {
                r.start.min = r.start.max = pos.startCharInFile();
                r.end.min = r.end.max = pos.endCharInFile();
            }
            this.boundaries.add(r.start);
            this.boundaries.add(r.end);
            LessThanRelation rel = new LessThanRelation(r.start, r.end);
            if (!((Relation)rel).isSatisfied()) {
                this.relations.add(rel);
            }
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EqualRelation
    extends Relation {
        EqualRelation(Boundary a, Boundary b) {
            super(a, b);
        }

        @Override
        boolean satisfy(List<? super Relation> toCheck) {
            int newAMin = Math.min(this.a.max, Math.max(this.a.min, this.b.min));
            int newAMax = Math.max(this.a.min, Math.min(this.a.max, this.b.max));
            int newBMin = Math.min(this.b.max, Math.max(this.a.min, this.b.min));
            int newBMax = Math.max(this.b.min, Math.min(this.a.max, this.b.max));
            boolean narrowed = false;
            if (this.a.min != newAMin || this.a.max != newAMax) {
                this.a.min = newAMin;
                this.a.max = newAMax;
                this.a.schedule(toCheck);
                narrowed = true;
            }
            if (this.b.min != newBMin || this.b.max != newBMax) {
                this.b.min = newBMin;
                this.b.max = newBMax;
                this.b.schedule(toCheck);
                narrowed = true;
            }
            return narrowed;
        }

        @Override
        boolean isSatisfied() {
            return this.a.isSpecified() && this.b.isSpecified() || this.a.min == this.b.min && this.a.max == this.b.max;
        }

        public String toString() {
            return "(" + this.a + " == " + this.b + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LessThanRelation
    extends Relation {
        LessThanRelation(Boundary lesser, Boundary greater) {
            super(lesser, greater);
        }

        @Override
        boolean satisfy(List<? super Relation> toCheck) {
            boolean narrowed = false;
            if (this.a.min <= this.b.max) {
                int newMax;
                int newMin;
                if (this.a.min > this.b.min && this.b.min != (newMin = Math.min(this.a.min, this.b.max))) {
                    this.b.min = newMin;
                    this.b.schedule(toCheck);
                    narrowed = true;
                }
                if (this.a.max > this.b.max && this.a.max != (newMax = Math.max(this.b.max, this.a.min))) {
                    this.a.max = newMax;
                    this.a.schedule(toCheck);
                    narrowed = true;
                }
            }
            return narrowed;
        }

        @Override
        boolean isSatisfied() {
            return this.a.isSpecified() && this.b.isSpecified() || this.a.max <= this.b.min;
        }

        public String toString() {
            return "(" + this.a + " <= " + this.b + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Relation {
        final Boundary a;
        final Boundary b;

        Relation(Boundary a, Boundary b) {
            this.a = a;
            this.b = b;
            if (!a.isSpecified() || !b.isSpecified()) {
                a.relations.add(this);
                b.relations.add(this);
            }
        }

        abstract boolean isSatisfied();

        abstract boolean satisfy(List<? super Relation> var1);
    }

    private static class Region {
        final Boundary start;
        final Boundary end;

        Region(Boundary start, Boundary end) {
            assert (start.isStart && !end.isStart);
            this.start = start;
            this.end = end;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Boundary {
        final boolean isStart;
        final Object target;
        final List<Relation> relations = Lists.newLinkedList();
        int min = PositionInferer.access$000();
        int max = Integer.MAX_VALUE;

        Boundary(boolean isStart, Object target) {
            this.isStart = isStart;
            this.target = target;
        }

        boolean isSpecified() {
            return this.min == this.max;
        }

        void schedule(List<? super Relation> out) {
            Iterator<Relation> deps = this.relations.iterator();
            while (deps.hasNext()) {
                Relation dep = deps.next();
                if (dep.isSatisfied()) {
                    deps.remove();
                    continue;
                }
                out.add(dep);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String targetStr = this.target != null ? this.target.toString().replace("\n", "\\n").replace("\r", "\\r") : "<null>";
            sb.append("(").append(this.isStart ? "start" : "end").append(" ").append(targetStr);
            if (this.min != UNSPECIFIED_MIN || this.max != Integer.MAX_VALUE) {
                if (this.min != UNSPECIFIED_MIN) {
                    sb.append(" min=").append(this.min);
                }
                if (this.max != Integer.MAX_VALUE) {
                    sb.append(" max=").append(this.max);
                }
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

