/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.transaction.infinispan;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.transaction.lookup.TransactionManagerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossStandaloneJTAManagerLookup
implements TransactionManagerLookup {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JBossStandaloneJTAManagerLookup");
    private Method manager;
    private Method user;

    public JBossStandaloneJTAManagerLookup() {
        try {
            this.manager = JBossStandaloneJTAManagerLookup.loadClassStrict("com.arjuna.ats.jta.TransactionManager").getMethod("transactionManager", new Class[0]);
            this.user = JBossStandaloneJTAManagerLookup.loadClassStrict("com.arjuna.ats.jta.UserTransaction").getMethod("userTransaction", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public TransactionManager getTransactionManager() throws Exception {
        TransactionManager tm = (TransactionManager)this.manager.invoke(null, new Object[0]);
        if (tm == null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"The transaction manager could not be found");
        }
        return tm;
    }

    public UserTransaction getUserTransaction() throws Exception {
        UserTransaction ut = (UserTransaction)this.user.invoke(null, new Object[0]);
        if (ut == null && LOG.isWarnEnabled()) {
            LOG.warn((Object)"The user transaction could not be found");
        }
        return ut;
    }

    private static Class<?> loadClassStrict(String classname) throws ClassNotFoundException {
        return ClassLoading.loadClass((String)classname, JBossStandaloneJTAManagerLookup.class);
    }
}

