/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Calendar;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.impl.dataflow.CalendarValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;

public class CalendarPersistedValueData
extends CalendarValueData
implements PersistedValueData {
    public CalendarPersistedValueData() {
        super(0, null);
    }

    public CalendarPersistedValueData(int orderNumber, Calendar value) {
        super(orderNumber, value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderNumber = in.readInt();
        byte[] data = new byte[in.readInt()];
        if (data.length > 0) {
            try {
                in.readFully(data);
                this.value = new JCRDateFormat().deserialize(new String(data, "UTF-8"));
            }
            catch (ValueFormatException e) {
                throw new IOException("Deserialization data error", e);
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.orderNumber);
        byte[] data = new JCRDateFormat().serialize(this.value);
        out.writeInt(data.length);
        out.write(data);
    }
}

