/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemParametersPersistenceConfigurator {
    public static final String UNMODIFIABLE = "unmodifiable";
    public static final String BEFORE_INITIALIZE = "before-initialize";
    public static final String FILE_PATH_PARAMETER = "file-path";
    public static final String FILE_NAME = "overridden-parameters.dat";
    public static final String SEPARATOR = "=";
    private Set<String> beforeInitialize = new HashSet<String>();
    private Set<String> unmodifiable = new HashSet<String>();
    private Map<String, String> oldParameters = new HashMap<String, String>();
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private String filePath;

    public SystemParametersPersistenceConfigurator() {
    }

    public SystemParametersPersistenceConfigurator(InitParams initialParameters) {
        this.initValuesParameters(initialParameters);
        this.initFileParameter(initialParameters);
        this.systemProperties = this.fetchSystemProperties();
        this.oldParameters = this.readFile();
        this.writeFile();
    }

    private void initValuesParameters(InitParams initialParameters) {
        Iterator valuesParamIterator = initialParameters.getValuesParamIterator();
        while (valuesParamIterator.hasNext()) {
            ValuesParam valuesParam = (ValuesParam)valuesParamIterator.next();
            if (UNMODIFIABLE.equals(valuesParam.getName())) {
                this.unmodifiable.addAll(valuesParam.getValues());
            }
            if (!BEFORE_INITIALIZE.equals(valuesParam.getName())) continue;
            this.beforeInitialize.addAll(valuesParam.getValues());
        }
    }

    private void initFileParameter(InitParams initialParameters) {
        ValueParam filePathValueParam = initialParameters.getValueParam(FILE_PATH_PARAMETER);
        if (filePathValueParam == null) {
            throw new IllegalStateException("No temporary file path is specified for " + SystemParametersPersistenceConfigurator.class.getSimpleName());
        }
        this.filePath = filePathValueParam.getValue() + File.separator + FILE_NAME;
    }

    private Map<String, String> readFile() {
        try {
            return (Map)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Map<String, String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Map<String, String> run() throws IOException {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    File file = new File(SystemParametersPersistenceConfigurator.this.filePath);
                    if (file.exists() && file.length() > 0L) {
                        BufferedReader reader = null;
                        String st = "";
                        try {
                            reader = new BufferedReader(new FileReader(file));
                            while ((st = reader.readLine()) != null) {
                                String[] sa = st.split(SystemParametersPersistenceConfigurator.SEPARATOR);
                                parameters.put(sa[0], sa[1]);
                            }
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                    }
                    return parameters;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read a file.", e);
        }
    }

    public Set<String> getBeforeInitializeParametersForWorkspaceComponent(String componentName) {
        return this.getParametersOfWorkspaceComponent(this.beforeInitialize, componentName);
    }

    public Set<String> getUnmodifiableParametersForWorkspaceComponent(String componentName) {
        return this.getParametersOfWorkspaceComponent(this.unmodifiable, componentName);
    }

    private Set<String> getParametersOfWorkspaceComponent(Set<String> originalParameters, String componentName) {
        HashSet<String> parameters = new HashSet<String>();
        for (String parameterName : originalParameters) {
            if (!parameterName.startsWith(componentName)) continue;
            parameters.add(parameterName.substring(componentName.length() + 1));
        }
        return parameters;
    }

    public Map<String, String> getOldParameters() {
        return this.oldParameters;
    }

    private void writeFile() {
        this.writePropertiesToFile(this.systemProperties);
    }

    public void rollback() {
        this.writePropertiesToFile(this.oldParameters);
    }

    private void writePropertiesToFile(final Map<String, String> properties) {
        try {
            SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws IOException {
                    BufferedWriter bufferedWriter = null;
                    try {
                        File file = new File(SystemParametersPersistenceConfigurator.this.filePath);
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        if (properties.isEmpty()) {
                            file.delete();
                            Void void_ = null;
                            return void_;
                        }
                        bufferedWriter = new BufferedWriter(new FileWriter(file));
                        for (Map.Entry entry : properties.entrySet()) {
                            bufferedWriter.write((String)entry.getKey() + SystemParametersPersistenceConfigurator.SEPARATOR + (String)entry.getValue());
                            bufferedWriter.newLine();
                        }
                    }
                    finally {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot persist system parameters to file", e);
        }
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    private Map<String, String> fetchSystemProperties() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String propertyName : this.getSystemPropertiesNames()) {
            if (!propertyName.startsWith("exo.jcr.config.")) continue;
            parameters.put(propertyName, PropertyManager.getProperty((String)propertyName));
        }
        return parameters;
    }

    private Set<String> getSystemPropertiesNames() {
        return (Set)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Set<String>>(){

            @Override
            public Set<String> run() {
                return System.getProperties().stringPropertyNames();
            }
        });
    }
}

