/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.exoplatform.services.organization.idm.UserDAOImpl;
import org.exoplatform.services.organization.impl.UserImpl;
import org.gatein.common.logging.LogLevel;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.api.query.UserQueryBuilder;

public class IDMUserListAccess
implements ListAccess<User>,
Serializable {
    private static Logger log = LoggerFactory.getLogger(IDMUserListAccess.class);
    private final UserQueryBuilder userQueryBuilder;
    private final int pageSize;
    private final boolean countAll;
    private final UserStatus userStatus;
    private List<org.picketlink.idm.api.User> fullResults;
    private int size = -1;
    private User lastExisting;

    public IDMUserListAccess(UserQueryBuilder userQueryBuilder, int pageSize, boolean countAll, UserStatus userStatus) {
        this.userQueryBuilder = userQueryBuilder;
        this.pageSize = pageSize;
        this.countAll = countAll;
        this.userStatus = userStatus;
    }

    public User[] load(int index, int length) throws Exception {
        int i;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "load", new Object[]{"index", index, "length", length});
        }
        if (length == 0) {
            return new User[0];
        }
        if (index + length > this.getSize()) {
            throw new IllegalArgumentException("Try to get more than number users can retrieve");
        }
        List users = null;
        if (this.fullResults == null) {
            this.getOrganizationService().flush();
            this.userQueryBuilder.page(index, length);
            UserQuery query = this.userQueryBuilder.sort(SortOrder.ASCENDING).createQuery();
            users = this.getIDMService().getIdentitySession().list(query);
        } else {
            users = this.fullResults.subList(index, index + length);
        }
        User[] exoUsers = new User[length];
        for (i = 0; i < users.size(); ++i) {
            org.picketlink.idm.api.User user = users.get(i);
            UserImpl gtnUser = new UserImpl(user.getId());
            ((UserDAOImpl)this.getOrganizationService().getUserHandler()).populateUser((User)gtnUser, this.getIDMService().getIdentitySession());
            exoUsers[i] = gtnUser;
            this.lastExisting = gtnUser;
        }
        if (length > users.size()) {
            while (i < length) {
                exoUsers[i] = this.lastExisting;
                ++i;
            }
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "load", exoUsers);
        }
        return exoUsers;
    }

    public int getSize() throws Exception {
        int result;
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getSize", null);
        }
        this.getOrganizationService().flush();
        if (this.size < 0) {
            if (this.fullResults != null) {
                result = this.fullResults.size();
            } else if (this.countAll) {
                result = this.getIDMService().getIdentitySession().getPersistenceManager().getUserCount();
            } else {
                this.userQueryBuilder.page(0, 0);
                UserQuery query = this.userQueryBuilder.sort(SortOrder.ASCENDING).createQuery();
                this.fullResults = this.getIDMService().getIdentitySession().list(query);
                result = this.fullResults.size();
            }
            this.size = result;
        } else {
            result = this.size;
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "getSize", result);
        }
        return result;
    }

    PicketLinkIDMService getIDMService() {
        return (PicketLinkIDMService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PicketLinkIDMService.class);
    }

    PicketLinkIDMOrganizationServiceImpl getOrganizationService() {
        return (PicketLinkIDMOrganizationServiceImpl)((Object)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class));
    }
}

