/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Properties;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.AttributesManager;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentitySessionFactory;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.Transaction;
import org.picketlink.idm.api.User;
import org.picketlink.idm.api.cfg.IdentityConfiguration;
import org.picketlink.idm.api.query.UserQuery;
import org.picketlink.idm.api.query.UserQueryBuilder;
import org.picketlink.idm.common.exception.IdentityConfigurationException;
import org.picketlink.idm.impl.api.SimpleAttribute;
import org.picketlink.idm.impl.configuration.IdentityConfigurationImpl;
import org.picketlink.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;

public class DisabledUserMigrationScript {
    private String realmName;
    private IdentitySessionFactory identitySessionFactory;
    private SessionFactory sessionFactory_;
    private int batch;
    private static final Log log = ExoLogger.getExoLogger(DisabledUserMigrationScript.class);

    public DisabledUserMigrationScript(Properties config) throws Exception {
        this.setupHibernate(config);
        this.setupPicketlink(config);
        String b = config.getProperty("batch");
        this.batch = Integer.parseInt(b == null ? "100" : b);
    }

    public void enableAll(int first) throws Exception {
        int length;
        long startTime = System.currentTimeMillis();
        this.startTransaction();
        int size = this.getIdentitySession().getPersistenceManager().getUserCount();
        log.info("Starting enable for {} users", new Object[]{size - first});
        int n = length = this.batch > size ? size : this.batch;
        while (length > 0) {
            try {
                log.info("enable for user from {} to {}", new Object[]{first, first + length});
                this.startTransaction();
                UserQueryBuilder qb = this.getIdentitySession().createUserQueryBuilder();
                List<User> users = this.load(qb, first, length);
                for (User user : users) {
                    this.setEnabled(user.getId(), true);
                }
                this.getIdentitySession().save();
                this.endTransaction();
            }
            catch (Exception e) {
                log.info("fail to migrate for users from index: {}", new Object[]{first});
                this.recoverFromIDMError(e);
                break;
            }
            length = this.batch + (first += this.batch) > size ? size - first : this.batch;
        }
        log.info("Finish enable all users in : {}ms", new Object[]{System.currentTimeMillis() - startTime});
    }

    private List<User> load(UserQueryBuilder qb, int index, int length) throws Exception {
        qb.sort(SortOrder.ASCENDING).page(index, length);
        UserQuery query = qb.createQuery();
        return this.getIdentitySession().list(query);
    }

    public void setEnabled(String userName, boolean enabled) throws Exception {
        Attribute[] attrs = new Attribute[]{new SimpleAttribute("enabled", (Object)String.valueOf(enabled))};
        IdentitySession session = this.getIdentitySession();
        AttributesManager am = session.getAttributesManager();
        am.updateAttributes(userName, attrs);
    }

    public void startTransaction() throws Exception {
        if (!this.getIdentitySession().getTransaction().isActive()) {
            this.getIdentitySession().beginTransaction();
        }
    }

    public void endTransaction() throws Exception {
        if (this.getIdentitySession().getTransaction().isActive()) {
            this.getIdentitySession().getTransaction().commit();
        }
    }

    public void recoverFromIDMError(Exception e) {
        log.error((Object)e);
        try {
            Transaction idmTransaction = this.getIdentitySession().getTransaction();
            if (idmTransaction.isActive()) {
                idmTransaction.rollback();
                log.info((Object)"IDM error recovery finished. Old transaction has been rolled-back");
            }
        }
        catch (Exception e1) {
            log.warn((Object)"Error during recovery of old error", (Throwable)e1);
        }
    }

    private void setupHibernate(Properties config) throws Exception {
        final Configuration conf_ = new Configuration();
        conf_.setProperty("hibernate.connection.driver_class", config.getProperty("hibernate.connection.driver_class"));
        conf_.setProperty("hibernate.connection.url", config.getProperty("hibernate.connection.url"));
        conf_.setProperty("hibernate.connection.username", config.getProperty("hibernate.connection.username"));
        conf_.setProperty("hibernate.connection.password", config.getProperty("hibernate.connection.password"));
        conf_.setProperty("hibernate.dialect", config.getProperty("hibernate.dialect"));
        String config_path = config.getProperty("hibernate.config_path");
        URL url = Thread.currentThread().getContextClassLoader().getResource(config_path);
        if (url == null) {
            log.error("hibernate config file not found: {}", new Object[]{config_path});
        } else {
            log.info("adding hibernate config file {}", new Object[]{config_path});
            conf_.addURL(url);
        }
        this.sessionFactory_ = (SessionFactory)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<SessionFactory>(){

            @Override
            public SessionFactory run() {
                SessionFactory factory = conf_.configure().buildSessionFactory();
                return factory;
            }
        });
    }

    private void setupPicketlink(Properties config) throws Exception {
        String pkConfig = config.getProperty("picketlink.config_file_path");
        URL pk_config_url = Thread.currentThread().getContextClassLoader().getResource(pkConfig);
        if (pk_config_url == null) {
            throw new IllegalStateException("Cannot fine resource: " + pkConfig);
        }
        this.realmName = config.getProperty("picketlink.realmName", "idm_realm");
        IdentityConfigurationMetaData configMD = JAXB2IdentityConfiguration.createConfigurationMetaData((InputStream)pk_config_url.openStream());
        IdentityConfiguration identityConfiguration = new IdentityConfigurationImpl().configure(configMD);
        identityConfiguration.getIdentityConfigurationRegistry().register((Object)this.sessionFactory_, "hibernateSessionFactory");
        if (this.identitySessionFactory == null) {
            try {
                this.identitySessionFactory = identityConfiguration.buildIdentitySessionFactory();
            }
            catch (IdentityConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IdentitySession getIdentitySession() throws Exception {
        return this.identitySessionFactory.getCurrentIdentitySession(this.realmName);
    }

    public static void main(String[] args) throws Exception {
        String config_path;
        Properties config = new Properties();
        String string = config_path = args.length > 0 ? args[0] : null;
        if (config_path != null) {
            URL config_url = Thread.currentThread().getContextClassLoader().getResource(config_path);
            if (config_url == null) {
                log.error("config file is not found: {}", new Object[]{config_path});
            } else {
                log.info("using config file {}", new Object[]{config_url});
                config.load(config_url.openStream());
            }
        } else {
            log.info((Object)"using default config file");
            InputStream defInput = Thread.currentThread().getContextClassLoader().getResourceAsStream("configuration.properties");
            config.load(defInput);
        }
        for (Object key : System.getProperties().keySet()) {
            config.setProperty((String)key, System.getProperty((String)key));
        }
        int first = Integer.parseInt(config.getProperty("enable_user_from", "0"));
        DisabledUserMigrationScript service = new DisabledUserMigrationScript(config);
        service.enableAll(first);
        service.sessionFactory_.close();
    }
}

