/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.xml;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.util.Preconditions;
import com.google.api.client.xml.Xml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import java.io.IOException;
import java.io.OutputStream;
import org.xmlpull.v1.XmlSerializer;

public abstract class AbstractXmlHttpContent
extends AbstractHttpContent {
    private final XmlNamespaceDictionary namespaceDictionary;

    protected AbstractXmlHttpContent(XmlNamespaceDictionary namespaceDictionary) {
        super(new HttpMediaType(Xml.MEDIA_TYPE));
        this.namespaceDictionary = Preconditions.checkNotNull(namespaceDictionary);
    }

    public final void writeTo(OutputStream out) throws IOException {
        XmlSerializer serializer = Xml.createSerializer();
        serializer.setOutput(out, this.getCharset().name());
        this.writeTo(serializer);
    }

    public AbstractXmlHttpContent setMediaType(HttpMediaType mediaType) {
        super.setMediaType(mediaType);
        return this;
    }

    public final XmlNamespaceDictionary getNamespaceDictionary() {
        return this.namespaceDictionary;
    }

    protected abstract void writeTo(XmlSerializer var1) throws IOException;
}

