/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.formula.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.formula.AbstractFormulaRenderer;
import org.xwiki.formula.FormulaRenderer;
import org.xwiki.formula.ImageData;
import uk.ac.ed.ph.snuggletex.SnuggleEngine;
import uk.ac.ed.ph.snuggletex.SnuggleInput;
import uk.ac.ed.ph.snuggletex.SnuggleSession;
import uk.ac.ed.ph.snuggletex.WebPageOutputOptions;
import uk.ac.ed.ph.snuggletex.jeuclid.JEuclidUtilities;
import uk.ac.ed.ph.snuggletex.jeuclid.MathMLImageSavingCallback;
import uk.ac.ed.ph.snuggletex.jeuclid.SimpleMathMLImageSavingCallback;

@Component(value="snuggletex")
public final class SnuggleTexFormulaRenderer
extends AbstractFormulaRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnuggleTexFormulaRenderer.class);
    private SnuggleEngine engine = new SnuggleEngine();

    @Override
    protected ImageData renderImage(String formula, boolean inline, FormulaRenderer.FontSize size, FormulaRenderer.Type type) throws IllegalArgumentException, IOException {
        SnuggleSession session = this.engine.createSession();
        SnuggleInput input = new SnuggleInput(this.wrapFormula(formula, inline));
        session.parseInput(input);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        CustomMathMLImageSavingCallback callback = new CustomMathMLImageSavingCallback((OutputStream)output, size.getSize());
        WebPageOutputOptions options = JEuclidUtilities.createWebPageOptions((boolean)false, (MathMLImageSavingCallback)callback);
        session.writeWebPage(options, (OutputStream)new NullOutputStream());
        return new ImageData(output.toByteArray(), type);
    }

    private class CustomMathMLImageSavingCallback
    extends SimpleMathMLImageSavingCallback {
        private OutputStream target;

        public CustomMathMLImageSavingCallback(OutputStream target, int size) {
            this.target = target;
            this.setFontSize(String.valueOf(size));
        }

        public File getImageOutputFile(int mathmlCounter) {
            return null;
        }

        public OutputStream getImageOutputStream(int mathmlCounter) {
            return mathmlCounter == 0 ? this.target : null;
        }

        public String getImageURL(int mathmlCounter) {
            return "";
        }

        public void imageSavingFailed(Object imageFileOrOutputStream, int mathmlCounter, String contentType, Throwable exception) {
            LOGGER.error("Can't save image", exception);
        }
    }
}

