/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.navigation.NavigationUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.selector.page.UIPageSelector;
import org.exoplatform.wcm.webui.selector.page.UIPageSelectorPanel;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIDropDownControl;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/wcm/webui/selector/page/UIPageNodeSelector.gtmpl", events={@EventConfig(listeners={SelectNavigationActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIDropDownControl.class, id="UIDropDown", template="classpath:groovy/wcm/webui/selector/page/UINavigationSelector.gtmpl", events={@EventConfig(listeners={SelectNavigationActionListener.class})})})
public class UIPageNodeSelector
extends UIContainer {
    private List<UserNavigation> navigations;
    private SelectedNode selectedNode;
    private SelectedNode copyNode;
    private List<UserNavigation> deleteNavigations = new ArrayList<UserNavigation>();
    private UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();

    public UIPageNodeSelector() throws Exception {
        UIDropDownControl uiDopDownControl = (UIDropDownControl)this.addChild(UIDropDownControl.class, "UIDropDown", "UIDropDown");
        uiDopDownControl.setParent((UIComponent)this);
        UITree uiTree = (UITree)this.addChild(UITree.class, null, "TreeNodeSelector");
        uiTree.setIcon("DefaultPageIcon");
        uiTree.setSelectedIcon("DefaultPageIcon");
        uiTree.setBeanIdField("URI");
        uiTree.setBeanChildCountField("ChildrenCount");
        uiTree.setBeanLabelField("encodedResolvedLabel");
        uiTree.setBeanIconField("icon");
        this.loadNavigations();
    }

    public void loadNavigations() throws Exception {
        this.navigations = new ArrayList<UserNavigation>();
        this.navigations.addAll(this.userPortal.getNavigations());
        if (this.navigations == null || this.navigations.size() <= 0) {
            ((UIDropDownControl)this.getChild(UIDropDownControl.class)).setOptions(null);
            ((UITree)this.getChild(UITree.class)).setSibbling(null);
            return;
        }
        this.updateNavigationSelector();
        this.chooseAndShowNavigation();
    }

    private void chooseAndShowNavigation() throws Exception {
        String currentPortalName = Util.getPortalRequestContext().getUserPortalConfig().getPortalName();
        UserNavigation portalSelectedNav = NavigationUtils.getUserNavigationOfPortal((UserPortal)this.userPortal, (String)currentPortalName);
        int portalSelectedNavId = this.getId(portalSelectedNav);
        if (this.getUserNavigation(portalSelectedNavId) != null) {
            this.selectNavigation(portalSelectedNavId);
            UserNode portalSelectedNode = Util.getUIPortal().getSelectedUserNode();
            if (portalSelectedNode != null) {
                this.selectUserNodeByUri(portalSelectedNode.getURI());
            }
            return;
        }
        UserNavigation firstNav = this.navigations.get(0);
        this.selectNavigation(this.getId(firstNav));
        UserNode rootNode = this.userPortal.getNode(firstNav, NavigationUtils.ECMS_NAVIGATION_SCOPE, null, null);
        Iterator childrenIter = rootNode.getChildren().iterator();
        if (childrenIter.hasNext()) {
            this.selectUserNodeByUri(((UserNode)childrenIter.next()).getURI());
        }
    }

    public int getId(UserNavigation nav) {
        return (nav.getKey().getTypeName() + "::" + nav.getKey().getName()).hashCode();
    }

    private int getIndex(int navId) {
        int index = -1;
        if (this.navigations == null || this.navigations.size() <= 0) {
            return index;
        }
        for (int i = 0; i < this.navigations.size(); ++i) {
            UserNavigation nav = this.navigations.get(i);
            if (this.getId(nav) != navId) continue;
            index = i;
            break;
        }
        return index;
    }

    private void updateNavigationSelector() {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (UserNavigation navigation : this.navigations) {
            options.add(new SelectItemOption(navigation.getKey().getTypeName() + ":" + navigation.getKey().getName(), (Object)String.valueOf(this.getId(navigation))));
        }
        UIDropDownControl uiNavigationSelector = (UIDropDownControl)this.getChild(UIDropDownControl.class);
        uiNavigationSelector.setOptions(options);
        if (options.size() > 0) {
            uiNavigationSelector.setValue(0);
        }
    }

    public void selectNavigation(int id) throws Exception {
        UserNavigation selectedNav = this.getUserNavigation(id);
        if (selectedNav == null) {
            return;
        }
        UserNode rootNode = this.userPortal.getNode(selectedNav, NavigationUtils.ECMS_NAVIGATION_SCOPE, null, null);
        this.selectedNode = new SelectedNode(selectedNav, rootNode, null, null);
        this.selectUserNodeByUri(null);
        UITree uiTree = (UITree)this.getChild(UITree.class);
        uiTree.setSibbling(rootNode.getChildren());
        UIDropDownControl uiDropDownSelector = (UIDropDownControl)this.getChild(UIDropDownControl.class);
        uiDropDownSelector.setValue(this.getIndex(id));
    }

    public void selectUserNodeByUri(String uri) throws Exception {
        if (this.selectedNode == null || uri == null) {
            return;
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        Collection sibbling = tree.getSibbling();
        tree.setSibbling(null);
        tree.setParentSelected(null);
        UserNavigation selectedNav = this.selectedNode.getUserNavigation();
        UserNode userNode = this.userPortal.resolvePath(selectedNav, null, uri);
        if (userNode != null) {
            this.userPortal.updateNode(userNode, NavigationUtils.ECMS_NAVIGATION_SCOPE, null);
            if (userNode != null) {
                this.selectedNode.setNode(userNode);
                this.selectedNode.setParentNode(userNode.getParent());
                tree.setParentSelected((Object)this.selectedNode.getParentNode());
                tree.setSibbling(this.selectedNode.getParentNode().getChildren());
                tree.setSelected((Object)this.selectedNode.getNode());
                tree.setChildren(this.selectedNode.getNode().getChildren());
                return;
            }
        }
        tree.setSelected(null);
        tree.setChildren(null);
        tree.setSibbling(sibbling);
    }

    public List<UserNavigation> getUserNavigations() {
        if (this.navigations == null) {
            this.navigations = new ArrayList<UserNavigation>();
        }
        return this.navigations;
    }

    public UserNavigation getUserNavigation(int id) {
        for (UserNavigation nav : this.getUserNavigations()) {
            if (this.getId(nav) != id) continue;
            return nav;
        }
        return null;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        UIRightClickPopupMenu uiPopupMenu = (UIRightClickPopupMenu)this.getChild(UIRightClickPopupMenu.class);
        if (uiPopupMenu != null) {
            if (this.navigations == null || this.navigations.size() < 1) {
                uiPopupMenu.setRendered(false);
            } else {
                uiPopupMenu.setRendered(true);
            }
        }
        super.processRender(context);
    }

    public SelectedNode getCopyNode() {
        return this.copyNode;
    }

    public void setCopyNode(SelectedNode copyNode) {
        this.copyNode = copyNode;
    }

    public SelectedNode getSelectedNode() {
        return this.selectedNode;
    }

    public UserNavigation getSelectedNavigation() {
        return this.selectedNode == null ? null : this.selectedNode.getUserNavigation();
    }

    public UserNode getRootNodeOfSelectedNav() {
        return this.selectedNode == null ? null : this.selectedNode.getRootNode();
    }

    public UserNode getSelectedUserNode() {
        return this.selectedNode == null ? null : this.selectedNode.getNode();
    }

    public String getUpLevelUri() {
        return this.selectedNode.getParentNode().getURI();
    }

    public List<UserNavigation> getDeleteNavigations() {
        return this.deleteNavigations;
    }

    public static class SelectedNode {
        private UserNavigation nav;
        private UserNode parentNode;
        private UserNode node;
        private UserNode rootNode;
        private boolean deleteNode = false;
        private boolean cloneNode = false;

        public SelectedNode(UserNavigation nav, UserNode rootNode, UserNode parentNode, UserNode node) {
            this.nav = nav;
            this.rootNode = rootNode;
            this.parentNode = parentNode;
            this.node = node;
        }

        public UserNavigation getUserNavigation() {
            return this.nav;
        }

        public void setUserNavigation(UserNavigation nav) {
            this.nav = nav;
        }

        public UserNode getRootNode() {
            return this.rootNode;
        }

        public void setRootNode(UserNode rootNode) {
            this.rootNode = rootNode;
        }

        public UserNode getParentNode() {
            return this.parentNode;
        }

        public void setParentNode(UserNode parentNode) {
            this.parentNode = parentNode;
        }

        public UserNode getNode() {
            return this.node;
        }

        public void setNode(UserNode node) {
            this.node = node;
        }

        public boolean isDeleteNode() {
            return this.deleteNode;
        }

        public void setDeleteNode(boolean deleteNode) {
            this.deleteNode = deleteNode;
        }

        public boolean isCloneNode() {
            return this.cloneNode;
        }

        public void setCloneNode(boolean b) {
            this.cloneNode = b;
        }
    }

    public static class SelectNavigationActionListener
    extends EventListener<UIDropDownControl> {
        public void execute(Event<UIDropDownControl> event) throws Exception {
            String id = event.getRequestContext().getRequestParameter("objectId");
            UIDropDownControl uiDropDownControl = (UIDropDownControl)event.getSource();
            UIPageNodeSelector uiPageNodeSelector = (UIPageNodeSelector)uiDropDownControl.getAncestorOfType(UIPageNodeSelector.class);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPageNodeSelector.getParent());
            if (id != null) {
                uiPageNodeSelector.selectNavigation(Integer.parseInt(id));
            }
            try {
                UIPageSelector pageSelector = (UIPageSelector)uiPageNodeSelector.getAncestorOfType(UIPageSelector.class);
                UIPageSelectorPanel pageSelectorPanel = (UIPageSelectorPanel)pageSelector.getChild(UIPageSelectorPanel.class);
                pageSelectorPanel.setSelectedNode(uiPageNodeSelector.getSelectedNode().getNode());
                pageSelectorPanel.updateGrid();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pageSelector);
            }
            catch (Exception ex) {
                Utils.createPopupMessage(uiPageNodeSelector, "UIMessageBoard.msg.select-navigation", null, 0);
            }
            uiPageNodeSelector.getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

