/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.api;

import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.activity.filter.ActivityFilter;
import org.exoplatform.social.core.activity.filter.ActivityUpdateFilter;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.storage.ActivityStorageException;
import org.exoplatform.social.core.storage.impl.ActivityBuilderWhere;

public interface ActivityStorage {
    public static final String MENTION_CHAR = "@";

    public void addPlugin(BaseComponentPlugin var1);

    public void setInjectStreams(boolean var1);

    public ExoSocialActivity getActivity(String var1) throws ActivityStorageException;

    public List<ExoSocialActivity> getUserActivities(Identity var1) throws ActivityStorageException;

    public List<ExoSocialActivity> getUserActivities(Identity var1, long var2, long var4) throws ActivityStorageException;

    public List<String> getUserIdsActivities(Identity var1, long var2, long var4) throws ActivityStorageException;

    public List<ExoSocialActivity> getUserActivitiesForUpgrade(Identity var1, long var2, long var4) throws ActivityStorageException;

    public List<ExoSocialActivity> getActivities(Identity var1, Identity var2, long var3, long var5) throws ActivityStorageException;

    public void saveComment(ExoSocialActivity var1, ExoSocialActivity var2) throws ActivityStorageException;

    public ExoSocialActivity saveActivity(Identity var1, ExoSocialActivity var2) throws ActivityStorageException;

    public ExoSocialActivity getParentActivity(ExoSocialActivity var1) throws ActivityStorageException;

    public void deleteActivity(String var1) throws ActivityStorageException;

    public void deleteComment(String var1, String var2) throws ActivityStorageException;

    public List<ExoSocialActivity> getActivitiesOfIdentities(List<Identity> var1, long var2, long var4) throws ActivityStorageException;

    public List<ExoSocialActivity> getActivitiesOfIdentities(List<Identity> var1, TimestampType var2, long var3, long var5) throws ActivityStorageException;

    public int getNumberOfUserActivities(Identity var1) throws ActivityStorageException;

    public int getNumberOfUserActivitiesForUpgrade(Identity var1) throws ActivityStorageException;

    public int getNumberOfNewerOnUserActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerOnUserActivities(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderOnUserActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnUserActivities(Identity var1, ExoSocialActivity var2, int var3);

    public List<ExoSocialActivity> getActivityFeed(Identity var1, int var2, int var3);

    public List<String> getActivityIdsFeed(Identity var1, int var2, int var3);

    @Deprecated
    public List<ExoSocialActivity> getActivityFeedForUpgrade(Identity var1, int var2, int var3);

    public int getNumberOfActivitesOnActivityFeed(Identity var1);

    public int getNumberOfActivitesOnActivityFeedForUpgrade(Identity var1);

    public int getNumberOfNewerOnActivityFeed(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerOnActivityFeed(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderOnActivityFeed(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnActivityFeed(Identity var1, ExoSocialActivity var2, int var3);

    public List<ExoSocialActivity> getActivitiesOfConnections(Identity var1, int var2, int var3);

    public List<String> getActivityIdsOfConnections(Identity var1, int var2, int var3);

    @Deprecated
    public List<ExoSocialActivity> getActivitiesOfConnectionsForUpgrade(Identity var1, int var2, int var3);

    public int getNumberOfActivitiesOfConnections(Identity var1);

    public int getNumberOfActivitiesOfConnectionsForUpgrade(Identity var1);

    public List<ExoSocialActivity> getActivitiesOfIdentity(Identity var1, long var2, long var4);

    public int getNumberOfNewerOnActivitiesOfConnections(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerOnActivitiesOfConnections(Identity var1, ExoSocialActivity var2, long var3);

    public int getNumberOfOlderOnActivitiesOfConnections(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnActivitiesOfConnections(Identity var1, ExoSocialActivity var2, int var3);

    public List<ExoSocialActivity> getUserSpacesActivities(Identity var1, int var2, int var3);

    public List<String> getUserSpacesActivityIds(Identity var1, int var2, int var3);

    public List<ExoSocialActivity> getUserSpacesActivitiesForUpgrade(Identity var1, int var2, int var3);

    public int getNumberOfUserSpacesActivities(Identity var1);

    public int getNumberOfUserSpacesActivitiesForUpgrade(Identity var1);

    public int getNumberOfNewerOnUserSpacesActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerOnUserSpacesActivities(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderOnUserSpacesActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnUserSpacesActivities(Identity var1, ExoSocialActivity var2, int var3);

    public List<ExoSocialActivity> getComments(ExoSocialActivity var1, int var2, int var3);

    public int getNumberOfComments(ExoSocialActivity var1);

    public int getNumberOfNewerComments(ExoSocialActivity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderComments(ExoSocialActivity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity var1, ExoSocialActivity var2, int var3);

    public SortedSet<ActivityProcessor> getActivityProcessors();

    public void updateActivity(ExoSocialActivity var1) throws ActivityStorageException;

    public int getNumberOfNewerOnActivityFeed(Identity var1, Long var2);

    public int getNumberOfNewerOnUserActivities(Identity var1, Long var2);

    public int getNumberOfNewerOnActivitiesOfConnections(Identity var1, Long var2);

    public int getNumberOfNewerOnUserSpacesActivities(Identity var1, Long var2);

    public List<ExoSocialActivity> getActivitiesOfIdentities(ActivityBuilderWhere var1, ActivityFilter var2, long var3, long var5) throws ActivityStorageException;

    public int getNumberOfSpaceActivities(Identity var1);

    public int getNumberOfSpaceActivitiesForUpgrade(Identity var1);

    public List<ExoSocialActivity> getSpaceActivities(Identity var1, int var2, int var3);

    public List<String> getSpaceActivityIds(Identity var1, int var2, int var3);

    public List<ExoSocialActivity> getSpaceActivitiesForUpgrade(Identity var1, int var2, int var3);

    public List<ExoSocialActivity> getActivitiesByPoster(Identity var1, int var2, int var3);

    public List<ExoSocialActivity> getActivitiesByPoster(Identity var1, int var2, int var3, String ... var4);

    public int getNumberOfActivitiesByPoster(Identity var1);

    public int getNumberOfActivitiesByPoster(Identity var1, Identity var2);

    public List<ExoSocialActivity> getNewerOnSpaceActivities(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfNewerOnSpaceActivities(Identity var1, ExoSocialActivity var2);

    public List<ExoSocialActivity> getOlderOnSpaceActivities(Identity var1, ExoSocialActivity var2, int var3);

    public int getNumberOfOlderOnSpaceActivities(Identity var1, ExoSocialActivity var2);

    public int getNumberOfNewerOnSpaceActivities(Identity var1, Long var2);

    public int getNumberOfUpdatedOnActivityFeed(Identity var1, ActivityUpdateFilter var2);

    public int getNumberOfUpdatedOnUserActivities(Identity var1, ActivityUpdateFilter var2);

    public int getNumberOfUpdatedOnActivitiesOfConnections(Identity var1, ActivityUpdateFilter var2);

    public int getNumberOfUpdatedOnUserSpacesActivities(Identity var1, ActivityUpdateFilter var2);

    public int getNumberOfUpdatedOnSpaceActivities(Identity var1, ActivityUpdateFilter var2);

    public int getNumberOfMultiUpdated(Identity var1, Map<String, Long> var2);

    public List<ExoSocialActivity> getNewerFeedActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getNewerUserActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getNewerUserSpacesActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getNewerActivitiesOfConnections(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getNewerSpaceActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderFeedActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderUserActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderUserSpacesActivities(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderActivitiesOfConnections(Identity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderSpaceActivities(Identity var1, Long var2, int var3);

    public int getNumberOfOlderOnActivityFeed(Identity var1, Long var2);

    public int getNumberOfOlderOnUserActivities(Identity var1, Long var2);

    public int getNumberOfOlderOnActivitiesOfConnections(Identity var1, Long var2);

    public int getNumberOfOlderOnUserSpacesActivities(Identity var1, Long var2);

    public int getNumberOfOlderOnSpaceActivities(Identity var1, Long var2);

    public List<ExoSocialActivity> getNewerComments(ExoSocialActivity var1, Long var2, int var3);

    public List<ExoSocialActivity> getOlderComments(ExoSocialActivity var1, Long var2, int var3);

    public int getNumberOfNewerComments(ExoSocialActivity var1, Long var2);

    public int getNumberOfOlderComments(ExoSocialActivity var1, Long var2);

    public List<ExoSocialActivity> getAllActivities(int var1, int var2);

    public static enum TimestampType {
        NEWER,
        OLDER,
        UPDATED;

        private Long number;

        public TimestampType from(Long number) {
            this.number = number;
            return this;
        }

        public Long get() {
            return this.number;
        }
    }
}

