/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.layout.JEuclidView;
import net.sourceforge.jeuclid.swing.JMathComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathComponentUI
extends ComponentUI
implements PropertyChangeListener {
    private static final Log LOGGER = LogFactory.getLog(MathComponentUI.class);
    private JMathComponent mathComponent;
    private JEuclidView jEuclidView;
    private Node document;
    private Dimension preferredSize;

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.preferredSize = null;
        Dimension dimension = this.mathComponent.getSize();
        Point point = this.getStartPointWithBordersAndAdjustDimension(dimension);
        this.paintBackground(graphics, dimension, point);
        if (this.jEuclidView != null) {
            Point2D point2D = this.calculateAlignmentOffset(dimension);
            this.jEuclidView.draw((Graphics2D)graphics, (float)point2D.getX() + (float)point.x, (float)point2D.getY() + (float)point.y);
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
        this.paint(graphics, jComponent);
    }

    private Point2D calculateAlignmentOffset(Dimension dimension) {
        float f = this.mathComponent.getHorizontalAlignment() == 10 || this.mathComponent.getHorizontalAlignment() == 2 ? 0.0f : (this.mathComponent.getHorizontalAlignment() == 11 || this.mathComponent.getHorizontalAlignment() == 4 ? (float)dimension.width - this.jEuclidView.getWidth() : ((float)dimension.width - this.jEuclidView.getWidth()) / 2.0f);
        float f2 = this.mathComponent.getVerticalAlignment() == 1 ? this.jEuclidView.getAscentHeight() : (this.mathComponent.getVerticalAlignment() == 3 ? (float)dimension.height - this.jEuclidView.getDescentHeight() : ((float)dimension.height + this.jEuclidView.getAscentHeight() - this.jEuclidView.getDescentHeight()) / 2.0f);
        return new Point2D.Float(f, f2);
    }

    private void paintBackground(Graphics graphics, Dimension dimension, Point point) {
        Color color = this.getRealBackgroundColor();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(point.x, point.y, dimension.width, dimension.height);
        }
    }

    private Point getStartPointWithBordersAndAdjustDimension(Dimension dimension) {
        Insets insets;
        Point point = new Point(0, 0);
        Border border = this.mathComponent.getBorder();
        if (border != null && (insets = border.getBorderInsets(this.mathComponent)) != null) {
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            point = new Point(insets.left, insets.top);
        }
        return point;
    }

    private Color getRealBackgroundColor() {
        Color color = this.mathComponent.getBackground();
        if (this.mathComponent.isOpaque()) {
            if (color == null) {
                color = Color.WHITE;
            }
            color = new Color(color.getRGB());
        }
        return color;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.mathComponent = (JMathComponent)jComponent;
        jComponent.addPropertyChangeListener(this);
        this.installDefaults(this.mathComponent);
    }

    protected void installDefaults(JMathComponent jMathComponent) {
        LookAndFeel.installProperty(jMathComponent, "opaque", Boolean.FALSE);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this);
        this.mathComponent = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string) || "property".equals(string)) {
            JMathComponent jMathComponent = (JMathComponent)propertyChangeEvent.getSource();
            this.document = (Node)propertyChangeEvent.getNewValue();
            this.redo(jMathComponent.getParameters(), (Graphics2D)jMathComponent.getGraphics());
        } else {
            try {
                JMathComponent jMathComponent = (JMathComponent)propertyChangeEvent.getSource();
                this.redo(jMathComponent.getParameters(), (Graphics2D)jMathComponent.getGraphics());
            }
            catch (ClassCastException classCastException) {
                LOGGER.debug((Object)classCastException);
            }
        }
    }

    private void redo(MutableLayoutContext mutableLayoutContext, Graphics2D graphics2D) {
        this.jEuclidView = this.document == null || graphics2D == null ? null : new JEuclidView(this.document, mutableLayoutContext, graphics2D);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMathComponentSize(jComponent);
    }

    private Dimension getMathComponentSize(JComponent jComponent) {
        if (this.preferredSize == null) {
            if (this.jEuclidView == null || jComponent.getGraphics() == null) {
                return super.getPreferredSize(jComponent);
            }
            this.calculatePreferredSize(jComponent);
        }
        return this.preferredSize;
    }

    private void calculatePreferredSize(JComponent jComponent) {
        Insets insets;
        this.preferredSize = new Dimension((int)Math.ceil(this.jEuclidView.getWidth()), (int)Math.ceil(this.jEuclidView.getAscentHeight() + this.jEuclidView.getDescentHeight()));
        Border border = jComponent.getBorder();
        if (border != null && (insets = border.getBorderInsets(jComponent)) != null) {
            this.preferredSize.width += insets.left + insets.right;
            this.preferredSize.height += insets.top + insets.bottom;
        }
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMathComponentSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getMathComponentSize(jComponent);
    }

    public List<JEuclidView.NodeRect> getNodesAt(float f, float f2) {
        Point2D point2D = this.calculateAlignmentOffset(this.mathComponent.getSize());
        return this.jEuclidView.getNodesAt(f, f2, (float)point2D.getX(), (float)point2D.getY());
    }
}

