/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.general;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jeuclid.elements.AbstractElementWithDelegates;
import net.sourceforge.jeuclid.elements.presentation.token.Mo;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLFencedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mfenced
extends AbstractElementWithDelegates
implements MathMLFencedElement {
    public static final String ATTR_SEPARATORS = "separators";
    public static final String ATTR_CLOSE = "close";
    public static final String ATTR_OPEN = "open";
    public static final String ELEMENT = "mfenced";
    private static final String FENCE_SPACE = "0.2em";
    private static final long serialVersionUID = 1L;

    public Mfenced() {
        this.setDefaultMathAttribute(ATTR_OPEN, "(");
        this.setDefaultMathAttribute(ATTR_CLOSE, ")");
        this.setDefaultMathAttribute(ATTR_SEPARATORS, ",");
    }

    protected Node newNode() {
        return new Mfenced();
    }

    @Override
    public String getOpen() {
        return this.getMathAttribute(ATTR_OPEN);
    }

    @Override
    public void setOpen(String string) {
        this.setAttribute(ATTR_OPEN, string);
    }

    @Override
    public String getClose() {
        return this.getMathAttribute(ATTR_CLOSE);
    }

    @Override
    public void setClose(String string) {
        this.setAttribute(ATTR_CLOSE, string);
    }

    @Override
    public String getSeparators() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getMathAttribute(ATTR_SEPARATORS);
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c < ' ') continue;
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSeparators(String string) {
        this.setAttribute(ATTR_SEPARATORS, string);
    }

    @Override
    protected List<LayoutableNode> createDelegates() {
        int n = this.getMathElementCount();
        ArrayList<LayoutableNode> arrayList = new ArrayList<LayoutableNode>(2 * n + 1);
        Mo mo = this.createFenceOperator();
        mo.setForm("prefix");
        mo.setTextContent(this.getOpen());
        arrayList.add(mo);
        String string = this.getSeparators();
        boolean bl = string != null && string.length() > 0;
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getMathElement(i));
            if (!bl || i >= n - 1) continue;
            Mo mo2 = (Mo)this.getOwnerDocument().createElement("mo");
            mo2.setSeparator("true");
            if (i < string.length()) {
                mo2.setTextContent(String.valueOf(string.charAt(i)));
            } else {
                mo2.setTextContent(String.valueOf(string.charAt(string.length() - 1)));
            }
            arrayList.add(mo2);
        }
        Mo mo3 = this.createFenceOperator();
        mo3.setForm("postfix");
        mo3.setTextContent(this.getClose());
        arrayList.add(mo3);
        return arrayList;
    }

    private Mo createFenceOperator() {
        Mo mo = (Mo)this.getOwnerDocument().createElement("mo");
        mo.setFence("true");
        mo.setStretchy("true");
        mo.setRspace(FENCE_SPACE);
        mo.setLspace(FENCE_SPACE);
        mo.setSymmetric("false");
        return mo;
    }
}

