/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.jeuclid;

import java.awt.Dimension;
import java.io.File;
import java.io.OutputStream;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.converter.Converter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.ed.ph.snuggletex.jeuclid.MathMLImageSavingCallback;
import uk.ac.ed.ph.snuggletex.utilities.MathMLPostProcessor;
import uk.ac.ed.ph.snuggletex.utilities.SnuggleUtilities;

public final class JEuclidMathMLPostProcessor
extends MathMLPostProcessor {
    private final MathMLImageSavingCallback imageSavingCallback;

    public JEuclidMathMLPostProcessor(MathMLImageSavingCallback callback) {
        this.imageSavingCallback = callback;
    }

    protected void handleMathMLIsland(Element inputMathIsland, Document outputDocument, Node outputParentNode, int mathmlCounter) {
        boolean isBlock;
        File imageOutputFile = this.imageSavingCallback.getImageOutputFile(mathmlCounter);
        Object imageOutputObject = imageOutputFile;
        OutputStream imageOutputStream = null;
        if (imageOutputFile == null) {
            imageOutputStream = this.imageSavingCallback.getImageOutputStream(mathmlCounter);
            imageOutputObject = imageOutputStream;
            if (imageOutputStream == null) {
                throw new IllegalArgumentException("Both getImageOutputFile() and getImageOutputStream() returned null");
            }
        }
        String contentType = this.imageSavingCallback.getImageContentType(mathmlCounter);
        MutableLayoutContext layoutContext = this.imageSavingCallback.getLayoutContext(mathmlCounter);
        Dimension imageDimension = null;
        try {
            Converter converter = Converter.getInstance();
            imageDimension = imageOutputFile != null ? converter.convert((Node)inputMathIsland, imageOutputFile, contentType, layoutContext) : converter.convert((Node)inputMathIsland, imageOutputStream, contentType, layoutContext);
            if (imageDimension != null) {
                this.imageSavingCallback.imageSavingSucceeded(imageOutputObject, mathmlCounter, contentType);
            } else {
                imageDimension = new Dimension(0, 0);
                this.imageSavingCallback.imageSavingFailed(imageOutputObject, mathmlCounter, contentType, null);
            }
        }
        catch (Exception e) {
            imageDimension = new Dimension(0, 0);
            this.imageSavingCallback.imageSavingFailed(imageOutputObject, mathmlCounter, contentType, e);
        }
        String snuggleTeXEncoding = SnuggleUtilities.extractSnuggleTeXAnnotation((Element)inputMathIsland);
        if (snuggleTeXEncoding != null) {
            snuggleTeXEncoding = snuggleTeXEncoding.replaceAll("%\\s+", "").replaceAll("\\s+", " ");
        }
        Element divOrSpan = outputDocument.createElementNS("http://www.w3.org/1999/xhtml", (isBlock = inputMathIsland.getAttribute("display").equals("block")) ? "div" : "span");
        divOrSpan.setAttribute("class", "mathml-math");
        outputParentNode.appendChild(divOrSpan);
        Element imgElement = outputDocument.createElementNS("http://www.w3.org/1999/xhtml", "img");
        imgElement.setAttribute("src", this.imageSavingCallback.getImageURL(mathmlCounter));
        imgElement.setAttribute("width", Integer.toString(imageDimension.width));
        imgElement.setAttribute("height", Integer.toString(imageDimension.height));
        if (snuggleTeXEncoding != null) {
            imgElement.setAttribute("alt", snuggleTeXEncoding);
        }
        divOrSpan.appendChild(imgElement);
    }
}

