/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.poi.POIXMLProperties;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.xmlbeans.XmlException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MSXWordDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.MSXWordDocumentReader");

    public String[] getMimeTypes() {
        return new String[]{"application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/vnd.ms-word.document.macroenabled.12", "application/vnd.ms-word.template.macroenabled.12"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(final InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        String text = "";
        try {
            XWPFDocument doc;
            if (is.available() == 0) {
                String string = "";
                return string;
            }
            try {
                doc = (XWPFDocument)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<XWPFDocument>(){

                    @Override
                    public XWPFDocument run() throws Exception {
                        return new XWPFDocument(is);
                    }
                });
            }
            catch (RuntimeException cause) {
                throw new DocumentReadException("Can not get the content: " + cause.getMessage(), cause);
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                throw new DocumentReadException("Can not get the content: " + cause.getMessage(), cause);
            }
            final XWPFWordExtractor extractor = new XWPFWordExtractor(doc);
            try {
                text = (String)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return extractor.getText();
                    }
                });
            }
            catch (Exception cause) {
                throw new DocumentReadException("Can not get the content: " + cause.getMessage(), cause);
            }
            finally {
                extractor.close();
            }
        }
        finally {
            block23: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block23;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
        return text.trim();
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(final InputStream is) throws IOException, DocumentReadException {
        try {
            OPCPackage container = (OPCPackage)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<OPCPackage>(){

                @Override
                public OPCPackage run() throws Exception {
                    return OPCPackage.open((InputStream)is);
                }
            });
            POIXMLProperties xmlProperties = new POIXMLProperties(container);
            POIPropertiesReader reader = new POIPropertiesReader();
            reader.readDCProperties(xmlProperties);
            return reader.getProperties();
        }
        catch (InvalidFormatException e) {
            throw new DocumentReadException("The format of the document to read is invalid.", e);
        }
        catch (XmlException e) {
            throw new DocumentReadException("Problem during the document parsing.", e);
        }
        catch (OpenXML4JException e) {
            throw new DocumentReadException("Problem during the document parsing.", e);
        }
    }
}

