/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.ph.snuggletex.internal.util;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.SnuggleRuntimeException;
import uk.ac.ed.ph.snuggletex.internal.util.StringUtilities;
import uk.ac.ed.ph.snuggletex.utilities.ClassPathURIResolver;
import uk.ac.ed.ph.snuggletex.utilities.StylesheetManager;

public final class XMLUtilities {
    public static final String SAXON_TRANSFORMER_FACTORY_CLASS_NAME = "net.sf.saxon.TransformerFactoryImpl";

    public static TransformerFactory createJAXPTransformerFactory() {
        TransformerFactory transformerFactory = null;
        try {
            transformerFactory = TransformerFactory.newInstance();
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SnuggleRuntimeException(e);
        }
        XMLUtilities.requireFeature(transformerFactory, "http://javax.xml.transform.dom.DOMSource/feature");
        XMLUtilities.requireFeature(transformerFactory, "http://javax.xml.transform.dom.DOMResult/feature");
        return transformerFactory;
    }

    private static void requireFeature(TransformerFactory transformerFactory, String feature) {
        if (!transformerFactory.getFeature(feature)) {
            throw new SnuggleRuntimeException("TransformerFactory " + transformerFactory.getClass().getName() + " needs to support feature " + feature + " in order to be used with SnuggleTeX");
        }
    }

    public static TransformerFactory createSaxonTransformerFactory() {
        try {
            return (TransformerFactory)Class.forName(SAXON_TRANSFORMER_FACTORY_CLASS_NAME).newInstance();
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Failed to explicitly instantiate SAXON net.sf.saxon.TransformerFactoryImpl class - check your ClassPath!", e);
        }
    }

    public static Templates compileInternalStylesheet(TransformerFactory transformerFactory, String classPathUri) {
        ClassPathURIResolver uriResolver = ClassPathURIResolver.getInstance();
        transformerFactory.setURIResolver(uriResolver);
        try {
            Source resolved = uriResolver.resolve(classPathUri, "");
            if (resolved == null) {
                throw new SnuggleRuntimeException("Not a ClassPath URI: " + classPathUri);
            }
            return transformerFactory.newTemplates(resolved);
        }
        catch (TransformerConfigurationException e) {
            throw new SnuggleRuntimeException("Could not compile internal stylesheet at " + classPathUri, e);
        }
        catch (TransformerException e) {
            throw new SnuggleRuntimeException("Could not resolve internal stylesheet location " + classPathUri, e);
        }
    }

    public static boolean supportsXSLT20(Transformer tranformer) {
        return tranformer.getClass().getName().startsWith("net.sf.saxon.");
    }

    public static DocumentBuilder createNSAwareDocumentBuilder() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SnuggleRuntimeException("Could not create Namespace-aware DocumentBuilder", e);
        }
    }

    public static String extractTextElementValue(Element textElement) {
        String result;
        NodeList childNodes = textElement.getChildNodes();
        if (childNodes.getLength() == 1) {
            result = XMLUtilities.ensureExtractTextNodeValue(childNodes.item(0));
        } else {
            StringBuilder resultBuilder = new StringBuilder();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                resultBuilder.append(XMLUtilities.ensureExtractTextNodeValue(childNodes.item(i)));
            }
            result = resultBuilder.toString();
        }
        return result;
    }

    private static String ensureExtractTextNodeValue(Node node) {
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        throw new IllegalArgumentException("Node is not a text Node");
    }

    public static String serializeNode(Node node, String encoding, boolean indent, boolean omitXMLDeclaration) {
        StringWriter resultWriter = new StringWriter();
        try {
            Transformer serializer = XMLUtilities.createJAXPTransformerFactory().newTransformer();
            serializer.setOutputProperty("indent", StringUtilities.toYesNo(indent));
            serializer.setOutputProperty("omit-xml-declaration", StringUtilities.toYesNo(omitXMLDeclaration));
            serializer.setOutputProperty("encoding", encoding != null ? encoding : "UTF-8");
            serializer.transform(new DOMSource(node), new StreamResult(resultWriter));
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Could not serialize DOM", e);
        }
        return resultWriter.toString();
    }

    public static String serializeNodeChildren(Node node, boolean indent, boolean omitXMLDeclaration, StylesheetManager stylesheetManager) {
        StringWriter resultWriter = new StringWriter();
        try {
            Transformer serializer = stylesheetManager.getStylesheet("classpath:/uk/ac/ed/ph/snuggletex/extract-child-nodes.xsl").newTransformer();
            serializer.setOutputProperty("indent", StringUtilities.toYesNo(indent));
            serializer.setOutputProperty("omit-xml-declaration", StringUtilities.toYesNo(omitXMLDeclaration));
            serializer.transform(new DOMSource(node), new StreamResult(resultWriter));
        }
        catch (Exception e) {
            throw new SnuggleRuntimeException("Could not serialize DOM", e);
        }
        return resultWriter.toString();
    }

    public static boolean isXMLName(String string) {
        return string != null && string.matches("[a-zA-Z_:][a-zA-Z0-9_:.-]*");
    }

    public static boolean isXMLNCName(String string) {
        return string != null && string.matches("[a-zA-Z_][a-zA-Z0-9_.-]*");
    }
}

