/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.views.UIViewContainer;
import org.exoplatform.ecm.webui.component.admin.views.UIViewForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.ecm.webui.component.admin.views.UIViewPermissionContainer;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIViewPermissionList.msg.confirm-delete")})
public class UIViewPermissionList
extends UIPagingGrid {
    public static String[] PERMISSION_BEAN_FIELD = new String[]{"friendlyPermission"};
    private String viewName;

    public UIViewPermissionList() throws Exception {
        this.getUIPageIterator().setId("PermissionListPageIterator");
        this.configure("permission", PERMISSION_BEAN_FIELD, new String[]{"Delete"});
    }

    public String[] getActions() {
        return new String[0];
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String name) {
        this.viewName = name;
    }

    public void refresh(int currentPage) throws Exception {
        UIViewPermissionContainer uiPerContainer = (UIViewPermissionContainer)this.getParent();
        UIViewFormTabPane uiTabPane = (UIViewFormTabPane)uiPerContainer.getParent();
        UIViewForm uiViewForm = (UIViewForm)uiTabPane.getChild(UIViewForm.class);
        List<Object> permissions = new ArrayList();
        if (uiPerContainer.isView()) {
            ManageViewService viewService = (ManageViewService)WCMCoreUtils.getService(ManageViewService.class);
            Node viewNode = viewService.getViewByName(this.viewName, WCMCoreUtils.getUserSessionProvider());
            String strPermission = viewNode.getProperty("exo:accessPermissions").getString();
            permissions = this.getBeanList(strPermission);
        } else {
            permissions = this.getBeanList(uiViewForm.getPermission());
        }
        Collections.sort(permissions, new ViewPermissionComparator());
        ListAccessImpl permissionBeanList = new ListAccessImpl(PermissionBean.class, permissions);
        this.getUIPageIterator().setPageList((PageList)new LazyPageList((ListAccess)permissionBeanList, this.getUIPageIterator().getItemsPerPage()));
        this.getUIPageIterator().setTotalItems(permissions.size());
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    private String removePermission(String removePermission, String permissions) {
        StringBuilder perBuilder = new StringBuilder();
        if (permissions.indexOf(",") > -1) {
            String[] arrPer;
            for (String per : arrPer = permissions.split(",")) {
                if (per.equals(removePermission)) continue;
                if (perBuilder.length() > 0) {
                    perBuilder.append(",");
                }
                perBuilder.append(per);
            }
        }
        return perBuilder.toString();
    }

    private List<PermissionBean> getBeanList(String permissions) throws Exception {
        UIViewContainer uiContainer = (UIViewContainer)this.getAncestorOfType(UIViewContainer.class);
        ArrayList<PermissionBean> listBean = new ArrayList<PermissionBean>();
        String[] arrPers = new String[]{};
        if (permissions.contains(",")) {
            arrPers = permissions.split(",");
        } else if (permissions.length() > 0) {
            arrPers = new String[]{permissions};
        }
        for (String per : arrPers) {
            PermissionBean bean = new PermissionBean();
            bean.setPermission(per);
            bean.setFriendlyPermission(uiContainer.getFriendlyPermission(per));
            listBean.add(bean);
        }
        return listBean;
    }

    public static class PermissionBean {
        private String permssion;
        private String friendlyPermission;

        public String getPermission() {
            return this.permssion;
        }

        public void setPermission(String permission) {
            this.permssion = permission;
        }

        public String getFriendlyPermission() {
            return this.friendlyPermission;
        }

        public void setFriendlyPermission(String friendlyPer) {
            this.friendlyPermission = friendlyPer;
        }
    }

    public static class ViewPermissionComparator
    implements Comparator<PermissionBean> {
        @Override
        public int compare(PermissionBean t1, PermissionBean t2) throws ClassCastException {
            String per1 = t1.getPermission();
            String per2 = t2.getPermission();
            return per1.compareToIgnoreCase(per2);
        }
    }

    public static class DeleteActionListener
    extends EventListener<UIViewPermissionList> {
        public void execute(Event<UIViewPermissionList> event) throws Exception {
            UIViewPermissionList uiPermissionList = (UIViewPermissionList)((Object)event.getSource());
            UIViewPermissionContainer uiContainer = (UIViewPermissionContainer)uiPermissionList.getParent();
            UIViewFormTabPane uiTabPane = (UIViewFormTabPane)uiContainer.getParent();
            UIViewForm uiViewForm = (UIViewForm)uiTabPane.getChild(UIViewForm.class);
            String permission = event.getRequestContext().getRequestParameter("objectId");
            String permissions = uiPermissionList.removePermission(permission, uiViewForm.getPermission());
            if (permissions.length() == 0) {
                UIApplication uiApp = (UIApplication)uiPermissionList.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIViewPermissionList.msg.permission-cannot-empty", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
                uiTabPane.setSelectedTab(uiContainer.getId());
                return;
            }
            uiViewForm.setPermission(permissions);
            uiPermissionList.refresh(uiPermissionList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPermissionList.getParent());
        }
    }
}

