/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service.ws;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.filter.model.CategoryFilter;
import org.exoplatform.forum.service.ws.BanIP;
import org.exoplatform.forum.service.ws.BeanToJsons;
import org.exoplatform.forum.service.ws.MessageBean;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="ks/forum")
public class ForumWebservice
implements ResourceContainer {
    protected static final String JSON_CONTENT_TYPE = "application/json";
    public static final String APP_TYPE = "forum".intern();
    private String strQuery;
    private List<BanIP> ipsToJson = new ArrayList<BanIP>();
    private static Log log = ExoLogger.getLogger(ForumWebservice.class);
    private static final CacheControl cc;

    @GET
    @Path(value="getmessage/{maxcount}")
    @Produces(value={"application/json"})
    public Response getMessage(@PathParam(value="maxcount") int maxcount, @Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        try {
            String userName = this.getUserId(sc, uriInfo);
            MessageBean data = this.getNewPosts(userName, maxcount);
            return Response.ok((Object)data, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get new post by user.");
            return Response.status((int)500).cacheControl(cc).build();
        }
    }

    @GET
    @Path(value="getpublicmessage/{maxcount}")
    @Produces(value={"application/json"})
    public Response getPulicMessage(@PathParam(value="maxcount") int maxcount) throws Exception {
        MessageBean data = this.getNewPosts(null, maxcount);
        return Response.ok((Object)data, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
    }

    @GET
    @Path(value="filter/{strIP}")
    @Produces(value={"application/json"})
    public Response filterIps(@PathParam(value="strIP") String str) throws Exception {
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getBanList();
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getBanList();
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
        }
        this.strQuery = str;
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
    }

    @GET
    @Path(value="filterIpBanforum/{strForumId}/{strIP}")
    @Produces(value={"application/json"})
    public Response filterIpBanForum(@PathParam(value="strForumId") String forumId, @PathParam(value="strIP") String str) throws Exception {
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals("all")) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else if (!str.equals(this.strQuery)) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getForumBanList(forumId);
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
        }
        this.strQuery = str;
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
    }

    @GET
    @Path(value="filterTagNameForum/{userAndTopicId}/{strTagName}")
    @Produces(value={"application/json"})
    public Response filterTagNameForum(@PathParam(value="strTagName") String str, @PathParam(value="userAndTopicId") String userAndTopicId) throws Exception {
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        if (str.equals(" ")) {
            this.ipsToJson.clear();
        } else if (str.equals("onclickForm")) {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getTagNameInTopic(userAndTopicId);
            for (String ip : banIps) {
                this.ipsToJson.add(new BanIP(ip));
            }
        } else {
            this.ipsToJson.clear();
            List<String> banIps = forumService.getAllTagName(str, userAndTopicId);
            for (String ip : banIps) {
                if (!ip.startsWith(str)) continue;
                this.ipsToJson.add(new BanIP(ip));
            }
        }
        return Response.ok(new BeanToJsons<BanIP>(this.ipsToJson), (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
    }

    @GET
    @Path(value="rss/{resourceid}")
    @Produces(value={"application/xml"})
    public Response viewrss(@PathParam(value="resourceid") String resourceid) throws Exception {
        try {
            ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            InputStream is = forumService.createForumRss(resourceid, "http://www.exoplatform.com");
            return Response.ok((Object)is, (String)"application/xml").cacheControl(cc).build();
        }
        catch (Exception e) {
            log.trace((Object)("\nView RSS fail: " + e.getMessage() + "\n" + e.getCause()));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="rss/user/{resourceid}")
    @Produces(value={"text/xml"})
    public Response userrss(@PathParam(value="resourceid") String resourceid) throws Exception {
        try {
            ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
            InputStream is = forumService.createUserRss(resourceid, "http://www.exoplatform.com");
            return Response.ok((Object)is, (String)"application/xml").cacheControl(cc).build();
        }
        catch (Exception e) {
            log.trace((Object)"\nGet UserRSS fail: ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="filterforum/")
    @Produces(value={"application/json"})
    public Response filterForum(@QueryParam(value="name") String forumName, @QueryParam(value="maxSize") String maxSize, @Context SecurityContext sc, @Context UriInfo uriInfo) throws Exception {
        try {
            ArrayList<CategoryFilter> categoryFilters = new ArrayList<CategoryFilter>();
            if (!Utils.isEmpty(forumName)) {
                ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
                String userName = this.getUserId(sc, uriInfo);
                int maxSize_ = 0;
                if (!Utils.isEmpty(maxSize)) {
                    try {
                        maxSize_ = Integer.parseInt(maxSize.trim());
                    }
                    catch (NumberFormatException e) {
                        maxSize_ = 0;
                    }
                }
                categoryFilters.addAll(forumService.filterForumByName(forumName, userName, maxSize_));
                Collections.sort(categoryFilters, new Utils.CategoryNameComparator());
            }
            return Response.ok(categoryFilters, (String)JSON_CONTENT_TYPE).cacheControl(cc).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private MessageBean getNewPosts(String userName, int maxcount) throws Exception {
        ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
        List<Post> list = forumService.getRecentPostsForUser(userName, maxcount);
        if (list != null) {
            for (Post post : list) {
                post.setLink(post.getLink() + "/" + post.getId());
            }
        }
        MessageBean data = new MessageBean();
        data.setData(list);
        return data;
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (NullPointerException e) {
            return this.getViewerId(uriInfo);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get user id", (Throwable)e);
            return null;
        }
    }

    private String getViewerId(UriInfo uriInfo) {
        String[] queryParts;
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        for (String queryPart : queryParts = requestString.split("&")) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            return queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
        }
        return null;
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cc = new CacheControl();
        cc.setNoCache(true);
        cc.setNoStore(true);
    }
}

