/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.common.cache.model.key.SimpleCacheKey;
import org.exoplatform.forum.common.jcr.KSDataLocation;
import org.exoplatform.forum.common.jcr.SessionManager;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;

public class ForumServiceUtils {
    private static final String COLON = ":".intern();
    private static final String SLASH = "/".intern();

    public static boolean hasPermission(String[] userGroupMembership, String userId) throws Exception {
        if (ForumServiceUtils.isPermissionEmpty(userGroupMembership)) {
            return true;
        }
        if (CommonUtils.isEmpty((String)userId)) {
            return false;
        }
        Identity identity = null;
        ConversationState state = ConversationState.getCurrent();
        if (state != null && !userId.equals((identity = state.getIdentity()).getUserId())) {
            IdentityRegistry identityRegistry = (IdentityRegistry)CommonsUtils.getService(IdentityRegistry.class);
            identity = identityRegistry.getIdentity(userId);
        }
        if (identity == null) {
            Collection memberships = UserHelper.findMembershipsByUser((String)userId);
            ArrayList<MembershipEntry> entries = new ArrayList<MembershipEntry>();
            if (memberships != null) {
                for (Membership membership : memberships) {
                    entries.add(new MembershipEntry(membership.getGroupId(), membership.getMembershipType()));
                }
            }
            identity = new Identity(userId, entries);
        }
        for (String item : userGroupMembership) {
            String username;
            String group;
            String membershipType;
            String[] array;
            String group2;
            String expr = item.trim();
            if (!(ForumServiceUtils.isMembershipExpression(expr) ? identity.isMemberOf(group2 = (array = expr.split(COLON))[1], membershipType = array[0]) : (ForumServiceUtils.isGroupExpression(expr) ? identity.isMemberOf(group = expr) : (username = expr).equals(userId)))) continue;
            return true;
        }
        return false;
    }

    public static boolean isModerator(String[] userGroupMembership, String userId) throws Exception {
        if (ForumServiceUtils.isPermissionEmpty(userGroupMembership)) {
            return false;
        }
        return ForumServiceUtils.hasPermission(userGroupMembership, userId);
    }

    public static boolean isGroupExpression(String expr) {
        return expr.indexOf(SLASH) >= 0 && expr.indexOf(COLON) < 0;
    }

    public static boolean isMembershipExpression(String expr) {
        return expr.indexOf(SLASH) >= 0 && expr.indexOf(COLON) >= 0;
    }

    private static ListAccess<User> getUserByGroup(String group) {
        try {
            return UserHelper.getUserHandler().findUsersByGroupId(group, UserStatus.ENABLED);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static List<String> getUserByMembershipType(String memberShip) throws Exception {
        List<String> users = ForumServiceUtils.getFromCache(new String[]{memberShip});
        if (users != null) {
            return users;
        }
        users = new ArrayList<String>();
        String[] array = memberShip.trim().split(COLON);
        String groupId = array[1];
        String memberShipType = array[0];
        if ("*".equals(memberShipType)) {
            users.addAll(ForumServiceUtils.getUserByGroupId(groupId));
        } else {
            Membership[] mbs;
            MembershipHandler membershipHandler = UserHelper.getMembershipHandler();
            ListAccess listAccess = membershipHandler.findAllMembershipsByGroup(UserHelper.getGroupHandler().findGroupById(groupId));
            for (Membership mb : mbs = (Membership[])listAccess.load(0, listAccess.getSize())) {
                if (ForumServiceUtils.isDisableUser(mb.getUserName()) || !mb.getMembershipType().equals(memberShipType) && !mb.getMembershipType().equals("*")) continue;
                users.add(mb.getUserName());
            }
        }
        ForumServiceUtils.storeInCache(new String[]{memberShip}, users);
        return users;
    }

    private static List<String> getUserByGroupId(String groupId) throws Exception {
        List<String> users = ForumServiceUtils.getFromCache(new String[]{groupId});
        if (users != null) {
            return users;
        }
        users = new ArrayList<String>();
        ListAccess<User> pageList = ForumServiceUtils.getUserByGroup(groupId);
        if (pageList == null) {
            return users;
        }
        User[] userArray = (User[])pageList.load(0, pageList.getSize());
        for (int i = 0; i < pageList.getSize(); ++i) {
            users.add(userArray[i].getUserName());
        }
        ForumServiceUtils.storeInCache(new String[]{groupId}, users);
        return users;
    }

    public static List<String> getUserPermission(String[] userGroupMembership) throws Exception {
        if (ForumServiceUtils.isPermissionEmpty(userGroupMembership)) {
            return new ArrayList<String>();
        }
        List<String> list = ForumServiceUtils.getFromCache(userGroupMembership);
        if (list != null) {
            return list;
        }
        HashSet<String> users = new HashSet<String>();
        for (int j = 0; j < userGroupMembership.length; ++j) {
            String inputValue = userGroupMembership[j].trim();
            if (ForumServiceUtils.isMembershipExpression(inputValue)) {
                users.addAll(ForumServiceUtils.getUserByMembershipType(inputValue));
                continue;
            }
            if (ForumServiceUtils.isGroupExpression(inputValue)) {
                users.addAll(ForumServiceUtils.getUserByGroupId(inputValue));
                continue;
            }
            if (ForumServiceUtils.isDisableUser(inputValue)) continue;
            users.add(inputValue);
        }
        ForumServiceUtils.storeInCache(userGroupMembership, new ArrayList<String>(users));
        return new ArrayList<String>(users);
    }

    private static boolean isPermissionEmpty(String[] userGroupMembership) {
        return CommonUtils.isEmpty((String[])userGroupMembership) || userGroupMembership.length == 1 && userGroupMembership[0].equals(" ");
    }

    public static boolean isDisableUser(String useId) {
        try {
            UserProfile profile = ((ForumService)CommonsUtils.getService(ForumService.class)).getQuickProfile(useId);
            return profile == null || profile.isDisabled();
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void clearCache() {
        ForumServiceUtils.getCache().clearCache();
    }

    private static void storeInCache(String[] userGroupMembership, List<String> users) throws Exception {
        ExoCache<Serializable, List<String>> cache = ForumServiceUtils.getCache();
        SimpleCacheKey cacheKey = ForumServiceUtils.getCacheKey(userGroupMembership);
        cache.put((Serializable)cacheKey, users);
    }

    private static List<String> getFromCache(String[] userGroupMembership) {
        ExoCache<Serializable, List<String>> cache = ForumServiceUtils.getCache();
        SimpleCacheKey cacheKey = ForumServiceUtils.getCacheKey(userGroupMembership);
        return (List)cache.get((Serializable)cacheKey);
    }

    private static SimpleCacheKey getCacheKey(String[] userGroupMembership) {
        StringBuilder sb = new StringBuilder();
        for (String item : userGroupMembership) {
            sb.append("#").append(item);
        }
        return new SimpleCacheKey(sb.toString());
    }

    private static ExoCache<Serializable, List<String>> getCache() {
        CacheService cacheService = (CacheService)CommonsUtils.getService(CacheService.class);
        return cacheService.getCacheInstance("user.PermissionCache");
    }

    public static void reparePermissions(Node node, String owner) throws Exception {
        ExtendedNode extNode = (ExtendedNode)node;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
        extNode.setPermission(owner, arrayPers);
        List permsList = extNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
        }
    }

    public static SessionManager getSessionManager() {
        KSDataLocation location = (KSDataLocation)CommonsUtils.getService(KSDataLocation.class);
        return location.getSessionManager();
    }
}

