/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.utils.lock;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class LockUtil {
    public static void keepLock(Lock lock) throws Exception {
        Map<String, String> lockedNodesInfo;
        LockService lockService = WCMCoreUtils.getService(LockService.class);
        String key = LockUtil.createLockKey(lock.getNode());
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = lockService.getLockInformation(userId)) == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.put(key, lock.getLockToken());
        lockService.putToLockHoding(userId, lockedNodesInfo);
    }

    public static void keepLock(Lock lock, String userId) throws Exception {
        String keyRoot = LockUtil.createLockKey(lock.getNode(), userId);
        LockService lockService = WCMCoreUtils.getService(LockService.class);
        Map<String, String> lockedNodesInfo = lockService.getLockInformation(userId);
        if (lockedNodesInfo == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.put(keyRoot, lock.getLockToken());
        lockService.putToLockHoding(userId, lockedNodesInfo);
    }

    public static void keepLock(Lock lock, String userId, String lockToken) throws Exception {
        LockService lockService = WCMCoreUtils.getService(LockService.class);
        String keyRoot = LockUtil.createLockKey(lock.getNode(), userId);
        Map<String, String> lockedNodesInfo = lockService.getLockInformation(userId);
        if (lockedNodesInfo == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.put(keyRoot, lockToken);
        lockService.putToLockHoding(userId, lockedNodesInfo);
    }

    public static void removeLock(Node node) throws Exception {
        Map<String, String> lockedNodesInfo;
        String key = LockUtil.createLockKey(node);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        LockService lockService = WCMCoreUtils.getService(LockService.class);
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = lockService.getLockInformation(userId)) == null) {
            return;
        }
        lockedNodesInfo.remove(key);
    }

    public static void changeLockToken(Node oldNode, Node newNode) throws Exception {
        WCMCoreUtils.getService(LockService.class).changeLockToken(oldNode, newNode);
    }

    public static void changeLockToken(String srcPath, Node newNode) throws Exception {
        WCMCoreUtils.getService(LockService.class).changeLockToken(srcPath, newNode);
    }

    public static String getLockTokenOfUser(Node node) throws Exception {
        return WCMCoreUtils.getService(LockService.class).getLockTokenOfUser(node);
    }

    public static String getLockToken(Node node) throws Exception {
        return WCMCoreUtils.getService(LockService.class).getLockToken(node);
    }

    public static String getOldLockKey(String srcPath, Node node) throws Exception {
        return WCMCoreUtils.getService(LockService.class).getOldLockKey(srcPath, node);
    }

    public static String createLockKey(Node node) throws Exception {
        return WCMCoreUtils.getService(LockService.class).createLockKey(node);
    }

    public static String createLockKey(Node node, String userId) throws Exception {
        return WCMCoreUtils.getService(LockService.class).createLockKey(node, userId);
    }

    public static boolean isLocked(Node node) throws Exception {
        if (!node.isLocked()) {
            return false;
        }
        String lockToken = LockUtil.getLockTokenOfUser(node);
        if (lockToken != null) {
            node.getSession().addLockToken(LockUtil.getLockToken(node));
            return false;
        }
        return true;
    }

    public static void updateLockCache(String membership) throws Exception {
        ManageableRepository repo = WCMCoreUtils.getRepository();
        Session session = null;
        OrganizationService service = WCMCoreUtils.getService(OrganizationService.class);
        List memberships = (List)service.getMembershipTypeHandler().findMembershipTypes();
        for (String ws : repo.getWorkspaceNames()) {
            session = WCMCoreUtils.getSystemSessionProvider().getSession(ws, repo);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("SELECT * FROM mix:lockable order by exo:dateCreated DESC", "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                Node itemNode = iter.nextNode();
                if (WCMCoreUtils.getService(TrashService.class).isInTrash(itemNode) || !itemNode.isLocked()) continue;
                String lockToken = LockUtil.getLockToken(itemNode);
                LockUtil.keepLock(itemNode.getLock(), membership, lockToken);
                if (!membership.startsWith("*")) continue;
                String lockTokenString = membership;
                for (MembershipType m : memberships) {
                    lockTokenString = membership.replace("*", m.getName());
                    LockUtil.keepLock(itemNode.getLock(), lockTokenString, lockToken);
                }
            }
        }
    }

    public static void removeLockCache(String removedMembership, List<String> ignoredMemberships) throws Exception {
        OrganizationService organizationService = WCMCoreUtils.getService(OrganizationService.class);
        List availMembershipTypes = (List)organizationService.getMembershipTypeHandler().findMembershipTypes();
        HashMap<String, Map<String, String>> lockHolding = WCMCoreUtils.getService(LockService.class).getLockHolding();
        lockHolding.remove(removedMembership);
        if (removedMembership.startsWith("*")) {
            for (MembershipType membershipType : availMembershipTypes) {
                String membership = removedMembership.replace("*", membershipType.getName());
                if (ignoredMemberships.contains(membership)) continue;
                lockHolding.remove(membership);
            }
        }
    }
}

