/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

var sEvObjProps = ['captures', 'currentTarget', 'target', 'eventPhase', 'type'];

//////////////////////////////////////////////////////////////////////////////
//
// Create a JSON string for the given eventObj
//
function dquote(inText)
{
	var ret = inText;
	
	if (ret.length)
	{
		if (ret.indexOf('"') != 0)
		{
			ret = '"' + ret;
		}
		
		if (ret.lastIndexOf('"') != ret.length-1)
		{
			ret = ret + '"';
		}
	}
	
	return ret;
}

function createEventObjectJSON(eventObj)
{
	var ret = '{';
	
	/*
	var props = sEvObjProps.slice();
	
	var classRef = $.dictionary.getClass(eventObj.reflect.name);

	if (classRef != null)
	{
		if (classRef.properties.length)
		{
			for (var p=0; p<classRef.properties.length; p++)
			{
				props.push(classRef.properties[p].name);
			}
		}
	}
	*/ 
	
	var props = [];
	
	for (var p in eventObj)
	{
		props.push(p);
	}
	
	for (var p=0; p<props.length; p++)
	{
        var valueStr = '';
        var value = eventObj[props[p]];
        
        if (typeof(value) == 'undefined')
        {
            valueStr = 'undefined';
        }
        else if (value == null)
        {
            valueStr = null;
        }
        else if (typeof(value) == 'object')
        {
            valueStr = dquote(value.toString());
        }
        else if (typeof(value) == 'string')
        {
            valueStr = dquote(value.toString());
        }            
        else
        {
            valueStr = value.toString();
            
            if (valueStr.indexOf('[object ') == 0)
            {
                valueStr = dquote(valueStr);
            }
        }
    
		//ret += '\t';
		ret += dquote(props[p]) + ' : ';
		ret += valueStr;
		
		if ((p+1) < props.length)
		{
			ret += ',';
		}
		
		//ret += '\n';
	}
	
	ret += '}';
	
	return ret;
}

//////////////////////////////////////////////////////////////////////////////
//
// Log event object properties
//
function logEventObj(inIndex)
{
	var ret = '';
	var evObj = getEventObject(inIndex);
	
	if (isValidProperty(evObj))
	{
		try
		{
			ret = createEventObjectJSON(evObj);
		}
		catch(ex)
		{
			var dummy=1;
		}
	}
	else
	{
		ret = 'undefined';
	}
	
	return ret;
}

//////////////////////////////////////////////////////////////////////////////
//
// Log condition
//
function logCondition(inIndex, inCondition, inResult)
{
	var ret = '';
	
	try
	{
		var evObj = getEventObject(inIndex);
	
		var rep = '[' + (isValidProperty(evObj) ? evObj.type : 'undefined' ) + ']';
	
		ret += inCondition.replace('${EVOBJ}$', rep);
		ret += ' = ';
		ret += inResult;
	}
	catch(e)
	{
	}	
	return ret;
}
