/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function JobCondition(/*[IJob]*/ inJob, /*[Function]*/ inResultCondition, /*[Function]*/ inErrorCondition)
{
	throwInvalid(inJob);

	this.job = inJob;
	this.resultCondition = inResultCondition;
	this.errorCondition = inErrorCondition;
}

function ConditionalJob(/*[JobCondition]*/ inJobCondition)
{
	throwInvalid(inJobCondition);

	var waiting = false;
	var status = IJob.STATUS_PENDING;
	var successHandler = null;
	var errorHandler = null;
	var jobCondition = inJobCondition;

	//////////////////////////////////////////////////////////////////////////////
	//
	// Get Job result
	//
	this.getResult = function()
	{
		return (isValidProperty(jobCondition) ? jobCondition.job.getResult() : null);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Get Job error
	//
	this.getError = function()
	{
		return (isValidProperty(jobCondition) ? jobCondition.job.getError() : null);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Wait for Job completed
	//
	function onSuccess(/*[any]*/ inResult)
	{
		var result = inResult;
		var ignoreResult = false;

		if (isValidProperty(jobCondition) && isValidProperty(jobCondition.resultCondition))
		{
			var jc = jobCondition.resultCondition(result);
			jobCondition = null;

			if (isValidProperty(jc) && (jc instanceof JobCondition))
			{
				jobCondition = jc;
				ignoreResult = true;

				if ((status & IJob.STATUS_CANCELED) != IJob.STATUS_CANCELED && !jobCondition.job.isStatus(IJob.STATUS_CANCELED))
				{
					jobCondition.job.wait(onSuccess, onError);
				}
			}
		}

		if (!ignoreResult && isValidProperty(successHandler))
		{
			successHandler(result);
		}
	}

	function onError(/*[any]*/ inError)
	{
		var error = inError;
		var ignoreError = false;

		if (isValidProperty(jobCondition) && isValidProperty(jobCondition.errorCondition))
		{
			var jc = jobCondition.errorCondition(error);
			jobCondition = null;

			if (isValidProperty(jc) && (jc instanceof JobCondition))
			{
				jobCondition = jc;
				ignoreError = true;

				if ((status & IJob.STATUS_CANCELED) != IJob.STATUS_CANCELED && !jobCondition.job.isStatus(IJob.STATUS_CANCELED))
				{
					jobCondition.job.wait(onSuccess, onError);
				}
			}
		}

		if (!ignoreError && isValidProperty(errorHandler))
		{
			errorHandler(error);
		}
	}

	this.wait = function(/*[Function]*/ inSuccessFct, /*[Function]*/ inErrorFct)
	{
		if (!waiting && !this.isStatus(IJob.STATUS_CANCELED))
		{
			waiting = true;
			successHandler = inSuccessFct;
			errorHandler = inErrorFct;

			if (isValidProperty(jobCondition))
			{
				jobCondition.job.wait(onSuccess, onError);
			}
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Cancel Job
	//
	this.cancel = function()
	{
		if (this.isStatus(IJob.STATUS_PENDING))
		{
			status = IJob.STATUS_CANCELED | IJob.STATUS_FINISHED;
			successHandler = null;
			errorHandler = null;
		}

		if (isValidProperty(jobCondition))
		{
			jobCondition.job.cancel();
			jobCondition = null;
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Get Job status
	//
	this.getStatus = function()
	{
		return (isValidProperty(jobCondition) ? jobCondition.job.getStatus() : status);
	}

	//////////////////////////////////////////////////////////////////////////////
	//
	// Check Job status
	//
	this.isStatus = function(/*[Number]*/ inStatusFlags)
	{
		var ret = false;

		if (isValidProperty(jobCondition))
		{
			ret = jobCondition.job.isStatus(inStatusFlags);
		}
		else
		{
			ret = ((status & inStatusFlags) == inStatusFlags);
		}

		return ret;
	}
}
