CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO Payloads VALUES	("{D38116C8-C472-4BB0-AD6F-0C1DD1320D1D}", "NonAdobePayload", "AdobeHelp", "4.0", "normal")
INSERT INTO PayloadData VALUES("{D38116C8-C472-4BB0-AD6F-0C1DD1320D1D}", "0" , "PayloadInfo", '<PayloadInfo version="2.0.74.0"><BuildInfo>
		<Property name="Created">2012-02-02</Property>
		<Property name="TargetName">AdobeHelp</Property>
	</BuildInfo><InstallerProperties>
		<Property name="AdobeCode">{D38116C8-C472-4BB0-AD6F-0C1DD1320D1D}</Property>
		<Property name="ProductName">AdobeHelp</Property>
		<Property name="ProductVersion">4.0</Property>
	</InstallerProperties><InstallDir>
		<Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]</Platform>
	</InstallDir><Languages languageIndependent="1"/><Satisfies>
		<ProductInfo>
			<Family>NonAdobePayload</Family>
			<ProductName>AdobeHelp</ProductName>
			<ProductVersion>4.0</ProductVersion>
		</ProductInfo>
	</Satisfies><InstallDestinationMetadata relocatableSize="0" sysDriveSize="7000000">
		<Destination>
			<Root>[AdobeProgramFiles]</Root>
			<TotalSize>7000000</TotalSize>
			<MaxPathComponent>/</MaxPathComponent>
		</Destination>
	</InstallDestinationMetadata><ThirdPartyComponent>
		<Metadata>
			<Type>application</Type>
			<Name>InstallAdobeHelp.exe</Name>
			<Properties>
				<Property name="ProductCode">{E17DD835-196A-481E-A149-EBA6953658A0}</Property>
			</Properties>
		</Metadata>
		<Capabilities>
			<Install>
				<Value lang="en_US">You just installed Adobe Community Help.</Value>
			</Install>
			<Repair isRepairable="1">
				<Value lang="en_US">Adobe Community Help was reinstalled.</Value>
			</Repair>
			<Uninstall isUninstallable="0">
				<Value lang="en_US">To remove Adobe Community Help please use Add/Remove programs from the control panel.</Value>
			</Uninstall>
		</Capabilities>
		<SuccessCodes>
			<Install>
				<Range lowerBound="0" upperBound="0"/>
					<Range lowerBound="1" upperBound="1"/>
					<Range lowerBound="7" upperBound="7"/>
				</Install>
			<Repair>
				<Range lowerBound="0" upperBound="0"/>
					<Range lowerBound="1" upperBound="1"/>
					<Range lowerBound="7" upperBound="7"/>
				</Repair>
		</SuccessCodes>
		<Arguments delimiter=" " prefix="">
			<Install>
				<Argument name="appVersion=4.0.244"/>
				<Argument name="appId=chc"/>
				<Argument name="pubId=4875E02D9FB21EE389F73B8D1702B320485DF8CE.1"/>
				<Argument name="installerArg1=-silent"/>
				<Argument name="installerArg2=-eulaAccepted"/>
				<Argument name="installerArg3=-programMenu"/>
				<Argument name="installerArg4=AdobeHelp.air"/>
			</Install>
			<Repair>
				<Argument name="appVersion=4.0.244"/>
				<Argument name="appId=chc"/>
				<Argument name="pubId=4875E02D9FB21EE389F73B8D1702B320485DF8CE.1"/>
				<Argument name="installerArg1=-silent"/>
				<Argument name="installerArg2=-eulaAccepted"/>
				<Argument name="installerArg3=-programMenu"/>
				<Argument name="installerArg4=AdobeHelp.air"/>
			</Repair>
		</Arguments>
	</ThirdPartyComponent></PayloadInfo>')
