CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "", "required", "NonAdobePayload", "Microsoft Visual C++ 2005 Redistributable Package (x86)", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{75DFF841-40F1-43DA-85D1-72DD6CAC09B3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{9BC1ED3D-EC21-40FF-83DF-803A7EDC33CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{FF6CD7F4-15EB-444C-95EE-273B2CFF4A23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{05618941-D9BA-4080-8319-B3E1DFE3BF50}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{E890316A-902F-4A09-878D-110E0E0352BD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{273DE39B-D336-4B52-B96A-A3949CE8EEC3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{2D70A601-08BB-47D0-9910-F64EA3495138}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{D66C9D6B-0804-49D3-AE32-DA4CB89A69C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{BE6BDB1E-AAB1-43F6-AC23-7732A4B42683}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{2CE69354-7837-4FBF-9042-F1B523772DEC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{97FD4E62-402D-4DA1-9AD3-82EDC3EA672C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{3765FBB8-1470-4C3B-88A9-A442953AADAC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{0EEE88BC-A11C-4C5D-B56D-A5AA84EFA503}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{C0DE1E4C-314A-485A-8ADC-46EE7A9E731A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{B0FFC5A8-3071-486F-A891-4F462E574D85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{7ED8097F-DBF1-4938-B8CB-90B202FE6F24}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{1AD52789-4E60-4EC5-AB61-DB08FFC59242}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{A9A3FF72-E604-4133-BB7A-924AAD493884}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{96DD516F-8DC6-456D-BC54-505201830F5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{534C2E77-AB19-45E0-9E1F-E56B9D51EAEC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{F8A820E6-DC7F-4938-858C-31580B8AB906}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{37040CA4-27B3-4B80-B4C9-D72939A60A84}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{A0731D44-832F-4BDC-90CB-0CF1294B82E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{5497021B-2504-4201-A12E-6A3219A0117A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{DADA7505-561D-46A1-B1FC-84277A9A7C80}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{AD0ABE3D-1BB8-4160-9D44-D0C4E2B95D60}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{BBCA6F94-C1DB-4BD4-9D82-F8E7B91EA4AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{B6489122-505E-4347-A4A3-EC46AD1FFB20}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{C2FCD793-062A-4187-8637-3B26182C48E3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{88E3D1B1-0B0B-467D-A033-8A650106A598}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{9C6F1DE5-B60B-48AB-A670-8DFA7B071469}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{B489782F-485C-4F68-B9E9-FBC6B06EF885}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{C0C1D2AB-6A29-449D-8524-EFA835C09C98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{7E131029-F46E-4FD1-B296-B2CBD89E96F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{96F8A715-9168-4B06-B49F-F533A5CDF465}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{CA37900C-479A-4223-BD76-89B02262B8F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{6ACBC364-7A0C-47E2-9028-FD0C7D2ABF78}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{C5485E78-145D-4698-BF9D-DC77544D9A4C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{E59BBBFD-4592-480A-A932-CF8461062BF2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{AE165407-53BE-4213-81C6-EBCBA37DB722}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{6BE56D66-D252-4915-B7FA-AC49F8403601}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{ADFEE5BD-6ABF-4B6D-9E93-F8F96D5EF8A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{640EACEE-84AA-45DD-81CA-325C5220AAC7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{A0DD25C7-01A7-40A5-A2D3-14CA68A02BB6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{52627903-AB41-44EC-B9D0-0D480C4A8CA4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{62110D5D-61B2-499D-95C4-75EB0C3E009A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{B7C5B9B4-BDC9-408E-9F1C-E8E03887314C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{9EC4F377-ADA0-474A-A3D9-FB5D868387B1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{6D045363-79E5-4AAB-A6F2-665ED895BEF1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{CA56C3AA-DF0D-4F17-ADB8-4BD1E70B9408}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{E474AAFE-E5E7-44E2-81F3-0B35AA1CAE0A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{7FCF776C-D318-4CA4-9EF0-16642701F035}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{8CD9959F-5EDA-4BCE-B65B-24A50616CB36}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{05CAE947-44B6-4D04-BA49-3457E6C6D687}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{ED2141C3-F339-4100-B006-BE9942738E5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{706C99D1-515B-412E-87B8-F36F9B3F9326}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{0DA70B2B-1ACF-4A3D-B099-7EAEFB459379}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{B1BCBE33-14CF-4496-BA7A-02E823DF08C6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{4E898C12-8B0D-4166-A6DF-6DFC43F7D815}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{1240D97D-40B6-40CD-B172-12055AEF4EBC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{74816030-229A-4D67-9458-B3498263A336}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{EC381FFE-F46E-4A52-9DA2-D6058DEB8E19}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{E73662A8-289C-4F76-87EF-268756008096}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{7938D0F6-FCD4-484C-AE38-1F5ABD1949F6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{D7BDAAEF-CB6E-4E51-8BA6-F62987C64CA6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{1EEFF9DE-87BD-4A29-83F3-13BEDCCCD345}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{A4CC0051-140D-428D-A691-DC009B6DDD03}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{CFFFDBFF-FBC4-4ECD-BB06-D5A58340460A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{43323517-0802-4568-B2A3-4C5B4909ACC7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{BBDC3F82-9EB5-40E5-BE5F-82BA79C1BB24}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{E85758C5-3AB8-47B9-B198-0065881E23FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{8B574BAE-87D1-41A3-A0E9-013B9EDDB78A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{9CC44C4A-84E2-4E41-9AD5-CB2FBA489D65}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{B7CB42CA-84BE-44A5-9E5C-149E2230FDFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{60998B00-75AD-4E65-BD90-61ECFBB2D29C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{A8132185-47B7-425F-AF60-60EEBF41DB7C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{B1294FD6-9E3F-4840-B1DA-D9E88F23E9E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{141A4B34-DD4D-4383-9D24-233BCAB4748B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{B4735203-F261-4DAE-84EE-3C2638B3614A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{B583D34C-827E-4AEA-BA2C-27FF0F5801F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{0675138A-3EA8-4E8A-A16A-3138D3CFD9A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{343146AE-49CF-4325-AA30-EF9D15C0447C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{41EF0A7F-EF08-4930-BB88-F9E3D7D14864}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{49C8BC3C-8C87-4167-B10B-D5872BDCA1CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{EBA1A2CF-D5DA-497A-B4A3-C7E7313A5432}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{18FB2C45-9E9E-4C8B-B192-54EEE0B86153}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{433B5A21-8AE2-4CA6-A869-FB64077A994E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{D06EA1AC-5074-46B5-A9A7-A021C83D8CEC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{29C64B36-94B5-43FC-9D61-54AF0B5F37B4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{C3B028F7-CF6D-4378-BEBD-D1BEDFB401E4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{41834A09-3A62-47DF-AFB1-B5721766D004}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{878C245E-A7C9-474F-B037-88692EA675D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{7380E30C-5EB0-45F7-993C-917E7819852C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{FDF0CB33-DBF7-4E9E-A6F7-57F7800EAE1D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{E79C22CE-F170-4249-A4EF-D4E8970B8BF9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{01782BC1-0D61-4B3C-ADC0-E8CFEC803A67}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{FB158719-06C4-45EF-8C50-7FE81DFDAD03}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{3B075EB6-BE90-4251-95C1-2B41AEDC1C92}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{AD0325F6-9602-4F21-A14E-A9473AB84501}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{FB1F9A57-4017-413A-95E7-C6ADB384E321}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{BFF29C68-31AD-4164-B2D7-82CC378D6A67}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{3B4E0CC4-D303-43FB-8164-FB04BAA7DFCF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{3F977067-F008-42C5-A541-C784F381FDDB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{5FAAD386-932C-4BFD-92CF-65663B7A1036}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{4BC2B70A-B788-4315-B239-CD53D6D1CDCF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{0FA76EE6-2041-4F02-8217-1402D6BACC5C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{0A76F41A-8155-4189-B75F-84D1ACA5455E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{BC09EE15-A4E0-4285-BFAF-67DCD2D814E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{257A380F-5383-456D-9909-A7F1FF52F547}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{0D78C53A-0962-4B1F-9D59-4049E531B8CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{4EC21F1B-1AC5-435D-BB85-56DB822033E8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{3B4BD104-FC3D-4C7E-AEA5-92C5054D8F29}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{2DAF54FD-6203-441B-B1EA-817738E0782A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{2356C7AF-5A5B-4AB3-B7A7-89CE8117C125}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{BDF36E42-10A9-4B87-84CB-9718B2849431}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{4F3DF4A8-C0C7-4810-A68B-92062E28A388}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{9BD3A825-8167-4B74-8CE8-DA02DFF264BE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{894D47E4-BF46-4B09-900A-5586EAA6D694}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{2E02E545-D1D0-47C1-9AAD-D9B4AFE0E161}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{D4390C17-CE5C-47DB-A69F-812052D78BDF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{7A2E5623-B765-4140-8F0F-C28D143A22D9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{54F0E0BC-DD66-44A2-BAB2-F69761953188}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{28E9ADDD-F710-4D67-B019-48F9BC2DC52B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{6090C1BE-48D7-4428-B418-7C0511462155}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{329DF640-DAA4-4EFE-99A6-01E1BE46C1E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "{92866EBD-EC39-45E8-9336-FAC53057BEC1}", "conflict", "", "", "")
INSERT INTO PayloadData VALUES("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{DE88AA40-6766-43D3-A755-8FC374B3D2C3}"><File><InstallPath>[AdobeCommon]\dynamiclink\CS6\boost_date_time.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\dynamiclink\CS6\boost_system.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\dynamiclink\CS6\boost_threads.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\dynamiclink\CS6\dvacore.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\dynamiclink\CS6\dvamarshal.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\dynamiclink\CS6\dvamediatypes.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\dynamiclink\CS6\dvatransport.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\dynamiclink\CS6\dynamiclink.dll</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File><File><InstallPath>[AdobeCommon]\dynamiclink\CS6\dynamiclinkmanager.exe</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "0" , "ValidationSig", "IuwqRB5b6CG1/ChbsbENTaIwVxrbyQBw5bZ6LZiMwcO9QiX4+x76XZNvFvywp4e+YasMG9/53izKxT5ENNOG7aaWmPqa+QK1CsNLEGakuGiePixTvl64BUdd41HHcAq4KnzuUM6doJVq2NKMPKOC50g4SdL4EkX8zP64WIF6b27UxopXGwlXGeS4QjtMcgkuoMoGpRh9jAJb00OgthleIA1Or+VtSxlU6QJtUSbUIG/mZWzrcOwxYCCVEo1Q8FEbgpgK+NiwvbekisrebACGRJV11jLtURBOJYlsQuu628OAxivAhVAyAJwcCLQdca8fYbR5sboNJC0TU56sn3dDr8qvDN7fL9AJjKPCHgwT04kuIDSc6QC4FKcVqRTuYwdCxMUGxaWQJFW91V5gx9+cBZNpTIh7fAmXU6mEpcyWoyhJAbrYT8KK5wpJI4ulAg69qsQEfr0vxDJzpiJP8kFMLTRoPNLO+T9iPcrXfYZi8SeB7gd6JYisYBAIb080KcgM")
INSERT INTO Payloads VALUES	("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "DVA", "DynamiclinkSupport", "6", "normal")
INSERT INTO PayloadData VALUES("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.29.0"><BuildInfo>
    <Property name="Created">2012-02-21 21:20:06.609000</Property>
    <Property name="TargetName">AdobeDynamiclinkSupport6All</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{DE88AA40-6766-43D3-A755-8FC374B3D2C3}</Property>
    <Property name="ProductName">Adobe Dynamiclink Support</Property>
    <Property name="ProductVersion">6</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="1" name="Default" folderName="">[AdobeCommon]</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
		<Family>DVA</Family>
		<ProductName>DynamiclinkSupport</ProductName>
	<ProductVersion>6</ProductVersion>
    </ProductInfo>
  </Satisfies><Dependencies>
    <ProductInfo type="required">
      <Family>NonAdobePayload</Family>
      <ProductName>Microsoft Visual C++ 2005 Redistributable Package (x86)</ProductName>
    </ProductInfo>
  </Dependencies><Upgrades>
    <AdobeCode>{75DFF841-40F1-43DA-85D1-72DD6CAC09B3}</AdobeCode>
    <AdobeCode>{9BC1ED3D-EC21-40FF-83DF-803A7EDC33CC}</AdobeCode>
    <AdobeCode>{FF6CD7F4-15EB-444C-95EE-273B2CFF4A23}</AdobeCode>
    <AdobeCode>{05618941-D9BA-4080-8319-B3E1DFE3BF50}</AdobeCode>
    <AdobeCode>{E890316A-902F-4A09-878D-110E0E0352BD}</AdobeCode>
    <AdobeCode>{273DE39B-D336-4B52-B96A-A3949CE8EEC3}</AdobeCode>
    <AdobeCode>{2D70A601-08BB-47D0-9910-F64EA3495138}</AdobeCode>
    <AdobeCode>{D66C9D6B-0804-49D3-AE32-DA4CB89A69C0}</AdobeCode>
    <AdobeCode>{BE6BDB1E-AAB1-43F6-AC23-7732A4B42683}</AdobeCode>
    <AdobeCode>{2CE69354-7837-4FBF-9042-F1B523772DEC}</AdobeCode>
    <AdobeCode>{97FD4E62-402D-4DA1-9AD3-82EDC3EA672C}</AdobeCode>
    <AdobeCode>{3765FBB8-1470-4C3B-88A9-A442953AADAC}</AdobeCode>
    <AdobeCode>{0EEE88BC-A11C-4C5D-B56D-A5AA84EFA503}</AdobeCode>
    <AdobeCode>{C0DE1E4C-314A-485A-8ADC-46EE7A9E731A}</AdobeCode>
    <AdobeCode>{B0FFC5A8-3071-486F-A891-4F462E574D85}</AdobeCode>
    <AdobeCode>{7ED8097F-DBF1-4938-B8CB-90B202FE6F24}</AdobeCode>
    <AdobeCode>{1AD52789-4E60-4EC5-AB61-DB08FFC59242}</AdobeCode>
    <AdobeCode>{A9A3FF72-E604-4133-BB7A-924AAD493884}</AdobeCode>
    <AdobeCode>{96DD516F-8DC6-456D-BC54-505201830F5F}</AdobeCode>
    <AdobeCode>{534C2E77-AB19-45E0-9E1F-E56B9D51EAEC}</AdobeCode>
    <AdobeCode>{F8A820E6-DC7F-4938-858C-31580B8AB906}</AdobeCode>
    <AdobeCode>{37040CA4-27B3-4B80-B4C9-D72939A60A84}</AdobeCode>
    <AdobeCode>{A0731D44-832F-4BDC-90CB-0CF1294B82E6}</AdobeCode>
    <AdobeCode>{5497021B-2504-4201-A12E-6A3219A0117A}</AdobeCode>
    <AdobeCode>{DADA7505-561D-46A1-B1FC-84277A9A7C80}</AdobeCode>
    <AdobeCode>{AD0ABE3D-1BB8-4160-9D44-D0C4E2B95D60}</AdobeCode>
    <AdobeCode>{BBCA6F94-C1DB-4BD4-9D82-F8E7B91EA4AF}</AdobeCode>
    <AdobeCode>{B6489122-505E-4347-A4A3-EC46AD1FFB20}</AdobeCode>
    <AdobeCode>{C2FCD793-062A-4187-8637-3B26182C48E3}</AdobeCode>
    <AdobeCode>{88E3D1B1-0B0B-467D-A033-8A650106A598}</AdobeCode>
    <AdobeCode>{9C6F1DE5-B60B-48AB-A670-8DFA7B071469}</AdobeCode>
    <AdobeCode>{B489782F-485C-4F68-B9E9-FBC6B06EF885}</AdobeCode>
    <AdobeCode>{C0C1D2AB-6A29-449D-8524-EFA835C09C98}</AdobeCode>
    <AdobeCode>{7E131029-F46E-4FD1-B296-B2CBD89E96F4}</AdobeCode>
    <AdobeCode>{96F8A715-9168-4B06-B49F-F533A5CDF465}</AdobeCode>
    <AdobeCode>{CA37900C-479A-4223-BD76-89B02262B8F8}</AdobeCode>
    <AdobeCode>{6ACBC364-7A0C-47E2-9028-FD0C7D2ABF78}</AdobeCode>
    <AdobeCode>{C5485E78-145D-4698-BF9D-DC77544D9A4C}</AdobeCode>
    <AdobeCode>{E59BBBFD-4592-480A-A932-CF8461062BF2}</AdobeCode>
    <AdobeCode>{AE165407-53BE-4213-81C6-EBCBA37DB722}</AdobeCode>
    <AdobeCode>{6BE56D66-D252-4915-B7FA-AC49F8403601}</AdobeCode>
    <AdobeCode>{ADFEE5BD-6ABF-4B6D-9E93-F8F96D5EF8A2}</AdobeCode>
    <AdobeCode>{640EACEE-84AA-45DD-81CA-325C5220AAC7}</AdobeCode>
    <AdobeCode>{A0DD25C7-01A7-40A5-A2D3-14CA68A02BB6}</AdobeCode>
    <AdobeCode>{52627903-AB41-44EC-B9D0-0D480C4A8CA4}</AdobeCode>
    <AdobeCode>{62110D5D-61B2-499D-95C4-75EB0C3E009A}</AdobeCode>
    <AdobeCode>{B7C5B9B4-BDC9-408E-9F1C-E8E03887314C}</AdobeCode>
    <AdobeCode>{9EC4F377-ADA0-474A-A3D9-FB5D868387B1}</AdobeCode>
    <AdobeCode>{6D045363-79E5-4AAB-A6F2-665ED895BEF1}</AdobeCode>
    <AdobeCode>{CA56C3AA-DF0D-4F17-ADB8-4BD1E70B9408}</AdobeCode>
    <AdobeCode>{E474AAFE-E5E7-44E2-81F3-0B35AA1CAE0A}</AdobeCode>
    <AdobeCode>{7FCF776C-D318-4CA4-9EF0-16642701F035}</AdobeCode>
    <AdobeCode>{8CD9959F-5EDA-4BCE-B65B-24A50616CB36}</AdobeCode>
    <AdobeCode>{05CAE947-44B6-4D04-BA49-3457E6C6D687}</AdobeCode>
    <AdobeCode>{ED2141C3-F339-4100-B006-BE9942738E5F}</AdobeCode>
    <AdobeCode>{706C99D1-515B-412E-87B8-F36F9B3F9326}</AdobeCode>
    <AdobeCode>{0DA70B2B-1ACF-4A3D-B099-7EAEFB459379}</AdobeCode>
    <AdobeCode>{B1BCBE33-14CF-4496-BA7A-02E823DF08C6}</AdobeCode>
    <AdobeCode>{4E898C12-8B0D-4166-A6DF-6DFC43F7D815}</AdobeCode>
    <AdobeCode>{1240D97D-40B6-40CD-B172-12055AEF4EBC}</AdobeCode>
    <AdobeCode>{74816030-229A-4D67-9458-B3498263A336}</AdobeCode>
    <AdobeCode>{EC381FFE-F46E-4A52-9DA2-D6058DEB8E19}</AdobeCode>
    <AdobeCode>{E73662A8-289C-4F76-87EF-268756008096}</AdobeCode>
    <AdobeCode>{7938D0F6-FCD4-484C-AE38-1F5ABD1949F6}</AdobeCode>
    <AdobeCode>{D7BDAAEF-CB6E-4E51-8BA6-F62987C64CA6}</AdobeCode>
    <AdobeCode>{1EEFF9DE-87BD-4A29-83F3-13BEDCCCD345}</AdobeCode>
    <AdobeCode>{A4CC0051-140D-428D-A691-DC009B6DDD03}</AdobeCode>
    <AdobeCode>{CFFFDBFF-FBC4-4ECD-BB06-D5A58340460A}</AdobeCode>
    <AdobeCode>{43323517-0802-4568-B2A3-4C5B4909ACC7}</AdobeCode>
    <AdobeCode>{BBDC3F82-9EB5-40E5-BE5F-82BA79C1BB24}</AdobeCode>
    <AdobeCode>{E85758C5-3AB8-47B9-B198-0065881E23FB}</AdobeCode>
    <AdobeCode>{8B574BAE-87D1-41A3-A0E9-013B9EDDB78A}</AdobeCode>
    <AdobeCode>{9CC44C4A-84E2-4E41-9AD5-CB2FBA489D65}</AdobeCode>
    <AdobeCode>{B7CB42CA-84BE-44A5-9E5C-149E2230FDFD}</AdobeCode>
    <AdobeCode>{60998B00-75AD-4E65-BD90-61ECFBB2D29C}</AdobeCode>
    <AdobeCode>{A8132185-47B7-425F-AF60-60EEBF41DB7C}</AdobeCode>
    <AdobeCode>{B1294FD6-9E3F-4840-B1DA-D9E88F23E9E5}</AdobeCode>
    <AdobeCode>{141A4B34-DD4D-4383-9D24-233BCAB4748B}</AdobeCode>
    <AdobeCode>{B4735203-F261-4DAE-84EE-3C2638B3614A}</AdobeCode>
    <AdobeCode>{B583D34C-827E-4AEA-BA2C-27FF0F5801F5}</AdobeCode>
    <AdobeCode>{0675138A-3EA8-4E8A-A16A-3138D3CFD9A6}</AdobeCode>
    <AdobeCode>{343146AE-49CF-4325-AA30-EF9D15C0447C}</AdobeCode>
    <AdobeCode>{41EF0A7F-EF08-4930-BB88-F9E3D7D14864}</AdobeCode>
    <AdobeCode>{49C8BC3C-8C87-4167-B10B-D5872BDCA1CF}</AdobeCode>
    <AdobeCode>{EBA1A2CF-D5DA-497A-B4A3-C7E7313A5432}</AdobeCode>
    <AdobeCode>{18FB2C45-9E9E-4C8B-B192-54EEE0B86153}</AdobeCode>
    <AdobeCode>{433B5A21-8AE2-4CA6-A869-FB64077A994E}</AdobeCode>
    <AdobeCode>{D06EA1AC-5074-46B5-A9A7-A021C83D8CEC}</AdobeCode>
    <AdobeCode>{29C64B36-94B5-43FC-9D61-54AF0B5F37B4}</AdobeCode>
    <AdobeCode>{C3B028F7-CF6D-4378-BEBD-D1BEDFB401E4}</AdobeCode>
    <AdobeCode>{41834A09-3A62-47DF-AFB1-B5721766D004}</AdobeCode>
    <AdobeCode>{878C245E-A7C9-474F-B037-88692EA675D8}</AdobeCode>
    <AdobeCode>{7380E30C-5EB0-45F7-993C-917E7819852C}</AdobeCode>
    <AdobeCode>{FDF0CB33-DBF7-4E9E-A6F7-57F7800EAE1D}</AdobeCode>
    <AdobeCode>{E79C22CE-F170-4249-A4EF-D4E8970B8BF9}</AdobeCode>
    <AdobeCode>{01782BC1-0D61-4B3C-ADC0-E8CFEC803A67}</AdobeCode>
    <AdobeCode>{FB158719-06C4-45EF-8C50-7FE81DFDAD03}</AdobeCode>
    <AdobeCode>{3B075EB6-BE90-4251-95C1-2B41AEDC1C92}</AdobeCode>
    <AdobeCode>{AD0325F6-9602-4F21-A14E-A9473AB84501}</AdobeCode>
    <AdobeCode>{FB1F9A57-4017-413A-95E7-C6ADB384E321}</AdobeCode>
    <AdobeCode>{BFF29C68-31AD-4164-B2D7-82CC378D6A67}</AdobeCode>
    <AdobeCode>{3B4E0CC4-D303-43FB-8164-FB04BAA7DFCF}</AdobeCode>
    <AdobeCode>{3F977067-F008-42C5-A541-C784F381FDDB}</AdobeCode>
    <AdobeCode>{5FAAD386-932C-4BFD-92CF-65663B7A1036}</AdobeCode>
    <AdobeCode>{4BC2B70A-B788-4315-B239-CD53D6D1CDCF}</AdobeCode>
    <AdobeCode>{0FA76EE6-2041-4F02-8217-1402D6BACC5C}</AdobeCode>
    <AdobeCode>{0A76F41A-8155-4189-B75F-84D1ACA5455E}</AdobeCode>
    <AdobeCode>{BC09EE15-A4E0-4285-BFAF-67DCD2D814E0}</AdobeCode>
    <AdobeCode>{257A380F-5383-456D-9909-A7F1FF52F547}</AdobeCode>
    <AdobeCode>{0D78C53A-0962-4B1F-9D59-4049E531B8CF}</AdobeCode>
    <AdobeCode>{4EC21F1B-1AC5-435D-BB85-56DB822033E8}</AdobeCode>
    <AdobeCode>{3B4BD104-FC3D-4C7E-AEA5-92C5054D8F29}</AdobeCode>
    <AdobeCode>{2DAF54FD-6203-441B-B1EA-817738E0782A}</AdobeCode>
    <AdobeCode>{2356C7AF-5A5B-4AB3-B7A7-89CE8117C125}</AdobeCode>
    <AdobeCode>{BDF36E42-10A9-4B87-84CB-9718B2849431}</AdobeCode>
    <AdobeCode>{4F3DF4A8-C0C7-4810-A68B-92062E28A388}</AdobeCode>
    <AdobeCode>{9BD3A825-8167-4B74-8CE8-DA02DFF264BE}</AdobeCode>
    <AdobeCode>{894D47E4-BF46-4B09-900A-5586EAA6D694}</AdobeCode>
    <AdobeCode>{2E02E545-D1D0-47C1-9AAD-D9B4AFE0E161}</AdobeCode>
    <AdobeCode>{D4390C17-CE5C-47DB-A69F-812052D78BDF}</AdobeCode>
    <AdobeCode>{7A2E5623-B765-4140-8F0F-C28D143A22D9}</AdobeCode>
    <AdobeCode>{54F0E0BC-DD66-44A2-BAB2-F69761953188}</AdobeCode>
    <AdobeCode>{28E9ADDD-F710-4D67-B019-48F9BC2DC52B}</AdobeCode>
    <AdobeCode>{6090C1BE-48D7-4428-B418-7C0511462155}</AdobeCode>
    <AdobeCode>{329DF640-DAA4-4EFE-99A6-01E1BE46C1E5}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{92866EBD-EC39-45E8-9336-FAC53057BEC1}</AdobeCode>
  </Conflicts><Channel enable="1" id="AdobeDynamiclinkSupport-6">
    <DisplayName>Adobe Dynamiclink Support</DisplayName>
  </Channel><InstallDestinationMetadata relocatableSize="0" sysDriveSize="5848256"><Destination>
      <Root>[UserRoamingAppData]</Root>
      <TotalSize>0</TotalSize>
      <MaxPathComponent>/Adobe/dynamiclinkmanager/6.0</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>5848256</TotalSize>
      <MaxPathComponent>/Keyfiles/dynamiclink/6\ConflictingProcesses</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="5848256"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	<Process processType="Adobe" blocking="1">^[Dd][Yy][Nn][Aa][Mm][Ii][Cc][Ll][Ii][Nn][Kk][Mm][Aa][Nn][Aa][Gg][Ee][Rr]\.[Ee][Xx][Ee]</Process>
    </Win32>
<OSX>
      <Process processType="Adobe" blocking="1">^[Dd][Yy][Nn][Aa][Mm][Ii][Cc][Ll][Ii][Nn][Kk][Mm][Aa][Nn][Aa][Gg][Ee][Rr]</Process>
    </OSX>
  </ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">6</Value>
      <Value lang="be_BY">6</Value>
      <Value lang="bg_BG">6</Value>
      <Value lang="ca_ES">6</Value>
      <Value lang="cs_CZ">6</Value>
      <Value lang="da_DK">6</Value>
      <Value lang="de_DE">6</Value>
      <Value lang="el_GR">6</Value>
      <Value lang="en_GB">6</Value>
      <Value lang="en_MX">6</Value>
      <Value lang="en_US">6</Value>
      <Value lang="en_XC">6</Value>
      <Value lang="en_XM">6</Value>
      <Value lang="es_ES">6</Value>
      <Value lang="es_MX">6</Value>
      <Value lang="es_QM">6</Value>
      <Value lang="et_EE">6</Value>
      <Value lang="fi_FI">6</Value>
      <Value lang="fr_CA">6</Value>
      <Value lang="fr_FR">6</Value>
      <Value lang="fr_MX">6</Value>
      <Value lang="fr_XM">6</Value>
      <Value lang="he_IL">6</Value>
      <Value lang="hi_IN">6</Value>
      <Value lang="hr_HR">6</Value>
      <Value lang="hu_HU">6</Value>
      <Value lang="is_IS">6</Value>
      <Value lang="it_IT">6</Value>
      <Value lang="ja_JP">6</Value>
      <Value lang="ko_KR">6</Value>
      <Value lang="lt_LT">6</Value>
      <Value lang="lv_LV">6</Value>
      <Value lang="mk_MK">6</Value>
      <Value lang="nb_NO">6</Value>
      <Value lang="nl_NL">6</Value>
      <Value lang="nn_NO">6</Value>
      <Value lang="no_NO">6</Value>
      <Value lang="pl_PL">6</Value>
      <Value lang="pt_BR">6</Value>
      <Value lang="ro_RO">6</Value>
      <Value lang="ru_RU">6</Value>
      <Value lang="sh_YU">6</Value>
      <Value lang="sk_SK">6</Value>
      <Value lang="sl_SI">6</Value>
      <Value lang="sq_AL">6</Value>
      <Value lang="sv_SE">6</Value>
      <Value lang="th_TH">6</Value>
      <Value lang="tr_TR">6</Value>
      <Value lang="uk_UA">6</Value>
      <Value lang="vi_VN">6</Value>
      <Value lang="zh_CN">6</Value>
      <Value lang="zh_TW">6</Value>
      <Value lang="en_AE">6</Value>
      <Value lang="en_IL">6</Value>
      <Value lang="fr_MA">6</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Adobe Dynamiclink Support</Value>
      <Value lang="be_BY">Adobe Dynamiclink Support</Value>
      <Value lang="bg_BG">Adobe Dynamiclink Support</Value>
      <Value lang="ca_ES">Adobe Dynamiclink Support</Value>
      <Value lang="cs_CZ">Adobe Dynamiclink Support</Value>
      <Value lang="da_DK">Adobe Dynamiclink Support</Value>
      <Value lang="de_DE">Adobe Dynamiclink Support</Value>
      <Value lang="el_GR">Adobe Dynamiclink Support</Value>
      <Value lang="en_GB">Adobe Dynamiclink Support</Value>
      <Value lang="en_MX">Adobe Dynamiclink Support</Value>
      <Value lang="en_US">Adobe Dynamiclink Support</Value>
      <Value lang="en_XC">Adobe Dynamiclink Support</Value>
      <Value lang="en_XM">Adobe Dynamiclink Support</Value>
      <Value lang="es_ES">Adobe Dynamiclink Support</Value>
      <Value lang="es_MX">Adobe Dynamiclink Support</Value>
      <Value lang="es_QM">Adobe Dynamiclink Support</Value>
      <Value lang="et_EE">Adobe Dynamiclink Support</Value>
      <Value lang="fi_FI">Adobe Dynamiclink Support</Value>
      <Value lang="fr_CA">Adobe Dynamiclink Support</Value>
      <Value lang="fr_FR">Adobe Dynamiclink Support</Value>
      <Value lang="fr_MX">Adobe Dynamiclink Support</Value>
      <Value lang="fr_XM">Adobe Dynamiclink Support</Value>
      <Value lang="he_IL">Adobe Dynamiclink Support</Value>
      <Value lang="hi_IN">Adobe Dynamiclink Support</Value>
      <Value lang="hr_HR">Adobe Dynamiclink Support</Value>
      <Value lang="hu_HU">Adobe Dynamiclink Support</Value>
      <Value lang="is_IS">Adobe Dynamiclink Support</Value>
      <Value lang="it_IT">Adobe Dynamiclink Support</Value>
      <Value lang="ja_JP">Adobe Dynamiclink Support</Value>
      <Value lang="ko_KR">Adobe Dynamiclink Support</Value>
      <Value lang="lt_LT">Adobe Dynamiclink Support</Value>
      <Value lang="lv_LV">Adobe Dynamiclink Support</Value>
      <Value lang="mk_MK">Adobe Dynamiclink Support</Value>
      <Value lang="nb_NO">Adobe Dynamiclink Support</Value>
      <Value lang="nl_NL">Adobe Dynamiclink Support</Value>
      <Value lang="nn_NO">Adobe Dynamiclink Support</Value>
      <Value lang="no_NO">Adobe Dynamiclink Support</Value>
      <Value lang="pl_PL">Adobe Dynamiclink Support</Value>
      <Value lang="pt_BR">Adobe Dynamiclink Support</Value>
      <Value lang="ro_RO">Adobe Dynamiclink Support</Value>
      <Value lang="ru_RU">Adobe Dynamiclink Support</Value>
      <Value lang="sh_YU">Adobe Dynamiclink Support</Value>
      <Value lang="sk_SK">Adobe Dynamiclink Support</Value>
      <Value lang="sl_SI">Adobe Dynamiclink Support</Value>
      <Value lang="sq_AL">Adobe Dynamiclink Support</Value>
      <Value lang="sv_SE">Adobe Dynamiclink Support</Value>
      <Value lang="th_TH">Adobe Dynamiclink Support</Value>
      <Value lang="tr_TR">Adobe Dynamiclink Support</Value>
      <Value lang="uk_UA">Adobe Dynamiclink Support</Value>
      <Value lang="vi_VN">Adobe Dynamiclink Support</Value>
      <Value lang="zh_CN">Adobe Dynamiclink Support</Value>
      <Value lang="zh_TW">Adobe Dynamiclink Support</Value>
      <Value lang="en_AE">Adobe Dynamiclink Support</Value>
      <Value lang="en_IL">Adobe Dynamiclink Support</Value>
      <Value lang="fr_MA">Adobe Dynamiclink Support</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>1</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "0", "ChannelID", "AdobeDynamiclinkSupport-6")
INSERT INTO PayloadData VALUES("{DE88AA40-6766-43D3-A755-8FC374B3D2C3}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeDynamiclinkSupport-6">
    <DisplayName>Adobe Dynamiclink Support</DisplayName>
  </Channel>')
