CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{3F023875-4A52-4605-9DB6-A88D4A813E8D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D02BFB5D-1448-4917-93F8-31FFD176E107}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{64E55471-E518-483C-813E-F0B5B72A8149}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0D2A8F25-B02D-4967-B0D9-243857B84581}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E345F408-469F-4FBF-8539-51C76710AA8D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{905B894A-D1A1-42EA-A4CE-9BE774F07EBA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F11D10AA-E6E8-49F9-9932-DB6E49C83CB8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D92C4259-B7A9-42DB-8CB0-0F0B4FB02D89}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{9772AC01-7F24-4639-A9EB-901996895F94}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B19F7533-6D7E-4352-90F2-2723B7CED9A1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{120FE1F7-7D57-4D97-91BD-1B1B7B700058}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0C8CF5DF-E104-49BF-854A-02BA386C80A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D6592AA9-9A96-4275-815A-380E59E9263B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{AFD8E277-963D-4B43-B9C7-B9073C3E08A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F99D40F3-1BE4-4533-8F71-43A65CE67328}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E947752A-3AF5-4C33-B337-5E6EB4AD373D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E3251C9D-7062-4396-B149-A50938B8E8C9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{96966A92-F175-4E10-8F6A-BC09E26C81A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FDFC8F79-354D-4276-A3A5-CDF367E3CC09}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6B5FDD94-019B-47EA-83BD-FEAD2E9FD3D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{015EF7BA-FA7F-41CD-B2AD-4A85CB887D4A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{AAF6E3F1-5C56-4CF5-94D4-DF397CB5CA76}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0029512D-55D4-481F-AAAE-BC276506A75A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A2892943-E811-4A13-A03C-8F0AEF314DF3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{91A3F0E7-5B0F-4C30-803F-D4920EF47CCA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{58BAFB20-85E5-4437-8A19-20FE2E23BC21}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F875DB63-2F81-42D4-8C09-D333DEDB5BBD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{BD2CF2F4-E465-4913-82A2-D0D307DFB4C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{966F1500-F38B-4AC3-9C80-B24554D4E1B0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FF20DF79-3C3B-47C7-A970-C7EAF24DB8DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{35774D09-F494-4C76-8AF1-A7EA452B49ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{78877FFC-1089-40C1-A06E-EF8FAE8BF0F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{3564957A-7246-43D7-B3B1-3A6AE9EC30D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{95515EE0-7539-4195-8DE5-EFEC840F3098}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{BDB9DDFB-C8F6-4D49-B519-D8D066306380}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6F791CB4-8EF5-400C-9E35-4E83397E6044}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7C11344B-78A7-417A-B97B-D59AB10723D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{4EF06DE5-9936-4CE0-AE35-AD4681903161}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{769F5264-113B-4523-940C-6F2A99166DD9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{BA2B0CA2-8134-453A-BC58-F239D664287E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5976F81F-64E9-4B2E-84BA-37C4C3B2B7CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{25036BC3-C892-4ED9-893C-EFE161B99080}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{AC83319A-99B6-423D-966F-3D697C9DA0D1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6AE9AEF4-1D5C-440B-B1F4-D9FB7165FB43}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{3869E022-F889-4915-9DC2-340C76222D20}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{4ED0D0B7-BFB5-461F-95DC-8EA99D3A0FBE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{244A22AC-6661-49A6-BD05-B2E3279D7584}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FEE92D29-6BC5-4205-8F3E-ABB9B31722E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A8064D35-5ED0-40FD-9260-633579DDE057}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B5C09D2D-D86F-4CAA-B2CC-26917A97C3E4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{2C529A4C-13DE-4F47-9A68-A963085287E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{905A7260-E885-47CA-B4D2-3351F873BFBF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{548FE5B6-CF33-4D8E-9548-AEA7359C81C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{19C79218-D1D7-4012-9A74-F650245A966D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{C801BC47-3F94-49AC-A594-356C25447734}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{3EF770BF-042B-4D0F-92FD-B1EBA66DDABD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CCFF62F0-75BF-4997-8C32-033D2C0ED333}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0F347603-ED9F-4840-A431-1442C2B4B7D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5CDE53A3-3651-465B-925C-22EC4E79DE15}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{4084E0D4-B49C-4D6E-95AD-71D9A7A84FC9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{208BF973-529D-45DA-AD32-B697AD4BA50D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FE6EC2D0-F783-4D9C-99BB-C228B84CFEF3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{71850143-AAFB-48CF-AC14-3A1955EC7722}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{230EFD6B-2444-4339-9D51-7458FEC0BD0C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B30DB44D-06D4-4A62-B517-CCF3859AAC2A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{810351A2-D919-4DED-A500-2273E48B5281}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{BB953980-4492-4B07-8BE0-7B9A9B8EC140}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1F635B27-0ACC-43CC-A98D-63C868426A68}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{57758354-5A9B-46AB-A80C-BB92068CF529}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{78B4841F-B92D-4F3B-BC79-F6A8C0F2006C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{8C558228-3E1D-427E-9FBA-9F593E7F1A01}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CC8613E0-BD63-4EC0-A859-0676C37DBBA0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{770DA287-5F87-4BF5-AD5F-F7DF596FE1D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{552B3702-40BA-4A63-86AD-8B77760A4A1C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F6F5021E-0548-43C1-82CC-C5C7A6906585}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{40AEEA11-B04A-4332-8D71-EE3684DAC229}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1D44253B-F50C-49B6-8D03-C8D0B96E4041}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D455367B-C277-40E2-99F7-1B99DB81375E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CB2E214E-DBA2-4C12-8718-5BD0A7835A4F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{80E81453-4931-4857-8E50-2AA54283349A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B4B25B03-54FD-40E0-978D-EECA687866AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{06D0BAEB-9A59-4963-8F57-9809173DE325}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{497FE677-CCD0-4B41-8C74-926C23CD3EA2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7DF97B88-C38E-4012-8814-C313EE2FAFB6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{9207A8AA-BFA0-4885-A5D9-1CEBCA226647}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{52FD67B1-E499-4E0A-8546-D964F043E99A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F41A35E2-F152-4B14-B95C-B8AB7F5D971B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F6F29ABF-7327-4F1C-BDD5-B6958532A7D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1E5A3FD6-DB97-4221-9D6D-F3EFDF168F2B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{64BA0F4C-B66E-47BC-B031-46A960BFF416}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{2435C5BA-914E-4884-99D1-10540E483FD5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{457A006A-9A2D-43B7-8723-501C966B84CF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{28AC85F6-1E75-4F7A-9F95-C479FDFA379C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5210406B-5C46-4339-8DBE-3FEFAD8D3E85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5D831588-D7E5-4192-BD31-708E76C7F026}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{165EEB50-26AD-4CF6-8537-87DF2A3DC4F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{BB4F0FF4-8C53-4D28-A45F-B326414EE02D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{56AB07CA-7B24-465C-A2B3-BF708EF46684}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{2F29321F-0D75-413A-B0FA-4C07266F83E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{52076580-86A0-444F-A8A7-66F70D4A16E3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7CFFA1A4-606D-408E-8DB2-2744164AEA66}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{693D4DD9-4E0C-4DBD-8D0A-A36194BCB0F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{EEF7CB6F-5E76-4877-8998-EA62237DE4D3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5B95576D-DB21-4EC9-8F98-5F572BA93C1B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{3180E709-C010-4C1B-81CA-6BD386524567}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E93BD38C-8ACF-43FB-B476-DF8D3A1E969B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{28FBEA46-23D0-4AF7-B918-1330FEF0E716}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{17DA2421-5D42-46DC-8414-8C9D7CD94C06}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{3917EE28-1680-4B04-8CEF-27B3AA95A864}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7474FB28-948C-49BD-845E-F51F04E13B2D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{596FD7E8-BC94-4C2F-8433-38D2D9E4112C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{178A6594-40EC-4816-90A9-EF5DC0116DDF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{452150C3-1F5B-448F-A71B-FBE3144567F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{140A8F0F-A4DD-4404-B080-9960D66BFB33}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B2EB987F-07F2-4948-9638-6E60C574288B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{3C122F56-9DCE-4895-8159-710A4A510904}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{71957A47-1FAB-4456-80E9-D6FB7C1BA3E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{DF728118-9E17-4C9F-9E7D-3F97C5528035}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CE104476-4951-49AF-AFD9-533F688D01D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{C650DD6A-D6CF-42AA-BBD6-A3D0CF0CB67E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1BEBE63D-813D-4D1A-A28F-D0255DFA0369}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{069F1464-7A01-4219-8F56-E1CD53D57E08}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{571B4823-4124-46CB-A2E8-71195FEA4EE7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{97717545-A80B-4FF1-8C0D-5DFA60048D5D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{64B4935C-3B1B-43FA-8578-CAAA21E1AA3B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{865FB8A3-6A1B-4B57-9DD5-152022E700F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{142DF1D7-D5DD-4DDC-BD77-3EF554AC27CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{33186F0C-C2E1-4333-A636-6044FE97C1AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A7EA4F61-A1E2-4CF5-9E80-5ABCC40CDBD1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{EE1555CF-1A67-4CCE-B8DD-CEFABE0575DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B508A43F-357E-442D-9975-13DBEFF9DCB6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{37B83AB6-DE74-4F79-A4F6-B81670191C70}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{C8C07A57-609B-4048-8B59-207B40CFDAAB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{81259193-9F79-4E6C-8AD3-C9FF3E2D6CAF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{821689B9-D48B-47F1-BF3D-187C276D6E44}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A7C8ACB9-C1E0-49DE-A47E-45AF0E09AA23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B7719770-B82C-4954-AD61-D8C1AEA4D79C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7754AE0A-A9A6-4494-BEF5-FAB35251CC01}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{068827A9-CF56-49C5-87AF-948D12767C1C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B1F13FB9-3458-4734-A310-97DF6CC8BAC0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7661F1CF-80D0-4447-8075-2A3E168D020A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{DEA7B40C-D238-4D19-AFA8-C0F3EF7884AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{2C0C0B4F-B542-45ED-8DA6-6E0D61B166BB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{81C35E63-CB46-424A-B4E7-3C32518EA398}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B85F7D67-60BE-4332-B6B2-D1F11B20D4EB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{8F780736-9FBB-4F55-858A-D8F873BE805F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5781B54D-32A8-4646-A5B7-EDDCB4EDE3D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{92C1E280-F6FC-458F-8AD0-E7C8A55B79A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{ACA4E5EC-CDDB-47A0-967C-4719A73C9D41}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0D81BA70-4F28-4003-AAB6-21632857D0CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7130B3A4-862A-4BE6-8B01-505158C7938F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FFF93200-3912-4273-BD98-C07D205A1F45}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{292EF891-EEC5-434F-B58D-E84991350521}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{9100BB02-CBE7-477B-BF1F-C287FB7AF9AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{894CB1C6-8AEF-4969-8C8C-1D51FC0F3C25}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{83546AC7-11A7-465A-86DA-895E2C79AD47}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{08694FF6-26F2-46E2-95FC-DE70D198444D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{789B281C-2879-4A9F-ACFB-8037A1A21413}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{BF0E1EEF-CF13-4FCC-98A4-B6000A350BA3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E0EADD91-5596-43D5-A0A7-9D09F275C41D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D3A02895-59C1-4BAC-8BF7-3849D4F78678}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{442769CB-C959-496E-8FE3-945BBEF956E4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{284385D4-B2A0-4279-97FA-97853774A777}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7A4693DC-6D00-46F1-AA21-2219126CC90E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A3293655-8C9F-4EF6-BADB-05978324A10C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7CA4AB03-5E09-46A6-94D3-E7ABC5404F91}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{4C8CDEB8-A65D-4CA4-A529-30F174EF3DE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{215ACD96-C0C4-4818-9DA6-1035CCE77566}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F00E3ADD-4052-48D3-B94D-7FDF7A0F302E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{759FF16D-5FC2-4880-95AC-950EDAC870E2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6C84D6D1-F9E7-447D-9B96-F89108120901}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{9460E630-A001-4631-95EB-0D8B7DA46C36}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{53940342-1B42-4155-97D5-7BE680427EE3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F01B981C-0A2F-4A65-ACAD-DAD7F42312A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FE3B717C-E85D-40DD-8D1F-49482F1D8CDC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D0E682B7-C955-4DB5-927B-CBAD6ED6917E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{120952EF-46F9-44C4-9710-AB34147FC413}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B98578E8-CE0E-479A-BB5E-34439AE9EAFC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{368ED7CF-1964-4D07-B861-666E42FAA58B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FE7E2A39-1CD0-4AD3-8615-98FC78EBF05C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1C6D2F66-44B4-411A-B6D3-B6F2FF114149}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5C57FB41-4FF2-468A-870A-C02C964E3E09}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{688BA135-E52E-443D-A237-A2357891A7B9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{C1B62BCD-D45D-48AE-97A5-B4172E45B4FC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{190B10E1-7CC3-4A0E-B14D-884852F9E04A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{878655B7-B8EA-4228-BF61-20B6A7CC8549}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{BAA5A33A-829C-4AB3-BA67-EC0DF448AF92}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B926070E-BB22-4BF0-A226-DAB7C481A25B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{8451B250-7BE3-49B7-9846-EC93A6941567}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{2B3D942E-0090-4CD2-A313-1072FF5AB8C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1E0CF828-4C0D-467B-B0B2-9CA3174A614A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D4227DD8-FF42-4ACD-B87E-1020CAD8A045}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{358DBD80-B03A-44EC-99D7-BF216A7FF603}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{58DC38AB-AA92-4319-BE91-93C9832F4DE7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{7C90AB7C-9BD7-4A65-8E13-AC44C087FF35}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{3F2BEE9D-8119-4429-A302-952E5F59D91E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{4DC8779C-DDD6-41E0-B79D-82C143D7914A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{75D63DE5-8290-4359-B2F6-987940DEEC64}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0568BDBC-19A8-4C62-AA28-CE54AB77C911}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{183DB405-8681-48C1-B1BA-5BE943DB9CB8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{41526885-92D9-4377-85D0-2EC87B5A8175}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{4EF234A5-AA67-4998-9108-83A46B1A3BAA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6BD6993C-762A-4F07-89D6-8E4073635C8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{82684311-9677-42EC-A476-EBDCB732E25D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0F925327-73B4-4C11-8DA4-05ADB0D21724}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{207213F5-5AA2-4144-9C5D-2A176584F714}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CC0FE328-898A-490B-946D-056603F4F4A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CDDCF604-FFEF-49D0-9E12-5A90E9F73F20}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B3D24BE5-094E-4AC4-85C4-27EB370F7BE3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{943CA24A-D070-401B-AD8A-6B9521D9D2FC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F2DC64B9-C25B-4DAB-A374-09763F37C77D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{67A48C8E-AE1A-4821-BE52-B6F3654190FF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CC90918C-B0E1-45B0-A6FB-0A9F78395338}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A1D95828-8009-4EA2-95E5-24BC533DDC96}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FB30BF47-A8AF-4366-A30F-0031C8ED2AC5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{C6236DF0-5316-4EB4-A543-15C042EEE8AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{607C56F2-0405-49F0-B67C-0DA08C4408FC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6ED03B73-05D1-44CE-91D1-ECA89647A2CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{25B71BEC-2D97-43F7-BB03-A10E3F2537AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{068697B1-6666-4F62-9269-DFE70257D5E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{429F48C4-D309-43E8-BD84-5E3F3AE4B6F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A7779EB4-ABEC-4588-A2D5-B65548BEB2BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D7B327E1-AAAE-49B8-9BBF-1D4D9FF91ACD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A71C03E1-7741-4D7A-A408-AB3E044B87DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{39EACC1D-6D84-4B78-AA90-F49EC4E663E2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0712C1A3-F5C0-4D29-9CC8-225ED1CEDFF2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{587F7F9E-A877-47F0-A528-F30B569DCC39}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{9D767741-0F4B-49F1-8197-A4D26C4D3ED0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{4F85465C-E02A-459F-B420-47CBDA87C301}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{35EFB3CE-2F56-43CB-8564-FA1FEBC79255}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0C690E53-A8F6-4BF0-984D-CAD4BFDDA9FD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{321F162D-78B2-44F4-BD9D-9451DF000569}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F1BFF988-FF3A-4D96-814C-7EA4D2A7DD0C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{EDF6BEB9-A46E-4C66-8A7F-781C24B5D125}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{BC923D68-E412-4994-99AE-EE5568253751}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{8B6B80EF-55FF-463C-8AB6-901CDB0155A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{88FF4A31-505B-4C8C-9DEB-9AD6468F34B8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B9EE1E7D-EC40-4857-BD0E-AC55E3E10869}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CF0714CA-A20E-49BD-B4C2-0A6B79028125}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0779BFCD-C5FF-4E68-B4A4-D563B010D25A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{C63B55F0-A228-4E50-B17D-4E87349F9C82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{61551253-A909-4C6C-A72D-8909A9B70099}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{74328862-E1D6-411B-B05F-8839B692CAF7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F1624B59-7ECF-4498-A18A-5698A06A5820}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F6E791BF-5A66-44D1-BED1-CAFDAF7A69EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{33BA6F08-4A24-447A-A3F1-62C15A790590}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6EFC46E4-C326-48A9-9217-2C6D2A5798F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E1E26669-4E59-4963-A8B1-731D1D7F7FE7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0E2C0395-07A4-4F08-B8E3-89FADF7A4D7B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{AA7AABB7-EDB2-4A61-9FA6-76A508868081}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{EFCDFB41-7E28-4E4F-9A61-BCE68541E001}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{C6182313-E9BE-4987-A912-65C1F9A207AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A7C9D230-4A7F-47B9-9BD3-039B65557517}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{81C744A5-5BE7-49FB-883E-1E416E2CC9C2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6CB372B4-4BD2-4924-BFC1-61916A0EEAF9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{943DB337-DF85-434C-9CCA-5647AD97BD54}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A216C618-C041-4486-9DD1-507A68B8E68B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{DB6D91EF-4125-4B08-8A61-03D582243892}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5E843C88-1B46-4E5C-AC5F-D6400ACC4C28}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B45110EB-C5B6-4CC7-A905-0B49216A9C9D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{54AFB319-CD95-41D3-9534-D7C82F1BDA0C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6FDB7F73-D3B0-429F-B153-F270FC448D97}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D40A1351-AA77-4534-93E2-EB67C3D11208}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{74EA3A8B-D145-459D-866C-80C946E4D451}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1F911904-8831-4063-BE57-385F4302F87D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5D2ACAAC-D325-4017-81F7-D80707C74DC2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{C00732C0-E5DF-43AC-AF66-71A8BD46FD65}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{731F488F-811B-479E-84F2-7AEA629F9C88}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{22FB7692-E2E3-4711-89D0-6137FE494EB4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E8F15189-B2B8-48AC-B8AF-DDE5CC8D7D56}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1AA04DBC-4069-4B1B-A40A-7C3CA25AE260}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{BEC1DC0F-1287-4D49-B8D6-772891DC298C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{9A3F5BAD-C34B-4C95-B8FD-FFD4F1D83987}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F75474EE-B180-4952-BAA1-4C7635B72408}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{03D22307-FB0E-48F7-A3C1-7705558FD011}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{85FD1567-88DD-4DB8-A9C0-80DEBE7E8743}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{29ADB5DC-ADBB-4158-B1F7-F0BA80A3D871}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5AA15E06-D80C-4897-8BC4-756CE5D838E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1F85FF2E-8145-47C5-8E8C-49AD81521843}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F4E96359-6BE6-49B1-91E2-B14F2B33F781}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B8F3841D-21C1-4844-B943-EC9B39A011F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5263C5FA-9E68-4435-B1F6-9A6DFB49CB58}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{03CB58A2-BA3F-44BF-8C3B-3307DC64BD33}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D619E4C0-7894-4293-AFF7-4C9FB4D520FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{77D0BDC3-5CCE-4049-8586-CE466CF589DF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{C2DE0ED8-C0C6-4056-B751-2526BF29BF3C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{327DE249-C35E-493E-85E9-8AACCD2530A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{442BD16F-12E5-47BC-B0A3-37291D23CEB3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{77B01FA6-73DE-4D87-AEB9-7CEE2133CC43}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{2E6AAA01-1AB5-472A-9454-8104F5D0EAB5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{EA4728EF-D98B-4E8B-8A7F-2329C196583C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E37F12DD-507F-4473-A05D-DC51AD2AA852}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{F44B1880-CD48-4909-B423-8F1BF75DB805}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{302FCFA3-1333-4AD9-98B5-E5D85282E822}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D841435D-8CEC-46B8-85ED-9B2E4D3F3CDD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A60DB855-257C-4E7E-887E-A0F4C5D8B7A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{9A4B2E63-9604-4969-A9E2-765E779BB40B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{75FDE4C5-2408-4805-8225-2A7DC7E15C45}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0B013458-A1C7-45DC-8F17-6F7A0C321665}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1306EE99-1892-40F3-B9D3-5D5ECCD74510}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{95A840F7-F625-4F53-B305-CAB3264F4FCD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{068D471B-0069-41D6-9596-A8C4B87C839A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{2F539FDF-5AB5-4CA4-B3ED-54D6228F7F97}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D48C8A4D-8FAA-4B9C-BA4B-A80506152AF8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{704FDDF1-E1C6-4C6F-901D-F27470F591FA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{5F508C65-6EA2-4639-8DC5-A5BC32F11CC0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{1DB94F20-B986-4EBA-88CE-71199D1B663D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{8A9B729C-A472-4C2D-9601-924CB4F9E823}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{191F7DEC-DDB6-42F0-B7B0-F4C721EFAB08}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{6D881611-D598-47EA-B7CB-3F9BCF7CB7BF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{18C95266-ED13-4008-860B-14F017D6C96F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CCEE82EA-C6BC-45FA-8D1B-5CFA66F67547}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0FC82967-3169-4BF1-8827-F8C3F52053B5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FE7B4ED4-2ED9-4AEC-A9FE-D895BEBDF23F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{56E35876-D89B-499B-BD55-17F7E7216B70}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{73F39C2D-5B9C-4D20-AB32-4B2811F257C2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{0B8E1E42-93F4-4F6B-A16E-EB6DD60CBA87}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{A1F41573-C9F2-42CA-8F41-9088EC8AA76F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D5603532-9B2C-4807-A803-F156B3156B5C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{243521BF-EE7B-419D-A20D-D450A6625790}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D109BE1C-146D-4733-856A-3BBCE83BDDF1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{312FF2F2-F0D0-406F-BFDF-40B6226CC497}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{FD1AFCE9-22F5-4804-B847-1F930D02334E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{4BA89517-14F9-408E-9E92-EA5643818DA7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CCD2827E-82FB-4F57-B24A-C8DAD4E66E2C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B7A897BD-E1B4-469C-A4E7-CBA2C84B5CCF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{4441F391-B70A-41C0-843E-52A09D581C6C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CA3407D3-37C6-4A8A-8FF6-2C3B58A523AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{EBA63BA8-181A-4222-A9C5-FC684CF4ACE6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B44B78F3-548A-4377-8113-98895C8B72D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{B8D0F393-422C-4E36-807A-1DB2ABDD122A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{2323B8DD-584F-4C80-8FC7-85B9CD321147}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CCE402F7-9291-446E-B2AF-A635402D12A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{316F7A55-182B-4518-A580-6A6CD61617DB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{CA0B4617-8CDE-4622-AD05-BBD69014EEDF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{38B35C45-D747-4423-AD7F-3C5136F157FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E76ABB12-7799-46AB-9589-110BE6540664}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{007CDB99-000E-4E1E-85A9-36643663A681}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{E65735BF-1364-4952-9319-02801B398792}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{65F1C69D-B7DA-4C69-A39A-2D45250C19C9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "{D88B7568-150D-4AB6-9475-4A07B1F60896}", "upgrade", "", "", "")
INSERT INTO PayloadData VALUES("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{539AEF15-3A2B-4A31-A587-7E90F7D9C700}"/>')
INSERT INTO PayloadData VALUES("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "0" , "ValidationSig", "XEiwHYrA6CeJ6gviSGwgnWahvIttmz0ZW1AY876m6VjzH8SWlCjF5GyoVsAWnhn2gzJ+tVEie5xcP+cOfBYUiUMt5OpZNyE1dT0+0fjvaqNu1xvIMELOFElQz2oNEPWRwOKMZd1pXCAORIlPzRH5rZbHp6ZhRkj2OSU7BCzjc2Y79l1xhHu3q3+9yH4d39fBLfn6q71V4VJbh+ymvvZf9v75txNrKZT0h947Z+iGyPEQgVV2bVNvpmnz4fKqWvEKl+bQXPfP9PGH91vg9c9FLCALUVdhMFmbxK1GLIDdusmg6ziQuPEDZ8dCNtSXDOwK8+FNmGNMVyDaVsdpGLUfN7rW7me37ic+Tj3V2fvD12+w1/+2YL3z9gSMQLRGYf9pRCIskEpQE5b0hNvWWV5aLBsJt/hd4d9J4p3sgjFNY4C0g3vkTql5MB2g+ztD5DJz3jRhPIHrQemAx/X7GiczAO3a/DM37UEfggcK2uBEh5jFcAZb6geh/TQrcLfv2B7R")
INSERT INTO Payloads VALUES	("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "Shared Technology", "Camera Profiles Installer", "7.0", "normal")
INSERT INTO PayloadData VALUES("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.29.0"><BuildInfo>
    <Property name="Created">2012-02-09 04:34:39.731000</Property>
    <Property name="TargetName">AdobeCameraRawProfile7.0All</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{539AEF15-3A2B-4A31-A587-7E90F7D9C700}</Property>
    <Property name="ProductName">Camera Profiles Installer</Property>
    <Property name="ProductVersion">7.0</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="1" name="Default" folderName="">[SharedApplicationData]\Adobe\CameraRaw</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
	<Family>Shared Technology</Family>
	<ProductName>Camera Profiles Installer</ProductName>
<ProductVersion>7.0</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{3F023875-4A52-4605-9DB6-A88D4A813E8D}</AdobeCode>
    <AdobeCode>{D02BFB5D-1448-4917-93F8-31FFD176E107}</AdobeCode>
    <AdobeCode>{64E55471-E518-483C-813E-F0B5B72A8149}</AdobeCode>
    <AdobeCode>{0D2A8F25-B02D-4967-B0D9-243857B84581}</AdobeCode>
    <AdobeCode>{E345F408-469F-4FBF-8539-51C76710AA8D}</AdobeCode>
    <AdobeCode>{905B894A-D1A1-42EA-A4CE-9BE774F07EBA}</AdobeCode>
    <AdobeCode>{F11D10AA-E6E8-49F9-9932-DB6E49C83CB8}</AdobeCode>
    <AdobeCode>{D92C4259-B7A9-42DB-8CB0-0F0B4FB02D89}</AdobeCode>
    <AdobeCode>{9772AC01-7F24-4639-A9EB-901996895F94}</AdobeCode>
    <AdobeCode>{B19F7533-6D7E-4352-90F2-2723B7CED9A1}</AdobeCode>
    <AdobeCode>{120FE1F7-7D57-4D97-91BD-1B1B7B700058}</AdobeCode>
    <AdobeCode>{0C8CF5DF-E104-49BF-854A-02BA386C80A8}</AdobeCode>
    <AdobeCode>{D6592AA9-9A96-4275-815A-380E59E9263B}</AdobeCode>
    <AdobeCode>{AFD8E277-963D-4B43-B9C7-B9073C3E08A4}</AdobeCode>
    <AdobeCode>{F99D40F3-1BE4-4533-8F71-43A65CE67328}</AdobeCode>
    <AdobeCode>{E947752A-3AF5-4C33-B337-5E6EB4AD373D}</AdobeCode>
    <AdobeCode>{E3251C9D-7062-4396-B149-A50938B8E8C9}</AdobeCode>
    <AdobeCode>{96966A92-F175-4E10-8F6A-BC09E26C81A0}</AdobeCode>
    <AdobeCode>{FDFC8F79-354D-4276-A3A5-CDF367E3CC09}</AdobeCode>
    <AdobeCode>{6B5FDD94-019B-47EA-83BD-FEAD2E9FD3D6}</AdobeCode>
    <AdobeCode>{015EF7BA-FA7F-41CD-B2AD-4A85CB887D4A}</AdobeCode>
    <AdobeCode>{AAF6E3F1-5C56-4CF5-94D4-DF397CB5CA76}</AdobeCode>
    <AdobeCode>{0029512D-55D4-481F-AAAE-BC276506A75A}</AdobeCode>
    <AdobeCode>{A2892943-E811-4A13-A03C-8F0AEF314DF3}</AdobeCode>
    <AdobeCode>{91A3F0E7-5B0F-4C30-803F-D4920EF47CCA}</AdobeCode>
    <AdobeCode>{58BAFB20-85E5-4437-8A19-20FE2E23BC21}</AdobeCode>
    <AdobeCode>{F875DB63-2F81-42D4-8C09-D333DEDB5BBD}</AdobeCode>
    <AdobeCode>{BD2CF2F4-E465-4913-82A2-D0D307DFB4C1}</AdobeCode>
    <AdobeCode>{966F1500-F38B-4AC3-9C80-B24554D4E1B0}</AdobeCode>
    <AdobeCode>{FF20DF79-3C3B-47C7-A970-C7EAF24DB8DA}</AdobeCode>
    <AdobeCode>{35774D09-F494-4C76-8AF1-A7EA452B49ED}</AdobeCode>
    <AdobeCode>{78877FFC-1089-40C1-A06E-EF8FAE8BF0F9}</AdobeCode>
    <AdobeCode>{3564957A-7246-43D7-B3B1-3A6AE9EC30D5}</AdobeCode>
    <AdobeCode>{95515EE0-7539-4195-8DE5-EFEC840F3098}</AdobeCode>
    <AdobeCode>{BDB9DDFB-C8F6-4D49-B519-D8D066306380}</AdobeCode>
    <AdobeCode>{6F791CB4-8EF5-400C-9E35-4E83397E6044}</AdobeCode>
    <AdobeCode>{7C11344B-78A7-417A-B97B-D59AB10723D5}</AdobeCode>
    <AdobeCode>{4EF06DE5-9936-4CE0-AE35-AD4681903161}</AdobeCode>
    <AdobeCode>{769F5264-113B-4523-940C-6F2A99166DD9}</AdobeCode>
    <AdobeCode>{BA2B0CA2-8134-453A-BC58-F239D664287E}</AdobeCode>
    <AdobeCode>{5976F81F-64E9-4B2E-84BA-37C4C3B2B7CF}</AdobeCode>
    <AdobeCode>{25036BC3-C892-4ED9-893C-EFE161B99080}</AdobeCode>
    <AdobeCode>{AC83319A-99B6-423D-966F-3D697C9DA0D1}</AdobeCode>
    <AdobeCode>{6AE9AEF4-1D5C-440B-B1F4-D9FB7165FB43}</AdobeCode>
    <AdobeCode>{3869E022-F889-4915-9DC2-340C76222D20}</AdobeCode>
    <AdobeCode>{4ED0D0B7-BFB5-461F-95DC-8EA99D3A0FBE}</AdobeCode>
    <AdobeCode>{244A22AC-6661-49A6-BD05-B2E3279D7584}</AdobeCode>
    <AdobeCode>{FEE92D29-6BC5-4205-8F3E-ABB9B31722E5}</AdobeCode>
    <AdobeCode>{A8064D35-5ED0-40FD-9260-633579DDE057}</AdobeCode>
    <AdobeCode>{B5C09D2D-D86F-4CAA-B2CC-26917A97C3E4}</AdobeCode>
    <AdobeCode>{2C529A4C-13DE-4F47-9A68-A963085287E1}</AdobeCode>
    <AdobeCode>{905A7260-E885-47CA-B4D2-3351F873BFBF}</AdobeCode>
    <AdobeCode>{548FE5B6-CF33-4D8E-9548-AEA7359C81C3}</AdobeCode>
    <AdobeCode>{19C79218-D1D7-4012-9A74-F650245A966D}</AdobeCode>
    <AdobeCode>{C801BC47-3F94-49AC-A594-356C25447734}</AdobeCode>
    <AdobeCode>{3EF770BF-042B-4D0F-92FD-B1EBA66DDABD}</AdobeCode>
    <AdobeCode>{CCFF62F0-75BF-4997-8C32-033D2C0ED333}</AdobeCode>
    <AdobeCode>{0F347603-ED9F-4840-A431-1442C2B4B7D8}</AdobeCode>
    <AdobeCode>{5CDE53A3-3651-465B-925C-22EC4E79DE15}</AdobeCode>
    <AdobeCode>{4084E0D4-B49C-4D6E-95AD-71D9A7A84FC9}</AdobeCode>
    <AdobeCode>{208BF973-529D-45DA-AD32-B697AD4BA50D}</AdobeCode>
    <AdobeCode>{FE6EC2D0-F783-4D9C-99BB-C228B84CFEF3}</AdobeCode>
    <AdobeCode>{71850143-AAFB-48CF-AC14-3A1955EC7722}</AdobeCode>
    <AdobeCode>{230EFD6B-2444-4339-9D51-7458FEC0BD0C}</AdobeCode>
    <AdobeCode>{B30DB44D-06D4-4A62-B517-CCF3859AAC2A}</AdobeCode>
    <AdobeCode>{810351A2-D919-4DED-A500-2273E48B5281}</AdobeCode>
    <AdobeCode>{BB953980-4492-4B07-8BE0-7B9A9B8EC140}</AdobeCode>
    <AdobeCode>{1F635B27-0ACC-43CC-A98D-63C868426A68}</AdobeCode>
    <AdobeCode>{57758354-5A9B-46AB-A80C-BB92068CF529}</AdobeCode>
    <AdobeCode>{78B4841F-B92D-4F3B-BC79-F6A8C0F2006C}</AdobeCode>
    <AdobeCode>{8C558228-3E1D-427E-9FBA-9F593E7F1A01}</AdobeCode>
    <AdobeCode>{CC8613E0-BD63-4EC0-A859-0676C37DBBA0}</AdobeCode>
    <AdobeCode>{770DA287-5F87-4BF5-AD5F-F7DF596FE1D8}</AdobeCode>
    <AdobeCode>{552B3702-40BA-4A63-86AD-8B77760A4A1C}</AdobeCode>
    <AdobeCode>{F6F5021E-0548-43C1-82CC-C5C7A6906585}</AdobeCode>
    <AdobeCode>{40AEEA11-B04A-4332-8D71-EE3684DAC229}</AdobeCode>
    <AdobeCode>{1D44253B-F50C-49B6-8D03-C8D0B96E4041}</AdobeCode>
    <AdobeCode>{D455367B-C277-40E2-99F7-1B99DB81375E}</AdobeCode>
    <AdobeCode>{CB2E214E-DBA2-4C12-8718-5BD0A7835A4F}</AdobeCode>
    <AdobeCode>{80E81453-4931-4857-8E50-2AA54283349A}</AdobeCode>
    <AdobeCode>{B4B25B03-54FD-40E0-978D-EECA687866AA}</AdobeCode>
    <AdobeCode>{06D0BAEB-9A59-4963-8F57-9809173DE325}</AdobeCode>
    <AdobeCode>{497FE677-CCD0-4B41-8C74-926C23CD3EA2}</AdobeCode>
    <AdobeCode>{7DF97B88-C38E-4012-8814-C313EE2FAFB6}</AdobeCode>
    <AdobeCode>{9207A8AA-BFA0-4885-A5D9-1CEBCA226647}</AdobeCode>
    <AdobeCode>{52FD67B1-E499-4E0A-8546-D964F043E99A}</AdobeCode>
    <AdobeCode>{F41A35E2-F152-4B14-B95C-B8AB7F5D971B}</AdobeCode>
    <AdobeCode>{F6F29ABF-7327-4F1C-BDD5-B6958532A7D0}</AdobeCode>
    <AdobeCode>{1E5A3FD6-DB97-4221-9D6D-F3EFDF168F2B}</AdobeCode>
    <AdobeCode>{64BA0F4C-B66E-47BC-B031-46A960BFF416}</AdobeCode>
    <AdobeCode>{2435C5BA-914E-4884-99D1-10540E483FD5}</AdobeCode>
    <AdobeCode>{457A006A-9A2D-43B7-8723-501C966B84CF}</AdobeCode>
    <AdobeCode>{28AC85F6-1E75-4F7A-9F95-C479FDFA379C}</AdobeCode>
    <AdobeCode>{5210406B-5C46-4339-8DBE-3FEFAD8D3E85}</AdobeCode>
    <AdobeCode>{5D831588-D7E5-4192-BD31-708E76C7F026}</AdobeCode>
    <AdobeCode>{165EEB50-26AD-4CF6-8537-87DF2A3DC4F5}</AdobeCode>
    <AdobeCode>{BB4F0FF4-8C53-4D28-A45F-B326414EE02D}</AdobeCode>
    <AdobeCode>{56AB07CA-7B24-465C-A2B3-BF708EF46684}</AdobeCode>
    <AdobeCode>{2F29321F-0D75-413A-B0FA-4C07266F83E0}</AdobeCode>
    <AdobeCode>{52076580-86A0-444F-A8A7-66F70D4A16E3}</AdobeCode>
    <AdobeCode>{7CFFA1A4-606D-408E-8DB2-2744164AEA66}</AdobeCode>
    <AdobeCode>{693D4DD9-4E0C-4DBD-8D0A-A36194BCB0F3}</AdobeCode>
    <AdobeCode>{EEF7CB6F-5E76-4877-8998-EA62237DE4D3}</AdobeCode>
    <AdobeCode>{5B95576D-DB21-4EC9-8F98-5F572BA93C1B}</AdobeCode>
    <AdobeCode>{3180E709-C010-4C1B-81CA-6BD386524567}</AdobeCode>
    <AdobeCode>{E93BD38C-8ACF-43FB-B476-DF8D3A1E969B}</AdobeCode>
    <AdobeCode>{28FBEA46-23D0-4AF7-B918-1330FEF0E716}</AdobeCode>
    <AdobeCode>{17DA2421-5D42-46DC-8414-8C9D7CD94C06}</AdobeCode>
    <AdobeCode>{3917EE28-1680-4B04-8CEF-27B3AA95A864}</AdobeCode>
    <AdobeCode>{7474FB28-948C-49BD-845E-F51F04E13B2D}</AdobeCode>
    <AdobeCode>{596FD7E8-BC94-4C2F-8433-38D2D9E4112C}</AdobeCode>
    <AdobeCode>{178A6594-40EC-4816-90A9-EF5DC0116DDF}</AdobeCode>
    <AdobeCode>{452150C3-1F5B-448F-A71B-FBE3144567F4}</AdobeCode>
    <AdobeCode>{140A8F0F-A4DD-4404-B080-9960D66BFB33}</AdobeCode>
    <AdobeCode>{B2EB987F-07F2-4948-9638-6E60C574288B}</AdobeCode>
    <AdobeCode>{3C122F56-9DCE-4895-8159-710A4A510904}</AdobeCode>
    <AdobeCode>{71957A47-1FAB-4456-80E9-D6FB7C1BA3E0}</AdobeCode>
    <AdobeCode>{DF728118-9E17-4C9F-9E7D-3F97C5528035}</AdobeCode>
    <AdobeCode>{CE104476-4951-49AF-AFD9-533F688D01D8}</AdobeCode>
    <AdobeCode>{C650DD6A-D6CF-42AA-BBD6-A3D0CF0CB67E}</AdobeCode>
    <AdobeCode>{1BEBE63D-813D-4D1A-A28F-D0255DFA0369}</AdobeCode>
    <AdobeCode>{069F1464-7A01-4219-8F56-E1CD53D57E08}</AdobeCode>
    <AdobeCode>{571B4823-4124-46CB-A2E8-71195FEA4EE7}</AdobeCode>
    <AdobeCode>{97717545-A80B-4FF1-8C0D-5DFA60048D5D}</AdobeCode>
    <AdobeCode>{64B4935C-3B1B-43FA-8578-CAAA21E1AA3B}</AdobeCode>
    <AdobeCode>{865FB8A3-6A1B-4B57-9DD5-152022E700F4}</AdobeCode>
    <AdobeCode>{142DF1D7-D5DD-4DDC-BD77-3EF554AC27CD}</AdobeCode>
    <AdobeCode>{33186F0C-C2E1-4333-A636-6044FE97C1AE}</AdobeCode>
    <AdobeCode>{A7EA4F61-A1E2-4CF5-9E80-5ABCC40CDBD1}</AdobeCode>
    <AdobeCode>{EE1555CF-1A67-4CCE-B8DD-CEFABE0575DA}</AdobeCode>
    <AdobeCode>{B508A43F-357E-442D-9975-13DBEFF9DCB6}</AdobeCode>
    <AdobeCode>{37B83AB6-DE74-4F79-A4F6-B81670191C70}</AdobeCode>
    <AdobeCode>{C8C07A57-609B-4048-8B59-207B40CFDAAB}</AdobeCode>
    <AdobeCode>{81259193-9F79-4E6C-8AD3-C9FF3E2D6CAF}</AdobeCode>
    <AdobeCode>{821689B9-D48B-47F1-BF3D-187C276D6E44}</AdobeCode>
    <AdobeCode>{A7C8ACB9-C1E0-49DE-A47E-45AF0E09AA23}</AdobeCode>
    <AdobeCode>{B7719770-B82C-4954-AD61-D8C1AEA4D79C}</AdobeCode>
    <AdobeCode>{7754AE0A-A9A6-4494-BEF5-FAB35251CC01}</AdobeCode>
    <AdobeCode>{068827A9-CF56-49C5-87AF-948D12767C1C}</AdobeCode>
    <AdobeCode>{B1F13FB9-3458-4734-A310-97DF6CC8BAC0}</AdobeCode>
    <AdobeCode>{7661F1CF-80D0-4447-8075-2A3E168D020A}</AdobeCode>
    <AdobeCode>{DEA7B40C-D238-4D19-AFA8-C0F3EF7884AB}</AdobeCode>
    <AdobeCode>{2C0C0B4F-B542-45ED-8DA6-6E0D61B166BB}</AdobeCode>
    <AdobeCode>{81C35E63-CB46-424A-B4E7-3C32518EA398}</AdobeCode>
    <AdobeCode>{B85F7D67-60BE-4332-B6B2-D1F11B20D4EB}</AdobeCode>
    <AdobeCode>{8F780736-9FBB-4F55-858A-D8F873BE805F}</AdobeCode>
    <AdobeCode>{5781B54D-32A8-4646-A5B7-EDDCB4EDE3D8}</AdobeCode>
    <AdobeCode>{92C1E280-F6FC-458F-8AD0-E7C8A55B79A6}</AdobeCode>
    <AdobeCode>{ACA4E5EC-CDDB-47A0-967C-4719A73C9D41}</AdobeCode>
    <AdobeCode>{0D81BA70-4F28-4003-AAB6-21632857D0CD}</AdobeCode>
    <AdobeCode>{7130B3A4-862A-4BE6-8B01-505158C7938F}</AdobeCode>
    <AdobeCode>{FFF93200-3912-4273-BD98-C07D205A1F45}</AdobeCode>
    <AdobeCode>{292EF891-EEC5-434F-B58D-E84991350521}</AdobeCode>
    <AdobeCode>{9100BB02-CBE7-477B-BF1F-C287FB7AF9AE}</AdobeCode>
    <AdobeCode>{894CB1C6-8AEF-4969-8C8C-1D51FC0F3C25}</AdobeCode>
    <AdobeCode>{83546AC7-11A7-465A-86DA-895E2C79AD47}</AdobeCode>
    <AdobeCode>{08694FF6-26F2-46E2-95FC-DE70D198444D}</AdobeCode>
    <AdobeCode>{789B281C-2879-4A9F-ACFB-8037A1A21413}</AdobeCode>
    <AdobeCode>{BF0E1EEF-CF13-4FCC-98A4-B6000A350BA3}</AdobeCode>
    <AdobeCode>{E0EADD91-5596-43D5-A0A7-9D09F275C41D}</AdobeCode>
    <AdobeCode>{D3A02895-59C1-4BAC-8BF7-3849D4F78678}</AdobeCode>
    <AdobeCode>{442769CB-C959-496E-8FE3-945BBEF956E4}</AdobeCode>
    <AdobeCode>{284385D4-B2A0-4279-97FA-97853774A777}</AdobeCode>
    <AdobeCode>{7A4693DC-6D00-46F1-AA21-2219126CC90E}</AdobeCode>
    <AdobeCode>{A3293655-8C9F-4EF6-BADB-05978324A10C}</AdobeCode>
    <AdobeCode>{7CA4AB03-5E09-46A6-94D3-E7ABC5404F91}</AdobeCode>
    <AdobeCode>{4C8CDEB8-A65D-4CA4-A529-30F174EF3DE4}</AdobeCode>
    <AdobeCode>{215ACD96-C0C4-4818-9DA6-1035CCE77566}</AdobeCode>
    <AdobeCode>{F00E3ADD-4052-48D3-B94D-7FDF7A0F302E}</AdobeCode>
    <AdobeCode>{759FF16D-5FC2-4880-95AC-950EDAC870E2}</AdobeCode>
    <AdobeCode>{6C84D6D1-F9E7-447D-9B96-F89108120901}</AdobeCode>
    <AdobeCode>{9460E630-A001-4631-95EB-0D8B7DA46C36}</AdobeCode>
    <AdobeCode>{53940342-1B42-4155-97D5-7BE680427EE3}</AdobeCode>
    <AdobeCode>{F01B981C-0A2F-4A65-ACAD-DAD7F42312A2}</AdobeCode>
    <AdobeCode>{FE3B717C-E85D-40DD-8D1F-49482F1D8CDC}</AdobeCode>
    <AdobeCode>{D0E682B7-C955-4DB5-927B-CBAD6ED6917E}</AdobeCode>
    <AdobeCode>{120952EF-46F9-44C4-9710-AB34147FC413}</AdobeCode>
    <AdobeCode>{B98578E8-CE0E-479A-BB5E-34439AE9EAFC}</AdobeCode>
    <AdobeCode>{368ED7CF-1964-4D07-B861-666E42FAA58B}</AdobeCode>
    <AdobeCode>{FE7E2A39-1CD0-4AD3-8615-98FC78EBF05C}</AdobeCode>
    <AdobeCode>{1C6D2F66-44B4-411A-B6D3-B6F2FF114149}</AdobeCode>
    <AdobeCode>{5C57FB41-4FF2-468A-870A-C02C964E3E09}</AdobeCode>
    <AdobeCode>{688BA135-E52E-443D-A237-A2357891A7B9}</AdobeCode>
    <AdobeCode>{C1B62BCD-D45D-48AE-97A5-B4172E45B4FC}</AdobeCode>
    <AdobeCode>{190B10E1-7CC3-4A0E-B14D-884852F9E04A}</AdobeCode>
    <AdobeCode>{878655B7-B8EA-4228-BF61-20B6A7CC8549}</AdobeCode>
    <AdobeCode>{BAA5A33A-829C-4AB3-BA67-EC0DF448AF92}</AdobeCode>
    <AdobeCode>{B926070E-BB22-4BF0-A226-DAB7C481A25B}</AdobeCode>
    <AdobeCode>{8451B250-7BE3-49B7-9846-EC93A6941567}</AdobeCode>
    <AdobeCode>{2B3D942E-0090-4CD2-A313-1072FF5AB8C3}</AdobeCode>
    <AdobeCode>{1E0CF828-4C0D-467B-B0B2-9CA3174A614A}</AdobeCode>
    <AdobeCode>{D4227DD8-FF42-4ACD-B87E-1020CAD8A045}</AdobeCode>
    <AdobeCode>{358DBD80-B03A-44EC-99D7-BF216A7FF603}</AdobeCode>
    <AdobeCode>{58DC38AB-AA92-4319-BE91-93C9832F4DE7}</AdobeCode>
    <AdobeCode>{7C90AB7C-9BD7-4A65-8E13-AC44C087FF35}</AdobeCode>
    <AdobeCode>{3F2BEE9D-8119-4429-A302-952E5F59D91E}</AdobeCode>
    <AdobeCode>{4DC8779C-DDD6-41E0-B79D-82C143D7914A}</AdobeCode>
    <AdobeCode>{75D63DE5-8290-4359-B2F6-987940DEEC64}</AdobeCode>
    <AdobeCode>{0568BDBC-19A8-4C62-AA28-CE54AB77C911}</AdobeCode>
    <AdobeCode>{183DB405-8681-48C1-B1BA-5BE943DB9CB8}</AdobeCode>
    <AdobeCode>{41526885-92D9-4377-85D0-2EC87B5A8175}</AdobeCode>
    <AdobeCode>{4EF234A5-AA67-4998-9108-83A46B1A3BAA}</AdobeCode>
    <AdobeCode>{6BD6993C-762A-4F07-89D6-8E4073635C8F}</AdobeCode>
    <AdobeCode>{82684311-9677-42EC-A476-EBDCB732E25D}</AdobeCode>
    <AdobeCode>{0F925327-73B4-4C11-8DA4-05ADB0D21724}</AdobeCode>
    <AdobeCode>{207213F5-5AA2-4144-9C5D-2A176584F714}</AdobeCode>
    <AdobeCode>{CC0FE328-898A-490B-946D-056603F4F4A2}</AdobeCode>
    <AdobeCode>{CDDCF604-FFEF-49D0-9E12-5A90E9F73F20}</AdobeCode>
    <AdobeCode>{B3D24BE5-094E-4AC4-85C4-27EB370F7BE3}</AdobeCode>
    <AdobeCode>{943CA24A-D070-401B-AD8A-6B9521D9D2FC}</AdobeCode>
    <AdobeCode>{F2DC64B9-C25B-4DAB-A374-09763F37C77D}</AdobeCode>
    <AdobeCode>{67A48C8E-AE1A-4821-BE52-B6F3654190FF}</AdobeCode>
    <AdobeCode>{CC90918C-B0E1-45B0-A6FB-0A9F78395338}</AdobeCode>
    <AdobeCode>{A1D95828-8009-4EA2-95E5-24BC533DDC96}</AdobeCode>
    <AdobeCode>{FB30BF47-A8AF-4366-A30F-0031C8ED2AC5}</AdobeCode>
    <AdobeCode>{C6236DF0-5316-4EB4-A543-15C042EEE8AB}</AdobeCode>
    <AdobeCode>{607C56F2-0405-49F0-B67C-0DA08C4408FC}</AdobeCode>
    <AdobeCode>{6ED03B73-05D1-44CE-91D1-ECA89647A2CC}</AdobeCode>
    <AdobeCode>{25B71BEC-2D97-43F7-BB03-A10E3F2537AC}</AdobeCode>
    <AdobeCode>{068697B1-6666-4F62-9269-DFE70257D5E0}</AdobeCode>
    <AdobeCode>{429F48C4-D309-43E8-BD84-5E3F3AE4B6F9}</AdobeCode>
    <AdobeCode>{A7779EB4-ABEC-4588-A2D5-B65548BEB2BA}</AdobeCode>
    <AdobeCode>{D7B327E1-AAAE-49B8-9BBF-1D4D9FF91ACD}</AdobeCode>
    <AdobeCode>{A71C03E1-7741-4D7A-A408-AB3E044B87DA}</AdobeCode>
    <AdobeCode>{39EACC1D-6D84-4B78-AA90-F49EC4E663E2}</AdobeCode>
    <AdobeCode>{0712C1A3-F5C0-4D29-9CC8-225ED1CEDFF2}</AdobeCode>
    <AdobeCode>{587F7F9E-A877-47F0-A528-F30B569DCC39}</AdobeCode>
    <AdobeCode>{9D767741-0F4B-49F1-8197-A4D26C4D3ED0}</AdobeCode>
    <AdobeCode>{4F85465C-E02A-459F-B420-47CBDA87C301}</AdobeCode>
    <AdobeCode>{35EFB3CE-2F56-43CB-8564-FA1FEBC79255}</AdobeCode>
    <AdobeCode>{0C690E53-A8F6-4BF0-984D-CAD4BFDDA9FD}</AdobeCode>
    <AdobeCode>{321F162D-78B2-44F4-BD9D-9451DF000569}</AdobeCode>
    <AdobeCode>{F1BFF988-FF3A-4D96-814C-7EA4D2A7DD0C}</AdobeCode>
    <AdobeCode>{EDF6BEB9-A46E-4C66-8A7F-781C24B5D125}</AdobeCode>
    <AdobeCode>{BC923D68-E412-4994-99AE-EE5568253751}</AdobeCode>
    <AdobeCode>{8B6B80EF-55FF-463C-8AB6-901CDB0155A4}</AdobeCode>
    <AdobeCode>{88FF4A31-505B-4C8C-9DEB-9AD6468F34B8}</AdobeCode>
    <AdobeCode>{B9EE1E7D-EC40-4857-BD0E-AC55E3E10869}</AdobeCode>
    <AdobeCode>{CF0714CA-A20E-49BD-B4C2-0A6B79028125}</AdobeCode>
    <AdobeCode>{0779BFCD-C5FF-4E68-B4A4-D563B010D25A}</AdobeCode>
    <AdobeCode>{C63B55F0-A228-4E50-B17D-4E87349F9C82}</AdobeCode>
    <AdobeCode>{61551253-A909-4C6C-A72D-8909A9B70099}</AdobeCode>
    <AdobeCode>{74328862-E1D6-411B-B05F-8839B692CAF7}</AdobeCode>
    <AdobeCode>{F1624B59-7ECF-4498-A18A-5698A06A5820}</AdobeCode>
    <AdobeCode>{F6E791BF-5A66-44D1-BED1-CAFDAF7A69EE}</AdobeCode>
    <AdobeCode>{33BA6F08-4A24-447A-A3F1-62C15A790590}</AdobeCode>
    <AdobeCode>{6EFC46E4-C326-48A9-9217-2C6D2A5798F1}</AdobeCode>
    <AdobeCode>{E1E26669-4E59-4963-A8B1-731D1D7F7FE7}</AdobeCode>
    <AdobeCode>{0E2C0395-07A4-4F08-B8E3-89FADF7A4D7B}</AdobeCode>
    <AdobeCode>{AA7AABB7-EDB2-4A61-9FA6-76A508868081}</AdobeCode>
    <AdobeCode>{EFCDFB41-7E28-4E4F-9A61-BCE68541E001}</AdobeCode>
    <AdobeCode>{C6182313-E9BE-4987-A912-65C1F9A207AE}</AdobeCode>
    <AdobeCode>{A7C9D230-4A7F-47B9-9BD3-039B65557517}</AdobeCode>
    <AdobeCode>{81C744A5-5BE7-49FB-883E-1E416E2CC9C2}</AdobeCode>
    <AdobeCode>{6CB372B4-4BD2-4924-BFC1-61916A0EEAF9}</AdobeCode>
    <AdobeCode>{943DB337-DF85-434C-9CCA-5647AD97BD54}</AdobeCode>
    <AdobeCode>{A216C618-C041-4486-9DD1-507A68B8E68B}</AdobeCode>
    <AdobeCode>{DB6D91EF-4125-4B08-8A61-03D582243892}</AdobeCode>
    <AdobeCode>{5E843C88-1B46-4E5C-AC5F-D6400ACC4C28}</AdobeCode>
    <AdobeCode>{B45110EB-C5B6-4CC7-A905-0B49216A9C9D}</AdobeCode>
    <AdobeCode>{54AFB319-CD95-41D3-9534-D7C82F1BDA0C}</AdobeCode>
    <AdobeCode>{6FDB7F73-D3B0-429F-B153-F270FC448D97}</AdobeCode>
    <AdobeCode>{D40A1351-AA77-4534-93E2-EB67C3D11208}</AdobeCode>
    <AdobeCode>{74EA3A8B-D145-459D-866C-80C946E4D451}</AdobeCode>
    <AdobeCode>{1F911904-8831-4063-BE57-385F4302F87D}</AdobeCode>
    <AdobeCode>{5D2ACAAC-D325-4017-81F7-D80707C74DC2}</AdobeCode>
    <AdobeCode>{C00732C0-E5DF-43AC-AF66-71A8BD46FD65}</AdobeCode>
    <AdobeCode>{731F488F-811B-479E-84F2-7AEA629F9C88}</AdobeCode>
    <AdobeCode>{22FB7692-E2E3-4711-89D0-6137FE494EB4}</AdobeCode>
    <AdobeCode>{E8F15189-B2B8-48AC-B8AF-DDE5CC8D7D56}</AdobeCode>
    <AdobeCode>{1AA04DBC-4069-4B1B-A40A-7C3CA25AE260}</AdobeCode>
    <AdobeCode>{BEC1DC0F-1287-4D49-B8D6-772891DC298C}</AdobeCode>
    <AdobeCode>{9A3F5BAD-C34B-4C95-B8FD-FFD4F1D83987}</AdobeCode>
    <AdobeCode>{F75474EE-B180-4952-BAA1-4C7635B72408}</AdobeCode>
    <AdobeCode>{03D22307-FB0E-48F7-A3C1-7705558FD011}</AdobeCode>
    <AdobeCode>{85FD1567-88DD-4DB8-A9C0-80DEBE7E8743}</AdobeCode>
    <AdobeCode>{29ADB5DC-ADBB-4158-B1F7-F0BA80A3D871}</AdobeCode>
    <AdobeCode>{5AA15E06-D80C-4897-8BC4-756CE5D838E5}</AdobeCode>
    <AdobeCode>{1F85FF2E-8145-47C5-8E8C-49AD81521843}</AdobeCode>
    <AdobeCode>{F4E96359-6BE6-49B1-91E2-B14F2B33F781}</AdobeCode>
    <AdobeCode>{B8F3841D-21C1-4844-B943-EC9B39A011F4}</AdobeCode>
    <AdobeCode>{5263C5FA-9E68-4435-B1F6-9A6DFB49CB58}</AdobeCode>
    <AdobeCode>{03CB58A2-BA3F-44BF-8C3B-3307DC64BD33}</AdobeCode>
    <AdobeCode>{D619E4C0-7894-4293-AFF7-4C9FB4D520FE}</AdobeCode>
    <AdobeCode>{77D0BDC3-5CCE-4049-8586-CE466CF589DF}</AdobeCode>
    <AdobeCode>{C2DE0ED8-C0C6-4056-B751-2526BF29BF3C}</AdobeCode>
    <AdobeCode>{327DE249-C35E-493E-85E9-8AACCD2530A0}</AdobeCode>
    <AdobeCode>{442BD16F-12E5-47BC-B0A3-37291D23CEB3}</AdobeCode>
    <AdobeCode>{77B01FA6-73DE-4D87-AEB9-7CEE2133CC43}</AdobeCode>
    <AdobeCode>{2E6AAA01-1AB5-472A-9454-8104F5D0EAB5}</AdobeCode>
    <AdobeCode>{EA4728EF-D98B-4E8B-8A7F-2329C196583C}</AdobeCode>
    <AdobeCode>{E37F12DD-507F-4473-A05D-DC51AD2AA852}</AdobeCode>
    <AdobeCode>{F44B1880-CD48-4909-B423-8F1BF75DB805}</AdobeCode>
    <AdobeCode>{302FCFA3-1333-4AD9-98B5-E5D85282E822}</AdobeCode>
    <AdobeCode>{D841435D-8CEC-46B8-85ED-9B2E4D3F3CDD}</AdobeCode>
    <AdobeCode>{A60DB855-257C-4E7E-887E-A0F4C5D8B7A7}</AdobeCode>
    <AdobeCode>{9A4B2E63-9604-4969-A9E2-765E779BB40B}</AdobeCode>
    <AdobeCode>{75FDE4C5-2408-4805-8225-2A7DC7E15C45}</AdobeCode>
    <AdobeCode>{0B013458-A1C7-45DC-8F17-6F7A0C321665}</AdobeCode>
    <AdobeCode>{1306EE99-1892-40F3-B9D3-5D5ECCD74510}</AdobeCode>
    <AdobeCode>{95A840F7-F625-4F53-B305-CAB3264F4FCD}</AdobeCode>
    <AdobeCode>{068D471B-0069-41D6-9596-A8C4B87C839A}</AdobeCode>
    <AdobeCode>{2F539FDF-5AB5-4CA4-B3ED-54D6228F7F97}</AdobeCode>
    <AdobeCode>{D48C8A4D-8FAA-4B9C-BA4B-A80506152AF8}</AdobeCode>
    <AdobeCode>{704FDDF1-E1C6-4C6F-901D-F27470F591FA}</AdobeCode>
    <AdobeCode>{5F508C65-6EA2-4639-8DC5-A5BC32F11CC0}</AdobeCode>
    <AdobeCode>{1DB94F20-B986-4EBA-88CE-71199D1B663D}</AdobeCode>
    <AdobeCode>{8A9B729C-A472-4C2D-9601-924CB4F9E823}</AdobeCode>
    <AdobeCode>{191F7DEC-DDB6-42F0-B7B0-F4C721EFAB08}</AdobeCode>
    <AdobeCode>{6D881611-D598-47EA-B7CB-3F9BCF7CB7BF}</AdobeCode>
    <AdobeCode>{18C95266-ED13-4008-860B-14F017D6C96F}</AdobeCode>
    <AdobeCode>{CCEE82EA-C6BC-45FA-8D1B-5CFA66F67547}</AdobeCode>
    <AdobeCode>{0FC82967-3169-4BF1-8827-F8C3F52053B5}</AdobeCode>
    <AdobeCode>{FE7B4ED4-2ED9-4AEC-A9FE-D895BEBDF23F}</AdobeCode>
    <AdobeCode>{56E35876-D89B-499B-BD55-17F7E7216B70}</AdobeCode>
    <AdobeCode>{73F39C2D-5B9C-4D20-AB32-4B2811F257C2}</AdobeCode>
    <AdobeCode>{0B8E1E42-93F4-4F6B-A16E-EB6DD60CBA87}</AdobeCode>
    <AdobeCode>{A1F41573-C9F2-42CA-8F41-9088EC8AA76F}</AdobeCode>
    <AdobeCode>{D5603532-9B2C-4807-A803-F156B3156B5C}</AdobeCode>
    <AdobeCode>{243521BF-EE7B-419D-A20D-D450A6625790}</AdobeCode>
    <AdobeCode>{D109BE1C-146D-4733-856A-3BBCE83BDDF1}</AdobeCode>
    <AdobeCode>{312FF2F2-F0D0-406F-BFDF-40B6226CC497}</AdobeCode>
    <AdobeCode>{FD1AFCE9-22F5-4804-B847-1F930D02334E}</AdobeCode>
    <AdobeCode>{4BA89517-14F9-408E-9E92-EA5643818DA7}</AdobeCode>
    <AdobeCode>{CCD2827E-82FB-4F57-B24A-C8DAD4E66E2C}</AdobeCode>
    <AdobeCode>{B7A897BD-E1B4-469C-A4E7-CBA2C84B5CCF}</AdobeCode>
    <AdobeCode>{4441F391-B70A-41C0-843E-52A09D581C6C}</AdobeCode>
    <AdobeCode>{CA3407D3-37C6-4A8A-8FF6-2C3B58A523AF}</AdobeCode>
    <AdobeCode>{EBA63BA8-181A-4222-A9C5-FC684CF4ACE6}</AdobeCode>
    <AdobeCode>{B44B78F3-548A-4377-8113-98895C8B72D6}</AdobeCode>
    <AdobeCode>{B8D0F393-422C-4E36-807A-1DB2ABDD122A}</AdobeCode>
    <AdobeCode>{2323B8DD-584F-4C80-8FC7-85B9CD321147}</AdobeCode>
    <AdobeCode>{CCE402F7-9291-446E-B2AF-A635402D12A9}</AdobeCode>
    <AdobeCode>{316F7A55-182B-4518-A580-6A6CD61617DB}</AdobeCode>
    <AdobeCode>{CA0B4617-8CDE-4622-AD05-BBD69014EEDF}</AdobeCode>
    <AdobeCode>{38B35C45-D747-4423-AD7F-3C5136F157FB}</AdobeCode>
    <AdobeCode>{E76ABB12-7799-46AB-9589-110BE6540664}</AdobeCode>
    <AdobeCode>{007CDB99-000E-4E1E-85A9-36643663A681}</AdobeCode>
    <AdobeCode>{E65735BF-1364-4952-9319-02801B398792}</AdobeCode>
    <AdobeCode>{65F1C69D-B7DA-4C69-A39A-2D45250C19C9}</AdobeCode>
    <AdobeCode>{D88B7568-150D-4AB6-9475-4A07B1F60896}</AdobeCode>
  </Upgrades><Channel enable="1" id="CameraProfilesInstaller-7.0">
    <DisplayName>Camera Profiles Installer</DisplayName>
  </Channel><InstallDestinationMetadata relocatableSize="272107188" sysDriveSize="0"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>272107188</TotalSize>
      <MaxPathComponent>/LensProfiles/1.0/Tokina/Nikon\NIKON CORPORATION (Tokina AT-X 165 PRO DX 16-50mm F2.8 (IF) ASPHERICAL) - RAW.lcp</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="1" name="Assets1_1" size="272107188"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">7.0</Value>
      <Value lang="be_BY">7.0</Value>
      <Value lang="bg_BG">7.0</Value>
      <Value lang="ca_ES">7.0</Value>
      <Value lang="cs_CZ">7.0</Value>
      <Value lang="da_DK">7.0</Value>
      <Value lang="de_DE">7.0</Value>
      <Value lang="el_GR">7.0</Value>
      <Value lang="en_GB">7.0</Value>
      <Value lang="en_MX">7.0</Value>
      <Value lang="en_US">7.0</Value>
      <Value lang="en_XC">7.0</Value>
      <Value lang="en_XM">7.0</Value>
      <Value lang="es_ES">7.0</Value>
      <Value lang="es_MX">7.0</Value>
      <Value lang="es_QM">7.0</Value>
      <Value lang="et_EE">7.0</Value>
      <Value lang="fi_FI">7.0</Value>
      <Value lang="fr_CA">7.0</Value>
      <Value lang="fr_FR">7.0</Value>
      <Value lang="fr_MX">7.0</Value>
      <Value lang="fr_XM">7.0</Value>
      <Value lang="he_IL">7.0</Value>
      <Value lang="hi_IN">7.0</Value>
      <Value lang="hr_HR">7.0</Value>
      <Value lang="hu_HU">7.0</Value>
      <Value lang="is_IS">7.0</Value>
      <Value lang="it_IT">7.0</Value>
      <Value lang="ja_JP">7.0</Value>
      <Value lang="ko_KR">7.0</Value>
      <Value lang="lt_LT">7.0</Value>
      <Value lang="lv_LV">7.0</Value>
      <Value lang="mk_MK">7.0</Value>
      <Value lang="nb_NO">7.0</Value>
      <Value lang="nl_NL">7.0</Value>
      <Value lang="nn_NO">7.0</Value>
      <Value lang="no_NO">7.0</Value>
      <Value lang="pl_PL">7.0</Value>
      <Value lang="pt_BR">7.0</Value>
      <Value lang="ro_RO">7.0</Value>
      <Value lang="ru_RU">7.0</Value>
      <Value lang="sh_YU">7.0</Value>
      <Value lang="sk_SK">7.0</Value>
      <Value lang="sl_SI">7.0</Value>
      <Value lang="sq_AL">7.0</Value>
      <Value lang="sv_SE">7.0</Value>
      <Value lang="th_TH">7.0</Value>
      <Value lang="tr_TR">7.0</Value>
      <Value lang="uk_UA">7.0</Value>
      <Value lang="vi_VN">7.0</Value>
      <Value lang="zh_CN">7.0</Value>
      <Value lang="zh_TW">7.0</Value>
      <Value lang="en_AE">7.0</Value>
      <Value lang="en_IL">7.0</Value>
      <Value lang="fr_MA">7.0</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Camera Profiles Installer</Value>
      <Value lang="be_BY">Camera Profiles Installer</Value>
      <Value lang="bg_BG">Camera Profiles Installer</Value>
      <Value lang="ca_ES">Camera Profiles Installer</Value>
      <Value lang="cs_CZ">Camera Profiles Installer</Value>
      <Value lang="da_DK">Camera Profiles Installer</Value>
      <Value lang="de_DE">Camera Profiles Installer</Value>
      <Value lang="el_GR">Camera Profiles Installer</Value>
      <Value lang="en_GB">Camera Profiles Installer</Value>
      <Value lang="en_MX">Camera Profiles Installer</Value>
      <Value lang="en_US">Camera Profiles Installer</Value>
      <Value lang="en_XC">Camera Profiles Installer</Value>
      <Value lang="en_XM">Camera Profiles Installer</Value>
      <Value lang="es_ES">Camera Profiles Installer</Value>
      <Value lang="es_MX">Camera Profiles Installer</Value>
      <Value lang="es_QM">Camera Profiles Installer</Value>
      <Value lang="et_EE">Camera Profiles Installer</Value>
      <Value lang="fi_FI">Camera Profiles Installer</Value>
      <Value lang="fr_CA">Camera Profiles Installer</Value>
      <Value lang="fr_FR">Camera Profiles Installer</Value>
      <Value lang="fr_MX">Camera Profiles Installer</Value>
      <Value lang="fr_XM">Camera Profiles Installer</Value>
      <Value lang="he_IL">Camera Profiles Installer</Value>
      <Value lang="hi_IN">Camera Profiles Installer</Value>
      <Value lang="hr_HR">Camera Profiles Installer</Value>
      <Value lang="hu_HU">Camera Profiles Installer</Value>
      <Value lang="is_IS">Camera Profiles Installer</Value>
      <Value lang="it_IT">Camera Profiles Installer</Value>
      <Value lang="ja_JP">Camera Profiles Installer</Value>
      <Value lang="ko_KR">Camera Profiles Installer</Value>
      <Value lang="lt_LT">Camera Profiles Installer</Value>
      <Value lang="lv_LV">Camera Profiles Installer</Value>
      <Value lang="mk_MK">Camera Profiles Installer</Value>
      <Value lang="nb_NO">Camera Profiles Installer</Value>
      <Value lang="nl_NL">Camera Profiles Installer</Value>
      <Value lang="nn_NO">Camera Profiles Installer</Value>
      <Value lang="no_NO">Camera Profiles Installer</Value>
      <Value lang="pl_PL">Camera Profiles Installer</Value>
      <Value lang="pt_BR">Camera Profiles Installer</Value>
      <Value lang="ro_RO">Camera Profiles Installer</Value>
      <Value lang="ru_RU">Camera Profiles Installer</Value>
      <Value lang="sh_YU">Camera Profiles Installer</Value>
      <Value lang="sk_SK">Camera Profiles Installer</Value>
      <Value lang="sl_SI">Camera Profiles Installer</Value>
      <Value lang="sq_AL">Camera Profiles Installer</Value>
      <Value lang="sv_SE">Camera Profiles Installer</Value>
      <Value lang="th_TH">Camera Profiles Installer</Value>
      <Value lang="tr_TR">Camera Profiles Installer</Value>
      <Value lang="uk_UA">Camera Profiles Installer</Value>
      <Value lang="vi_VN">Camera Profiles Installer</Value>
      <Value lang="zh_CN">Camera Profiles Installer</Value>
      <Value lang="zh_TW">Camera Profiles Installer</Value>
      <Value lang="en_AE">Camera Profiles Installer</Value>
      <Value lang="en_IL">Camera Profiles Installer</Value>
      <Value lang="fr_MA">Camera Profiles Installer</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "0", "ChannelID", "CameraProfilesInstaller-7.0")
INSERT INTO PayloadData VALUES("{539AEF15-3A2B-4A31-A587-7E90F7D9C700}", "0", "ChannelInfo", '<Channel enable="1" id="CameraProfilesInstaller-7.0">
    <DisplayName>Camera Profiles Installer</DisplayName>
  </Channel>')
