CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "", "required", "Shared Technology", "Camera Profiles Installer", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7BEBD9CC-7168-4228-B61D-1AC0697B34BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0D46674C-6161-43EA-B4E8-DEF1B7BCB3C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A1983E6A-E21E-4E16-8CDD-38A3BB5379D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3C7C936C-32E2-4F96-B775-40EAAAC1FDE6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{881AAB69-0474-4CBC-86BD-B6AE76E9DDD7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C0CF1A9C-D714-45C2-86E1-235DE821AAFB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{AA533120-F712-4020-9108-8B344B5CB3B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8BB2FB56-E363-47B4-9A10-EFDD509887BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BE1AA89E-E779-4F74-A0C3-83EFC28B52AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{087E6811-1920-4F91-A6C4-A076844C3CCD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0FC28CDE-3C9E-475E-A464-EDF95FD9A3E9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0B680C2A-A629-438E-8B13-0171DE5A3ECF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B1A28420-D386-4985-94F2-9A5EDC9BBF52}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3BFC6FE8-E921-4302-B4EE-27F6F046C238}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{376874C1-3108-45E2-B0E2-F76AE68C88FA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C66A06AD-FC3C-4EEA-910E-68BBFFB1AC12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E6846BDC-F37C-42AB-AF04-996B2D3DDA10}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1138F6DC-DD26-41B0-9945-0D4643E0D25B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{33EC0EB0-2F4A-448B-91F5-CBEF29A0F3AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D3D37D7D-ACCB-4075-95B1-1B6E816E7886}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E6DFAA64-A17A-4739-8ABD-7AE24E279317}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4F71FA1B-0D99-4BEF-A957-84CEFE63FECC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{DB7A16F1-EEC3-4AA5-BF0A-BC8B822D9718}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{238468B0-D852-4E8E-B67E-D2A74B4EF151}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9A9D22AC-A766-4B9D-A436-65BDEA7D11DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0DB38B8C-99AA-465B-8995-8638CBFCE3D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{AD9B765D-6571-417C-B57D-DECCC3D066E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A7F9E8EA-6C32-42B9-9144-D4E8D6E0CC97}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{268EC631-5A48-4ECB-92B3-A2341FC8F087}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F4745D43-96AF-4059-932A-1E4C0CCCA6B6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6854A364-F2A4-442D-9EC0-298C13146FDD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3250F41A-11AF-4DB6-B3AA-F2BF463639D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{441F7E0B-D46F-422B-89AB-C53C3FF30293}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FE1AA85B-BE49-499F-B580-31F71EE3C9D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5A57627E-0967-49A9-A59C-E0812C6AB0FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5F6B06E9-96BD-48D5-89D7-196D8558DFA2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{602CE089-8AFB-4B6D-B491-3AC2BE488C9C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5C4538E1-580E-497C-B69F-F7203A7F3A4C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{42669937-EC3C-4D03-88D0-8E080DE54F09}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{250F9613-36AB-4D4B-B597-E8D502EAA43F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E47E5781-5791-4DE5-B1DF-97E524FCDB8E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{143D866C-143A-4E7F-890F-43BC1AB1A432}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{172F6140-F252-4505-A96A-D83C2BF77EEB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9B22125F-CAFA-496E-A4C2-08E3D52791C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{26DD735A-8944-4243-A841-4A80C2E899A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{24267CDA-253F-4A5C-9A3C-997D91744761}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8B44A7D1-68DB-4B75-87E4-7857BE4C27F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F5B37F42-A411-4913-A469-E5BD3920E7B0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{DFBC3A3D-A1F6-4C02-8D7F-BC3BEF4261D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{00110F63-F251-4590-8F46-7C3E459A925C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3172DE7D-E286-47D1-932F-B015FB9EB924}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2867FA8C-72AB-4218-AE89-CC8DCA87993B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{ACEAE2E9-C31A-48F8-9CEC-23809EB0CB28}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{05F67A82-3921-41E4-A2BC-2DC0BB561AE6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{81C006A6-5FFE-407B-A2C0-1E87F1D33898}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3DA97310-4A7C-446C-A2E6-EAB13FC7658A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B948AB0B-1FFA-44AD-87BD-88F32548EDAE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4E982115-8A35-4EFD-8FD0-8CA500614C32}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{27B396C1-D84E-421B-A022-F90278969ACE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{33453B72-DE38-4424-A16A-6ABBA2D3FA8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{11286FE8-463A-4253-9CCC-0C92E019A8CE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2E4B0022-3C5B-4C66-9F7F-DF2D185DF2EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{07CD8964-183B-4D9B-AC58-1AFB1521F561}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1176F757-5B76-48DB-98A1-9CA74C4F581C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B0661C65-4699-4F72-8CE7-03DC51E4586B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E95E6212-BB39-4F65-970D-B8FA84D62B1D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D54E5551-C446-4DA5-BEB3-887E97761193}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{754F8692-F5CE-419B-A064-8341162F1C3B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{06400CAA-5647-4526-9325-51319695D9C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{39FA669E-B423-45BF-894C-39DA25C82485}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{AAD4AAF8-4D1C-4D0F-A96A-CE3E19888B92}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{CE0CD426-1835-4A7A-8BA8-3AC4B695BAAB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{27FB2B1A-9764-4628-9279-0FA25EEED6FA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{AC24272C-6DA8-44F5-BD0E-B63295C7550D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{90866745-296E-42B1-9CE0-AC4174606FB1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A79B75BE-1727-456E-967D-7A1F10D851A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B43C01A9-C4D6-4E0A-B02C-58E507206CB5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C88931C2-A3FB-4038-82E0-8893B7287CCC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C8737634-1086-43F7-A9DB-2A94F1593BF2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9E0C8143-6C84-4DDC-BA35-1AD349C4FEAE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5532F71F-EF98-460B-AA5C-42D8143BFB84}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{29B276F2-1656-4AB4-816F-E1F9B0A2A982}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9F886699-91FF-4B19-B552-D07641D74242}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{CF3C6F9A-AC62-4F8E-A014-141C575C117E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4729F1EC-0DF4-4370-BF35-490292746482}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0AFC2429-5FD7-4D96-B837-588D39A5851C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B39CD810-645C-4CF8-A68E-EB10FF6FFC2F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{922E0B1F-E033-4A3F-82DD-7C774F546671}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4D19BBE4-A47C-4589-BDD3-5E89515E83D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{868BBDD4-F0B4-4514-BCF7-277893B0BBBD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{985D769F-F7EE-4F3A-9A0E-82C78802000B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7F0AD319-4F7C-429C-8025-CDA5C405F9BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5DEA21BE-0664-4AA8-8C2C-0C5F322CAE4E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{71E5E0FD-399A-484D-8843-18D58D62403E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5240B617-5620-4D32-B7C7-FD2C6779592B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{301A815B-C970-473E-8D01-04AF0C81EEE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{ECBE01AE-59AE-4436-BF57-59CC0D1076A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{42DF120B-430C-49D0-B084-FEABD8C74CA2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8E946EE1-0CA2-4FA3-BE4A-82E8F4CA041D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{87AE988C-AD3B-4009-86F7-DC94FE0291E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{DEA68381-2903-4303-8998-75674F365A74}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{126F50AB-A1B3-4BBF-A1EE-C7C3BE92014A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7468396C-2AD7-4A3A-8816-F58A0C3F7366}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{76D49B10-29C3-4441-A647-CC6C842D406A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A68CA0FB-E0D0-46E4-944A-CDAAE8F54408}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D6E242ED-4813-43DB-A0B5-B25F78A3E92C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F83180B9-92FE-4E06-8DD6-4992465CB928}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{229A6A91-0A9B-4CEB-AE5C-C574CEDA7DEE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B5F2AE25-D5EA-4C1E-B674-30B9EAAA0984}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FE7682EA-CA86-47C0-8E69-30B99956B32A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B36FFB88-11DE-404A-9AEA-BFD435402184}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FD4CC9AB-6630-48FC-9863-7720CE0AD89B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{78421498-DF18-4F34-8E50-7141C8C6C96B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FC62E09F-8B6B-4ACB-9BEA-8ECB2B021DD2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3821C2C2-464F-434B-981B-7D10721B0DE9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A44379D8-E02D-4C8D-94E5-59666BE3B325}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4387B927-E6BD-4C1D-AE70-F6B095BE344A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{96ECC460-FD66-46B1-A965-CDC9C51AEF94}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{CC15CC0B-F35F-41ED-9A90-B9CD4F4C359E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B694A647-361A-4271-AB17-5A1E1A0EA99D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EF8E46B9-AEFB-4F00-80CC-3FDBD1DAAFE9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{05023453-5F2A-4828-A0BA-283330C926FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3FF73FCD-4AD3-413E-B73D-332AB246BD0F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9E8D800A-5C1D-48B3-AF5F-5629C715613C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{90D9A65A-3708-4ACE-8194-B067627238A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B9AB12D0-9E3A-4007-81FD-1EB3FC1564FF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4C263BDA-47F7-44A1-BEA0-2A03FCB32957}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{82D797CE-391D-41C5-A1B0-0A0A7923E90F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{489E0573-6F7F-4E9C-BC31-7BDED90ADC82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6BED3CD5-8092-4C0B-85FC-97CDABEDE861}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9E08B116-B364-40AB-833E-5F6A13297270}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8468C1EF-51B4-4449-9590-E0890EC5CC6C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A6AE3389-5ED0-4B1B-8822-135DFCCE710D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F31EB872-964F-4862-9AA7-B08BB45EDFF7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3BDC915E-F0B7-413B-B0D7-84BE4B434BE1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{12727A2C-CF4C-4161-AF95-AA67B044E989}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{96716D3D-31C3-413A-A164-F142CFE471B4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1F33C725-AFF0-4DD8-A3AB-61A7C6E007A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4221D776-A659-47B9-9398-88D5EC9BB3A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0713DBB8-3E1E-424F-981D-DBA9CA0C398E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E5802BB7-3D2E-443A-A446-D896C134180B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B11BACA2-487E-4333-9131-E41A9CDDE998}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{24B2AB69-5DC7-4681-A23D-18ACC2A8FA9C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{92DF34A9-F240-407F-92D3-ECE060803ED5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C3C68C4B-368C-4F8D-8E57-2669EF7A1B13}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{480C4FC1-F13A-4B00-BE39-27678D69DD4F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{65E75B6D-E00B-4543-83D4-175BF461E03B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3434F363-ACFA-4AFD-8BEA-FE3ABD6FC5BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{35BCDA3A-79BD-47BB-A721-849F9DAC0017}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9D982AC1-1821-43B9-9B24-92B29098511B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{08F8840D-0D75-4DBA-A501-60A55FBAA03A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3183D795-7072-4807-AE41-A4291C414143}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B64E42B7-E4CA-4027-84FA-59099CF6F444}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2B285F5A-8858-4743-8C23-64DFA3329856}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EB294169-F347-497B-8BBB-9D119334FFC3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{67D7CDB0-A403-4200-BD58-69F65A75B695}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BCB45B93-00DD-492E-96CF-88FCFB0E1C4E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8ED35321-289E-48E5-9639-8B4BD8FCE9AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{AD3BF031-1134-4F6A-AB4B-51A7608C191A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8067118A-88D5-440B-9156-0981C850ECDA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{64AA0738-86B2-4259-9D5B-04D3D5AA4937}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2EC318CE-7898-4356-B6B4-FAC24F605E05}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A8F6E251-2774-468E-84BA-EB0D0C98B6AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A5BC3D6F-202E-4903-8DF7-3D038F797EB5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{385B16D5-7413-43F0-B1E5-96D09621801B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C6A3549E-A8E2-469E-ABB4-86A881740ACB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9BF671E9-7E51-4C95-BD17-93546182BBBE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3D68A11A-7D64-4D77-87C4-8AE6B8B71D6B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5396CDC3-D00B-4088-A3AD-B4E2E8D48C82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A0A28328-34B8-4646-BC1E-685F92142D6C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{00217391-489B-4CA5-9D1B-73D56C5F5991}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0D9763EE-8099-4149-8CFB-8C297EC3D894}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{833A773F-F30C-4DB1-931A-01D06C675E4A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{021BF003-327B-4748-BD6D-D800CE008809}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1176AEB5-DA6B-45DB-B644-C6ECBA0A5391}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BAB747EA-DA54-4A43-A3D0-33AC62761FD5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{93DBA5E9-6A3E-4A45-B89B-F64D949579A1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{DE9A895F-A348-492E-8EB5-93A5162BFFBF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C5D86391-CFFE-4174-9A20-00773F808F3E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{355B41C3-84FA-47EA-8F59-BDD6241DBFCC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1DEDBEF3-6424-4F6C-9565-801512ECD1FC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FFEE4D59-1E65-4AA8-B57F-2B8EAC30BDBD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{23E47F69-156A-4A94-9C6C-5DC47D71DF63}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{823985EA-A4A7-484B-B508-4785FC50F1AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8E4A6D58-BBB9-4216-9A8C-060B3659BF5B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{71B68D72-C03A-4C9B-B3D6-F34BBCB7851D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6D7D9914-8AD9-4C03-A192-AB457E160288}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C5813E19-D989-432F-A87E-46D9CDBECB7C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4DB45C99-DB58-4689-A3D5-8FD5F3B88A9A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{61C5DC98-8680-4A21-A5D0-9C9112F07413}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5AF358DC-61D8-4BFD-A4DE-F03C51A36B34}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BB708323-F4FD-4AAB-86A0-18DE58D8D761}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E8043131-ADB4-4F4A-9B8C-5A99FEC19A5D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{47CDC367-31A5-4711-9146-2CB1096B555C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6FA6A66A-AC40-4BEC-BC0B-CCA9F0808594}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8992975F-CB1B-43FC-A9CE-83BD66FB8CC3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{459C48A3-6DCD-4644-965C-B5D54A182C25}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9C4ED71A-2F8B-4FF0-BB0B-B16BFD9AE076}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BE8211F8-233D-421E-955B-AD736CC4729A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{67272687-4DA3-469B-89CA-633C3A5478B3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F7AB2AF5-ADFB-4305-A34A-8EF2F2BB7C82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{27C15FFF-FF26-4E13-B6B8-C5976996A125}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1EC76F02-6AFB-437A-BB01-D67B056011CA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{64CA1539-973C-463F-A99F-A53EFD39F3A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6A5F2FA5-FD33-41E8-B456-B44BE8ED6819}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2486128E-90D6-4686-B934-5C01CABFC4D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{339E1ADA-5D0D-4335-9F26-D9EFC76F2DC5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{76D1C92D-AC08-4513-BCD7-841850F94ED5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{398DD229-4D44-4806-BC25-E05C5D4423DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6125717B-8CCA-4716-BE09-22DF7AF32D69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{36024268-B97E-49F8-8E6D-4073955763CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C7C942A9-4AE1-4118-939D-630EA307E9DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BED7EC26-E626-4EA8-927A-AD60BE458D75}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{529BB679-32AD-4E5A-ADC1-C4ED3C24B1EC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{87AFEF17-A618-4717-B7E1-C2C93BCCBE38}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B509BCFC-B1F9-44C9-846D-4CCF9AC313B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6E143120-4282-4457-85C3-713F555CD054}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{19D65B0A-F30B-46EF-800C-E817F4F72BDE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1C6A183F-00BD-4703-B54E-D44909AF27C5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{62FD6B7F-86C9-4BFE-801F-F30C557C3287}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1EF8D542-2204-4517-9D25-06C805EE8489}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{362BC19D-EEF4-4C69-AF7F-EFBDD8DFEFC4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{02098A65-E194-4101-B3C0-81C4028AA230}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{AD9F3EAE-D34D-40F7-A6EA-77E14F5DD285}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{99041B31-DCAA-46B0-9E46-6B45E7534C8D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1CAF629F-BB15-4641-B30C-15F1B34B1DDD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5361D036-0833-4B56-8236-FCD85D3277A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{169DFCE8-D111-40FF-960A-DC52E1D80E43}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E5CE3189-7AAD-4695-98CF-71AA9E843BE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{434FAC93-0067-41ED-B982-A0007602A51C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5ACA1C87-61B9-46E9-A947-8BCAD1C28F3A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2636DFF6-8700-4996-B223-AEDBE4410E83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{05DDFA16-7260-4534-9E8F-94615EAAF3A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C87A592B-8974-40BA-B80C-2282F3E3E2EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A1BCCF0D-1137-4201-AD0C-696169AF55DB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{51A0C0CD-A650-4FCE-AD62-9B3E3A5FC801}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{04D0EEF3-3A77-49E7-9CF3-B418A98D8FC6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1B596724-D085-48FB-9491-BDED716EC80E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{ADA51F4F-1363-4BE5-B798-EFEA26FEB077}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{28D6B854-1EA1-466E-9657-843B9F5055BF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D03CB540-C714-4AE9-8129-CB7BD5C05D45}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{DC017DD0-8DA6-4835-BB41-D214FFDF29C2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1ADD9EEC-04F9-4928-A246-AC7B63FBE25B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F7F6293E-2234-4A9E-A71F-28BA94299316}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7B776D65-6689-4DAC-94BA-D47EE3AA2372}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{41F349CE-7852-444C-804A-9074274D266D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{44D6E83F-8FA1-4F1E-8EAD-5C21AF9FA912}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C4F1AE65-E1E1-46B0-BE34-CAF3CF9B2BAC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F1C988ED-6CED-4786-82A6-50917C4AF3DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6C6C5887-B0AA-4E78-B0E3-6779425D026A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6CF4AFCC-851E-48B8-B7ED-564B3F001613}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E11BF272-B8B9-47F7-9A97-D1E6FC27ED85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4DE6A599-E3BB-40EF-BC60-DC2559C20970}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{CB2FF902-C83D-4B6E-8745-64AED222B60B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C32D486D-AA69-4460-9011-EB24AB23F0F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{234EE2FA-6E9E-4CC7-AE66-492012BB1157}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{769C3CBB-A7DB-4D74-B579-FDCAA8E018DF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{201F38F2-915E-453F-A9E3-401AA63A7535}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{54D50CBF-D711-4575-AD1F-CF7A4A4A4A2E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{35A7FC4F-0205-496F-8FB3-8E3CDC80A0C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7AB1D2C6-5796-420F-A9A9-307B9D8DBDCD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1FB0DAA8-2835-4F3E-9C79-8A3DF149662D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C8857121-0851-4BD5-886B-A3FBE1991C59}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{72F0A7B6-CFE6-4689-B88D-76911CB32608}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A57A32D0-84FE-443D-B1F6-AC9DBE1A7763}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FB4A2648-F7A3-48C3-AB19-85D65FBF786F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F13D7CBC-E74C-4802-821A-5ABB82EE67B4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{DBA2357E-E77D-44E1-9B1D-AE71B95F6C9A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0800FCEA-13AB-47FB-90FC-EC3E3FE5A7D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8990600D-405F-49E8-8A2B-456D9E43CFB0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E72E5D46-44C4-41C6-A4E7-4060DE2AC6FF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F0F9DA19-07CA-4DC4-84CA-572BF51040B9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{76DA4991-00BA-41A0-9E26-FA84CED62ABB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7B6FF34C-9376-4416-98A6-E5539F79128C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A4DDF30D-4607-4FA1-A7B1-6A862C48743D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{887044B4-6B73-47BD-8EA9-A30EE323075C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{03EB2EF5-6993-4C2D-A326-670B36B93524}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3FC24BCD-B0D6-4251-81E2-B8EDB76D0F32}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D244E30F-E9BB-4D83-8B56-2993606C0B6B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{496BC69F-EB62-41BB-A95E-F2BB51E53231}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{25D63A98-2080-44F2-A0B3-692C2F7A2692}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{85695B8A-D626-4158-BDC2-B9F9B2461607}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F4B1CB06-9FC3-423A-BCC1-C8FBD360D325}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{086604B5-E5A1-4DC4-A49C-8A2EBE5F78AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2052DF92-F743-4623-BBBD-0C415B121F7C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0D1FA38A-63CF-4CAF-A51D-6812984D03CB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3D3C0ED3-1257-4515-8316-35A3CE5DB62A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6693AA3E-9906-4C68-A4A5-AD86CFCAAE2C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B4B8179B-19B5-479A-9711-CDE0835AEAB6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D94FE971-1790-4532-B556-82211B8D1852}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D5FFEFF2-6083-4AD5-BD1D-74DB7013B659}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B58B2438-7B92-4825-B10F-7067F95D902A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EF54ABCC-1A8A-43C9-8CAC-B2ED9648193B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C1CDCEEA-76D1-4316-8F87-35AE11168F4F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F4FDF8E5-A695-4E8D-8E0C-C685A774CEFA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7D2E4D3F-3990-4EA9-86F9-DE02E780F093}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{74FF2A2B-2BA8-48A6-95CD-1130C2517011}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BB83F9F8-F6BA-4B19-BD8A-4A93E15E9E30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1E4C5E83-995E-4677-80B2-E802F1658D45}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1497CC52-8469-43FA-BD1E-BADCE8179B9F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4C00CF92-A1D2-4C0B-9EF4-8677EF1D05A3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EBEB34C8-27D7-482C-9BBF-CE5D315BBD84}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{814E43D2-5BB3-408C-8C86-0CAD24A9323D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4673A985-A693-43C1-B350-3BAF6965831F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6E237C5F-49B0-4741-83CF-16FE688FA0F0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{03D9D331-F7C5-4379-BE00-700930F2EA5A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2A8FDED3-514F-41F3-92B7-77C94878BB79}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9B446645-95FA-48B7-90A4-444A2623C83A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EAC0F810-B26A-4FC6-BF9A-BE9370C4C588}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3532A60A-0AB2-4F9A-A118-F3FA48442F0A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{24686BBB-E969-4690-A2B0-96F3A988040B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9FEC632F-48AA-4DAC-B587-AA27D8C16246}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6AE3E14F-188A-4314-8C46-3C8E0705C3EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4AC78A97-F473-44E2-85DD-A104E4BFE29E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{38251553-DE77-420D-AC75-F76B888C37E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A9D0B9E3-43F4-4AEE-A935-120DD9B4D856}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5833160E-5191-42CC-8D12-447B6C1AADB1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4E6C817B-EAC5-4B4D-ACE0-A0E5BA921520}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2DD7471E-2F12-4C82-A225-BA418EC663BB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8CDA2AF4-BCC9-4285-A18D-546DDB1CCB52}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{606FF3FC-0DBA-4581-B380-849E6A080932}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{205CA158-A64F-447B-8165-A4B1877C6BF9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7094F240-ABC1-408A-8598-ED5C5A2E68A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2202194F-BA2A-4E17-8CD2-CC5D468AFFC0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{531A9D7D-04B8-4681-8CCA-E2E652B5936A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C0828F09-DDDD-4DB0-9310-607A84A7FB16}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{14972A7A-1998-4267-B3E8-6D1F710FD14B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EB17C708-72C1-4057-8092-CDA79CC89422}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8088B004-9C58-4E5D-911F-EC3B27EE18E2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6B76F0E4-3F4F-4E29-B5DE-2BE58B642BF9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{77DCB379-3EB4-43C1-AAA4-8E617B7EADC6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{97062D96-EE03-4910-8187-949E3ED25619}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E46C6366-25B6-4982-9A1B-3ADF0DBC9C70}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7129AC35-26A2-44C5-84B8-1BC0C45E4566}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{59A2F410-EC0A-44F2-BD54-5EEA7A7D96C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{ADA76273-5571-4C44-9D20-A5F4B48C8C79}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6B6F1092-4D14-428E-8DE2-E62D16EBB876}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{16DA2C64-59E8-491A-BC62-0A0C63719FD3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EA7192BD-B1DB-4DE9-B479-27D9ED649CA9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{54AB7647-45D1-4C1A-B598-C5CCA73A008B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6E79FAED-4F16-4DA0-BF01-D8CEB67BAF6B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{684F79CE-582B-4BCC-BA8F-1504E2341BC4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6B9E9006-7451-4DA3-A676-B01D1D933D6E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{89F40A86-AE7A-4CFF-A4DC-1DDF802E7EB9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C3D2E20A-7390-4558-BB1E-9FE3B9217B47}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{79F901DD-0D66-4D24-94CC-1D344D120F7E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E18BE01E-DB11-4FBA-AC3D-2BCD32DD2666}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7E3126D8-4A2D-4057-B835-97444801F793}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C9D6221B-D740-4063-BF91-665F8FDEBC40}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8B1FB787-EED5-4FB7-A44B-415A3C497B40}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{31A6FAAB-AF82-4C33-871D-DE29CA03B2DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2917BA33-6316-474A-B0FD-A0A989BCBCB8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E0E071A4-E4F6-4C51-9952-DD4C25ABB6AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3DD65C54-430B-464A-BC83-E662EB21BD4C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C96EA15A-7C06-476C-B0C0-212D5686DB22}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{77F32508-E7AE-427C-AA88-724A18E538A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1F7A538D-5A81-4356-A400-958B2017274F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{12E5C0D1-D8D7-4405-A2DA-8922446B62C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{11774808-CE7F-4C29-B415-824F371B4E9D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F239CE98-C5CC-4266-8F94-5EB69644A1D4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C7490FF4-9194-44D6-80C2-6C11CC16FBD8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1C32F7EA-4879-4508-88E4-D4002FD1CC61}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1B86D4F4-DD8D-4303-8C8F-DB33537D8CFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D6BFEBD5-A0A7-4593-903A-20EA80A13DE3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2DE72118-4C08-4D2D-B866-CC5A9161F539}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{DAA11836-F832-4DFA-A143-31D20FF75C7A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FF4A22A9-C243-4A1A-A06A-0AE3B8907536}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{88A9268C-DABF-44D7-8040-DD9FCA8F32DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{765109AA-283E-41BF-9699-7D1556D34793}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E452634F-F2D1-418A-9D10-01F81017CDEF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E7C65EDE-AA21-48D9-870C-B1FF712345A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EFD71ECF-CBCC-4159-9F46-D9443B22CA75}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2CC5E357-D420-460C-A63C-F8B5335DF012}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A9B55B19-187B-4601-A2F6-9327553412B7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{38B7B024-843F-44A0-B81A-7DFDA93CA7CA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9403736D-027F-4F94-A4FB-0F835567F10F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D215C379-A2E1-4439-A563-7C13069E43BB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5FCE8DA6-BB95-4525-90F0-955ACB9644D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{311EFAAF-06EC-440E-B267-FF6F71075ACE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{AFDB0254-1544-412C-A7FD-08BA441684BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3B0FEEE0-89F3-4F88-AA4F-5737E32DCF8A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{716F99EB-CF55-4BEA-BD45-5A84C57417F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E2DC79D1-A3EC-4C93-8D11-F8700AEF268A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D3BFE9EF-0AF1-47BD-A1D9-E0D240030A20}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{95539F5A-A28A-4D7F-BF71-D36C1ABF83A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1E2A2C89-2495-4E8C-9016-FA7B0DA8299C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D01BA04C-DA01-4BAC-9569-63E24446F383}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FF687063-3173-438B-A6C3-707BBF5E658F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A97B438E-128F-4A75-91CF-9018EA9D47EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{254DBA29-52C2-4FE4-AED7-9B17314FA243}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F4493909-CE58-424D-AE54-53BBA06C91CE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5C3C3DAE-1A64-45BB-B32F-31372B61DB3F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{58ADA6BB-4B18-4B9D-8932-35724F2566F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0F7F6CB3-7B6A-45A4-BF03-62940445DC23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EAD7A022-66F8-4CA3-8711-B8E1A3F42256}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{460F7381-9ABB-467D-B7FE-7A789CB0ED12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{F9B6040F-ECC6-4285-BCA8-008816C6197C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{06779BAA-2018-4C44-8712-9786062E14C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3755E17F-FF81-4F45-93D3-8FF411786EAE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FFFDB71D-9ED7-431F-A90F-7B512E6A0C87}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8D1B5E32-F367-454B-A8AD-32B730986859}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A765EBC3-7BDC-4810-B1B5-6C0F9633ACF1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{39E716B3-9ABF-482E-B15A-CB1D219620E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{211C5D0C-B73A-4482-B6D1-5F4AE8770F14}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{58AFC45D-4A2C-432E-8221-E2ACFC029B88}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2087DD7A-BE6D-4A7E-B4D7-9DC201C09C83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{75E2AC9B-BA38-4738-B018-BCD8BB1A5BCD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2E42803C-E795-4352-946C-4C805D98F5E4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E963D74F-CDAC-468C-9238-EC725700B083}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7D24BEAD-CDD5-49F0-8655-D7D6EEE5162B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E6E57A92-C417-4B50-ADAB-97D021A3CF52}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{637C59EC-E004-4C43-A32B-B358BBCD6B1D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{795ED090-B0AF-428F-A678-D13976844974}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FC487BA8-5611-4D14-A106-242AF710FFD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{397478E9-E773-444A-A0BF-E4BF6C754E6E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A2BE7F22-1653-469C-8994-FA8A6B82148D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{CC2CC414-619A-445C-8BAF-308A5AA63611}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{654A5572-91DC-43E0-9D42-0162EB632FD3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B0AE6AE8-0434-4A10-A3EE-657381AA14B5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{316BECBE-20FA-4715-A490-FEC7EAC6E108}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{ADC2E345-3780-4230-8EE1-C58BB63CB552}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{61C4A8D3-92F5-4976-8D6F-B4E6307291F7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0B478F47-98C5-4257-9F55-24574DF61CCE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7A511FFF-0211-4764-99F6-23C1874FC6FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{62759074-BD96-4467-9FE1-1EF2D1583E2C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1F926D67-4C4E-4BCF-9250-A67741A0F284}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6F5E6EA2-7AD8-494B-A6CD-C5E19135EC45}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6485425B-719E-495C-ABF9-3211DED27963}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B0D5EE95-FEF6-44DF-9D37-CC1572D04EF7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E3734CF8-286B-49D7-B033-B1748ABCFA91}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{DC725085-B805-4AA3-A21E-C1F9C0EA733A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6ECE76DF-4EC1-451D-8A72-6F23E13F586A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D0100C9A-8399-4355-81E5-D2BB49B67EFC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E4A18ABB-111A-4EC1-A7D2-09D0CEA27BC6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{22D17909-EF2C-428C-B069-69B12D10FFC0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C4F70FB4-C5D6-4C4F-A936-DA604BD99BC2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{81824B18-9080-4151-B73B-08A9E0116780}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0A7CC7ED-E07D-4F2C-8F88-0F43DB6EFD26}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{30272670-B1DA-4096-88A4-EB96A2EF3B5B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D961AC9E-9972-4702-8C04-BE32C78F45BB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8442D7BA-637C-4B9C-9DCB-925C9AF91544}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{50446164-925E-441C-91E4-BF27EED4103F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FC2EEC3B-620C-4884-8626-C29544266A23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C9AEB7E2-1871-470B-B05F-964A886F6736}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A0AAEBA5-7C33-4F77-AB6C-4FFBCBA8A842}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A0B83CC4-7CD3-435E-8B05-022B270EAC76}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6163C4A5-0D2A-444A-87FD-DEE493F77A29}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FC331E7E-95BD-4482-8113-2FA65EFD30BD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{265B6C2B-1931-48DF-BB52-BAFEB2BEF4F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0A1E2FE2-B2AD-42F4-9C74-641853FB093A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C6783F5B-37C3-44B5-AE97-F75DF44BBB83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6E4EE2A6-C107-483E-B136-D9E02EF2389B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{8EEC5817-3776-430D-AD30-EC879396A3C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7ED7FB10-DE1F-40C4-BF6B-48440982F04C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{662312BA-DA48-4BFD-9CA7-534652E90D39}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D6AF1C1A-912D-4D80-AAE5-446F8C0BE9B0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7F812A79-10D6-47BF-81EC-6D2CF42CD52B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{715996D2-ABBD-483D-A26F-C140872CACCD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2741DE8F-61E0-43D9-BB10-567E33FD2A39}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6555999A-56F7-4642-B32F-BE09B52B5374}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C6AFC8C5-6914-4564-AD42-21BFDEDBA7CB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{4AB72F9A-884F-433C-BCA7-A4AD8787C5AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1070A498-4DD1-496C-98BB-88112C8BBCFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{845D8900-8A13-4911-B473-8AEED9D058C0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9DC19726-6863-4C24-8F79-4541A9211EA5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{55ED4E06-39E8-4EDE-9759-60C802B40F45}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D0669A2D-2353-44FE-A097-51A73A8AD3E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2F3C1351-180D-4122-A16A-DC1A17B75C62}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{991A706F-8468-4E29-8DD3-32A4A1DD4155}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FF2B40F8-336F-40CE-AF80-C635DE27BD23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C6BBD2C7-464C-4FD9-94A1-77546583BC55}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B6683272-CCE2-414D-B29D-EACBBAD0140C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A77ACEAF-348A-4D22-BF56-0D0E1597E8DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{64E1C429-144B-4EC1-B7FA-87919C8A29A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A1768B72-0A6B-45FF-8ABC-8CC5C334E4B4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A3CF3377-4EF9-4784-B101-0CBB20EE6D63}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1B8BD6DC-FD9D-46F0-B7FB-3BBD4DBA385B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{85045805-4216-4849-926F-B47AEA1DEC4A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BC755D83-275F-4B0F-A82C-2BEC0B5C970B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{16F7648A-5EF7-4B34-8F8C-52E728928FFB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2D78A9A2-B300-41EA-A593-76259F264494}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{234F93F3-5767-4330-A949-775AA9248EBC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2846528D-38CF-47FA-ABBA-D898092199AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{1788E9A3-4822-4DDE-B2E1-28412F117056}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D79E8BCD-A7F9-4F2E-A92B-737907FB27F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BFC0A0F6-DDDF-40E6-96E8-985C0C6E6C11}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{7597A909-A8D0-4245-B541-507BF55576AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{0FEBF73A-5BF1-49E0-AF30-12C11B590435}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A82174F5-9B60-4962-99D6-FA9EFEF463C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B66B9A8D-1E5C-40E7-842D-9F502F5E0FD7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{26A928C5-013F-417F-B3DC-837D32A97C2D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5E8016A1-D1FD-47CF-8874-6815685D1133}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{D8825AC4-2EA5-4C85-AC1E-23ADB0CE11DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{04C6FB4C-96DE-483B-9184-171E37311876}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{DD234E23-805B-44EC-9120-9DEEFB4468D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{901A431D-2AF9-4BA5-A0A5-CB2CBACD1E28}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{E91AD757-F0F2-4580-A8A1-C151C4EEE3BB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BF2089C4-CA0C-4402-8430-0BA4293A135D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3EBD800B-A3C3-4324-B120-A0816ACAC3BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FFB59A71-0065-4576-AB06-E1AB9F727F73}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{A9E0B086-E409-433B-98D6-D16AAB8D7F43}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{78F2EABB-C3D7-44B0-A726-28313880951C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B44A0C6F-F80D-4B0A-8E29-C2F14CD25306}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{70958EF5-4C89-41FD-A655-0CCCE1F23E90}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{85F8098E-D4EB-4135-ACEA-514DCA2E09F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{417209BC-24B9-4CF6-BE68-18A1DECA7D6F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2C1F4060-0CF5-4F2A-AC52-B198C5A57858}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{C5154E97-6C0A-480B-B2D8-4E367A0F0567}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{67E10674-4FC7-4B23-AA56-09C21442FE41}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{2CEB18D5-16B5-4FBF-9E04-D1711D2ADF4F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{6FDA38EA-EFFF-4E87-AFEB-ED785ACE9A55}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BD4EF3B8-7F04-4648-9EBE-204FD4C65F27}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{B224F5BC-CE0D-40C4-AB61-1AC3F9BC7B67}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{82773387-3D3B-4903-8DCA-A7675859F98F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{379FD47B-C56C-49A4-903D-94567317DD90}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3AEDA0A3-D377-41E0-B759-4AB71E5DCF1E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{3465D2E6-22E2-46FC-B7C1-D5D0416B4262}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{EA9A91FD-5398-45B8-86E1-7781662A8860}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5D6659A7-DABC-482F-9325-9E171D9049D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{9DEE279B-53D9-424B-8887-1F6497656622}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{FC810EDF-988E-42FF-BD3D-11AC3E34C7A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{833729FF-3DB8-450E-BE36-A0F7E6189BA0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{19DF3EBC-6275-4893-B5B8-B55E06B69D7F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5FDA1D1C-5723-48F9-9CF6-FB4CAC7FE739}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{34526FA1-12B3-40B0-804E-3C0263760890}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{53296484-1037-4F56-B978-CD678CE2319D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{636ACDD8-368E-4390-B95F-8B7EBA11681D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{5E1CE47C-BD60-47DB-BCBF-26E15318CC1A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{86DD1F80-0A27-42F5-9283-40815500C301}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{BB2302AE-85C1-457F-85D5-7A8AE1ABB6E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{23820776-03C7-4A16-B595-C12B480D652F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "{93A1589C-DE51-4EA1-B896-6128FC2E42E0}", "upgrade", "", "", "")
INSERT INTO PayloadData VALUES("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{CFC3110A-491C-4DBF-A97D-66C567600A2F}"><File><InstallPath>[INSTALLDIR]\Plug-Ins\CS6\File Formats\Camera Raw.8bi</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5{|}Class 3 Public Primary Certification Authority</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "0" , "ValidationSig", "f+1frl1Mh818VzUXse7MWBXf+D/o04ZbBSIrj2Gn9DvYWxeMoofnD4qOv+a67V5JP125Rh11rcs09cflJGvRTo1IDWwfVq3JjUjnPZ6A6T1f+NPlFHpoB/ORjcpAHgHLZ1S62nw0rsVs0tqph8mn8m2tYIk7CogPhKlIv/jFF63mPkvMz8M49Vtvpom5xoPLsw4fWR10EB58XBzqNLOKul2TvOhQDVf/rBYMtGRXb2U7ooIfXUsP7yI6skB6DkoLcIuarwLvcCzc/WxLzSMzX2iZu01+D8RZOl9bT+/wxmHXpXqA4qNSUM8QeqnVXBZ/ebnJnFh528aCstmNrOrpywCcsNVajg2FhSAUPV0yJjLwGu1N3SEdTgRQ2VveRJPlTqKWYLFrPN1hivdoBHdf1gKOv++BP/BZskM+J4YYdUgRrzQpcbNwuc73mXOFZP12fUvAOo2VxnTXQkszXblNbtoXtiz+J2GKCCdKd2x8qYPz5jTfUhGSpJqOaUbaJG01")
INSERT INTO Branding VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "AMTConfig", 'PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjxDb25maWd1cmF0aW9uPg0K
ICAgIDxQYXlsb2FkPg0KICAgICAgICA8IS0tIGRlZmF1bHRBZG9iZUNvZGUgZm9yIGRldmVsb3Bt
ZW50IHVzZS4gLS0+DQogICAgICAgIDxEYXRhIGtleT0iZGVmYXVsdEFkb2JlQ29kZSI+Q2FtZXJh
X1Jhdy1JbnN0YWxsZXItQWRvYmVDb2RlPC9EYXRhPg0KICAgICAgICA8RGF0YSBrZXk9IkxpY2Vu
c2luZ0NvZGUiPkNhbWVyYV9SYXctNy1XaW4tR008L0RhdGE+DQogICAgPC9QYXlsb2FkPg0KCTxP
dGhlciBhZG9iZUNvZGU9IkNhbWVyYV9SYXctNy1XaW4tR00iPg0KICAgICAgICA8RGF0YSBrZXk9
IkVQSUNfQVBQIj5QaG90b3Nob3AgQ2FtZXJhIFJhdzwvRGF0YT4NCiAgICAgICAgPERhdGEga2V5
PSJFUElDX0FQUF8wIj5QaG90b3Nob3AgQ2FtZXJhIFJhdyA3LjA8L0RhdGE+DQogICAgICAgIDxE
YXRhIGtleT0iR3JhY2VQZXJpb2QiPjEwMDAwPC9EYXRhPg0KICAgIDwvT3RoZXI+DQo8L0NvbmZp
Z3VyYXRpb24+')
INSERT INTO Branding VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "ProductIcon", 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABHNCSVQICAgIfAhkiAAAAAlwSFlz
AAALEgAACxIB0t1+/AAAABV0RVh0Q3JlYXRpb24gVGltZQAxLzI5LzEwocsEVQAAABx0RVh0U29m
dHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTM5jWRgMAAASMSURBVFiFxZdPaBx1FMc/v9/Oprsp2dgW
JcmiDfGQxCIqtKl4EkRFEGoP6kXxonjyKBjPoj1KtTdFqOBBaMWLCsaeQkypUJSWaqUE2iQmKQ1t
kt3Jzu/P8/Cbnd1NMxtRSx782JnfvH3vO9/3fW9m1OzsrCilUEoB0H68nYkIIrLjsff+rv9s9fXe
EymlmJiYyE14L+3cuXPoXcmcmlIK3aRlt2xXGQCItgomzw68O4+vrSDrC7jVa7hbf1KfPbXjtR0B
QKeC88wtXUSSGr62gl9bRDaWM+DdruVZ1nUzMzNy+PDhXAAvf75KVNBEBY1W4L0nsWEZ6zDWkRiL
tZbEWIwxHb9zHz+ZC2B6ejqUoFsZ1hNFf28EWiMIohRaQ0ELTrXmhlIKnZ5rBVoB4nPjah3kF3kf
nPIc65uWUqSwtjOodWF5Z8GHJd6hxIF4EN/1xiCUPtNAnuNmIyGOHFprNMGnHbRzDmtDCZw1OOcR
Z/DOhpUTVykVJiGAcy7XcW2jzh5dzGhtakWJCwykINqBGJsem2RnBpoB8xxNIyaObaAfUKTz3LuM
Oe9sBqCDkS4AtNaBgSxIXgniOjXdg0KCyJBQ4/QOvLOISGDBmqCPDIDJjdvMmQFwzm3PQNKgJg0K
KQUKCT0sPmNBvOtgwlmDdUGIeXG11jjndmbAmzqbtkW/UqrFQlPpqdi899k+4sHnizBjYKc2FBPj
ZMu1thJ0JGxbIgI+XwMZAGtbNdwWgG10JL3r19s2MBZcEmaCM+CS3LhRFIUSJElAmTeKv37z/m33
/6nlxW3qLnLOdR1Ehw4d+k8Ackubsh5Za7tq4F5ZxkATQLFY3BUAqvLWz4LSKF0Alb4gKd0htkzt
3ra1mEOyvda+eNfhu/Ucb1uC9ZZIFYrovqGQtAmgvZXEozpazLb20w5oD5z5toMVQbwFn2RPTVyC
X5snEtsILZPe+dhAD5PPVQA4fX6D/pJibCDiw+9WeenxXsYHinxzcZ33X9jP65/dYGK4xBtP7ePK
YsynU0tI+po5eewgfyzWGB0sc+HaHSoljXjH2dl5FCASgbdoSWqIjREbg63TFzU4crDI6ZlVPjrW
z2CfMPpAAfGGakUxPlCk0uM5MlymWlGceq3K2V9Wmbp8u2MwPVLtZWhfD+PVvbzz/IMM7tvD0P5S
IKz5geIMWpJ1SDbA1JGkBnYThXD8sTJTl9cCO+LB1DP6mowdf6KPK4sxR0fKTL44SKVomRguUe1X
rTKlY3t8qNwaUD4MLDExWhrriImRpJYBEBFO/nCd97662qqbicOxeMQ2EBEWbtWo9hf48debHB3Z
S98eYWKkl+p9hfBmlL4pffHTHM8+eiCcm3rIZxtg6mhp3CFbyTpiaiiEK3PLAZBLGBss8eXbD3Nm
5gbV/gInXnmIT76f48z0NaZ+W+HEq8Os1RPm/1rh5LeXmL10HXEmJHKGhaWbnP99OQBPapBspCBi
VPmZD2RrF3R8nKptvl3aHk7ZqO32UBIPtHVH2j12+RKR31jCrVz+N7Pkf7HoaPnCKGWe3qX8V/8G
Tilns8Q4iRUAAAAASUVORK5CYII=')
INSERT INTO Payloads VALUES	("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "Shared Technology", "Photoshop Camera Raw 7", "7.0", "normal")
INSERT INTO PayloadData VALUES("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.29.0"><BuildInfo>
    <Property name="Created">2012-02-09 04:31:49.414000</Property>
    <Property name="TargetName">AdobeCameraRaw7.0All</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{CFC3110A-491C-4DBF-A97D-66C567600A2F}</Property>
    <Property name="ProductName">Photoshop Camera Raw 7</Property>
    <Property name="ProductVersion">7.0</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="1" name="Default" folderName="">[AdobeCommon]</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
	<Family>Shared Technology</Family>
	<ProductName>Photoshop Camera Raw 7</ProductName>
<ProductVersion>7.0</ProductVersion>
    </ProductInfo>
  </Satisfies><Dependencies>
    <ProductInfo type="required">
						<Family>Shared Technology</Family>
						<ProductName>Camera Profiles Installer</ProductName>
					</ProductInfo>
  </Dependencies><Upgrades>
    <AdobeCode>{7BEBD9CC-7168-4228-B61D-1AC0697B34BA}</AdobeCode>
    <AdobeCode>{0D46674C-6161-43EA-B4E8-DEF1B7BCB3C1}</AdobeCode>
    <AdobeCode>{A1983E6A-E21E-4E16-8CDD-38A3BB5379D6}</AdobeCode>
    <AdobeCode>{3C7C936C-32E2-4F96-B775-40EAAAC1FDE6}</AdobeCode>
    <AdobeCode>{881AAB69-0474-4CBC-86BD-B6AE76E9DDD7}</AdobeCode>
    <AdobeCode>{C0CF1A9C-D714-45C2-86E1-235DE821AAFB}</AdobeCode>
    <AdobeCode>{AA533120-F712-4020-9108-8B344B5CB3B2}</AdobeCode>
    <AdobeCode>{8BB2FB56-E363-47B4-9A10-EFDD509887BA}</AdobeCode>
    <AdobeCode>{BE1AA89E-E779-4F74-A0C3-83EFC28B52AD}</AdobeCode>
    <AdobeCode>{087E6811-1920-4F91-A6C4-A076844C3CCD}</AdobeCode>
    <AdobeCode>{0FC28CDE-3C9E-475E-A464-EDF95FD9A3E9}</AdobeCode>
    <AdobeCode>{0B680C2A-A629-438E-8B13-0171DE5A3ECF}</AdobeCode>
    <AdobeCode>{B1A28420-D386-4985-94F2-9A5EDC9BBF52}</AdobeCode>
    <AdobeCode>{3BFC6FE8-E921-4302-B4EE-27F6F046C238}</AdobeCode>
    <AdobeCode>{376874C1-3108-45E2-B0E2-F76AE68C88FA}</AdobeCode>
    <AdobeCode>{C66A06AD-FC3C-4EEA-910E-68BBFFB1AC12}</AdobeCode>
    <AdobeCode>{E6846BDC-F37C-42AB-AF04-996B2D3DDA10}</AdobeCode>
    <AdobeCode>{1138F6DC-DD26-41B0-9945-0D4643E0D25B}</AdobeCode>
    <AdobeCode>{33EC0EB0-2F4A-448B-91F5-CBEF29A0F3AD}</AdobeCode>
    <AdobeCode>{D3D37D7D-ACCB-4075-95B1-1B6E816E7886}</AdobeCode>
    <AdobeCode>{E6DFAA64-A17A-4739-8ABD-7AE24E279317}</AdobeCode>
    <AdobeCode>{4F71FA1B-0D99-4BEF-A957-84CEFE63FECC}</AdobeCode>
    <AdobeCode>{DB7A16F1-EEC3-4AA5-BF0A-BC8B822D9718}</AdobeCode>
    <AdobeCode>{238468B0-D852-4E8E-B67E-D2A74B4EF151}</AdobeCode>
    <AdobeCode>{9A9D22AC-A766-4B9D-A436-65BDEA7D11DE}</AdobeCode>
    <AdobeCode>{0DB38B8C-99AA-465B-8995-8638CBFCE3D0}</AdobeCode>
    <AdobeCode>{AD9B765D-6571-417C-B57D-DECCC3D066E5}</AdobeCode>
    <AdobeCode>{A7F9E8EA-6C32-42B9-9144-D4E8D6E0CC97}</AdobeCode>
    <AdobeCode>{268EC631-5A48-4ECB-92B3-A2341FC8F087}</AdobeCode>
    <AdobeCode>{F4745D43-96AF-4059-932A-1E4C0CCCA6B6}</AdobeCode>
    <AdobeCode>{6854A364-F2A4-442D-9EC0-298C13146FDD}</AdobeCode>
    <AdobeCode>{3250F41A-11AF-4DB6-B3AA-F2BF463639D7}</AdobeCode>
    <AdobeCode>{441F7E0B-D46F-422B-89AB-C53C3FF30293}</AdobeCode>
    <AdobeCode>{FE1AA85B-BE49-499F-B580-31F71EE3C9D5}</AdobeCode>
    <AdobeCode>{5A57627E-0967-49A9-A59C-E0812C6AB0FE}</AdobeCode>
    <AdobeCode>{5F6B06E9-96BD-48D5-89D7-196D8558DFA2}</AdobeCode>
    <AdobeCode>{602CE089-8AFB-4B6D-B491-3AC2BE488C9C}</AdobeCode>
    <AdobeCode>{5C4538E1-580E-497C-B69F-F7203A7F3A4C}</AdobeCode>
    <AdobeCode>{42669937-EC3C-4D03-88D0-8E080DE54F09}</AdobeCode>
    <AdobeCode>{250F9613-36AB-4D4B-B597-E8D502EAA43F}</AdobeCode>
    <AdobeCode>{E47E5781-5791-4DE5-B1DF-97E524FCDB8E}</AdobeCode>
    <AdobeCode>{143D866C-143A-4E7F-890F-43BC1AB1A432}</AdobeCode>
    <AdobeCode>{172F6140-F252-4505-A96A-D83C2BF77EEB}</AdobeCode>
    <AdobeCode>{9B22125F-CAFA-496E-A4C2-08E3D52791C1}</AdobeCode>
    <AdobeCode>{26DD735A-8944-4243-A841-4A80C2E899A7}</AdobeCode>
    <AdobeCode>{24267CDA-253F-4A5C-9A3C-997D91744761}</AdobeCode>
    <AdobeCode>{8B44A7D1-68DB-4B75-87E4-7857BE4C27F8}</AdobeCode>
    <AdobeCode>{F5B37F42-A411-4913-A469-E5BD3920E7B0}</AdobeCode>
    <AdobeCode>{DFBC3A3D-A1F6-4C02-8D7F-BC3BEF4261D0}</AdobeCode>
    <AdobeCode>{00110F63-F251-4590-8F46-7C3E459A925C}</AdobeCode>
    <AdobeCode>{3172DE7D-E286-47D1-932F-B015FB9EB924}</AdobeCode>
    <AdobeCode>{2867FA8C-72AB-4218-AE89-CC8DCA87993B}</AdobeCode>
    <AdobeCode>{ACEAE2E9-C31A-48F8-9CEC-23809EB0CB28}</AdobeCode>
    <AdobeCode>{05F67A82-3921-41E4-A2BC-2DC0BB561AE6}</AdobeCode>
    <AdobeCode>{81C006A6-5FFE-407B-A2C0-1E87F1D33898}</AdobeCode>
    <AdobeCode>{3DA97310-4A7C-446C-A2E6-EAB13FC7658A}</AdobeCode>
    <AdobeCode>{B948AB0B-1FFA-44AD-87BD-88F32548EDAE}</AdobeCode>
    <AdobeCode>{4E982115-8A35-4EFD-8FD0-8CA500614C32}</AdobeCode>
    <AdobeCode>{27B396C1-D84E-421B-A022-F90278969ACE}</AdobeCode>
    <AdobeCode>{33453B72-DE38-4424-A16A-6ABBA2D3FA8F}</AdobeCode>
    <AdobeCode>{11286FE8-463A-4253-9CCC-0C92E019A8CE}</AdobeCode>
    <AdobeCode>{2E4B0022-3C5B-4C66-9F7F-DF2D185DF2EE}</AdobeCode>
    <AdobeCode>{07CD8964-183B-4D9B-AC58-1AFB1521F561}</AdobeCode>
    <AdobeCode>{1176F757-5B76-48DB-98A1-9CA74C4F581C}</AdobeCode>
    <AdobeCode>{B0661C65-4699-4F72-8CE7-03DC51E4586B}</AdobeCode>
    <AdobeCode>{E95E6212-BB39-4F65-970D-B8FA84D62B1D}</AdobeCode>
    <AdobeCode>{D54E5551-C446-4DA5-BEB3-887E97761193}</AdobeCode>
    <AdobeCode>{754F8692-F5CE-419B-A064-8341162F1C3B}</AdobeCode>
    <AdobeCode>{06400CAA-5647-4526-9325-51319695D9C1}</AdobeCode>
    <AdobeCode>{39FA669E-B423-45BF-894C-39DA25C82485}</AdobeCode>
    <AdobeCode>{AAD4AAF8-4D1C-4D0F-A96A-CE3E19888B92}</AdobeCode>
    <AdobeCode>{CE0CD426-1835-4A7A-8BA8-3AC4B695BAAB}</AdobeCode>
    <AdobeCode>{27FB2B1A-9764-4628-9279-0FA25EEED6FA}</AdobeCode>
    <AdobeCode>{AC24272C-6DA8-44F5-BD0E-B63295C7550D}</AdobeCode>
    <AdobeCode>{90866745-296E-42B1-9CE0-AC4174606FB1}</AdobeCode>
    <AdobeCode>{A79B75BE-1727-456E-967D-7A1F10D851A7}</AdobeCode>
    <AdobeCode>{B43C01A9-C4D6-4E0A-B02C-58E507206CB5}</AdobeCode>
    <AdobeCode>{C88931C2-A3FB-4038-82E0-8893B7287CCC}</AdobeCode>
    <AdobeCode>{C8737634-1086-43F7-A9DB-2A94F1593BF2}</AdobeCode>
    <AdobeCode>{9E0C8143-6C84-4DDC-BA35-1AD349C4FEAE}</AdobeCode>
    <AdobeCode>{5532F71F-EF98-460B-AA5C-42D8143BFB84}</AdobeCode>
    <AdobeCode>{29B276F2-1656-4AB4-816F-E1F9B0A2A982}</AdobeCode>
    <AdobeCode>{9F886699-91FF-4B19-B552-D07641D74242}</AdobeCode>
    <AdobeCode>{CF3C6F9A-AC62-4F8E-A014-141C575C117E}</AdobeCode>
    <AdobeCode>{4729F1EC-0DF4-4370-BF35-490292746482}</AdobeCode>
    <AdobeCode>{0AFC2429-5FD7-4D96-B837-588D39A5851C}</AdobeCode>
    <AdobeCode>{B39CD810-645C-4CF8-A68E-EB10FF6FFC2F}</AdobeCode>
    <AdobeCode>{922E0B1F-E033-4A3F-82DD-7C774F546671}</AdobeCode>
    <AdobeCode>{4D19BBE4-A47C-4589-BDD3-5E89515E83D0}</AdobeCode>
    <AdobeCode>{868BBDD4-F0B4-4514-BCF7-277893B0BBBD}</AdobeCode>
    <AdobeCode>{985D769F-F7EE-4F3A-9A0E-82C78802000B}</AdobeCode>
    <AdobeCode>{7F0AD319-4F7C-429C-8025-CDA5C405F9BC}</AdobeCode>
    <AdobeCode>{5DEA21BE-0664-4AA8-8C2C-0C5F322CAE4E}</AdobeCode>
    <AdobeCode>{71E5E0FD-399A-484D-8843-18D58D62403E}</AdobeCode>
    <AdobeCode>{5240B617-5620-4D32-B7C7-FD2C6779592B}</AdobeCode>
    <AdobeCode>{301A815B-C970-473E-8D01-04AF0C81EEE4}</AdobeCode>
    <AdobeCode>{ECBE01AE-59AE-4436-BF57-59CC0D1076A7}</AdobeCode>
    <AdobeCode>{42DF120B-430C-49D0-B084-FEABD8C74CA2}</AdobeCode>
    <AdobeCode>{8E946EE1-0CA2-4FA3-BE4A-82E8F4CA041D}</AdobeCode>
    <AdobeCode>{87AE988C-AD3B-4009-86F7-DC94FE0291E6}</AdobeCode>
    <AdobeCode>{DEA68381-2903-4303-8998-75674F365A74}</AdobeCode>
    <AdobeCode>{126F50AB-A1B3-4BBF-A1EE-C7C3BE92014A}</AdobeCode>
    <AdobeCode>{7468396C-2AD7-4A3A-8816-F58A0C3F7366}</AdobeCode>
    <AdobeCode>{76D49B10-29C3-4441-A647-CC6C842D406A}</AdobeCode>
    <AdobeCode>{A68CA0FB-E0D0-46E4-944A-CDAAE8F54408}</AdobeCode>
    <AdobeCode>{D6E242ED-4813-43DB-A0B5-B25F78A3E92C}</AdobeCode>
    <AdobeCode>{F83180B9-92FE-4E06-8DD6-4992465CB928}</AdobeCode>
    <AdobeCode>{229A6A91-0A9B-4CEB-AE5C-C574CEDA7DEE}</AdobeCode>
    <AdobeCode>{B5F2AE25-D5EA-4C1E-B674-30B9EAAA0984}</AdobeCode>
    <AdobeCode>{FE7682EA-CA86-47C0-8E69-30B99956B32A}</AdobeCode>
    <AdobeCode>{B36FFB88-11DE-404A-9AEA-BFD435402184}</AdobeCode>
    <AdobeCode>{FD4CC9AB-6630-48FC-9863-7720CE0AD89B}</AdobeCode>
    <AdobeCode>{78421498-DF18-4F34-8E50-7141C8C6C96B}</AdobeCode>
    <AdobeCode>{FC62E09F-8B6B-4ACB-9BEA-8ECB2B021DD2}</AdobeCode>
    <AdobeCode>{3821C2C2-464F-434B-981B-7D10721B0DE9}</AdobeCode>
    <AdobeCode>{A44379D8-E02D-4C8D-94E5-59666BE3B325}</AdobeCode>
    <AdobeCode>{4387B927-E6BD-4C1D-AE70-F6B095BE344A}</AdobeCode>
    <AdobeCode>{96ECC460-FD66-46B1-A965-CDC9C51AEF94}</AdobeCode>
    <AdobeCode>{CC15CC0B-F35F-41ED-9A90-B9CD4F4C359E}</AdobeCode>
    <AdobeCode>{B694A647-361A-4271-AB17-5A1E1A0EA99D}</AdobeCode>
    <AdobeCode>{EF8E46B9-AEFB-4F00-80CC-3FDBD1DAAFE9}</AdobeCode>
    <AdobeCode>{05023453-5F2A-4828-A0BA-283330C926FE}</AdobeCode>
    <AdobeCode>{3FF73FCD-4AD3-413E-B73D-332AB246BD0F}</AdobeCode>
    <AdobeCode>{9E8D800A-5C1D-48B3-AF5F-5629C715613C}</AdobeCode>
    <AdobeCode>{90D9A65A-3708-4ACE-8194-B067627238A4}</AdobeCode>
    <AdobeCode>{B9AB12D0-9E3A-4007-81FD-1EB3FC1564FF}</AdobeCode>
    <AdobeCode>{4C263BDA-47F7-44A1-BEA0-2A03FCB32957}</AdobeCode>
    <AdobeCode>{82D797CE-391D-41C5-A1B0-0A0A7923E90F}</AdobeCode>
    <AdobeCode>{489E0573-6F7F-4E9C-BC31-7BDED90ADC82}</AdobeCode>
    <AdobeCode>{6BED3CD5-8092-4C0B-85FC-97CDABEDE861}</AdobeCode>
    <AdobeCode>{9E08B116-B364-40AB-833E-5F6A13297270}</AdobeCode>
    <AdobeCode>{8468C1EF-51B4-4449-9590-E0890EC5CC6C}</AdobeCode>
    <AdobeCode>{A6AE3389-5ED0-4B1B-8822-135DFCCE710D}</AdobeCode>
    <AdobeCode>{F31EB872-964F-4862-9AA7-B08BB45EDFF7}</AdobeCode>
    <AdobeCode>{3BDC915E-F0B7-413B-B0D7-84BE4B434BE1}</AdobeCode>
    <AdobeCode>{12727A2C-CF4C-4161-AF95-AA67B044E989}</AdobeCode>
    <AdobeCode>{96716D3D-31C3-413A-A164-F142CFE471B4}</AdobeCode>
    <AdobeCode>{1F33C725-AFF0-4DD8-A3AB-61A7C6E007A7}</AdobeCode>
    <AdobeCode>{4221D776-A659-47B9-9398-88D5EC9BB3A4}</AdobeCode>
    <AdobeCode>{0713DBB8-3E1E-424F-981D-DBA9CA0C398E}</AdobeCode>
    <AdobeCode>{E5802BB7-3D2E-443A-A446-D896C134180B}</AdobeCode>
    <AdobeCode>{B11BACA2-487E-4333-9131-E41A9CDDE998}</AdobeCode>
    <AdobeCode>{24B2AB69-5DC7-4681-A23D-18ACC2A8FA9C}</AdobeCode>
    <AdobeCode>{92DF34A9-F240-407F-92D3-ECE060803ED5}</AdobeCode>
    <AdobeCode>{C3C68C4B-368C-4F8D-8E57-2669EF7A1B13}</AdobeCode>
    <AdobeCode>{480C4FC1-F13A-4B00-BE39-27678D69DD4F}</AdobeCode>
    <AdobeCode>{65E75B6D-E00B-4543-83D4-175BF461E03B}</AdobeCode>
    <AdobeCode>{3434F363-ACFA-4AFD-8BEA-FE3ABD6FC5BC}</AdobeCode>
    <AdobeCode>{35BCDA3A-79BD-47BB-A721-849F9DAC0017}</AdobeCode>
    <AdobeCode>{9D982AC1-1821-43B9-9B24-92B29098511B}</AdobeCode>
    <AdobeCode>{08F8840D-0D75-4DBA-A501-60A55FBAA03A}</AdobeCode>
    <AdobeCode>{3183D795-7072-4807-AE41-A4291C414143}</AdobeCode>
    <AdobeCode>{B64E42B7-E4CA-4027-84FA-59099CF6F444}</AdobeCode>
    <AdobeCode>{2B285F5A-8858-4743-8C23-64DFA3329856}</AdobeCode>
    <AdobeCode>{EB294169-F347-497B-8BBB-9D119334FFC3}</AdobeCode>
    <AdobeCode>{67D7CDB0-A403-4200-BD58-69F65A75B695}</AdobeCode>
    <AdobeCode>{BCB45B93-00DD-492E-96CF-88FCFB0E1C4E}</AdobeCode>
    <AdobeCode>{8ED35321-289E-48E5-9639-8B4BD8FCE9AC}</AdobeCode>
    <AdobeCode>{AD3BF031-1134-4F6A-AB4B-51A7608C191A}</AdobeCode>
    <AdobeCode>{8067118A-88D5-440B-9156-0981C850ECDA}</AdobeCode>
    <AdobeCode>{64AA0738-86B2-4259-9D5B-04D3D5AA4937}</AdobeCode>
    <AdobeCode>{2EC318CE-7898-4356-B6B4-FAC24F605E05}</AdobeCode>
    <AdobeCode>{A8F6E251-2774-468E-84BA-EB0D0C98B6AB}</AdobeCode>
    <AdobeCode>{A5BC3D6F-202E-4903-8DF7-3D038F797EB5}</AdobeCode>
    <AdobeCode>{385B16D5-7413-43F0-B1E5-96D09621801B}</AdobeCode>
    <AdobeCode>{C6A3549E-A8E2-469E-ABB4-86A881740ACB}</AdobeCode>
    <AdobeCode>{9BF671E9-7E51-4C95-BD17-93546182BBBE}</AdobeCode>
    <AdobeCode>{3D68A11A-7D64-4D77-87C4-8AE6B8B71D6B}</AdobeCode>
    <AdobeCode>{5396CDC3-D00B-4088-A3AD-B4E2E8D48C82}</AdobeCode>
    <AdobeCode>{A0A28328-34B8-4646-BC1E-685F92142D6C}</AdobeCode>
    <AdobeCode>{00217391-489B-4CA5-9D1B-73D56C5F5991}</AdobeCode>
    <AdobeCode>{0D9763EE-8099-4149-8CFB-8C297EC3D894}</AdobeCode>
    <AdobeCode>{833A773F-F30C-4DB1-931A-01D06C675E4A}</AdobeCode>
    <AdobeCode>{021BF003-327B-4748-BD6D-D800CE008809}</AdobeCode>
    <AdobeCode>{1176AEB5-DA6B-45DB-B644-C6ECBA0A5391}</AdobeCode>
    <AdobeCode>{BAB747EA-DA54-4A43-A3D0-33AC62761FD5}</AdobeCode>
    <AdobeCode>{93DBA5E9-6A3E-4A45-B89B-F64D949579A1}</AdobeCode>
    <AdobeCode>{DE9A895F-A348-492E-8EB5-93A5162BFFBF}</AdobeCode>
    <AdobeCode>{C5D86391-CFFE-4174-9A20-00773F808F3E}</AdobeCode>
    <AdobeCode>{355B41C3-84FA-47EA-8F59-BDD6241DBFCC}</AdobeCode>
    <AdobeCode>{1DEDBEF3-6424-4F6C-9565-801512ECD1FC}</AdobeCode>
    <AdobeCode>{FFEE4D59-1E65-4AA8-B57F-2B8EAC30BDBD}</AdobeCode>
    <AdobeCode>{23E47F69-156A-4A94-9C6C-5DC47D71DF63}</AdobeCode>
    <AdobeCode>{823985EA-A4A7-484B-B508-4785FC50F1AB}</AdobeCode>
    <AdobeCode>{8E4A6D58-BBB9-4216-9A8C-060B3659BF5B}</AdobeCode>
    <AdobeCode>{71B68D72-C03A-4C9B-B3D6-F34BBCB7851D}</AdobeCode>
    <AdobeCode>{6D7D9914-8AD9-4C03-A192-AB457E160288}</AdobeCode>
    <AdobeCode>{C5813E19-D989-432F-A87E-46D9CDBECB7C}</AdobeCode>
    <AdobeCode>{4DB45C99-DB58-4689-A3D5-8FD5F3B88A9A}</AdobeCode>
    <AdobeCode>{61C5DC98-8680-4A21-A5D0-9C9112F07413}</AdobeCode>
    <AdobeCode>{5AF358DC-61D8-4BFD-A4DE-F03C51A36B34}</AdobeCode>
    <AdobeCode>{BB708323-F4FD-4AAB-86A0-18DE58D8D761}</AdobeCode>
    <AdobeCode>{E8043131-ADB4-4F4A-9B8C-5A99FEC19A5D}</AdobeCode>
    <AdobeCode>{47CDC367-31A5-4711-9146-2CB1096B555C}</AdobeCode>
    <AdobeCode>{6FA6A66A-AC40-4BEC-BC0B-CCA9F0808594}</AdobeCode>
    <AdobeCode>{8992975F-CB1B-43FC-A9CE-83BD66FB8CC3}</AdobeCode>
    <AdobeCode>{459C48A3-6DCD-4644-965C-B5D54A182C25}</AdobeCode>
    <AdobeCode>{9C4ED71A-2F8B-4FF0-BB0B-B16BFD9AE076}</AdobeCode>
    <AdobeCode>{BE8211F8-233D-421E-955B-AD736CC4729A}</AdobeCode>
    <AdobeCode>{67272687-4DA3-469B-89CA-633C3A5478B3}</AdobeCode>
    <AdobeCode>{F7AB2AF5-ADFB-4305-A34A-8EF2F2BB7C82}</AdobeCode>
    <AdobeCode>{27C15FFF-FF26-4E13-B6B8-C5976996A125}</AdobeCode>
    <AdobeCode>{1EC76F02-6AFB-437A-BB01-D67B056011CA}</AdobeCode>
    <AdobeCode>{64CA1539-973C-463F-A99F-A53EFD39F3A6}</AdobeCode>
    <AdobeCode>{6A5F2FA5-FD33-41E8-B456-B44BE8ED6819}</AdobeCode>
    <AdobeCode>{2486128E-90D6-4686-B934-5C01CABFC4D8}</AdobeCode>
    <AdobeCode>{339E1ADA-5D0D-4335-9F26-D9EFC76F2DC5}</AdobeCode>
    <AdobeCode>{76D1C92D-AC08-4513-BCD7-841850F94ED5}</AdobeCode>
    <AdobeCode>{398DD229-4D44-4806-BC25-E05C5D4423DD}</AdobeCode>
    <AdobeCode>{6125717B-8CCA-4716-BE09-22DF7AF32D69}</AdobeCode>
    <AdobeCode>{36024268-B97E-49F8-8E6D-4073955763CD}</AdobeCode>
    <AdobeCode>{C7C942A9-4AE1-4118-939D-630EA307E9DE}</AdobeCode>
    <AdobeCode>{BED7EC26-E626-4EA8-927A-AD60BE458D75}</AdobeCode>
    <AdobeCode>{529BB679-32AD-4E5A-ADC1-C4ED3C24B1EC}</AdobeCode>
    <AdobeCode>{87AFEF17-A618-4717-B7E1-C2C93BCCBE38}</AdobeCode>
    <AdobeCode>{B509BCFC-B1F9-44C9-846D-4CCF9AC313B2}</AdobeCode>
    <AdobeCode>{6E143120-4282-4457-85C3-713F555CD054}</AdobeCode>
    <AdobeCode>{19D65B0A-F30B-46EF-800C-E817F4F72BDE}</AdobeCode>
    <AdobeCode>{1C6A183F-00BD-4703-B54E-D44909AF27C5}</AdobeCode>
    <AdobeCode>{62FD6B7F-86C9-4BFE-801F-F30C557C3287}</AdobeCode>
    <AdobeCode>{1EF8D542-2204-4517-9D25-06C805EE8489}</AdobeCode>
    <AdobeCode>{362BC19D-EEF4-4C69-AF7F-EFBDD8DFEFC4}</AdobeCode>
    <AdobeCode>{02098A65-E194-4101-B3C0-81C4028AA230}</AdobeCode>
    <AdobeCode>{AD9F3EAE-D34D-40F7-A6EA-77E14F5DD285}</AdobeCode>
    <AdobeCode>{99041B31-DCAA-46B0-9E46-6B45E7534C8D}</AdobeCode>
    <AdobeCode>{1CAF629F-BB15-4641-B30C-15F1B34B1DDD}</AdobeCode>
    <AdobeCode>{5361D036-0833-4B56-8236-FCD85D3277A9}</AdobeCode>
    <AdobeCode>{169DFCE8-D111-40FF-960A-DC52E1D80E43}</AdobeCode>
    <AdobeCode>{E5CE3189-7AAD-4695-98CF-71AA9E843BE4}</AdobeCode>
    <AdobeCode>{434FAC93-0067-41ED-B982-A0007602A51C}</AdobeCode>
    <AdobeCode>{5ACA1C87-61B9-46E9-A947-8BCAD1C28F3A}</AdobeCode>
    <AdobeCode>{2636DFF6-8700-4996-B223-AEDBE4410E83}</AdobeCode>
    <AdobeCode>{05DDFA16-7260-4534-9E8F-94615EAAF3A2}</AdobeCode>
    <AdobeCode>{C87A592B-8974-40BA-B80C-2282F3E3E2EF}</AdobeCode>
    <AdobeCode>{A1BCCF0D-1137-4201-AD0C-696169AF55DB}</AdobeCode>
    <AdobeCode>{51A0C0CD-A650-4FCE-AD62-9B3E3A5FC801}</AdobeCode>
    <AdobeCode>{04D0EEF3-3A77-49E7-9CF3-B418A98D8FC6}</AdobeCode>
    <AdobeCode>{1B596724-D085-48FB-9491-BDED716EC80E}</AdobeCode>
    <AdobeCode>{ADA51F4F-1363-4BE5-B798-EFEA26FEB077}</AdobeCode>
    <AdobeCode>{28D6B854-1EA1-466E-9657-843B9F5055BF}</AdobeCode>
    <AdobeCode>{D03CB540-C714-4AE9-8129-CB7BD5C05D45}</AdobeCode>
    <AdobeCode>{DC017DD0-8DA6-4835-BB41-D214FFDF29C2}</AdobeCode>
    <AdobeCode>{1ADD9EEC-04F9-4928-A246-AC7B63FBE25B}</AdobeCode>
    <AdobeCode>{F7F6293E-2234-4A9E-A71F-28BA94299316}</AdobeCode>
    <AdobeCode>{7B776D65-6689-4DAC-94BA-D47EE3AA2372}</AdobeCode>
    <AdobeCode>{41F349CE-7852-444C-804A-9074274D266D}</AdobeCode>
    <AdobeCode>{44D6E83F-8FA1-4F1E-8EAD-5C21AF9FA912}</AdobeCode>
    <AdobeCode>{C4F1AE65-E1E1-46B0-BE34-CAF3CF9B2BAC}</AdobeCode>
    <AdobeCode>{F1C988ED-6CED-4786-82A6-50917C4AF3DC}</AdobeCode>
    <AdobeCode>{6C6C5887-B0AA-4E78-B0E3-6779425D026A}</AdobeCode>
    <AdobeCode>{6CF4AFCC-851E-48B8-B7ED-564B3F001613}</AdobeCode>
    <AdobeCode>{E11BF272-B8B9-47F7-9A97-D1E6FC27ED85}</AdobeCode>
    <AdobeCode>{4DE6A599-E3BB-40EF-BC60-DC2559C20970}</AdobeCode>
    <AdobeCode>{CB2FF902-C83D-4B6E-8745-64AED222B60B}</AdobeCode>
    <AdobeCode>{C32D486D-AA69-4460-9011-EB24AB23F0F4}</AdobeCode>
    <AdobeCode>{234EE2FA-6E9E-4CC7-AE66-492012BB1157}</AdobeCode>
    <AdobeCode>{769C3CBB-A7DB-4D74-B579-FDCAA8E018DF}</AdobeCode>
    <AdobeCode>{201F38F2-915E-453F-A9E3-401AA63A7535}</AdobeCode>
    <AdobeCode>{54D50CBF-D711-4575-AD1F-CF7A4A4A4A2E}</AdobeCode>
    <AdobeCode>{35A7FC4F-0205-496F-8FB3-8E3CDC80A0C7}</AdobeCode>
    <AdobeCode>{7AB1D2C6-5796-420F-A9A9-307B9D8DBDCD}</AdobeCode>
    <AdobeCode>{1FB0DAA8-2835-4F3E-9C79-8A3DF149662D}</AdobeCode>
    <AdobeCode>{C8857121-0851-4BD5-886B-A3FBE1991C59}</AdobeCode>
    <AdobeCode>{72F0A7B6-CFE6-4689-B88D-76911CB32608}</AdobeCode>
    <AdobeCode>{A57A32D0-84FE-443D-B1F6-AC9DBE1A7763}</AdobeCode>
    <AdobeCode>{FB4A2648-F7A3-48C3-AB19-85D65FBF786F}</AdobeCode>
    <AdobeCode>{F13D7CBC-E74C-4802-821A-5ABB82EE67B4}</AdobeCode>
    <AdobeCode>{DBA2357E-E77D-44E1-9B1D-AE71B95F6C9A}</AdobeCode>
    <AdobeCode>{0800FCEA-13AB-47FB-90FC-EC3E3FE5A7D2}</AdobeCode>
    <AdobeCode>{8990600D-405F-49E8-8A2B-456D9E43CFB0}</AdobeCode>
    <AdobeCode>{E72E5D46-44C4-41C6-A4E7-4060DE2AC6FF}</AdobeCode>
    <AdobeCode>{F0F9DA19-07CA-4DC4-84CA-572BF51040B9}</AdobeCode>
    <AdobeCode>{76DA4991-00BA-41A0-9E26-FA84CED62ABB}</AdobeCode>
    <AdobeCode>{7B6FF34C-9376-4416-98A6-E5539F79128C}</AdobeCode>
    <AdobeCode>{A4DDF30D-4607-4FA1-A7B1-6A862C48743D}</AdobeCode>
    <AdobeCode>{887044B4-6B73-47BD-8EA9-A30EE323075C}</AdobeCode>
    <AdobeCode>{03EB2EF5-6993-4C2D-A326-670B36B93524}</AdobeCode>
    <AdobeCode>{3FC24BCD-B0D6-4251-81E2-B8EDB76D0F32}</AdobeCode>
    <AdobeCode>{D244E30F-E9BB-4D83-8B56-2993606C0B6B}</AdobeCode>
    <AdobeCode>{496BC69F-EB62-41BB-A95E-F2BB51E53231}</AdobeCode>
    <AdobeCode>{25D63A98-2080-44F2-A0B3-692C2F7A2692}</AdobeCode>
    <AdobeCode>{85695B8A-D626-4158-BDC2-B9F9B2461607}</AdobeCode>
    <AdobeCode>{F4B1CB06-9FC3-423A-BCC1-C8FBD360D325}</AdobeCode>
    <AdobeCode>{086604B5-E5A1-4DC4-A49C-8A2EBE5F78AE}</AdobeCode>
    <AdobeCode>{2052DF92-F743-4623-BBBD-0C415B121F7C}</AdobeCode>
    <AdobeCode>{0D1FA38A-63CF-4CAF-A51D-6812984D03CB}</AdobeCode>
    <AdobeCode>{3D3C0ED3-1257-4515-8316-35A3CE5DB62A}</AdobeCode>
    <AdobeCode>{6693AA3E-9906-4C68-A4A5-AD86CFCAAE2C}</AdobeCode>
    <AdobeCode>{B4B8179B-19B5-479A-9711-CDE0835AEAB6}</AdobeCode>
    <AdobeCode>{D94FE971-1790-4532-B556-82211B8D1852}</AdobeCode>
    <AdobeCode>{D5FFEFF2-6083-4AD5-BD1D-74DB7013B659}</AdobeCode>
    <AdobeCode>{B58B2438-7B92-4825-B10F-7067F95D902A}</AdobeCode>
    <AdobeCode>{EF54ABCC-1A8A-43C9-8CAC-B2ED9648193B}</AdobeCode>
    <AdobeCode>{C1CDCEEA-76D1-4316-8F87-35AE11168F4F}</AdobeCode>
    <AdobeCode>{F4FDF8E5-A695-4E8D-8E0C-C685A774CEFA}</AdobeCode>
    <AdobeCode>{7D2E4D3F-3990-4EA9-86F9-DE02E780F093}</AdobeCode>
    <AdobeCode>{74FF2A2B-2BA8-48A6-95CD-1130C2517011}</AdobeCode>
    <AdobeCode>{BB83F9F8-F6BA-4B19-BD8A-4A93E15E9E30}</AdobeCode>
    <AdobeCode>{1E4C5E83-995E-4677-80B2-E802F1658D45}</AdobeCode>
    <AdobeCode>{1497CC52-8469-43FA-BD1E-BADCE8179B9F}</AdobeCode>
    <AdobeCode>{4C00CF92-A1D2-4C0B-9EF4-8677EF1D05A3}</AdobeCode>
    <AdobeCode>{EBEB34C8-27D7-482C-9BBF-CE5D315BBD84}</AdobeCode>
    <AdobeCode>{814E43D2-5BB3-408C-8C86-0CAD24A9323D}</AdobeCode>
    <AdobeCode>{4673A985-A693-43C1-B350-3BAF6965831F}</AdobeCode>
    <AdobeCode>{6E237C5F-49B0-4741-83CF-16FE688FA0F0}</AdobeCode>
    <AdobeCode>{03D9D331-F7C5-4379-BE00-700930F2EA5A}</AdobeCode>
    <AdobeCode>{2A8FDED3-514F-41F3-92B7-77C94878BB79}</AdobeCode>
    <AdobeCode>{9B446645-95FA-48B7-90A4-444A2623C83A}</AdobeCode>
    <AdobeCode>{EAC0F810-B26A-4FC6-BF9A-BE9370C4C588}</AdobeCode>
    <AdobeCode>{3532A60A-0AB2-4F9A-A118-F3FA48442F0A}</AdobeCode>
    <AdobeCode>{24686BBB-E969-4690-A2B0-96F3A988040B}</AdobeCode>
    <AdobeCode>{9FEC632F-48AA-4DAC-B587-AA27D8C16246}</AdobeCode>
    <AdobeCode>{6AE3E14F-188A-4314-8C46-3C8E0705C3EF}</AdobeCode>
    <AdobeCode>{4AC78A97-F473-44E2-85DD-A104E4BFE29E}</AdobeCode>
    <AdobeCode>{38251553-DE77-420D-AC75-F76B888C37E5}</AdobeCode>
    <AdobeCode>{A9D0B9E3-43F4-4AEE-A935-120DD9B4D856}</AdobeCode>
    <AdobeCode>{5833160E-5191-42CC-8D12-447B6C1AADB1}</AdobeCode>
    <AdobeCode>{4E6C817B-EAC5-4B4D-ACE0-A0E5BA921520}</AdobeCode>
    <AdobeCode>{2DD7471E-2F12-4C82-A225-BA418EC663BB}</AdobeCode>
    <AdobeCode>{8CDA2AF4-BCC9-4285-A18D-546DDB1CCB52}</AdobeCode>
    <AdobeCode>{606FF3FC-0DBA-4581-B380-849E6A080932}</AdobeCode>
    <AdobeCode>{205CA158-A64F-447B-8165-A4B1877C6BF9}</AdobeCode>
    <AdobeCode>{7094F240-ABC1-408A-8598-ED5C5A2E68A2}</AdobeCode>
    <AdobeCode>{2202194F-BA2A-4E17-8CD2-CC5D468AFFC0}</AdobeCode>
    <AdobeCode>{531A9D7D-04B8-4681-8CCA-E2E652B5936A}</AdobeCode>
    <AdobeCode>{C0828F09-DDDD-4DB0-9310-607A84A7FB16}</AdobeCode>
    <AdobeCode>{14972A7A-1998-4267-B3E8-6D1F710FD14B}</AdobeCode>
    <AdobeCode>{EB17C708-72C1-4057-8092-CDA79CC89422}</AdobeCode>
    <AdobeCode>{8088B004-9C58-4E5D-911F-EC3B27EE18E2}</AdobeCode>
    <AdobeCode>{6B76F0E4-3F4F-4E29-B5DE-2BE58B642BF9}</AdobeCode>
    <AdobeCode>{77DCB379-3EB4-43C1-AAA4-8E617B7EADC6}</AdobeCode>
    <AdobeCode>{97062D96-EE03-4910-8187-949E3ED25619}</AdobeCode>
    <AdobeCode>{E46C6366-25B6-4982-9A1B-3ADF0DBC9C70}</AdobeCode>
    <AdobeCode>{7129AC35-26A2-44C5-84B8-1BC0C45E4566}</AdobeCode>
    <AdobeCode>{59A2F410-EC0A-44F2-BD54-5EEA7A7D96C1}</AdobeCode>
    <AdobeCode>{ADA76273-5571-4C44-9D20-A5F4B48C8C79}</AdobeCode>
    <AdobeCode>{6B6F1092-4D14-428E-8DE2-E62D16EBB876}</AdobeCode>
    <AdobeCode>{16DA2C64-59E8-491A-BC62-0A0C63719FD3}</AdobeCode>
    <AdobeCode>{EA7192BD-B1DB-4DE9-B479-27D9ED649CA9}</AdobeCode>
    <AdobeCode>{54AB7647-45D1-4C1A-B598-C5CCA73A008B}</AdobeCode>
    <AdobeCode>{6E79FAED-4F16-4DA0-BF01-D8CEB67BAF6B}</AdobeCode>
    <AdobeCode>{684F79CE-582B-4BCC-BA8F-1504E2341BC4}</AdobeCode>
    <AdobeCode>{6B9E9006-7451-4DA3-A676-B01D1D933D6E}</AdobeCode>
    <AdobeCode>{89F40A86-AE7A-4CFF-A4DC-1DDF802E7EB9}</AdobeCode>
    <AdobeCode>{C3D2E20A-7390-4558-BB1E-9FE3B9217B47}</AdobeCode>
    <AdobeCode>{79F901DD-0D66-4D24-94CC-1D344D120F7E}</AdobeCode>
    <AdobeCode>{E18BE01E-DB11-4FBA-AC3D-2BCD32DD2666}</AdobeCode>
    <AdobeCode>{7E3126D8-4A2D-4057-B835-97444801F793}</AdobeCode>
    <AdobeCode>{C9D6221B-D740-4063-BF91-665F8FDEBC40}</AdobeCode>
    <AdobeCode>{8B1FB787-EED5-4FB7-A44B-415A3C497B40}</AdobeCode>
    <AdobeCode>{31A6FAAB-AF82-4C33-871D-DE29CA03B2DD}</AdobeCode>
    <AdobeCode>{2917BA33-6316-474A-B0FD-A0A989BCBCB8}</AdobeCode>
    <AdobeCode>{E0E071A4-E4F6-4C51-9952-DD4C25ABB6AF}</AdobeCode>
    <AdobeCode>{3DD65C54-430B-464A-BC83-E662EB21BD4C}</AdobeCode>
    <AdobeCode>{C96EA15A-7C06-476C-B0C0-212D5686DB22}</AdobeCode>
    <AdobeCode>{77F32508-E7AE-427C-AA88-724A18E538A4}</AdobeCode>
    <AdobeCode>{1F7A538D-5A81-4356-A400-958B2017274F}</AdobeCode>
    <AdobeCode>{12E5C0D1-D8D7-4405-A2DA-8922446B62C3}</AdobeCode>
    <AdobeCode>{11774808-CE7F-4C29-B415-824F371B4E9D}</AdobeCode>
    <AdobeCode>{F239CE98-C5CC-4266-8F94-5EB69644A1D4}</AdobeCode>
    <AdobeCode>{C7490FF4-9194-44D6-80C2-6C11CC16FBD8}</AdobeCode>
    <AdobeCode>{1C32F7EA-4879-4508-88E4-D4002FD1CC61}</AdobeCode>
    <AdobeCode>{1B86D4F4-DD8D-4303-8C8F-DB33537D8CFE}</AdobeCode>
    <AdobeCode>{D6BFEBD5-A0A7-4593-903A-20EA80A13DE3}</AdobeCode>
    <AdobeCode>{2DE72118-4C08-4D2D-B866-CC5A9161F539}</AdobeCode>
    <AdobeCode>{DAA11836-F832-4DFA-A143-31D20FF75C7A}</AdobeCode>
    <AdobeCode>{FF4A22A9-C243-4A1A-A06A-0AE3B8907536}</AdobeCode>
    <AdobeCode>{88A9268C-DABF-44D7-8040-DD9FCA8F32DA}</AdobeCode>
    <AdobeCode>{765109AA-283E-41BF-9699-7D1556D34793}</AdobeCode>
    <AdobeCode>{E452634F-F2D1-418A-9D10-01F81017CDEF}</AdobeCode>
    <AdobeCode>{E7C65EDE-AA21-48D9-870C-B1FF712345A4}</AdobeCode>
    <AdobeCode>{EFD71ECF-CBCC-4159-9F46-D9443B22CA75}</AdobeCode>
    <AdobeCode>{2CC5E357-D420-460C-A63C-F8B5335DF012}</AdobeCode>
    <AdobeCode>{A9B55B19-187B-4601-A2F6-9327553412B7}</AdobeCode>
    <AdobeCode>{38B7B024-843F-44A0-B81A-7DFDA93CA7CA}</AdobeCode>
    <AdobeCode>{9403736D-027F-4F94-A4FB-0F835567F10F}</AdobeCode>
    <AdobeCode>{D215C379-A2E1-4439-A563-7C13069E43BB}</AdobeCode>
    <AdobeCode>{5FCE8DA6-BB95-4525-90F0-955ACB9644D6}</AdobeCode>
    <AdobeCode>{311EFAAF-06EC-440E-B267-FF6F71075ACE}</AdobeCode>
    <AdobeCode>{AFDB0254-1544-412C-A7FD-08BA441684BA}</AdobeCode>
    <AdobeCode>{3B0FEEE0-89F3-4F88-AA4F-5737E32DCF8A}</AdobeCode>
    <AdobeCode>{716F99EB-CF55-4BEA-BD45-5A84C57417F3}</AdobeCode>
    <AdobeCode>{E2DC79D1-A3EC-4C93-8D11-F8700AEF268A}</AdobeCode>
    <AdobeCode>{D3BFE9EF-0AF1-47BD-A1D9-E0D240030A20}</AdobeCode>
    <AdobeCode>{95539F5A-A28A-4D7F-BF71-D36C1ABF83A6}</AdobeCode>
    <AdobeCode>{1E2A2C89-2495-4E8C-9016-FA7B0DA8299C}</AdobeCode>
    <AdobeCode>{D01BA04C-DA01-4BAC-9569-63E24446F383}</AdobeCode>
    <AdobeCode>{FF687063-3173-438B-A6C3-707BBF5E658F}</AdobeCode>
    <AdobeCode>{A97B438E-128F-4A75-91CF-9018EA9D47EA}</AdobeCode>
    <AdobeCode>{254DBA29-52C2-4FE4-AED7-9B17314FA243}</AdobeCode>
    <AdobeCode>{F4493909-CE58-424D-AE54-53BBA06C91CE}</AdobeCode>
    <AdobeCode>{5C3C3DAE-1A64-45BB-B32F-31372B61DB3F}</AdobeCode>
    <AdobeCode>{58ADA6BB-4B18-4B9D-8932-35724F2566F8}</AdobeCode>
    <AdobeCode>{0F7F6CB3-7B6A-45A4-BF03-62940445DC23}</AdobeCode>
    <AdobeCode>{EAD7A022-66F8-4CA3-8711-B8E1A3F42256}</AdobeCode>
    <AdobeCode>{460F7381-9ABB-467D-B7FE-7A789CB0ED12}</AdobeCode>
    <AdobeCode>{F9B6040F-ECC6-4285-BCA8-008816C6197C}</AdobeCode>
    <AdobeCode>{06779BAA-2018-4C44-8712-9786062E14C8}</AdobeCode>
    <AdobeCode>{3755E17F-FF81-4F45-93D3-8FF411786EAE}</AdobeCode>
    <AdobeCode>{FFFDB71D-9ED7-431F-A90F-7B512E6A0C87}</AdobeCode>
    <AdobeCode>{8D1B5E32-F367-454B-A8AD-32B730986859}</AdobeCode>
    <AdobeCode>{A765EBC3-7BDC-4810-B1B5-6C0F9633ACF1}</AdobeCode>
    <AdobeCode>{39E716B3-9ABF-482E-B15A-CB1D219620E1}</AdobeCode>
    <AdobeCode>{211C5D0C-B73A-4482-B6D1-5F4AE8770F14}</AdobeCode>
    <AdobeCode>{58AFC45D-4A2C-432E-8221-E2ACFC029B88}</AdobeCode>
    <AdobeCode>{2087DD7A-BE6D-4A7E-B4D7-9DC201C09C83}</AdobeCode>
    <AdobeCode>{75E2AC9B-BA38-4738-B018-BCD8BB1A5BCD}</AdobeCode>
    <AdobeCode>{2E42803C-E795-4352-946C-4C805D98F5E4}</AdobeCode>
    <AdobeCode>{E963D74F-CDAC-468C-9238-EC725700B083}</AdobeCode>
    <AdobeCode>{7D24BEAD-CDD5-49F0-8655-D7D6EEE5162B}</AdobeCode>
    <AdobeCode>{E6E57A92-C417-4B50-ADAB-97D021A3CF52}</AdobeCode>
    <AdobeCode>{637C59EC-E004-4C43-A32B-B358BBCD6B1D}</AdobeCode>
    <AdobeCode>{795ED090-B0AF-428F-A678-D13976844974}</AdobeCode>
    <AdobeCode>{FC487BA8-5611-4D14-A106-242AF710FFD4}</AdobeCode>
    <AdobeCode>{397478E9-E773-444A-A0BF-E4BF6C754E6E}</AdobeCode>
    <AdobeCode>{A2BE7F22-1653-469C-8994-FA8A6B82148D}</AdobeCode>
    <AdobeCode>{CC2CC414-619A-445C-8BAF-308A5AA63611}</AdobeCode>
    <AdobeCode>{654A5572-91DC-43E0-9D42-0162EB632FD3}</AdobeCode>
    <AdobeCode>{B0AE6AE8-0434-4A10-A3EE-657381AA14B5}</AdobeCode>
    <AdobeCode>{316BECBE-20FA-4715-A490-FEC7EAC6E108}</AdobeCode>
    <AdobeCode>{ADC2E345-3780-4230-8EE1-C58BB63CB552}</AdobeCode>
    <AdobeCode>{61C4A8D3-92F5-4976-8D6F-B4E6307291F7}</AdobeCode>
    <AdobeCode>{0B478F47-98C5-4257-9F55-24574DF61CCE}</AdobeCode>
    <AdobeCode>{7A511FFF-0211-4764-99F6-23C1874FC6FE}</AdobeCode>
    <AdobeCode>{62759074-BD96-4467-9FE1-1EF2D1583E2C}</AdobeCode>
    <AdobeCode>{1F926D67-4C4E-4BCF-9250-A67741A0F284}</AdobeCode>
    <AdobeCode>{6F5E6EA2-7AD8-494B-A6CD-C5E19135EC45}</AdobeCode>
    <AdobeCode>{6485425B-719E-495C-ABF9-3211DED27963}</AdobeCode>
    <AdobeCode>{B0D5EE95-FEF6-44DF-9D37-CC1572D04EF7}</AdobeCode>
    <AdobeCode>{E3734CF8-286B-49D7-B033-B1748ABCFA91}</AdobeCode>
    <AdobeCode>{DC725085-B805-4AA3-A21E-C1F9C0EA733A}</AdobeCode>
    <AdobeCode>{6ECE76DF-4EC1-451D-8A72-6F23E13F586A}</AdobeCode>
    <AdobeCode>{D0100C9A-8399-4355-81E5-D2BB49B67EFC}</AdobeCode>
    <AdobeCode>{E4A18ABB-111A-4EC1-A7D2-09D0CEA27BC6}</AdobeCode>
    <AdobeCode>{22D17909-EF2C-428C-B069-69B12D10FFC0}</AdobeCode>
    <AdobeCode>{C4F70FB4-C5D6-4C4F-A936-DA604BD99BC2}</AdobeCode>
    <AdobeCode>{81824B18-9080-4151-B73B-08A9E0116780}</AdobeCode>
    <AdobeCode>{0A7CC7ED-E07D-4F2C-8F88-0F43DB6EFD26}</AdobeCode>
    <AdobeCode>{30272670-B1DA-4096-88A4-EB96A2EF3B5B}</AdobeCode>
    <AdobeCode>{D961AC9E-9972-4702-8C04-BE32C78F45BB}</AdobeCode>
    <AdobeCode>{8442D7BA-637C-4B9C-9DCB-925C9AF91544}</AdobeCode>
    <AdobeCode>{50446164-925E-441C-91E4-BF27EED4103F}</AdobeCode>
    <AdobeCode>{FC2EEC3B-620C-4884-8626-C29544266A23}</AdobeCode>
    <AdobeCode>{C9AEB7E2-1871-470B-B05F-964A886F6736}</AdobeCode>
    <AdobeCode>{A0AAEBA5-7C33-4F77-AB6C-4FFBCBA8A842}</AdobeCode>
    <AdobeCode>{A0B83CC4-7CD3-435E-8B05-022B270EAC76}</AdobeCode>
    <AdobeCode>{6163C4A5-0D2A-444A-87FD-DEE493F77A29}</AdobeCode>
    <AdobeCode>{FC331E7E-95BD-4482-8113-2FA65EFD30BD}</AdobeCode>
    <AdobeCode>{265B6C2B-1931-48DF-BB52-BAFEB2BEF4F2}</AdobeCode>
    <AdobeCode>{0A1E2FE2-B2AD-42F4-9C74-641853FB093A}</AdobeCode>
    <AdobeCode>{C6783F5B-37C3-44B5-AE97-F75DF44BBB83}</AdobeCode>
    <AdobeCode>{6E4EE2A6-C107-483E-B136-D9E02EF2389B}</AdobeCode>
    <AdobeCode>{8EEC5817-3776-430D-AD30-EC879396A3C7}</AdobeCode>
    <AdobeCode>{7ED7FB10-DE1F-40C4-BF6B-48440982F04C}</AdobeCode>
    <AdobeCode>{662312BA-DA48-4BFD-9CA7-534652E90D39}</AdobeCode>
    <AdobeCode>{D6AF1C1A-912D-4D80-AAE5-446F8C0BE9B0}</AdobeCode>
    <AdobeCode>{7F812A79-10D6-47BF-81EC-6D2CF42CD52B}</AdobeCode>
    <AdobeCode>{715996D2-ABBD-483D-A26F-C140872CACCD}</AdobeCode>
    <AdobeCode>{2741DE8F-61E0-43D9-BB10-567E33FD2A39}</AdobeCode>
    <AdobeCode>{6555999A-56F7-4642-B32F-BE09B52B5374}</AdobeCode>
    <AdobeCode>{C6AFC8C5-6914-4564-AD42-21BFDEDBA7CB}</AdobeCode>
    <AdobeCode>{4AB72F9A-884F-433C-BCA7-A4AD8787C5AE}</AdobeCode>
    <AdobeCode>{1070A498-4DD1-496C-98BB-88112C8BBCFD}</AdobeCode>
    <AdobeCode>{845D8900-8A13-4911-B473-8AEED9D058C0}</AdobeCode>
    <AdobeCode>{9DC19726-6863-4C24-8F79-4541A9211EA5}</AdobeCode>
    <AdobeCode>{55ED4E06-39E8-4EDE-9759-60C802B40F45}</AdobeCode>
    <AdobeCode>{D0669A2D-2353-44FE-A097-51A73A8AD3E5}</AdobeCode>
    <AdobeCode>{2F3C1351-180D-4122-A16A-DC1A17B75C62}</AdobeCode>
    <AdobeCode>{991A706F-8468-4E29-8DD3-32A4A1DD4155}</AdobeCode>
    <AdobeCode>{FF2B40F8-336F-40CE-AF80-C635DE27BD23}</AdobeCode>
    <AdobeCode>{C6BBD2C7-464C-4FD9-94A1-77546583BC55}</AdobeCode>
    <AdobeCode>{B6683272-CCE2-414D-B29D-EACBBAD0140C}</AdobeCode>
    <AdobeCode>{A77ACEAF-348A-4D22-BF56-0D0E1597E8DA}</AdobeCode>
    <AdobeCode>{64E1C429-144B-4EC1-B7FA-87919C8A29A8}</AdobeCode>
    <AdobeCode>{A1768B72-0A6B-45FF-8ABC-8CC5C334E4B4}</AdobeCode>
    <AdobeCode>{A3CF3377-4EF9-4784-B101-0CBB20EE6D63}</AdobeCode>
    <AdobeCode>{1B8BD6DC-FD9D-46F0-B7FB-3BBD4DBA385B}</AdobeCode>
    <AdobeCode>{85045805-4216-4849-926F-B47AEA1DEC4A}</AdobeCode>
    <AdobeCode>{BC755D83-275F-4B0F-A82C-2BEC0B5C970B}</AdobeCode>
    <AdobeCode>{16F7648A-5EF7-4B34-8F8C-52E728928FFB}</AdobeCode>
    <AdobeCode>{2D78A9A2-B300-41EA-A593-76259F264494}</AdobeCode>
    <AdobeCode>{234F93F3-5767-4330-A949-775AA9248EBC}</AdobeCode>
    <AdobeCode>{2846528D-38CF-47FA-ABBA-D898092199AA}</AdobeCode>
    <AdobeCode>{1788E9A3-4822-4DDE-B2E1-28412F117056}</AdobeCode>
    <AdobeCode>{D79E8BCD-A7F9-4F2E-A92B-737907FB27F2}</AdobeCode>
    <AdobeCode>{BFC0A0F6-DDDF-40E6-96E8-985C0C6E6C11}</AdobeCode>
    <AdobeCode>{7597A909-A8D0-4245-B541-507BF55576AA}</AdobeCode>
    <AdobeCode>{0FEBF73A-5BF1-49E0-AF30-12C11B590435}</AdobeCode>
    <AdobeCode>{A82174F5-9B60-4962-99D6-FA9EFEF463C8}</AdobeCode>
    <AdobeCode>{B66B9A8D-1E5C-40E7-842D-9F502F5E0FD7}</AdobeCode>
    <AdobeCode>{26A928C5-013F-417F-B3DC-837D32A97C2D}</AdobeCode>
    <AdobeCode>{5E8016A1-D1FD-47CF-8874-6815685D1133}</AdobeCode>
    <AdobeCode>{D8825AC4-2EA5-4C85-AC1E-23ADB0CE11DC}</AdobeCode>
    <AdobeCode>{04C6FB4C-96DE-483B-9184-171E37311876}</AdobeCode>
    <AdobeCode>{DD234E23-805B-44EC-9120-9DEEFB4468D0}</AdobeCode>
    <AdobeCode>{901A431D-2AF9-4BA5-A0A5-CB2CBACD1E28}</AdobeCode>
    <AdobeCode>{E91AD757-F0F2-4580-A8A1-C151C4EEE3BB}</AdobeCode>
    <AdobeCode>{BF2089C4-CA0C-4402-8430-0BA4293A135D}</AdobeCode>
    <AdobeCode>{3EBD800B-A3C3-4324-B120-A0816ACAC3BA}</AdobeCode>
    <AdobeCode>{FFB59A71-0065-4576-AB06-E1AB9F727F73}</AdobeCode>
    <AdobeCode>{A9E0B086-E409-433B-98D6-D16AAB8D7F43}</AdobeCode>
    <AdobeCode>{78F2EABB-C3D7-44B0-A726-28313880951C}</AdobeCode>
    <AdobeCode>{B44A0C6F-F80D-4B0A-8E29-C2F14CD25306}</AdobeCode>
    <AdobeCode>{70958EF5-4C89-41FD-A655-0CCCE1F23E90}</AdobeCode>
    <AdobeCode>{85F8098E-D4EB-4135-ACEA-514DCA2E09F9}</AdobeCode>
    <AdobeCode>{417209BC-24B9-4CF6-BE68-18A1DECA7D6F}</AdobeCode>
    <AdobeCode>{2C1F4060-0CF5-4F2A-AC52-B198C5A57858}</AdobeCode>
    <AdobeCode>{C5154E97-6C0A-480B-B2D8-4E367A0F0567}</AdobeCode>
    <AdobeCode>{67E10674-4FC7-4B23-AA56-09C21442FE41}</AdobeCode>
    <AdobeCode>{2CEB18D5-16B5-4FBF-9E04-D1711D2ADF4F}</AdobeCode>
    <AdobeCode>{6FDA38EA-EFFF-4E87-AFEB-ED785ACE9A55}</AdobeCode>
    <AdobeCode>{BD4EF3B8-7F04-4648-9EBE-204FD4C65F27}</AdobeCode>
    <AdobeCode>{B224F5BC-CE0D-40C4-AB61-1AC3F9BC7B67}</AdobeCode>
    <AdobeCode>{82773387-3D3B-4903-8DCA-A7675859F98F}</AdobeCode>
    <AdobeCode>{379FD47B-C56C-49A4-903D-94567317DD90}</AdobeCode>
    <AdobeCode>{3AEDA0A3-D377-41E0-B759-4AB71E5DCF1E}</AdobeCode>
    <AdobeCode>{3465D2E6-22E2-46FC-B7C1-D5D0416B4262}</AdobeCode>
    <AdobeCode>{EA9A91FD-5398-45B8-86E1-7781662A8860}</AdobeCode>
    <AdobeCode>{5D6659A7-DABC-482F-9325-9E171D9049D7}</AdobeCode>
    <AdobeCode>{9DEE279B-53D9-424B-8887-1F6497656622}</AdobeCode>
    <AdobeCode>{FC810EDF-988E-42FF-BD3D-11AC3E34C7A9}</AdobeCode>
    <AdobeCode>{833729FF-3DB8-450E-BE36-A0F7E6189BA0}</AdobeCode>
    <AdobeCode>{19DF3EBC-6275-4893-B5B8-B55E06B69D7F}</AdobeCode>
    <AdobeCode>{5FDA1D1C-5723-48F9-9CF6-FB4CAC7FE739}</AdobeCode>
    <AdobeCode>{34526FA1-12B3-40B0-804E-3C0263760890}</AdobeCode>
    <AdobeCode>{53296484-1037-4F56-B978-CD678CE2319D}</AdobeCode>
    <AdobeCode>{636ACDD8-368E-4390-B95F-8B7EBA11681D}</AdobeCode>
    <AdobeCode>{5E1CE47C-BD60-47DB-BCBF-26E15318CC1A}</AdobeCode>
    <AdobeCode>{86DD1F80-0A27-42F5-9283-40815500C301}</AdobeCode>
    <AdobeCode>{BB2302AE-85C1-457F-85D5-7A8AE1ABB6E0}</AdobeCode>
    <AdobeCode>{23820776-03C7-4A16-B595-C12B480D652F}</AdobeCode>
    <AdobeCode>{93A1589C-DE51-4EA1-B896-6128FC2E42E0}</AdobeCode>
  </Upgrades><Channel enable="1" id="PhotoshopCameraRaw7-7.0">
    <DisplayName>Photoshop Camera Raw 7</DisplayName>
  </Channel><AMTConfig path="[INSTALLDIR]\Camera Raw 7\AMT\component.xml" LEID="Camera_Raw-7-Win-GM"/><InstallDestinationMetadata relocatableSize="20906157" sysDriveSize="0"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>20906157</TotalSize>
      <MaxPathComponent>/Plug-Ins/CS6/File Formats\Camera Raw.8bi</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[_OOBEHome]</Root>
      <TotalSize>0</TotalSize>
      <MaxPathComponent>/PCF\component.xml</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="1" name="Assets1_1" size="20906157"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	<Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr][Ff][Xx].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Dd][Nn][Gg] [Cc][Oo][Nn][Vv][Ee][Rr][Tt][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Bb][Rr][Ii][Dd][Gg][Ee].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Dd][Oo][Ww][Nn][Ll][Oo][Aa][Dd][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 9.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 10.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 9.0.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss] 10.0.[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp][Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Oo][Rr][Gg][Aa][Nn][Ii][Zz][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp][Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Ee][Dd][Ii][Tt][Oo][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ll][Ii][Gg][Hh][Tt][Rr][Oo][Oo][Mm].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ee][Ll][Ee][Mm][Ee][Nn][Tt][Ss][Aa][Uu][Tt][Oo][Aa][Nn][Aa][Ll][Yy][Zz][Ee][Rr].[Ee][Xx][Ee]$</Process>
    </Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">7.0</Value>
      <Value lang="be_BY">7.0</Value>
      <Value lang="bg_BG">7.0</Value>
      <Value lang="ca_ES">7.0</Value>
      <Value lang="cs_CZ">7.0</Value>
      <Value lang="da_DK">7.0</Value>
      <Value lang="de_DE">7.0</Value>
      <Value lang="el_GR">7.0</Value>
      <Value lang="en_GB">7.0</Value>
      <Value lang="en_MX">7.0</Value>
      <Value lang="en_US">7.0</Value>
      <Value lang="en_XC">7.0</Value>
      <Value lang="en_XM">7.0</Value>
      <Value lang="es_ES">7.0</Value>
      <Value lang="es_MX">7.0</Value>
      <Value lang="es_QM">7.0</Value>
      <Value lang="et_EE">7.0</Value>
      <Value lang="fi_FI">7.0</Value>
      <Value lang="fr_CA">7.0</Value>
      <Value lang="fr_FR">7.0</Value>
      <Value lang="fr_MX">7.0</Value>
      <Value lang="fr_XM">7.0</Value>
      <Value lang="he_IL">7.0</Value>
      <Value lang="hi_IN">7.0</Value>
      <Value lang="hr_HR">7.0</Value>
      <Value lang="hu_HU">7.0</Value>
      <Value lang="is_IS">7.0</Value>
      <Value lang="it_IT">7.0</Value>
      <Value lang="ja_JP">7.0</Value>
      <Value lang="ko_KR">7.0</Value>
      <Value lang="lt_LT">7.0</Value>
      <Value lang="lv_LV">7.0</Value>
      <Value lang="mk_MK">7.0</Value>
      <Value lang="nb_NO">7.0</Value>
      <Value lang="nl_NL">7.0</Value>
      <Value lang="nn_NO">7.0</Value>
      <Value lang="no_NO">7.0</Value>
      <Value lang="pl_PL">7.0</Value>
      <Value lang="pt_BR">7.0</Value>
      <Value lang="ro_RO">7.0</Value>
      <Value lang="ru_RU">7.0</Value>
      <Value lang="sh_YU">7.0</Value>
      <Value lang="sk_SK">7.0</Value>
      <Value lang="sl_SI">7.0</Value>
      <Value lang="sq_AL">7.0</Value>
      <Value lang="sv_SE">7.0</Value>
      <Value lang="th_TH">7.0</Value>
      <Value lang="tr_TR">7.0</Value>
      <Value lang="uk_UA">7.0</Value>
      <Value lang="vi_VN">7.0</Value>
      <Value lang="zh_CN">7.0</Value>
      <Value lang="zh_TW">7.0</Value>
      <Value lang="en_AE">7.0</Value>
      <Value lang="en_IL">7.0</Value>
      <Value lang="fr_MA">7.0</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Photoshop Camera Raw 7</Value>
      <Value lang="be_BY">Photoshop Camera Raw 7</Value>
      <Value lang="bg_BG">Photoshop Camera Raw 7</Value>
      <Value lang="ca_ES">Photoshop Camera Raw 7</Value>
      <Value lang="cs_CZ">Photoshop Camera Raw 7</Value>
      <Value lang="da_DK">Photoshop Camera Raw 7</Value>
      <Value lang="de_DE">Photoshop Camera Raw 7</Value>
      <Value lang="el_GR">Photoshop Camera Raw 7</Value>
      <Value lang="en_GB">Photoshop Camera Raw 7</Value>
      <Value lang="en_MX">Photoshop Camera Raw 7</Value>
      <Value lang="en_US">Photoshop Camera Raw 7</Value>
      <Value lang="en_XC">Photoshop Camera Raw 7</Value>
      <Value lang="en_XM">Photoshop Camera Raw 7</Value>
      <Value lang="es_ES">Photoshop Camera Raw 7</Value>
      <Value lang="es_MX">Photoshop Camera Raw 7</Value>
      <Value lang="es_QM">Photoshop Camera Raw 7</Value>
      <Value lang="et_EE">Photoshop Camera Raw 7</Value>
      <Value lang="fi_FI">Photoshop Camera Raw 7</Value>
      <Value lang="fr_CA">Photoshop Camera Raw 7</Value>
      <Value lang="fr_FR">Photoshop Camera Raw 7</Value>
      <Value lang="fr_MX">Photoshop Camera Raw 7</Value>
      <Value lang="fr_XM">Photoshop Camera Raw 7</Value>
      <Value lang="he_IL">Photoshop Camera Raw 7</Value>
      <Value lang="hi_IN">Photoshop Camera Raw 7</Value>
      <Value lang="hr_HR">Photoshop Camera Raw 7</Value>
      <Value lang="hu_HU">Photoshop Camera Raw 7</Value>
      <Value lang="is_IS">Photoshop Camera Raw 7</Value>
      <Value lang="it_IT">Photoshop Camera Raw 7</Value>
      <Value lang="ja_JP">Photoshop Camera Raw 7</Value>
      <Value lang="ko_KR">Photoshop Camera Raw 7</Value>
      <Value lang="lt_LT">Photoshop Camera Raw 7</Value>
      <Value lang="lv_LV">Photoshop Camera Raw 7</Value>
      <Value lang="mk_MK">Photoshop Camera Raw 7</Value>
      <Value lang="nb_NO">Photoshop Camera Raw 7</Value>
      <Value lang="nl_NL">Photoshop Camera Raw 7</Value>
      <Value lang="nn_NO">Photoshop Camera Raw 7</Value>
      <Value lang="no_NO">Photoshop Camera Raw 7</Value>
      <Value lang="pl_PL">Photoshop Camera Raw 7</Value>
      <Value lang="pt_BR">Photoshop Camera Raw 7</Value>
      <Value lang="ro_RO">Photoshop Camera Raw 7</Value>
      <Value lang="ru_RU">Photoshop Camera Raw 7</Value>
      <Value lang="sh_YU">Photoshop Camera Raw 7</Value>
      <Value lang="sk_SK">Photoshop Camera Raw 7</Value>
      <Value lang="sl_SI">Photoshop Camera Raw 7</Value>
      <Value lang="sq_AL">Photoshop Camera Raw 7</Value>
      <Value lang="sv_SE">Photoshop Camera Raw 7</Value>
      <Value lang="th_TH">Photoshop Camera Raw 7</Value>
      <Value lang="tr_TR">Photoshop Camera Raw 7</Value>
      <Value lang="uk_UA">Photoshop Camera Raw 7</Value>
      <Value lang="vi_VN">Photoshop Camera Raw 7</Value>
      <Value lang="zh_CN">Photoshop Camera Raw 7</Value>
      <Value lang="zh_TW">Photoshop Camera Raw 7</Value>
      <Value lang="en_AE">Photoshop Camera Raw 7</Value>
      <Value lang="en_IL">Photoshop Camera Raw 7</Value>
      <Value lang="fr_MA">Photoshop Camera Raw 7</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "0", "AMTConfigPath", "[INSTALLDIR]\Camera Raw 7\AMT\component.xml")
INSERT INTO PayloadData VALUES("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "0", "LEID", "Camera_Raw-7-Win-GM")
INSERT INTO PayloadData VALUES("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "0", "ChannelID", "PhotoshopCameraRaw7-7.0")
INSERT INTO PayloadData VALUES("{CFC3110A-491C-4DBF-A97D-66C567600A2F}", "0", "ChannelInfo", '<Channel enable="1" id="PhotoshopCameraRaw7-7.0">
    <DisplayName>Photoshop Camera Raw 7</DisplayName>
  </Channel>')
