CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F46EAF19-C62E-409E-8A85-2546E14851EC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5E38EA8F-106D-436d-9A43-5EDB151AA993}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4713F905-F06A-4E78-AED9-AEB164125487}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4A470B9B-D64A-4B65-803A-AA6967C62170}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BE2AAA07-8F95-4435-B615-1D33451716AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4A1CFA3E-71C0-42C6-A19D-415801ACF37A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{95A564CD-E7F6-4954-B714-ACBFECA4FF0B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3952DD6D-DA69-401A-878B-26637F91F360}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{63EF4929-2979-4785-B0B9-BEAF4127EE2F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4FABAFE1-B867-408A-8F77-1E7453E7126B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{06EA00A3-4461-4461-8731-4FD9DA167D35}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5A142F95-DF85-4C7C-9BE7-206989934CFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{60371889-ED9E-41F4-9A2F-48862028FE2A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6B405F32-374A-43A5-83D2-26BE82F96248}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{258673B7-C6B8-408A-B38B-9D8F268BD507}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1ED0BFB4-1694-449A-9AD4-BC024D7A840B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{27E50586-0555-4923-8E4D-A08F1D641C2A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5982B3BA-7A64-4D6E-B222-0D00285DC597}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{AD878506-1A03-4110-9702-656E99304248}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D4BA0EDD-1963-4730-84EB-095F1195C543}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4195A1DB-E747-4EF6-91B7-658256482E10}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E6680F4C-0CC7-4ADF-8023-52063F668AFF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{15D245E9-17AB-462E-B87A-8A3A734F0F9E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6FE253BF-1104-4A93-BB95-C4392DC366B9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{11929797-5CD5-4233-AB54-101FCDD3A03F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D8474C7F-5259-4ABF-BD64-F20F4AFD392A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9EF9D2E8-9664-4147-B7F3-FA4B80E4AD18}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{97A8E954-D267-4769-9853-3EF0F259EA06}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4B11CA64-0B86-4453-AC06-57BD649861FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8C96E7A9-E060-41F0-AA59-5678E5C307D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6A5544C8-F418-43D8-9D27-4E19C3BB5E7B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0ADC08F2-B744-4049-B240-36441554FA41}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{78F39EC8-134D-4660-BE4F-E7C4E17B1E5C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0CD2C592-13B7-47B6-BBF5-FB4C50C1AEC3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E020BDA2-D099-4E31-8586-44853EC7E690}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{50D5136F-839D-42F3-9343-6F5A62B53939}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A54A83C6-0F5F-4A9E-ABE9-5F19FD91B20D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D39D3599-AB31-41CD-8BC4-5B79D49B99D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A6F92A3C-AC45-424D-BE21-0654C6D2B3F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1BC7B3EC-517D-436D-BA47-9DD95A94E06F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{AC9E45EC-A422-4121-90B4-EC4A395AD8C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E9EB523D-D667-44EB-A804-77F24AA91E6C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3E0E007C-C85D-4ADC-9F16-EBED21D26CC2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{522A4B68-0282-4C67-82D2-CC1323FE3FE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C84DEB4C-8F82-4DCC-9273-7952B40F7ED7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{79CA2C27-7BD0-4CD9-8D17-1FCE7CC820B1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CD086B29-15D3-4DA8-8E98-1CB71B1DF015}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9145DE9B-3564-4872-83FC-EE11BB0E491E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A093C0C5-0408-4B7B-B5AC-099254FB03D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4FF0F828-D0FC-479F-9F1A-3BFE75CA184B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E5941A84-4868-4597-9071-E2C5ECF59B53}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{24C06C12-2AC5-444B-A919-3E44B7E0D686}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{784A98B3-FC86-43D1-8342-8248A786790E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{04801B4C-B7A1-4D70-A6B1-79BBCCFE6ACA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0383261E-6EEB-400A-90CD-97F63C9F23F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C0C9BCD1-5189-4549-9AA3-7407FDA4827D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{70EAEC3B-E722-4C13-9BBD-690B79134BFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3DE08C59-2178-49A5-A8A2-0CD316A80DFA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FA8C6B01-839B-4BDB-934C-13F538A94F5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3099756C-3E45-405E-9B06-219139105CFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{47243908-0E10-49C9-9F86-BB9FF8AFF840}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C71101D9-5B2D-43B6-B779-5855D4D489A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8B784A1A-4312-4C62-BB75-DEFC8D7595D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0413E679-4D23-4EE5-BD93-EA09BB6980F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DC9D0DB2-9F8A-4F3C-854D-7287A2F502F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D934114F-4497-4B45-905F-DACC40AC3C15}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DAB1A990-CF4E-4CC9-B8BB-F99EAB65452E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EA9F770F-5332-4C11-96AF-C91DB344E8A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{34F296FE-C6AF-4DB2-B314-CBF29B088733}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EC9B1B78-06EE-4522-9AD8-31575B9E8202}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EEEAF7B2-51FE-4AAB-B26E-83B83DEEFB97}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BDB8D7DF-37DF-456F-AE2C-C51A888A6016}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1482B68A-AA94-4679-A696-B268CF44AF9E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C2162B86-A64C-4664-80CA-93B418F34F78}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{13D064F7-4896-489C-BE38-F342A7CC4896}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CEF75904-C47F-4439-8ED4-B3884586DD09}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B5482CC1-F23F-48D0-8ADA-03B2879A26EB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8CEA8CBA-0F88-4601-82A1-AD361AF8980A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{02BF1A34-C7AC-4C3E-B214-C07876381568}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E4B957A2-C755-4660-A766-1AD59F14A952}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7E7C5632-F74E-40D8-9EBD-20D4BC8EF3C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DEEB0AD2-1CD5-4334-B7E2-6D539FA75484}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9AE2E4E8-36DF-48BC-9B26-590923874E2D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{58679466-1351-46C3-B271-5E51CD680938}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C606656D-EDDF-49F0-96DE-0D1F83CA5814}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CEE07388-92B0-4741-9F2C-0F90168B5BDA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6552F9F7-A78B-4AA9-B462-37C6B99ED1D1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5E10FC51-134E-438C-9237-51B08EBAD097}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{93411628-A348-4EBA-B83A-6F3D4F2E827E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3D2BB002-0F46-44C8-B533-6B5520E4FC87}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{68E382C8-673E-4FD2-A483-6B6CC0B730F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{58F2C875-38F3-4117-AE3F-BFE5064859E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9FB61B98-70B5-44B8-8A52-F05F9528EA66}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D4A23BFD-85A6-46F1-A45A-0FFE59D2A05D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4A4F8BB8-7CF3-4450-ABA7-5636ACEEB84A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{00C06D4A-515F-497B-9611-8840511534AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{36481681-3DE6-4026-8A9E-83ED1F91CB47}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{57A64018-672B-44E0-9885-2AA88282446C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{34450FE1-EB5A-4F6D-B02C-648FC48D4905}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F7C48E6F-36D5-45FC-B097-C15FEB2E2847}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6F142611-13B8-4BDD-B029-A7AB279C9BD8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E1400D7B-BBE1-4701-B8C0-8FAE93745E17}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{56EC817F-C687-42C4-81E5-BFA90F78D42F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{36692E5F-4CB0-4EC5-A037-403A2602A7AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{13292C24-1EE6-4B5F-9D6D-E98C478345F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6CD7A24E-E72E-49CD-A9F7-CFE1EBC0D7D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CE630DD3-2486-4673-B434-7ED71E052F3F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1F28592B-07A2-4FD6-B59A-A3DA72647FB5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D4D79BAD-15C0-4E58-BEBA-E76BD03DEB98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A46B064D-C24B-4B48-98F7-6F8DC1EBA0D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{52F56A22-DC2C-4C9C-9773-02705A9B8A5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{51BE7E92-7359-4935-9168-D376B562E9BE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F935222F-D5D8-4915-BBE7-A2087B76C017}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3211E941-87C5-4CE1-B71B-33967ACCA54D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C824F6E1-B1A9-439A-AD44-9F84F241AE85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A9E54EE3-DD44-4433-A650-C9A8654ADEE6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A7136821-7395-4CDE-9418-F857BD764474}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{910DB454-B351-4AF2-9A45-2ECE4D3DE788}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9D4CBDF4-DC09-46BD-96E0-3BCA955BE13C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{2750B44B-0595-4B51-99B9-327EE4024119}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{AFE64ADA-9458-45B1-A750-39CFDF62976B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E31EA65A-01F4-4FB1-A5B9-D3B8CBB32BB4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DAD02C7A-D645-4A84-9203-91BC4B0BD024}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6981A267-CA4C-4F37-AAA7-BB3D374C0151}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D391812F-CDBE-4ED4-9FC6-AE0E0E541965}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A746D681-C3F4-4CF9-A889-056DA46F4D83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8C7BE264-E746-42BB-83B1-2ED323E8491F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A286BA6A-C0A1-4F39-ADE3-DC0529725201}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{AFE0646A-173D-41E9-97D8-72452E72C6D9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{25055C36-A9A2-491C-817C-CA018745E701}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BD6ED4DB-C4D6-4DD3-8542-9F559A69EAD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{AA6A3650-7D04-428A-BB49-0808F00F8196}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C2C1E2EA-AF73-4F0D-A4EA-CA899D2BD58A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6D42A91E-7A94-4523-A0C8-88CD10765636}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{AD9C9492-FFC2-4BB9-A13F-0B29C7F9FFF7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D663BEF0-3485-48F2-990A-C82194CDDF69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1CDFAA0A-12A3-46C0-884A-6E44DA606DCA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{2AEF1C35-2D14-42F5-8F1C-A04327B5966E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F117A0FB-5C64-4025-9C69-8DD98FF94D28}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5D2602BA-787B-4B82-A0D7-BE3E1E2E89A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C1E4C0F6-5AD5-43FF-AF19-7FA55319AA9E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FEBBD97F-340E-4564-911C-41CCB5FE6661}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FDA3D25A-CA84-400A-947E-E2157FFFAECA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{80B37CC5-88CF-40FE-AEC3-984B56A86C54}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BD33ACFF-D9B2-4033-8809-2EE354ECAEF3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8DB90744-4EE8-4577-8A9C-EE1DDF1E96BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F3B002EB-8070-4014-855B-175BB2851B42}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7828BA26-86B7-4674-AFF1-A386BDA78CBF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B43B075C-77AE-4A89-B030-97977914BD44}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D56C2484-9243-4FFC-9F13-0C152E2E7E0D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C0AC0C1A-2A4B-4B14-9FB6-96FFFABF4537}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{49BCF039-A434-4E7D-94FE-F9908C60E052}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BA4E645D-966D-4C96-A4A1-A9729C51B9F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{02D81C1A-234F-4062-9E0E-C7FE2C8200D4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B418BC21-BAD2-48D0-96FC-7C7CB70FDB1E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7E1D0A40-D494-448B-B52E-1FAC1361E61E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6CBA3044-857F-4325-AA4C-C7E3F405268B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F0B6DC5D-F6A2-459D-9ECE-1ADA9B897441}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0F7C54A4-0E13-445D-92DE-BD53E166460D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E78B534D-9CA3-4CB6-8B43-3A40A83123F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{86C36B7C-F423-42B4-BBFE-C72FA7DE934E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{19A37370-091C-43CB-821D-E10825432934}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DB355314-07C9-40F6-8FF9-D31FFA894B49}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A4EC440C-024D-48B8-8674-175A136A369F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CA711759-9FD7-4887-8106-0B78B320B11C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E32C92FA-5048-4598-9440-B71924D22189}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A4751C6B-C13F-4AFF-9C06-E98E8B23792E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B43E977C-33DA-44D9-A38A-D894A62E0767}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F9C47909-6140-41CA-B484-464FF64CACD5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3D4D5E35-810D-4B0B-92A0-DEB8A36811D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8F4824F9-ABE8-4ED8-8840-079199DD2828}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4D09D8B4-69AF-4BF0-9C5C-FC7B813F436D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{12A68B28-A1AA-4098-8448-1F0AE6741617}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{846933F8-FFC2-420F-BE1E-0EB2750A7532}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FB96548A-9293-4534-96D4-76DBE8B5EF33}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E6EBCADF-B9B3-471E-9F30-161F80F2070B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C47C1A87-32EA-4FAF-8C44-1CC8E3550149}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5D6BB7DB-41AF-436A-A96B-25505FF090C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1A434883-28D3-4190-B738-277B04A948D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{34ED0200-CB88-440F-A0D4-EA24DA1DFB5A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7C8415B7-D75B-47F9-A2BC-1EB5B113D748}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C300E3A0-C742-476C-B999-39FC8B51A7A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E5301FAB-D2B6-4F59-9A25-C258E37E94EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{02B2AE25-2F4D-4DB4-AAAB-0F824207D7F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DD3A18DE-4226-408B-8D12-FA26710AF421}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C797E07C-80A5-4127-8C61-F225A7FD15E3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7CB2FA0E-E91C-4ED4-A6E8-74EAD7C5A612}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1D8F5EFF-EA61-417E-A1C7-C1C134A9C2CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{64BD4602-7010-4A60-9BD5-A3774AF17572}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E0A121D9-8D09-4DBE-B495-0F2D6042E7A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{45AAB2B4-861D-4B0D-B613-35E3C83D77DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9A87AB83-74FE-46FB-955A-9A0D614542DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9C8BE58A-33C1-4E4D-9E65-7D1D606ADACA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{49CEE435-7355-49BB-8504-5921B89AC8D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BC02498B-D371-4F18-96C2-DEAB0927E6BE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{00FF76CB-7A3A-45FE-B223-4CBC67025E2C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{463386B5-4277-47DD-BD5D-876C55A51969}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DA41FF5D-1584-49E7-8CCB-B45579DBFCE2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{99CEA660-AD17-4695-900E-F9F4DAE55EC5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5512FF1C-81D1-4773-9DC1-531AC1ADCCA7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CAFB4502-AFA8-4455-B577-2A0D290451F7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5CF39048-11C9-431D-8D03-B595ACB80A1B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{80C19226-81EE-442E-BE6C-CFAE11422895}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BE1FDBEB-07F4-411A-9882-0FD1A5071C3A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{2CA953EA-4BCE-4D92-ADD3-7BBCB062DC4E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BEB52E33-7EDD-4627-8946-3871A0BFEF4D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1A07A3B5-9158-43EB-A590-0DDD42BD7477}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{46BF72B7-18A0-49DA-B9AF-428CB8E940CE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{13A7E000-7168-40B6-89FA-5F09CDED288A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{866EBCC5-8DD0-4F1A-808E-D57191677CD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EE9C377F-2107-4C8E-AE01-3729037F9BFB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D843D08C-9B2C-40B2-B712-628C3D879084}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{625400B2-9AD9-4000-8156-79A32E0BFBEF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3CE07F20-CE7D-4A4D-8867-864D51F8E6F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5190AC29-9815-4829-AD83-39E2519DA697}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C46C09AF-2C03-4F77-AC91-35FFDB68888A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{084DE26A-21A5-4B8D-907C-A2A7CA55F82C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1049C710-D579-48F9-A741-2D3CB8A9B501}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EFE3EDA2-6E22-4015-B53C-A6763DD929E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{49038883-BF22-4F40-BEA8-3EB2E5030E3D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{12620A7E-B369-4C43-B690-82E043A3B5BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{40874E83-B3C5-4D78-8BDB-C7F139BFA34D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7FB5EBD8-C577-4294-B64D-720F008845D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C3180AC0-3B28-4AC8-B08D-92E9F2084571}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8EE5F2E5-99F7-4399-B439-FA488E660836}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9B10AE46-6B40-4CCB-A950-6B418D0EF5F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E4D78DB2-69BF-42C6-8CDD-5A3CE9E0E5AA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{60695A1B-0441-46B0-8217-9A80062DCF47}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{23F00765-0749-4E0C-9BCA-62B896C80ADC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B0BE1320-A85A-4884-ABC1-F3176CC2EAB3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C2FE0C5E-369A-434F-9CB9-FEF5CDA30A0D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3213DA64-FA72-4989-8053-A1B27E06F012}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{524736DF-9A79-464C-90F0-BA1FB1F2BA13}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{92B68C27-86A5-4600-B5FA-ADBBBC3EE392}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4F726952-4516-4B84-BF66-FDF19F0470A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5398306E-3B8B-439A-9B79-237FE5F181D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{154DD731-8BBB-4141-8C15-ABCD63168375}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{40FC5C32-09A1-497D-8226-7356EB75AAF6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0C4BADB6-1579-42ED-8F46-E235319F2DE5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F98FC65E-4DFE-4D67-94D9-66317323422B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6D78911F-C0DC-437C-A923-2C407D666210}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BA8A8FB9-7DF9-4BED-A66B-5665EB5BFE84}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{96950B2D-CC80-4FF4-AAEB-AFB7FB14B6AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E4BC69DE-1488-499D-BDED-74AF5BE9853B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E1B08F4B-F637-44D3-AB78-AABFC9DF000E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{361758BE-5D8B-4CA7-9FD8-75A5D7606C39}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F78822F6-5530-4267-A98F-FA4FA46DE7CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{473B7C13-4928-4D15-AC7C-529D111FBD7E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8007EC46-B258-4E25-AEE3-3251E844C346}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8F55826F-125F-45B5-8D1C-463ACD50DC3A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{54594B1B-AEF6-4D20-8298-0E1E2AD31735}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{65DED6AD-822B-49B9-AA33-087492227992}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{632CB292-8F38-4EED-A7A9-ABE50D05B33D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{47150C1E-0611-4290-9073-44743F499239}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7289E121-32C9-437B-AE96-71BE89416003}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{61CD5082-D922-4699-A452-8E451E678428}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3AF1D2BB-7A1C-463C-A7B0-621F877A331A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A81279EA-CACE-4724-855F-EB804EFC5D3F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7557C459-F86E-4000-9C42-71D26ACF71DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BD85E970-D924-4166-9925-BA88BDE785F6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A136684D-BEC5-456D-A604-5A2DC7BBE7CB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{05867531-2E63-4C9E-B051-87DA9AB8A417}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CFD0E763-CD20-4FF1-901F-95CF2E1CB4AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6EF1C589-A284-43AE-BAC3-209707190240}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{12AA8D84-76CC-4BE5-9481-F5686F22FFEC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{59BB3CD1-2C33-40B2-A204-3A15414210A1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{85B260BC-9E03-4C91-8990-8D32523089CE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{33FE1B1C-897B-409E-A5C2-73216949359E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{AB10E501-C014-427B-B2E1-3BC6BD17D4D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D23652A6-1212-4D5F-B264-633FF436D491}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4E9C6C40-7121-4841-A3CF-F813453CDE2D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C18F37CE-3D11-499F-80A4-F2A5D1F7373B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1A596F27-CE28-4EAD-A463-08782BE12FD7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{AEE58DE2-3CBD-4952-9EEA-ED21DD646E72}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9922FF62-A587-4089-B3E2-08A59133CA0F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EF9FFA02-0E8F-463D-9970-A57E673D6E12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6D049360-E389-47FF-B508-152A4B51EAD7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E7EE5BF3-2DB8-4EC0-9F44-6902052C5973}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D22C5A83-C2E5-42E7-A8F2-2A4D357CF45B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FB85FE4F-3312-46AB-B1E2-4930F5F97E91}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0A3D7088-60A5-4BD9-AA5B-4D48FCF7AFA5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4D966CBD-B9AE-44EB-904C-8C6FC93054DB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A9B32EF2-8765-4074-96C1-733DA6B53F6C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EA6DED97-ED43-436F-B2D6-E361D298E545}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B5148994-FFC4-4399-AE7B-3F34CD05C7A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6DD52846-EFC2-46B3-973D-0DEABD4FE5E4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5465ADC2-FB86-4735-BF0C-CAB7FF6A74F0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CB78092C-0D3D-4B15-94AC-42521854C1A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B0CA4EB4-808A-4149-9417-E7DF999A5D96}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{855D5AE1-5530-4AD4-A81F-2AA6362ED15D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{2E1F78BF-7114-4B70-8DF6-BDD089FDB261}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F395EAC9-5B5F-4FC2-9F2A-FDB35E83D03C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FBE784B8-E3D8-47BD-ACD7-2DC5585FC395}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4B670647-C4FF-4326-BBE6-18D095A9AF99}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EEBAA18F-9F47-4772-966B-D593ABAFCE1F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D3B13CB5-59BE-4451-BD3E-9E1F9AF589A1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{35F52DCB-6BDF-4748-93AF-03E14947E72F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EE9224D5-1047-429F-A512-82E3CA8B5C3F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D1EE0F1D-B38A-4832-B4A8-270C07C75432}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A475A98A-23B2-4865-BBD5-83911241630B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1D39F485-7F53-4EBF-A076-53C7DD6422E8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A35C2887-4D05-4D41-8473-4074C304F8FA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0C9122B0-8ECC-47AC-8931-05DB6868D667}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B3A53CAB-7C3F-4E35-828A-2F53A46198A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{01EF8527-75C5-4EE2-BE3E-AF298A12DABD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{28E5E248-7084-45FF-854F-1310C2E8A9B6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6B82936D-B6D3-45F3-828C-5F2AF87EEDE6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{37896A59-8978-49AF-8988-95D9912B0060}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{48727239-21AD-4444-9F5F-37AAF53B1A77}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EE9FF2FA-70C7-4840-97DA-86B745F88667}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3B502396-859C-495F-8A9C-D4E70AB7994D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{54C43E22-2AAF-44E9-A77A-94BF48425079}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D28586FC-BAD5-4EB4-A050-348F93CB1261}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8F2E0280-BBE3-4B9F-976C-CDB008EB737B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FF3881E1-273C-44E5-91EC-9DB807AD2FF8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A1F0BAF5-74D4-4A14-AFA5-49FE8136C932}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FF1E58CC-8549-4BA5-B5E9-608009986435}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3ABEB1C5-307C-4633-AEEF-3F62DBF2C9DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{54CB9030-6A35-4426-9328-71748216A884}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{04AB3C65-44A6-4DC3-9136-8D87D1117D1C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{21007E2D-0D3B-44CD-A07E-40819593B522}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{17A94F2C-2ADF-4BE5-9FCB-8C7592FED773}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FF1E43B6-143C-48BC-8886-9107644E7CA9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EC74B746-524A-4F89-93D4-0378561F43A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7AC10712-DA44-4115-95F6-9DC84A4CD8B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A79D021A-4C50-4295-83AC-0EC046C373B9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A7BA2D74-9863-432E-B992-D91EF45061D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{11C86F85-837C-4377-8FD6-1159B2C3A10A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DD29CB9B-4550-4A75-B9B8-507EDFD1D4D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{23435DBF-EAB1-4F7D-84FE-5C73C139B794}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0B9F1F2E-A91F-4921-8BDE-C8132679AE60}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A358C1A1-3A07-4680-B40C-B9D3343DDF7B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8E1556EE-4CA5-4E3C-8C32-2AE0DBDB3BB8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6C619526-5249-4EEF-9FEA-EC072181BC1B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{05D18608-9610-4397-A56E-A51AE61D11DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F27D2774-0068-4196-99A4-9D6E9BF17295}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{19674DB1-E28F-4137-919B-F0D49A321166}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CF28C6ED-EAA5-4CBD-A457-9547DCBD05C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1A46ECEC-0E32-4759-944B-DC6E12C3B055}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B6A46655-6EDD-4F45-941C-CBC64C327F60}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8769AB72-CA49-466F-856F-05479ED56016}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0E584F38-5542-41F2-8291-E8D45FD1BDFC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9191B0A5-DA0A-444D-9DA8-D88AC0CC9AC8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FCA9D3A8-7E65-4896-B7A3-BB925209DCB0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6EAB3B6B-19E8-4F26-BA34-0D6DD066E109}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E074F3E9-FD84-47FC-BED1-E572F71B1BAF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4CD91959-34FA-4EF7-9CEC-83A2384E4144}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4E664593-3E5A-4008-BBCD-80EAB19A1DD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9F6D5243-386F-46D3-84BA-4B0157544488}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BF6081DC-FBD8-48FF-B8C3-8042EDA4CF26}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6AC43DB4-51CE-4867-95AC-F0212B15C2ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{35DD31DD-0229-4B78-8033-9207723839A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D297C8D2-FB3E-45A0-928E-562379CD482E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C9EA3A72-0FCD-47CB-B271-3C14765D3B9F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1ECA5E5F-51EF-4D25-ABD9-F09326AAF989}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7D9ED791-341A-4F4D-BAF0-7D9FB3236669}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8F891302-075F-4E99-A795-46C7E8E72224}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C3F4D02A-809B-4537-864D-3575886B7F41}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BFAEDE79-F22F-4784-8A7C-DCF502AD4D1F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6F805F05-2404-4894-A22A-8CC6F7D04580}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C2026C27-D2BE-4AA7-A662-D5CC453AE9A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3154B671-596F-4B56-AE94-3C2628EAD4D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EE4B0BC0-C470-4F13-846F-C8CB46C3A224}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{76470281-ADE7-4B66-A2B3-F4359C83210B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5FAA071A-F47D-47E7-A2BE-F7A66FD33287}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7932F8EE-C7C7-4291-99B6-DA92F51E181E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{10460AC8-5CB1-4AB6-BFD7-B2E8BCB2CB88}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C170090D-AEE7-4AD6-B355-428F2C227608}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F6E5C657-801E-413F-88E3-62775D7E715B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DDFFC4F4-AF6F-4A09-8356-31049ADD5DBE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6F0FA794-63E0-4A56-97E9-42ABE42026FA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{69AAED52-61BA-43D0-ACDD-C97370A57992}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1C780B04-1893-418E-BD6E-C4A3F5A5A644}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F91EB724-58C7-4241-8C29-32E9D8E950C2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3FBAF0C1-E72E-4C65-A268-59FA98F08476}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1B4E8C2E-C376-4855-898C-935930DDA075}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C16D8C14-59D9-45B1-9057-4F06FC2131BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1D636BB2-C24E-401C-AABD-1461EECC6770}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D5AFFC13-C34D-40F9-A812-5980CC8B43DF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1AE85DB5-BC53-4194-AE12-7C8E1A87E3AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{283A703E-BBFB-4D8D-93D3-D3D05ABE98D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5283ED77-581D-48F9-A2F1-CC6DF286753F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F26951D1-5EC7-4D47-8DED-9FC185E7F85C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F44AB292-FB09-4BEB-ACE2-3C122433E8E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{084A1460-0578-4D8F-95A1-EAC96CC74199}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F3D6A6EC-10D5-4E45-8FDA-88F03F353CB5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{80625461-7BD1-4F3C-918B-6C333D18EA8E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DB2935E9-AB51-4625-8991-0FC99D70F0DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9496617D-FC9E-4AB0-A5AD-64417FF3EA7A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DA2A91EC-AE32-4138-ABB5-1176AC9DCA3C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E8632CBD-A455-45F1-8C4D-C2A14E0E0AF0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{866E2FE3-2FE8-4C0C-B472-5D816F47630E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A2FC240E-24F4-4B4D-900A-69C2644E9A96}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{12165EE7-DCB9-48A3-9658-5D54B26156CE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{973DB403-1A9E-4D45-B603-4AFBEBDA3B42}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{374D8627-4401-4EE2-A25C-F2A6F24123F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1ECEE78F-62A9-41AA-975A-075B9F4B7521}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5BFDCA69-4C1F-4AB5-AAEA-DE84D757536D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5CE95589-36F3-4178-B3B0-DC884FA09ECD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{AE581541-DBB9-42E2-AE2D-B02BAF8CFF6F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{730151E3-2938-4744-8F3D-680A5A6CB086}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1246D290-A992-473E-82E8-F8EFF08C05AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6D096089-FACF-4E33-8D54-DBDE5543B099}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{82197C8C-0168-484C-A468-D6A113F58A46}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0096676C-9A74-4EB1-860D-B40517C36D48}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1800EFB7-34BF-499D-8C67-1EABF70460C9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B583AC44-A43D-4380-93F5-59EB2F1BF5D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{53197C90-EDB4-4924-B01B-0DB51236D416}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{ACB69932-3543-4B74-BD1F-F01AD416D013}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9BDD6EFB-7914-4285-BFC7-36873AA2F42D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{29BB8AE6-57E9-41CC-AB2C-75B7B2A617BA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A7179014-A365-4D46-90B5-3D0B116CAA2B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{73407700-80EA-4168-8DCA-75C66A49F68F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{462E7F92-130D-4218-BDB8-AEF17C5EDE24}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{432FF194-31D8-4C86-B7CF-6ECAD0D25C24}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5006DE15-370B-416D-B506-B7930D1FD201}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B34297BD-65C4-474C-8807-4CD8F210ABB4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CD7438E0-5881-4FB1-B3B4-3C07F281899E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E648EB50-98C9-4206-B344-988C24EFED7F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7C7D4925-331F-427D-8E70-31B35811A14E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{230E196A-0E57-4986-92B5-169D2783B4E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E352003D-2179-4757-9664-B370914B59B7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C447B77D-9BCC-45FC-9DFD-04F95AE520A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E3379B1F-71F4-4A38-9F2B-A498F9F0FA13}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{502613D4-D65C-4F8C-9E9F-E71DBFB7670F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E5D8EF44-6039-450E-B3CE-00D8924902B8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A0BEAF6D-A2F6-40AA-A63E-C9050E772801}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{98F977AF-F9EA-4027-99F1-26837A8B2FD2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C10E6A35-690A-40BC-8121-A150A45CCC1C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{36090C6B-1A52-4710-A2EC-9C64160561AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{947B43C6-FF66-42AF-92EA-BD5DC70A5721}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6C227956-8B99-4E47-AF6B-C08594F2CFC8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7AC26064-4F13-4ACA-886F-0F58C6151457}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0B89E31B-D7A5-4232-9995-118A210C6B51}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{2044F3C6-92DF-434D-9E7E-A7B74AA5A01B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C648DA3C-0D53-41D0-BB78-925008614A5D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3DB9E8AE-C108-4852-934D-021F3FEF97B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C90FEAFF-C7F5-441F-A4A8-9ACB776EC400}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5AD74727-BFCD-4F21-9705-3D6DFD8D4A8E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{45B9401A-7DF5-4E5A-9987-897179E9B669}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{638664AE-CD4C-45E1-80A3-768178CAE851}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C791874D-9256-426A-915F-BC2D37D3B4FF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0248F18A-E609-440E-97FB-0BC4A0CFA888}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{32AB00A8-D273-4AA5-8195-8844E0CE6CC0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{143E7B8D-68FF-4E08-BE4A-0962AC998027}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7289C6C9-58ED-464B-9804-794E53E345C9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{2FFD8434-AE64-464F-ADD5-5DEB55C9DAD8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{84C2040F-AB7A-48B5-B82D-DC44EF9DA023}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{2BD7B320-D7C1-4E2A-80FC-F634B52DE365}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{82535F24-FF24-4873-9C7E-47DC0CFB98B3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0347B002-318F-4E4E-ABC6-2B112B82CF57}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4500B3EE-26C8-4606-90C9-0E728EF35A53}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{48FBCCF3-3551-4916-8B8E-B51F25115773}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F62D21A3-6965-4A3E-9519-3A58670807DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{962E7344-FB62-4CC6-8DE6-49AC2A5CD1AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6A2BB588-BE4B-4B05-90ED-BF02AA258634}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{65744AB7-F370-4BEB-B2D8-874F4849FE82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D391940F-1904-49A0-AECC-0CCB66555893}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F65493E0-3A71-44C1-AF10-004CA3F77F30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B2E8AA57-9369-4F91-B536-62F61BE60356}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{570E9B7E-1BF3-4D98-AA66-5A5A1A5DB24D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{432BFBDB-6365-4372-9B17-76CA822AF509}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{39EB2884-E201-4260-9034-0C7358B0F5B6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{53C7E79B-33B6-4F5C-86EF-0A601B5C8DFC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C58BA6AF-C03B-41BA-A39D-6A480F8B67DB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9917243A-BE42-463A-8B7A-53AE85A4BB85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B9581136-CF1A-4128-B458-E5F22FA52B5E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{74D5A6C2-2587-4F73-9F2D-657B7C31EE89}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{712D49B5-209D-4B41-935A-729677B05821}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{14883A65-328C-4A9F-A909-1E6523279973}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{19CB52C5-542A-4DFB-A556-93DA6A152574}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B34AF69C-0F03-43D9-9ECD-28251F5868BF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B1C1BD56-F1E5-404B-8D70-38CB0F4A46E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7E8350A4-64F6-4E82-8935-BDDE57ECA06C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1C33CF08-93CE-4207-B8CB-54023D433DC0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DD5A26D5-C3CE-42A4-8492-4CF8B3AA9294}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9FD70F27-358B-49A4-8596-FDE54A59D244}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{0F12BE76-D0D0-4D90-B50B-70D17E36978A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{74B01DDF-BD4C-4D16-B4C1-ACCA5142FC4A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D0CF14B8-AA3F-4309-8404-13080B84049D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D0C0AE90-E342-4CD8-9EA6-6C3FE3922BEA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1D8868AF-BE63-4200-8F5F-DCEA6BD41848}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6644FA45-0C27-46E4-9418-D6DB65086986}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{47B772B9-CAD0-4475-8596-8053E7A43989}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{97E17459-DFF2-4541-853F-1D0645727CB3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EF001A73-9826-46A1-A951-E1950B62C4B1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{1C00728B-B854-4F69-9DEA-17A7961B6B98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{03E800DC-3895-46E7-B5A9-000FFBEC7C30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F07DB986-D0D8-41C4-AE96-66EC9DBED486}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7B22BF45-7798-4C19-8A5F-81B561B588EC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F3A755AA-5A06-47D3-9AD4-F2CDADDB3B4E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{7F588C1B-878F-4FA0-9310-5431EF8971ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{D470D9ED-412A-4F9E-A8D5-25A2132424D4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{35E1D150-76FE-4D4A-A7BC-5F9C2ED9B572}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{72759E88-E98F-43BC-87F8-4E3764716938}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DA0829D7-0BD6-4539-881D-E715E72B9DFB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4C26EDAA-BEBE-4DB1-9D28-28D99E828880}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4C4AE924-E739-4A87-843C-760B0B592308}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{A258414D-ADCD-48B2-A800-3E927AE93B3E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F0B7A64E-0D03-43F3-93C8-C8738FAC7F81}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{DB019779-83E8-4648-AB77-219AF78CA790}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{6923B816-0CC1-4EE2-9F11-93106A1B0DD9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{457C56E0-00D7-4E2B-B629-991D80F01EDA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9AEF659F-764F-46F1-BB67-F54927A76666}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{EAD8425A-507B-4D1D-A154-E03CAB5168D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BC0E173F-A43C-4FC4-BEDE-042FD1665BDC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{ABB524EA-9382-4494-8BA9-6BDA89314838}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8D9F8112-A866-4454-AF60-CC2079CA560A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FB0A78EE-BE02-4A75-AFB8-CE2DE901519A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{56060C02-947A-4B92-9A36-9925B119A001}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3B5441E9-1EEA-4F41-A9D5-45726FFE483B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{8C82AC7F-6119-43DA-B691-AD02CE4C3D48}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{2355319B-B9A6-4BAB-8266-F1B7376F455B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{9010941E-93C3-4AE6-B8E0-5168B02FB096}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CF41C361-37F9-4ED3-A0CA-DD0438D62C59}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{2B3C699A-876F-4CAE-9093-5B06570C0CC3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{4A56B5B8-09E1-4FFA-8D42-8B6B424DBC96}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{3EA111A2-20AB-4239-B39C-000BB75E04CE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{C503F43D-C728-4658-8C7A-E356090A049D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{FF5E2D6B-F5DA-43B3-B92E-D7DE318E811A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{36A2F0CA-830B-4003-80C1-4C545AD556FA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F02FDF99-3D47-4637-9363-DA371BFA44C6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{564AD75D-C977-45AE-9178-12FFCE3A19A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{BE48DDAB-7930-4972-BE2E-FA2A2BAA12E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{55967F4D-5EDD-44DA-BD39-63054A9B7330}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{5D239502-8980-4737-80EF-D2466BAC3131}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{B86410B8-CD81-4E18-B98C-5E33FE138352}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{E7A4FD74-6B67-42CD-8B55-0B06894F456D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{F31F4664-47C6-4FAF-8C76-09F07329EFAD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "{CEDC15B9-E830-4CA4-B3D1-E7DC84813DB9}", "upgrade", "", "", "")
INSERT INTO PayloadData VALUES("{55F0AFED-606D-476A-A07A-134291002FBA}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{55F0AFED-606D-476A-A07A-134291002FBA}"><File><InstallPath>[INSTALLDIR]\Plug-Ins\CS6\File Formats\Camera Raw.8bi</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2010 CA{|}VeriSign Class 3 Public Primary Certification Authority - G5{|}Class 3 Public Primary Certification Authority</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{55F0AFED-606D-476A-A07A-134291002FBA}", "0" , "ValidationSig", "lD0KkIX9VhXrhKqtDawCyvrgifYAxaHKbgrQwWbfpfLDmHQDSDKyuIlLQ2CxUsFFS0uoNpldaXExLU9LTKVj2Fm4yTK3br7de4F4bQ2UiQIuUj1UN6vNaNMwxDAG+okypRQzt7v+yQKSM2+aCoKmXUaXxYSw9Lh+GwlvNf6CpLHc85iE8e0g+SHnVibCHd/LT7qxyrUFQUw2WxD/1MPRsOcFY7vdd5RGWy90uhFtTI63sk0kWbWEPqpMQc9ToChvyWGLiOBDb3dhWmXwMfBoK7MpfFRKrBIkqC4CoJYhRza3JIxfOEN71JnXyN5waCuEdwiAzNL8Cj/4OfK7APXwrTrGnFgvkZP7S3gRTvrWqcYA7fRS9KWB/LWgb4tRzta7ebF74WWs1KHfa1s4zpnnrULn6auv0y9TsLnN4H9iNuP8mOWfFJku9O0jxT6hkhAWzu1117JkIHUV05DXkQNyvSEGREs0igbVpm3o4LQPWKT0JXFKXZmvjyeDeBRy+54+")
INSERT INTO Branding VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "AMTConfig", 'PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjxDb25maWd1cmF0aW9uPg0K
ICAgIDxQYXlsb2FkPg0KICAgICAgICA8IS0tIGRlZmF1bHRBZG9iZUNvZGUgZm9yIGRldmVsb3Bt
ZW50IHVzZS4gLS0+DQogICAgICAgIDxEYXRhIGtleT0iZGVmYXVsdEFkb2JlQ29kZSI+Q2FtZXJh
X1Jhdy1JbnN0YWxsZXItQWRvYmVDb2RlPC9EYXRhPg0KICAgIDwvUGF5bG9hZD4NCjwvQ29uZmln
dXJhdGlvbj4=')
INSERT INTO Payloads VALUES	("{55F0AFED-606D-476A-A07A-134291002FBA}", "Shared Technology", "Photoshop Camera Raw 7 (64 bit)", "7.0", "normal")
INSERT INTO PayloadData VALUES("{55F0AFED-606D-476A-A07A-134291002FBA}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.29.0"><BuildInfo>
    <Property name="Created">2012-02-09 05:03:04.535000</Property>
    <Property name="TargetName">AdobeCameraRaw7.0All-x64</Property>
    <Property name="ProcessorFamily">x64</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{55F0AFED-606D-476A-A07A-134291002FBA}</Property>
    <Property name="ProductName">Photoshop Camera Raw 7 (64 bit)</Property>
    <Property name="ProductVersion">7.0</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="1" name="Default" folderName="">[AdobeCommon]</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
	<Family>Shared Technology</Family>
	<ProductName>Photoshop Camera Raw 7 (64 bit)</ProductName>
<ProductVersion>7.0</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{F46EAF19-C62E-409E-8A85-2546E14851EC}</AdobeCode>
    <AdobeCode>{5E38EA8F-106D-436d-9A43-5EDB151AA993}</AdobeCode>
    <AdobeCode>{4713F905-F06A-4E78-AED9-AEB164125487}</AdobeCode>
    <AdobeCode>{4A470B9B-D64A-4B65-803A-AA6967C62170}</AdobeCode>
    <AdobeCode>{BE2AAA07-8F95-4435-B615-1D33451716AE}</AdobeCode>
    <AdobeCode>{4A1CFA3E-71C0-42C6-A19D-415801ACF37A}</AdobeCode>
    <AdobeCode>{95A564CD-E7F6-4954-B714-ACBFECA4FF0B}</AdobeCode>
    <AdobeCode>{3952DD6D-DA69-401A-878B-26637F91F360}</AdobeCode>
    <AdobeCode>{63EF4929-2979-4785-B0B9-BEAF4127EE2F}</AdobeCode>
    <AdobeCode>{4FABAFE1-B867-408A-8F77-1E7453E7126B}</AdobeCode>
    <AdobeCode>{06EA00A3-4461-4461-8731-4FD9DA167D35}</AdobeCode>
    <AdobeCode>{5A142F95-DF85-4C7C-9BE7-206989934CFD}</AdobeCode>
    <AdobeCode>{60371889-ED9E-41F4-9A2F-48862028FE2A}</AdobeCode>
    <AdobeCode>{6B405F32-374A-43A5-83D2-26BE82F96248}</AdobeCode>
    <AdobeCode>{258673B7-C6B8-408A-B38B-9D8F268BD507}</AdobeCode>
    <AdobeCode>{1ED0BFB4-1694-449A-9AD4-BC024D7A840B}</AdobeCode>
    <AdobeCode>{27E50586-0555-4923-8E4D-A08F1D641C2A}</AdobeCode>
    <AdobeCode>{5982B3BA-7A64-4D6E-B222-0D00285DC597}</AdobeCode>
    <AdobeCode>{AD878506-1A03-4110-9702-656E99304248}</AdobeCode>
    <AdobeCode>{D4BA0EDD-1963-4730-84EB-095F1195C543}</AdobeCode>
    <AdobeCode>{4195A1DB-E747-4EF6-91B7-658256482E10}</AdobeCode>
    <AdobeCode>{E6680F4C-0CC7-4ADF-8023-52063F668AFF}</AdobeCode>
    <AdobeCode>{15D245E9-17AB-462E-B87A-8A3A734F0F9E}</AdobeCode>
    <AdobeCode>{6FE253BF-1104-4A93-BB95-C4392DC366B9}</AdobeCode>
    <AdobeCode>{11929797-5CD5-4233-AB54-101FCDD3A03F}</AdobeCode>
    <AdobeCode>{D8474C7F-5259-4ABF-BD64-F20F4AFD392A}</AdobeCode>
    <AdobeCode>{9EF9D2E8-9664-4147-B7F3-FA4B80E4AD18}</AdobeCode>
    <AdobeCode>{97A8E954-D267-4769-9853-3EF0F259EA06}</AdobeCode>
    <AdobeCode>{4B11CA64-0B86-4453-AC06-57BD649861FB}</AdobeCode>
    <AdobeCode>{8C96E7A9-E060-41F0-AA59-5678E5C307D5}</AdobeCode>
    <AdobeCode>{6A5544C8-F418-43D8-9D27-4E19C3BB5E7B}</AdobeCode>
    <AdobeCode>{0ADC08F2-B744-4049-B240-36441554FA41}</AdobeCode>
    <AdobeCode>{78F39EC8-134D-4660-BE4F-E7C4E17B1E5C}</AdobeCode>
    <AdobeCode>{0CD2C592-13B7-47B6-BBF5-FB4C50C1AEC3}</AdobeCode>
    <AdobeCode>{E020BDA2-D099-4E31-8586-44853EC7E690}</AdobeCode>
    <AdobeCode>{50D5136F-839D-42F3-9343-6F5A62B53939}</AdobeCode>
    <AdobeCode>{A54A83C6-0F5F-4A9E-ABE9-5F19FD91B20D}</AdobeCode>
    <AdobeCode>{D39D3599-AB31-41CD-8BC4-5B79D49B99D2}</AdobeCode>
    <AdobeCode>{A6F92A3C-AC45-424D-BE21-0654C6D2B3F1}</AdobeCode>
    <AdobeCode>{1BC7B3EC-517D-436D-BA47-9DD95A94E06F}</AdobeCode>
    <AdobeCode>{AC9E45EC-A422-4121-90B4-EC4A395AD8C1}</AdobeCode>
    <AdobeCode>{E9EB523D-D667-44EB-A804-77F24AA91E6C}</AdobeCode>
    <AdobeCode>{3E0E007C-C85D-4ADC-9F16-EBED21D26CC2}</AdobeCode>
    <AdobeCode>{522A4B68-0282-4C67-82D2-CC1323FE3FE4}</AdobeCode>
    <AdobeCode>{C84DEB4C-8F82-4DCC-9273-7952B40F7ED7}</AdobeCode>
    <AdobeCode>{79CA2C27-7BD0-4CD9-8D17-1FCE7CC820B1}</AdobeCode>
    <AdobeCode>{CD086B29-15D3-4DA8-8E98-1CB71B1DF015}</AdobeCode>
    <AdobeCode>{9145DE9B-3564-4872-83FC-EE11BB0E491E}</AdobeCode>
    <AdobeCode>{A093C0C5-0408-4B7B-B5AC-099254FB03D8}</AdobeCode>
    <AdobeCode>{4FF0F828-D0FC-479F-9F1A-3BFE75CA184B}</AdobeCode>
    <AdobeCode>{E5941A84-4868-4597-9071-E2C5ECF59B53}</AdobeCode>
    <AdobeCode>{24C06C12-2AC5-444B-A919-3E44B7E0D686}</AdobeCode>
    <AdobeCode>{784A98B3-FC86-43D1-8342-8248A786790E}</AdobeCode>
    <AdobeCode>{04801B4C-B7A1-4D70-A6B1-79BBCCFE6ACA}</AdobeCode>
    <AdobeCode>{0383261E-6EEB-400A-90CD-97F63C9F23F5}</AdobeCode>
    <AdobeCode>{C0C9BCD1-5189-4549-9AA3-7407FDA4827D}</AdobeCode>
    <AdobeCode>{70EAEC3B-E722-4C13-9BBD-690B79134BFD}</AdobeCode>
    <AdobeCode>{3DE08C59-2178-49A5-A8A2-0CD316A80DFA}</AdobeCode>
    <AdobeCode>{FA8C6B01-839B-4BDB-934C-13F538A94F5F}</AdobeCode>
    <AdobeCode>{3099756C-3E45-405E-9B06-219139105CFD}</AdobeCode>
    <AdobeCode>{47243908-0E10-49C9-9F86-BB9FF8AFF840}</AdobeCode>
    <AdobeCode>{C71101D9-5B2D-43B6-B779-5855D4D489A4}</AdobeCode>
    <AdobeCode>{8B784A1A-4312-4C62-BB75-DEFC8D7595D5}</AdobeCode>
    <AdobeCode>{0413E679-4D23-4EE5-BD93-EA09BB6980F3}</AdobeCode>
    <AdobeCode>{DC9D0DB2-9F8A-4F3C-854D-7287A2F502F9}</AdobeCode>
    <AdobeCode>{D934114F-4497-4B45-905F-DACC40AC3C15}</AdobeCode>
    <AdobeCode>{DAB1A990-CF4E-4CC9-B8BB-F99EAB65452E}</AdobeCode>
    <AdobeCode>{EA9F770F-5332-4C11-96AF-C91DB344E8A9}</AdobeCode>
    <AdobeCode>{34F296FE-C6AF-4DB2-B314-CBF29B088733}</AdobeCode>
    <AdobeCode>{EC9B1B78-06EE-4522-9AD8-31575B9E8202}</AdobeCode>
    <AdobeCode>{EEEAF7B2-51FE-4AAB-B26E-83B83DEEFB97}</AdobeCode>
    <AdobeCode>{BDB8D7DF-37DF-456F-AE2C-C51A888A6016}</AdobeCode>
    <AdobeCode>{1482B68A-AA94-4679-A696-B268CF44AF9E}</AdobeCode>
    <AdobeCode>{C2162B86-A64C-4664-80CA-93B418F34F78}</AdobeCode>
    <AdobeCode>{13D064F7-4896-489C-BE38-F342A7CC4896}</AdobeCode>
    <AdobeCode>{CEF75904-C47F-4439-8ED4-B3884586DD09}</AdobeCode>
    <AdobeCode>{B5482CC1-F23F-48D0-8ADA-03B2879A26EB}</AdobeCode>
    <AdobeCode>{8CEA8CBA-0F88-4601-82A1-AD361AF8980A}</AdobeCode>
    <AdobeCode>{02BF1A34-C7AC-4C3E-B214-C07876381568}</AdobeCode>
    <AdobeCode>{E4B957A2-C755-4660-A766-1AD59F14A952}</AdobeCode>
    <AdobeCode>{7E7C5632-F74E-40D8-9EBD-20D4BC8EF3C7}</AdobeCode>
    <AdobeCode>{DEEB0AD2-1CD5-4334-B7E2-6D539FA75484}</AdobeCode>
    <AdobeCode>{9AE2E4E8-36DF-48BC-9B26-590923874E2D}</AdobeCode>
    <AdobeCode>{58679466-1351-46C3-B271-5E51CD680938}</AdobeCode>
    <AdobeCode>{C606656D-EDDF-49F0-96DE-0D1F83CA5814}</AdobeCode>
    <AdobeCode>{CEE07388-92B0-4741-9F2C-0F90168B5BDA}</AdobeCode>
    <AdobeCode>{6552F9F7-A78B-4AA9-B462-37C6B99ED1D1}</AdobeCode>
    <AdobeCode>{5E10FC51-134E-438C-9237-51B08EBAD097}</AdobeCode>
    <AdobeCode>{93411628-A348-4EBA-B83A-6F3D4F2E827E}</AdobeCode>
    <AdobeCode>{3D2BB002-0F46-44C8-B533-6B5520E4FC87}</AdobeCode>
    <AdobeCode>{68E382C8-673E-4FD2-A483-6B6CC0B730F5}</AdobeCode>
    <AdobeCode>{58F2C875-38F3-4117-AE3F-BFE5064859E1}</AdobeCode>
    <AdobeCode>{9FB61B98-70B5-44B8-8A52-F05F9528EA66}</AdobeCode>
    <AdobeCode>{D4A23BFD-85A6-46F1-A45A-0FFE59D2A05D}</AdobeCode>
    <AdobeCode>{4A4F8BB8-7CF3-4450-ABA7-5636ACEEB84A}</AdobeCode>
    <AdobeCode>{00C06D4A-515F-497B-9611-8840511534AB}</AdobeCode>
    <AdobeCode>{36481681-3DE6-4026-8A9E-83ED1F91CB47}</AdobeCode>
    <AdobeCode>{57A64018-672B-44E0-9885-2AA88282446C}</AdobeCode>
    <AdobeCode>{34450FE1-EB5A-4F6D-B02C-648FC48D4905}</AdobeCode>
    <AdobeCode>{F7C48E6F-36D5-45FC-B097-C15FEB2E2847}</AdobeCode>
    <AdobeCode>{6F142611-13B8-4BDD-B029-A7AB279C9BD8}</AdobeCode>
    <AdobeCode>{E1400D7B-BBE1-4701-B8C0-8FAE93745E17}</AdobeCode>
    <AdobeCode>{56EC817F-C687-42C4-81E5-BFA90F78D42F}</AdobeCode>
    <AdobeCode>{36692E5F-4CB0-4EC5-A037-403A2602A7AE}</AdobeCode>
    <AdobeCode>{13292C24-1EE6-4B5F-9D6D-E98C478345F9}</AdobeCode>
    <AdobeCode>{6CD7A24E-E72E-49CD-A9F7-CFE1EBC0D7D6}</AdobeCode>
    <AdobeCode>{CE630DD3-2486-4673-B434-7ED71E052F3F}</AdobeCode>
    <AdobeCode>{1F28592B-07A2-4FD6-B59A-A3DA72647FB5}</AdobeCode>
    <AdobeCode>{D4D79BAD-15C0-4E58-BEBA-E76BD03DEB98}</AdobeCode>
    <AdobeCode>{A46B064D-C24B-4B48-98F7-6F8DC1EBA0D5}</AdobeCode>
    <AdobeCode>{52F56A22-DC2C-4C9C-9773-02705A9B8A5F}</AdobeCode>
    <AdobeCode>{51BE7E92-7359-4935-9168-D376B562E9BE}</AdobeCode>
    <AdobeCode>{F935222F-D5D8-4915-BBE7-A2087B76C017}</AdobeCode>
    <AdobeCode>{3211E941-87C5-4CE1-B71B-33967ACCA54D}</AdobeCode>
    <AdobeCode>{C824F6E1-B1A9-439A-AD44-9F84F241AE85}</AdobeCode>
    <AdobeCode>{A9E54EE3-DD44-4433-A650-C9A8654ADEE6}</AdobeCode>
    <AdobeCode>{A7136821-7395-4CDE-9418-F857BD764474}</AdobeCode>
    <AdobeCode>{910DB454-B351-4AF2-9A45-2ECE4D3DE788}</AdobeCode>
    <AdobeCode>{9D4CBDF4-DC09-46BD-96E0-3BCA955BE13C}</AdobeCode>
    <AdobeCode>{2750B44B-0595-4B51-99B9-327EE4024119}</AdobeCode>
    <AdobeCode>{AFE64ADA-9458-45B1-A750-39CFDF62976B}</AdobeCode>
    <AdobeCode>{E31EA65A-01F4-4FB1-A5B9-D3B8CBB32BB4}</AdobeCode>
    <AdobeCode>{DAD02C7A-D645-4A84-9203-91BC4B0BD024}</AdobeCode>
    <AdobeCode>{6981A267-CA4C-4F37-AAA7-BB3D374C0151}</AdobeCode>
    <AdobeCode>{D391812F-CDBE-4ED4-9FC6-AE0E0E541965}</AdobeCode>
    <AdobeCode>{A746D681-C3F4-4CF9-A889-056DA46F4D83}</AdobeCode>
    <AdobeCode>{8C7BE264-E746-42BB-83B1-2ED323E8491F}</AdobeCode>
    <AdobeCode>{A286BA6A-C0A1-4F39-ADE3-DC0529725201}</AdobeCode>
    <AdobeCode>{AFE0646A-173D-41E9-97D8-72452E72C6D9}</AdobeCode>
    <AdobeCode>{25055C36-A9A2-491C-817C-CA018745E701}</AdobeCode>
    <AdobeCode>{BD6ED4DB-C4D6-4DD3-8542-9F559A69EAD4}</AdobeCode>
    <AdobeCode>{AA6A3650-7D04-428A-BB49-0808F00F8196}</AdobeCode>
    <AdobeCode>{C2C1E2EA-AF73-4F0D-A4EA-CA899D2BD58A}</AdobeCode>
    <AdobeCode>{6D42A91E-7A94-4523-A0C8-88CD10765636}</AdobeCode>
    <AdobeCode>{AD9C9492-FFC2-4BB9-A13F-0B29C7F9FFF7}</AdobeCode>
    <AdobeCode>{D663BEF0-3485-48F2-990A-C82194CDDF69}</AdobeCode>
    <AdobeCode>{1CDFAA0A-12A3-46C0-884A-6E44DA606DCA}</AdobeCode>
    <AdobeCode>{2AEF1C35-2D14-42F5-8F1C-A04327B5966E}</AdobeCode>
    <AdobeCode>{F117A0FB-5C64-4025-9C69-8DD98FF94D28}</AdobeCode>
    <AdobeCode>{5D2602BA-787B-4B82-A0D7-BE3E1E2E89A8}</AdobeCode>
    <AdobeCode>{C1E4C0F6-5AD5-43FF-AF19-7FA55319AA9E}</AdobeCode>
    <AdobeCode>{FEBBD97F-340E-4564-911C-41CCB5FE6661}</AdobeCode>
    <AdobeCode>{FDA3D25A-CA84-400A-947E-E2157FFFAECA}</AdobeCode>
    <AdobeCode>{80B37CC5-88CF-40FE-AEC3-984B56A86C54}</AdobeCode>
    <AdobeCode>{BD33ACFF-D9B2-4033-8809-2EE354ECAEF3}</AdobeCode>
    <AdobeCode>{8DB90744-4EE8-4577-8A9C-EE1DDF1E96BC}</AdobeCode>
    <AdobeCode>{F3B002EB-8070-4014-855B-175BB2851B42}</AdobeCode>
    <AdobeCode>{7828BA26-86B7-4674-AFF1-A386BDA78CBF}</AdobeCode>
    <AdobeCode>{B43B075C-77AE-4A89-B030-97977914BD44}</AdobeCode>
    <AdobeCode>{D56C2484-9243-4FFC-9F13-0C152E2E7E0D}</AdobeCode>
    <AdobeCode>{C0AC0C1A-2A4B-4B14-9FB6-96FFFABF4537}</AdobeCode>
    <AdobeCode>{49BCF039-A434-4E7D-94FE-F9908C60E052}</AdobeCode>
    <AdobeCode>{BA4E645D-966D-4C96-A4A1-A9729C51B9F1}</AdobeCode>
    <AdobeCode>{02D81C1A-234F-4062-9E0E-C7FE2C8200D4}</AdobeCode>
    <AdobeCode>{B418BC21-BAD2-48D0-96FC-7C7CB70FDB1E}</AdobeCode>
    <AdobeCode>{7E1D0A40-D494-448B-B52E-1FAC1361E61E}</AdobeCode>
    <AdobeCode>{6CBA3044-857F-4325-AA4C-C7E3F405268B}</AdobeCode>
    <AdobeCode>{F0B6DC5D-F6A2-459D-9ECE-1ADA9B897441}</AdobeCode>
    <AdobeCode>{0F7C54A4-0E13-445D-92DE-BD53E166460D}</AdobeCode>
    <AdobeCode>{E78B534D-9CA3-4CB6-8B43-3A40A83123F8}</AdobeCode>
    <AdobeCode>{86C36B7C-F423-42B4-BBFE-C72FA7DE934E}</AdobeCode>
    <AdobeCode>{19A37370-091C-43CB-821D-E10825432934}</AdobeCode>
    <AdobeCode>{DB355314-07C9-40F6-8FF9-D31FFA894B49}</AdobeCode>
    <AdobeCode>{A4EC440C-024D-48B8-8674-175A136A369F}</AdobeCode>
    <AdobeCode>{CA711759-9FD7-4887-8106-0B78B320B11C}</AdobeCode>
    <AdobeCode>{E32C92FA-5048-4598-9440-B71924D22189}</AdobeCode>
    <AdobeCode>{A4751C6B-C13F-4AFF-9C06-E98E8B23792E}</AdobeCode>
    <AdobeCode>{B43E977C-33DA-44D9-A38A-D894A62E0767}</AdobeCode>
    <AdobeCode>{F9C47909-6140-41CA-B484-464FF64CACD5}</AdobeCode>
    <AdobeCode>{3D4D5E35-810D-4B0B-92A0-DEB8A36811D7}</AdobeCode>
    <AdobeCode>{8F4824F9-ABE8-4ED8-8840-079199DD2828}</AdobeCode>
    <AdobeCode>{4D09D8B4-69AF-4BF0-9C5C-FC7B813F436D}</AdobeCode>
    <AdobeCode>{12A68B28-A1AA-4098-8448-1F0AE6741617}</AdobeCode>
    <AdobeCode>{846933F8-FFC2-420F-BE1E-0EB2750A7532}</AdobeCode>
    <AdobeCode>{FB96548A-9293-4534-96D4-76DBE8B5EF33}</AdobeCode>
    <AdobeCode>{E6EBCADF-B9B3-471E-9F30-161F80F2070B}</AdobeCode>
    <AdobeCode>{C47C1A87-32EA-4FAF-8C44-1CC8E3550149}</AdobeCode>
    <AdobeCode>{5D6BB7DB-41AF-436A-A96B-25505FF090C8}</AdobeCode>
    <AdobeCode>{1A434883-28D3-4190-B738-277B04A948D8}</AdobeCode>
    <AdobeCode>{34ED0200-CB88-440F-A0D4-EA24DA1DFB5A}</AdobeCode>
    <AdobeCode>{7C8415B7-D75B-47F9-A2BC-1EB5B113D748}</AdobeCode>
    <AdobeCode>{C300E3A0-C742-476C-B999-39FC8B51A7A5}</AdobeCode>
    <AdobeCode>{E5301FAB-D2B6-4F59-9A25-C258E37E94EF}</AdobeCode>
    <AdobeCode>{02B2AE25-2F4D-4DB4-AAAB-0F824207D7F4}</AdobeCode>
    <AdobeCode>{DD3A18DE-4226-408B-8D12-FA26710AF421}</AdobeCode>
    <AdobeCode>{C797E07C-80A5-4127-8C61-F225A7FD15E3}</AdobeCode>
    <AdobeCode>{7CB2FA0E-E91C-4ED4-A6E8-74EAD7C5A612}</AdobeCode>
    <AdobeCode>{1D8F5EFF-EA61-417E-A1C7-C1C134A9C2CD}</AdobeCode>
    <AdobeCode>{64BD4602-7010-4A60-9BD5-A3774AF17572}</AdobeCode>
    <AdobeCode>{E0A121D9-8D09-4DBE-B495-0F2D6042E7A7}</AdobeCode>
    <AdobeCode>{45AAB2B4-861D-4B0D-B613-35E3C83D77DD}</AdobeCode>
    <AdobeCode>{9A87AB83-74FE-46FB-955A-9A0D614542DA}</AdobeCode>
    <AdobeCode>{9C8BE58A-33C1-4E4D-9E65-7D1D606ADACA}</AdobeCode>
    <AdobeCode>{49CEE435-7355-49BB-8504-5921B89AC8D2}</AdobeCode>
    <AdobeCode>{BC02498B-D371-4F18-96C2-DEAB0927E6BE}</AdobeCode>
    <AdobeCode>{00FF76CB-7A3A-45FE-B223-4CBC67025E2C}</AdobeCode>
    <AdobeCode>{463386B5-4277-47DD-BD5D-876C55A51969}</AdobeCode>
    <AdobeCode>{DA41FF5D-1584-49E7-8CCB-B45579DBFCE2}</AdobeCode>
    <AdobeCode>{99CEA660-AD17-4695-900E-F9F4DAE55EC5}</AdobeCode>
    <AdobeCode>{5512FF1C-81D1-4773-9DC1-531AC1ADCCA7}</AdobeCode>
    <AdobeCode>{CAFB4502-AFA8-4455-B577-2A0D290451F7}</AdobeCode>
    <AdobeCode>{5CF39048-11C9-431D-8D03-B595ACB80A1B}</AdobeCode>
    <AdobeCode>{80C19226-81EE-442E-BE6C-CFAE11422895}</AdobeCode>
    <AdobeCode>{BE1FDBEB-07F4-411A-9882-0FD1A5071C3A}</AdobeCode>
    <AdobeCode>{2CA953EA-4BCE-4D92-ADD3-7BBCB062DC4E}</AdobeCode>
    <AdobeCode>{BEB52E33-7EDD-4627-8946-3871A0BFEF4D}</AdobeCode>
    <AdobeCode>{1A07A3B5-9158-43EB-A590-0DDD42BD7477}</AdobeCode>
    <AdobeCode>{46BF72B7-18A0-49DA-B9AF-428CB8E940CE}</AdobeCode>
    <AdobeCode>{13A7E000-7168-40B6-89FA-5F09CDED288A}</AdobeCode>
    <AdobeCode>{866EBCC5-8DD0-4F1A-808E-D57191677CD4}</AdobeCode>
    <AdobeCode>{EE9C377F-2107-4C8E-AE01-3729037F9BFB}</AdobeCode>
    <AdobeCode>{D843D08C-9B2C-40B2-B712-628C3D879084}</AdobeCode>
    <AdobeCode>{625400B2-9AD9-4000-8156-79A32E0BFBEF}</AdobeCode>
    <AdobeCode>{3CE07F20-CE7D-4A4D-8867-864D51F8E6F4}</AdobeCode>
    <AdobeCode>{5190AC29-9815-4829-AD83-39E2519DA697}</AdobeCode>
    <AdobeCode>{C46C09AF-2C03-4F77-AC91-35FFDB68888A}</AdobeCode>
    <AdobeCode>{084DE26A-21A5-4B8D-907C-A2A7CA55F82C}</AdobeCode>
    <AdobeCode>{1049C710-D579-48F9-A741-2D3CB8A9B501}</AdobeCode>
    <AdobeCode>{EFE3EDA2-6E22-4015-B53C-A6763DD929E6}</AdobeCode>
    <AdobeCode>{49038883-BF22-4F40-BEA8-3EB2E5030E3D}</AdobeCode>
    <AdobeCode>{12620A7E-B369-4C43-B690-82E043A3B5BC}</AdobeCode>
    <AdobeCode>{40874E83-B3C5-4D78-8BDB-C7F139BFA34D}</AdobeCode>
    <AdobeCode>{7FB5EBD8-C577-4294-B64D-720F008845D6}</AdobeCode>
    <AdobeCode>{C3180AC0-3B28-4AC8-B08D-92E9F2084571}</AdobeCode>
    <AdobeCode>{8EE5F2E5-99F7-4399-B439-FA488E660836}</AdobeCode>
    <AdobeCode>{9B10AE46-6B40-4CCB-A950-6B418D0EF5F2}</AdobeCode>
    <AdobeCode>{E4D78DB2-69BF-42C6-8CDD-5A3CE9E0E5AA}</AdobeCode>
    <AdobeCode>{60695A1B-0441-46B0-8217-9A80062DCF47}</AdobeCode>
    <AdobeCode>{23F00765-0749-4E0C-9BCA-62B896C80ADC}</AdobeCode>
    <AdobeCode>{B0BE1320-A85A-4884-ABC1-F3176CC2EAB3}</AdobeCode>
    <AdobeCode>{C2FE0C5E-369A-434F-9CB9-FEF5CDA30A0D}</AdobeCode>
    <AdobeCode>{3213DA64-FA72-4989-8053-A1B27E06F012}</AdobeCode>
    <AdobeCode>{524736DF-9A79-464C-90F0-BA1FB1F2BA13}</AdobeCode>
    <AdobeCode>{92B68C27-86A5-4600-B5FA-ADBBBC3EE392}</AdobeCode>
    <AdobeCode>{4F726952-4516-4B84-BF66-FDF19F0470A4}</AdobeCode>
    <AdobeCode>{5398306E-3B8B-439A-9B79-237FE5F181D2}</AdobeCode>
    <AdobeCode>{154DD731-8BBB-4141-8C15-ABCD63168375}</AdobeCode>
    <AdobeCode>{40FC5C32-09A1-497D-8226-7356EB75AAF6}</AdobeCode>
    <AdobeCode>{0C4BADB6-1579-42ED-8F46-E235319F2DE5}</AdobeCode>
    <AdobeCode>{F98FC65E-4DFE-4D67-94D9-66317323422B}</AdobeCode>
    <AdobeCode>{6D78911F-C0DC-437C-A923-2C407D666210}</AdobeCode>
    <AdobeCode>{BA8A8FB9-7DF9-4BED-A66B-5665EB5BFE84}</AdobeCode>
    <AdobeCode>{96950B2D-CC80-4FF4-AAEB-AFB7FB14B6AF}</AdobeCode>
    <AdobeCode>{E4BC69DE-1488-499D-BDED-74AF5BE9853B}</AdobeCode>
    <AdobeCode>{E1B08F4B-F637-44D3-AB78-AABFC9DF000E}</AdobeCode>
    <AdobeCode>{361758BE-5D8B-4CA7-9FD8-75A5D7606C39}</AdobeCode>
    <AdobeCode>{F78822F6-5530-4267-A98F-FA4FA46DE7CC}</AdobeCode>
    <AdobeCode>{473B7C13-4928-4D15-AC7C-529D111FBD7E}</AdobeCode>
    <AdobeCode>{8007EC46-B258-4E25-AEE3-3251E844C346}</AdobeCode>
    <AdobeCode>{8F55826F-125F-45B5-8D1C-463ACD50DC3A}</AdobeCode>
    <AdobeCode>{54594B1B-AEF6-4D20-8298-0E1E2AD31735}</AdobeCode>
    <AdobeCode>{65DED6AD-822B-49B9-AA33-087492227992}</AdobeCode>
    <AdobeCode>{632CB292-8F38-4EED-A7A9-ABE50D05B33D}</AdobeCode>
    <AdobeCode>{47150C1E-0611-4290-9073-44743F499239}</AdobeCode>
    <AdobeCode>{7289E121-32C9-437B-AE96-71BE89416003}</AdobeCode>
    <AdobeCode>{61CD5082-D922-4699-A452-8E451E678428}</AdobeCode>
    <AdobeCode>{3AF1D2BB-7A1C-463C-A7B0-621F877A331A}</AdobeCode>
    <AdobeCode>{A81279EA-CACE-4724-855F-EB804EFC5D3F}</AdobeCode>
    <AdobeCode>{7557C459-F86E-4000-9C42-71D26ACF71DE}</AdobeCode>
    <AdobeCode>{BD85E970-D924-4166-9925-BA88BDE785F6}</AdobeCode>
    <AdobeCode>{A136684D-BEC5-456D-A604-5A2DC7BBE7CB}</AdobeCode>
    <AdobeCode>{05867531-2E63-4C9E-B051-87DA9AB8A417}</AdobeCode>
    <AdobeCode>{CFD0E763-CD20-4FF1-901F-95CF2E1CB4AD}</AdobeCode>
    <AdobeCode>{6EF1C589-A284-43AE-BAC3-209707190240}</AdobeCode>
    <AdobeCode>{12AA8D84-76CC-4BE5-9481-F5686F22FFEC}</AdobeCode>
    <AdobeCode>{59BB3CD1-2C33-40B2-A204-3A15414210A1}</AdobeCode>
    <AdobeCode>{85B260BC-9E03-4C91-8990-8D32523089CE}</AdobeCode>
    <AdobeCode>{33FE1B1C-897B-409E-A5C2-73216949359E}</AdobeCode>
    <AdobeCode>{AB10E501-C014-427B-B2E1-3BC6BD17D4D0}</AdobeCode>
    <AdobeCode>{D23652A6-1212-4D5F-B264-633FF436D491}</AdobeCode>
    <AdobeCode>{4E9C6C40-7121-4841-A3CF-F813453CDE2D}</AdobeCode>
    <AdobeCode>{C18F37CE-3D11-499F-80A4-F2A5D1F7373B}</AdobeCode>
    <AdobeCode>{1A596F27-CE28-4EAD-A463-08782BE12FD7}</AdobeCode>
    <AdobeCode>{AEE58DE2-3CBD-4952-9EEA-ED21DD646E72}</AdobeCode>
    <AdobeCode>{9922FF62-A587-4089-B3E2-08A59133CA0F}</AdobeCode>
    <AdobeCode>{EF9FFA02-0E8F-463D-9970-A57E673D6E12}</AdobeCode>
    <AdobeCode>{6D049360-E389-47FF-B508-152A4B51EAD7}</AdobeCode>
    <AdobeCode>{E7EE5BF3-2DB8-4EC0-9F44-6902052C5973}</AdobeCode>
    <AdobeCode>{D22C5A83-C2E5-42E7-A8F2-2A4D357CF45B}</AdobeCode>
    <AdobeCode>{FB85FE4F-3312-46AB-B1E2-4930F5F97E91}</AdobeCode>
    <AdobeCode>{0A3D7088-60A5-4BD9-AA5B-4D48FCF7AFA5}</AdobeCode>
    <AdobeCode>{4D966CBD-B9AE-44EB-904C-8C6FC93054DB}</AdobeCode>
    <AdobeCode>{A9B32EF2-8765-4074-96C1-733DA6B53F6C}</AdobeCode>
    <AdobeCode>{EA6DED97-ED43-436F-B2D6-E361D298E545}</AdobeCode>
    <AdobeCode>{B5148994-FFC4-4399-AE7B-3F34CD05C7A0}</AdobeCode>
    <AdobeCode>{6DD52846-EFC2-46B3-973D-0DEABD4FE5E4}</AdobeCode>
    <AdobeCode>{5465ADC2-FB86-4735-BF0C-CAB7FF6A74F0}</AdobeCode>
    <AdobeCode>{CB78092C-0D3D-4B15-94AC-42521854C1A5}</AdobeCode>
    <AdobeCode>{B0CA4EB4-808A-4149-9417-E7DF999A5D96}</AdobeCode>
    <AdobeCode>{855D5AE1-5530-4AD4-A81F-2AA6362ED15D}</AdobeCode>
    <AdobeCode>{2E1F78BF-7114-4B70-8DF6-BDD089FDB261}</AdobeCode>
    <AdobeCode>{F395EAC9-5B5F-4FC2-9F2A-FDB35E83D03C}</AdobeCode>
    <AdobeCode>{FBE784B8-E3D8-47BD-ACD7-2DC5585FC395}</AdobeCode>
    <AdobeCode>{4B670647-C4FF-4326-BBE6-18D095A9AF99}</AdobeCode>
    <AdobeCode>{EEBAA18F-9F47-4772-966B-D593ABAFCE1F}</AdobeCode>
    <AdobeCode>{D3B13CB5-59BE-4451-BD3E-9E1F9AF589A1}</AdobeCode>
    <AdobeCode>{35F52DCB-6BDF-4748-93AF-03E14947E72F}</AdobeCode>
    <AdobeCode>{EE9224D5-1047-429F-A512-82E3CA8B5C3F}</AdobeCode>
    <AdobeCode>{D1EE0F1D-B38A-4832-B4A8-270C07C75432}</AdobeCode>
    <AdobeCode>{A475A98A-23B2-4865-BBD5-83911241630B}</AdobeCode>
    <AdobeCode>{1D39F485-7F53-4EBF-A076-53C7DD6422E8}</AdobeCode>
    <AdobeCode>{A35C2887-4D05-4D41-8473-4074C304F8FA}</AdobeCode>
    <AdobeCode>{0C9122B0-8ECC-47AC-8931-05DB6868D667}</AdobeCode>
    <AdobeCode>{B3A53CAB-7C3F-4E35-828A-2F53A46198A4}</AdobeCode>
    <AdobeCode>{01EF8527-75C5-4EE2-BE3E-AF298A12DABD}</AdobeCode>
    <AdobeCode>{28E5E248-7084-45FF-854F-1310C2E8A9B6}</AdobeCode>
    <AdobeCode>{6B82936D-B6D3-45F3-828C-5F2AF87EEDE6}</AdobeCode>
    <AdobeCode>{37896A59-8978-49AF-8988-95D9912B0060}</AdobeCode>
    <AdobeCode>{48727239-21AD-4444-9F5F-37AAF53B1A77}</AdobeCode>
    <AdobeCode>{EE9FF2FA-70C7-4840-97DA-86B745F88667}</AdobeCode>
    <AdobeCode>{3B502396-859C-495F-8A9C-D4E70AB7994D}</AdobeCode>
    <AdobeCode>{54C43E22-2AAF-44E9-A77A-94BF48425079}</AdobeCode>
    <AdobeCode>{D28586FC-BAD5-4EB4-A050-348F93CB1261}</AdobeCode>
    <AdobeCode>{8F2E0280-BBE3-4B9F-976C-CDB008EB737B}</AdobeCode>
    <AdobeCode>{FF3881E1-273C-44E5-91EC-9DB807AD2FF8}</AdobeCode>
    <AdobeCode>{A1F0BAF5-74D4-4A14-AFA5-49FE8136C932}</AdobeCode>
    <AdobeCode>{FF1E58CC-8549-4BA5-B5E9-608009986435}</AdobeCode>
    <AdobeCode>{3ABEB1C5-307C-4633-AEEF-3F62DBF2C9DE}</AdobeCode>
    <AdobeCode>{54CB9030-6A35-4426-9328-71748216A884}</AdobeCode>
    <AdobeCode>{04AB3C65-44A6-4DC3-9136-8D87D1117D1C}</AdobeCode>
    <AdobeCode>{21007E2D-0D3B-44CD-A07E-40819593B522}</AdobeCode>
    <AdobeCode>{17A94F2C-2ADF-4BE5-9FCB-8C7592FED773}</AdobeCode>
    <AdobeCode>{FF1E43B6-143C-48BC-8886-9107644E7CA9}</AdobeCode>
    <AdobeCode>{EC74B746-524A-4F89-93D4-0378561F43A7}</AdobeCode>
    <AdobeCode>{7AC10712-DA44-4115-95F6-9DC84A4CD8B2}</AdobeCode>
    <AdobeCode>{A79D021A-4C50-4295-83AC-0EC046C373B9}</AdobeCode>
    <AdobeCode>{A7BA2D74-9863-432E-B992-D91EF45061D6}</AdobeCode>
    <AdobeCode>{11C86F85-837C-4377-8FD6-1159B2C3A10A}</AdobeCode>
    <AdobeCode>{DD29CB9B-4550-4A75-B9B8-507EDFD1D4D7}</AdobeCode>
    <AdobeCode>{23435DBF-EAB1-4F7D-84FE-5C73C139B794}</AdobeCode>
    <AdobeCode>{0B9F1F2E-A91F-4921-8BDE-C8132679AE60}</AdobeCode>
    <AdobeCode>{A358C1A1-3A07-4680-B40C-B9D3343DDF7B}</AdobeCode>
    <AdobeCode>{8E1556EE-4CA5-4E3C-8C32-2AE0DBDB3BB8}</AdobeCode>
    <AdobeCode>{6C619526-5249-4EEF-9FEA-EC072181BC1B}</AdobeCode>
    <AdobeCode>{05D18608-9610-4397-A56E-A51AE61D11DC}</AdobeCode>
    <AdobeCode>{F27D2774-0068-4196-99A4-9D6E9BF17295}</AdobeCode>
    <AdobeCode>{19674DB1-E28F-4137-919B-F0D49A321166}</AdobeCode>
    <AdobeCode>{CF28C6ED-EAA5-4CBD-A457-9547DCBD05C3}</AdobeCode>
    <AdobeCode>{1A46ECEC-0E32-4759-944B-DC6E12C3B055}</AdobeCode>
    <AdobeCode>{B6A46655-6EDD-4F45-941C-CBC64C327F60}</AdobeCode>
    <AdobeCode>{8769AB72-CA49-466F-856F-05479ED56016}</AdobeCode>
    <AdobeCode>{0E584F38-5542-41F2-8291-E8D45FD1BDFC}</AdobeCode>
    <AdobeCode>{9191B0A5-DA0A-444D-9DA8-D88AC0CC9AC8}</AdobeCode>
    <AdobeCode>{FCA9D3A8-7E65-4896-B7A3-BB925209DCB0}</AdobeCode>
    <AdobeCode>{6EAB3B6B-19E8-4F26-BA34-0D6DD066E109}</AdobeCode>
    <AdobeCode>{E074F3E9-FD84-47FC-BED1-E572F71B1BAF}</AdobeCode>
    <AdobeCode>{4CD91959-34FA-4EF7-9CEC-83A2384E4144}</AdobeCode>
    <AdobeCode>{4E664593-3E5A-4008-BBCD-80EAB19A1DD4}</AdobeCode>
    <AdobeCode>{9F6D5243-386F-46D3-84BA-4B0157544488}</AdobeCode>
    <AdobeCode>{BF6081DC-FBD8-48FF-B8C3-8042EDA4CF26}</AdobeCode>
    <AdobeCode>{6AC43DB4-51CE-4867-95AC-F0212B15C2ED}</AdobeCode>
    <AdobeCode>{35DD31DD-0229-4B78-8033-9207723839A8}</AdobeCode>
    <AdobeCode>{D297C8D2-FB3E-45A0-928E-562379CD482E}</AdobeCode>
    <AdobeCode>{C9EA3A72-0FCD-47CB-B271-3C14765D3B9F}</AdobeCode>
    <AdobeCode>{1ECA5E5F-51EF-4D25-ABD9-F09326AAF989}</AdobeCode>
    <AdobeCode>{7D9ED791-341A-4F4D-BAF0-7D9FB3236669}</AdobeCode>
    <AdobeCode>{8F891302-075F-4E99-A795-46C7E8E72224}</AdobeCode>
    <AdobeCode>{C3F4D02A-809B-4537-864D-3575886B7F41}</AdobeCode>
    <AdobeCode>{BFAEDE79-F22F-4784-8A7C-DCF502AD4D1F}</AdobeCode>
    <AdobeCode>{6F805F05-2404-4894-A22A-8CC6F7D04580}</AdobeCode>
    <AdobeCode>{C2026C27-D2BE-4AA7-A662-D5CC453AE9A9}</AdobeCode>
    <AdobeCode>{3154B671-596F-4B56-AE94-3C2628EAD4D6}</AdobeCode>
    <AdobeCode>{EE4B0BC0-C470-4F13-846F-C8CB46C3A224}</AdobeCode>
    <AdobeCode>{76470281-ADE7-4B66-A2B3-F4359C83210B}</AdobeCode>
    <AdobeCode>{5FAA071A-F47D-47E7-A2BE-F7A66FD33287}</AdobeCode>
    <AdobeCode>{7932F8EE-C7C7-4291-99B6-DA92F51E181E}</AdobeCode>
    <AdobeCode>{10460AC8-5CB1-4AB6-BFD7-B2E8BCB2CB88}</AdobeCode>
    <AdobeCode>{C170090D-AEE7-4AD6-B355-428F2C227608}</AdobeCode>
    <AdobeCode>{F6E5C657-801E-413F-88E3-62775D7E715B}</AdobeCode>
    <AdobeCode>{DDFFC4F4-AF6F-4A09-8356-31049ADD5DBE}</AdobeCode>
    <AdobeCode>{6F0FA794-63E0-4A56-97E9-42ABE42026FA}</AdobeCode>
    <AdobeCode>{69AAED52-61BA-43D0-ACDD-C97370A57992}</AdobeCode>
    <AdobeCode>{1C780B04-1893-418E-BD6E-C4A3F5A5A644}</AdobeCode>
    <AdobeCode>{F91EB724-58C7-4241-8C29-32E9D8E950C2}</AdobeCode>
    <AdobeCode>{3FBAF0C1-E72E-4C65-A268-59FA98F08476}</AdobeCode>
    <AdobeCode>{1B4E8C2E-C376-4855-898C-935930DDA075}</AdobeCode>
    <AdobeCode>{C16D8C14-59D9-45B1-9057-4F06FC2131BC}</AdobeCode>
    <AdobeCode>{1D636BB2-C24E-401C-AABD-1461EECC6770}</AdobeCode>
    <AdobeCode>{D5AFFC13-C34D-40F9-A812-5980CC8B43DF}</AdobeCode>
    <AdobeCode>{1AE85DB5-BC53-4194-AE12-7C8E1A87E3AC}</AdobeCode>
    <AdobeCode>{283A703E-BBFB-4D8D-93D3-D3D05ABE98D5}</AdobeCode>
    <AdobeCode>{5283ED77-581D-48F9-A2F1-CC6DF286753F}</AdobeCode>
    <AdobeCode>{F26951D1-5EC7-4D47-8DED-9FC185E7F85C}</AdobeCode>
    <AdobeCode>{F44AB292-FB09-4BEB-ACE2-3C122433E8E6}</AdobeCode>
    <AdobeCode>{084A1460-0578-4D8F-95A1-EAC96CC74199}</AdobeCode>
    <AdobeCode>{F3D6A6EC-10D5-4E45-8FDA-88F03F353CB5}</AdobeCode>
    <AdobeCode>{80625461-7BD1-4F3C-918B-6C333D18EA8E}</AdobeCode>
    <AdobeCode>{DB2935E9-AB51-4625-8991-0FC99D70F0DA}</AdobeCode>
    <AdobeCode>{9496617D-FC9E-4AB0-A5AD-64417FF3EA7A}</AdobeCode>
    <AdobeCode>{DA2A91EC-AE32-4138-ABB5-1176AC9DCA3C}</AdobeCode>
    <AdobeCode>{E8632CBD-A455-45F1-8C4D-C2A14E0E0AF0}</AdobeCode>
    <AdobeCode>{866E2FE3-2FE8-4C0C-B472-5D816F47630E}</AdobeCode>
    <AdobeCode>{A2FC240E-24F4-4B4D-900A-69C2644E9A96}</AdobeCode>
    <AdobeCode>{12165EE7-DCB9-48A3-9658-5D54B26156CE}</AdobeCode>
    <AdobeCode>{973DB403-1A9E-4D45-B603-4AFBEBDA3B42}</AdobeCode>
    <AdobeCode>{374D8627-4401-4EE2-A25C-F2A6F24123F2}</AdobeCode>
    <AdobeCode>{1ECEE78F-62A9-41AA-975A-075B9F4B7521}</AdobeCode>
    <AdobeCode>{5BFDCA69-4C1F-4AB5-AAEA-DE84D757536D}</AdobeCode>
    <AdobeCode>{5CE95589-36F3-4178-B3B0-DC884FA09ECD}</AdobeCode>
    <AdobeCode>{AE581541-DBB9-42E2-AE2D-B02BAF8CFF6F}</AdobeCode>
    <AdobeCode>{730151E3-2938-4744-8F3D-680A5A6CB086}</AdobeCode>
    <AdobeCode>{1246D290-A992-473E-82E8-F8EFF08C05AE}</AdobeCode>
    <AdobeCode>{6D096089-FACF-4E33-8D54-DBDE5543B099}</AdobeCode>
    <AdobeCode>{82197C8C-0168-484C-A468-D6A113F58A46}</AdobeCode>
    <AdobeCode>{0096676C-9A74-4EB1-860D-B40517C36D48}</AdobeCode>
    <AdobeCode>{1800EFB7-34BF-499D-8C67-1EABF70460C9}</AdobeCode>
    <AdobeCode>{B583AC44-A43D-4380-93F5-59EB2F1BF5D7}</AdobeCode>
    <AdobeCode>{53197C90-EDB4-4924-B01B-0DB51236D416}</AdobeCode>
    <AdobeCode>{ACB69932-3543-4B74-BD1F-F01AD416D013}</AdobeCode>
    <AdobeCode>{9BDD6EFB-7914-4285-BFC7-36873AA2F42D}</AdobeCode>
    <AdobeCode>{29BB8AE6-57E9-41CC-AB2C-75B7B2A617BA}</AdobeCode>
    <AdobeCode>{A7179014-A365-4D46-90B5-3D0B116CAA2B}</AdobeCode>
    <AdobeCode>{73407700-80EA-4168-8DCA-75C66A49F68F}</AdobeCode>
    <AdobeCode>{462E7F92-130D-4218-BDB8-AEF17C5EDE24}</AdobeCode>
    <AdobeCode>{432FF194-31D8-4C86-B7CF-6ECAD0D25C24}</AdobeCode>
    <AdobeCode>{5006DE15-370B-416D-B506-B7930D1FD201}</AdobeCode>
    <AdobeCode>{B34297BD-65C4-474C-8807-4CD8F210ABB4}</AdobeCode>
    <AdobeCode>{CD7438E0-5881-4FB1-B3B4-3C07F281899E}</AdobeCode>
    <AdobeCode>{E648EB50-98C9-4206-B344-988C24EFED7F}</AdobeCode>
    <AdobeCode>{7C7D4925-331F-427D-8E70-31B35811A14E}</AdobeCode>
    <AdobeCode>{230E196A-0E57-4986-92B5-169D2783B4E6}</AdobeCode>
    <AdobeCode>{E352003D-2179-4757-9664-B370914B59B7}</AdobeCode>
    <AdobeCode>{C447B77D-9BCC-45FC-9DFD-04F95AE520A5}</AdobeCode>
    <AdobeCode>{E3379B1F-71F4-4A38-9F2B-A498F9F0FA13}</AdobeCode>
    <AdobeCode>{502613D4-D65C-4F8C-9E9F-E71DBFB7670F}</AdobeCode>
    <AdobeCode>{E5D8EF44-6039-450E-B3CE-00D8924902B8}</AdobeCode>
    <AdobeCode>{A0BEAF6D-A2F6-40AA-A63E-C9050E772801}</AdobeCode>
    <AdobeCode>{98F977AF-F9EA-4027-99F1-26837A8B2FD2}</AdobeCode>
    <AdobeCode>{C10E6A35-690A-40BC-8121-A150A45CCC1C}</AdobeCode>
    <AdobeCode>{36090C6B-1A52-4710-A2EC-9C64160561AB}</AdobeCode>
    <AdobeCode>{947B43C6-FF66-42AF-92EA-BD5DC70A5721}</AdobeCode>
    <AdobeCode>{6C227956-8B99-4E47-AF6B-C08594F2CFC8}</AdobeCode>
    <AdobeCode>{7AC26064-4F13-4ACA-886F-0F58C6151457}</AdobeCode>
    <AdobeCode>{0B89E31B-D7A5-4232-9995-118A210C6B51}</AdobeCode>
    <AdobeCode>{2044F3C6-92DF-434D-9E7E-A7B74AA5A01B}</AdobeCode>
    <AdobeCode>{C648DA3C-0D53-41D0-BB78-925008614A5D}</AdobeCode>
    <AdobeCode>{3DB9E8AE-C108-4852-934D-021F3FEF97B2}</AdobeCode>
    <AdobeCode>{C90FEAFF-C7F5-441F-A4A8-9ACB776EC400}</AdobeCode>
    <AdobeCode>{5AD74727-BFCD-4F21-9705-3D6DFD8D4A8E}</AdobeCode>
    <AdobeCode>{45B9401A-7DF5-4E5A-9987-897179E9B669}</AdobeCode>
    <AdobeCode>{638664AE-CD4C-45E1-80A3-768178CAE851}</AdobeCode>
    <AdobeCode>{C791874D-9256-426A-915F-BC2D37D3B4FF}</AdobeCode>
    <AdobeCode>{0248F18A-E609-440E-97FB-0BC4A0CFA888}</AdobeCode>
    <AdobeCode>{32AB00A8-D273-4AA5-8195-8844E0CE6CC0}</AdobeCode>
    <AdobeCode>{143E7B8D-68FF-4E08-BE4A-0962AC998027}</AdobeCode>
    <AdobeCode>{7289C6C9-58ED-464B-9804-794E53E345C9}</AdobeCode>
    <AdobeCode>{2FFD8434-AE64-464F-ADD5-5DEB55C9DAD8}</AdobeCode>
    <AdobeCode>{84C2040F-AB7A-48B5-B82D-DC44EF9DA023}</AdobeCode>
    <AdobeCode>{2BD7B320-D7C1-4E2A-80FC-F634B52DE365}</AdobeCode>
    <AdobeCode>{82535F24-FF24-4873-9C7E-47DC0CFB98B3}</AdobeCode>
    <AdobeCode>{0347B002-318F-4E4E-ABC6-2B112B82CF57}</AdobeCode>
    <AdobeCode>{4500B3EE-26C8-4606-90C9-0E728EF35A53}</AdobeCode>
    <AdobeCode>{48FBCCF3-3551-4916-8B8E-B51F25115773}</AdobeCode>
    <AdobeCode>{F62D21A3-6965-4A3E-9519-3A58670807DA}</AdobeCode>
    <AdobeCode>{962E7344-FB62-4CC6-8DE6-49AC2A5CD1AF}</AdobeCode>
    <AdobeCode>{6A2BB588-BE4B-4B05-90ED-BF02AA258634}</AdobeCode>
    <AdobeCode>{65744AB7-F370-4BEB-B2D8-874F4849FE82}</AdobeCode>
    <AdobeCode>{D391940F-1904-49A0-AECC-0CCB66555893}</AdobeCode>
    <AdobeCode>{F65493E0-3A71-44C1-AF10-004CA3F77F30}</AdobeCode>
    <AdobeCode>{B2E8AA57-9369-4F91-B536-62F61BE60356}</AdobeCode>
    <AdobeCode>{570E9B7E-1BF3-4D98-AA66-5A5A1A5DB24D}</AdobeCode>
    <AdobeCode>{432BFBDB-6365-4372-9B17-76CA822AF509}</AdobeCode>
    <AdobeCode>{39EB2884-E201-4260-9034-0C7358B0F5B6}</AdobeCode>
    <AdobeCode>{53C7E79B-33B6-4F5C-86EF-0A601B5C8DFC}</AdobeCode>
    <AdobeCode>{C58BA6AF-C03B-41BA-A39D-6A480F8B67DB}</AdobeCode>
    <AdobeCode>{9917243A-BE42-463A-8B7A-53AE85A4BB85}</AdobeCode>
    <AdobeCode>{B9581136-CF1A-4128-B458-E5F22FA52B5E}</AdobeCode>
    <AdobeCode>{74D5A6C2-2587-4F73-9F2D-657B7C31EE89}</AdobeCode>
    <AdobeCode>{712D49B5-209D-4B41-935A-729677B05821}</AdobeCode>
    <AdobeCode>{14883A65-328C-4A9F-A909-1E6523279973}</AdobeCode>
    <AdobeCode>{19CB52C5-542A-4DFB-A556-93DA6A152574}</AdobeCode>
    <AdobeCode>{B34AF69C-0F03-43D9-9ECD-28251F5868BF}</AdobeCode>
    <AdobeCode>{B1C1BD56-F1E5-404B-8D70-38CB0F4A46E1}</AdobeCode>
    <AdobeCode>{7E8350A4-64F6-4E82-8935-BDDE57ECA06C}</AdobeCode>
    <AdobeCode>{1C33CF08-93CE-4207-B8CB-54023D433DC0}</AdobeCode>
    <AdobeCode>{DD5A26D5-C3CE-42A4-8492-4CF8B3AA9294}</AdobeCode>
    <AdobeCode>{9FD70F27-358B-49A4-8596-FDE54A59D244}</AdobeCode>
    <AdobeCode>{0F12BE76-D0D0-4D90-B50B-70D17E36978A}</AdobeCode>
    <AdobeCode>{74B01DDF-BD4C-4D16-B4C1-ACCA5142FC4A}</AdobeCode>
    <AdobeCode>{D0CF14B8-AA3F-4309-8404-13080B84049D}</AdobeCode>
    <AdobeCode>{D0C0AE90-E342-4CD8-9EA6-6C3FE3922BEA}</AdobeCode>
    <AdobeCode>{1D8868AF-BE63-4200-8F5F-DCEA6BD41848}</AdobeCode>
    <AdobeCode>{6644FA45-0C27-46E4-9418-D6DB65086986}</AdobeCode>
    <AdobeCode>{47B772B9-CAD0-4475-8596-8053E7A43989}</AdobeCode>
    <AdobeCode>{97E17459-DFF2-4541-853F-1D0645727CB3}</AdobeCode>
    <AdobeCode>{EF001A73-9826-46A1-A951-E1950B62C4B1}</AdobeCode>
    <AdobeCode>{1C00728B-B854-4F69-9DEA-17A7961B6B98}</AdobeCode>
    <AdobeCode>{03E800DC-3895-46E7-B5A9-000FFBEC7C30}</AdobeCode>
    <AdobeCode>{F07DB986-D0D8-41C4-AE96-66EC9DBED486}</AdobeCode>
    <AdobeCode>{7B22BF45-7798-4C19-8A5F-81B561B588EC}</AdobeCode>
    <AdobeCode>{F3A755AA-5A06-47D3-9AD4-F2CDADDB3B4E}</AdobeCode>
    <AdobeCode>{7F588C1B-878F-4FA0-9310-5431EF8971ED}</AdobeCode>
    <AdobeCode>{D470D9ED-412A-4F9E-A8D5-25A2132424D4}</AdobeCode>
    <AdobeCode>{35E1D150-76FE-4D4A-A7BC-5F9C2ED9B572}</AdobeCode>
    <AdobeCode>{72759E88-E98F-43BC-87F8-4E3764716938}</AdobeCode>
    <AdobeCode>{DA0829D7-0BD6-4539-881D-E715E72B9DFB}</AdobeCode>
    <AdobeCode>{4C26EDAA-BEBE-4DB1-9D28-28D99E828880}</AdobeCode>
    <AdobeCode>{4C4AE924-E739-4A87-843C-760B0B592308}</AdobeCode>
    <AdobeCode>{A258414D-ADCD-48B2-A800-3E927AE93B3E}</AdobeCode>
    <AdobeCode>{F0B7A64E-0D03-43F3-93C8-C8738FAC7F81}</AdobeCode>
    <AdobeCode>{DB019779-83E8-4648-AB77-219AF78CA790}</AdobeCode>
    <AdobeCode>{6923B816-0CC1-4EE2-9F11-93106A1B0DD9}</AdobeCode>
    <AdobeCode>{457C56E0-00D7-4E2B-B629-991D80F01EDA}</AdobeCode>
    <AdobeCode>{9AEF659F-764F-46F1-BB67-F54927A76666}</AdobeCode>
    <AdobeCode>{EAD8425A-507B-4D1D-A154-E03CAB5168D6}</AdobeCode>
    <AdobeCode>{BC0E173F-A43C-4FC4-BEDE-042FD1665BDC}</AdobeCode>
    <AdobeCode>{ABB524EA-9382-4494-8BA9-6BDA89314838}</AdobeCode>
    <AdobeCode>{8D9F8112-A866-4454-AF60-CC2079CA560A}</AdobeCode>
    <AdobeCode>{FB0A78EE-BE02-4A75-AFB8-CE2DE901519A}</AdobeCode>
    <AdobeCode>{56060C02-947A-4B92-9A36-9925B119A001}</AdobeCode>
    <AdobeCode>{3B5441E9-1EEA-4F41-A9D5-45726FFE483B}</AdobeCode>
    <AdobeCode>{8C82AC7F-6119-43DA-B691-AD02CE4C3D48}</AdobeCode>
    <AdobeCode>{2355319B-B9A6-4BAB-8266-F1B7376F455B}</AdobeCode>
    <AdobeCode>{9010941E-93C3-4AE6-B8E0-5168B02FB096}</AdobeCode>
    <AdobeCode>{CF41C361-37F9-4ED3-A0CA-DD0438D62C59}</AdobeCode>
    <AdobeCode>{2B3C699A-876F-4CAE-9093-5B06570C0CC3}</AdobeCode>
    <AdobeCode>{4A56B5B8-09E1-4FFA-8D42-8B6B424DBC96}</AdobeCode>
    <AdobeCode>{3EA111A2-20AB-4239-B39C-000BB75E04CE}</AdobeCode>
    <AdobeCode>{C503F43D-C728-4658-8C7A-E356090A049D}</AdobeCode>
    <AdobeCode>{FF5E2D6B-F5DA-43B3-B92E-D7DE318E811A}</AdobeCode>
    <AdobeCode>{36A2F0CA-830B-4003-80C1-4C545AD556FA}</AdobeCode>
    <AdobeCode>{F02FDF99-3D47-4637-9363-DA371BFA44C6}</AdobeCode>
    <AdobeCode>{564AD75D-C977-45AE-9178-12FFCE3A19A6}</AdobeCode>
    <AdobeCode>{BE48DDAB-7930-4972-BE2E-FA2A2BAA12E6}</AdobeCode>
    <AdobeCode>{55967F4D-5EDD-44DA-BD39-63054A9B7330}</AdobeCode>
    <AdobeCode>{5D239502-8980-4737-80EF-D2466BAC3131}</AdobeCode>
    <AdobeCode>{B86410B8-CD81-4E18-B98C-5E33FE138352}</AdobeCode>
    <AdobeCode>{E7A4FD74-6B67-42CD-8B55-0B06894F456D}</AdobeCode>
    <AdobeCode>{F31F4664-47C6-4FAF-8C76-09F07329EFAD}</AdobeCode>
    <AdobeCode>{CEDC15B9-E830-4CA4-B3D1-E7DC84813DB9}</AdobeCode>
  </Upgrades><Channel enable="1" id="PhotoshopCameraRaw764bit-7.0">
    <DisplayName>Photoshop Camera Raw 7 (64 bit)</DisplayName>
  </Channel><AMTConfig path="[INSTALLDIR]\Camera Raw 7\AMT\component.xml" LEID=""/><InstallDestinationMetadata relocatableSize="23220316" sysDriveSize="0"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>23220316</TotalSize>
      <MaxPathComponent>/Plug-Ins/CS6/File Formats\Camera Raw.8bi</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[_OOBEHome]</Root>
      <TotalSize>0</TotalSize>
      <MaxPathComponent>/PCF\component.xml</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="1" name="Assets1_1" size="23220316"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	<Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr][Ff][Xx].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Dd][Nn][Gg] [Cc][Oo][Nn][Vv][Ee][Rr][Tt][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Bb][Rr][Ii][Dd][Gg][Ee].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Dd][Oo][Ww][Nn][Ll][Oo][Aa][Dd][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Ll][Ii][Gg][Hh][Tt][Rr][Oo][Oo][Mm].[Ee][Xx][Ee]$</Process>
    </Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">7.0</Value>
      <Value lang="be_BY">7.0</Value>
      <Value lang="bg_BG">7.0</Value>
      <Value lang="ca_ES">7.0</Value>
      <Value lang="cs_CZ">7.0</Value>
      <Value lang="da_DK">7.0</Value>
      <Value lang="de_DE">7.0</Value>
      <Value lang="el_GR">7.0</Value>
      <Value lang="en_GB">7.0</Value>
      <Value lang="en_MX">7.0</Value>
      <Value lang="en_US">7.0</Value>
      <Value lang="en_XC">7.0</Value>
      <Value lang="en_XM">7.0</Value>
      <Value lang="es_ES">7.0</Value>
      <Value lang="es_MX">7.0</Value>
      <Value lang="es_QM">7.0</Value>
      <Value lang="et_EE">7.0</Value>
      <Value lang="fi_FI">7.0</Value>
      <Value lang="fr_CA">7.0</Value>
      <Value lang="fr_FR">7.0</Value>
      <Value lang="fr_MX">7.0</Value>
      <Value lang="fr_XM">7.0</Value>
      <Value lang="he_IL">7.0</Value>
      <Value lang="hi_IN">7.0</Value>
      <Value lang="hr_HR">7.0</Value>
      <Value lang="hu_HU">7.0</Value>
      <Value lang="is_IS">7.0</Value>
      <Value lang="it_IT">7.0</Value>
      <Value lang="ja_JP">7.0</Value>
      <Value lang="ko_KR">7.0</Value>
      <Value lang="lt_LT">7.0</Value>
      <Value lang="lv_LV">7.0</Value>
      <Value lang="mk_MK">7.0</Value>
      <Value lang="nb_NO">7.0</Value>
      <Value lang="nl_NL">7.0</Value>
      <Value lang="nn_NO">7.0</Value>
      <Value lang="no_NO">7.0</Value>
      <Value lang="pl_PL">7.0</Value>
      <Value lang="pt_BR">7.0</Value>
      <Value lang="ro_RO">7.0</Value>
      <Value lang="ru_RU">7.0</Value>
      <Value lang="sh_YU">7.0</Value>
      <Value lang="sk_SK">7.0</Value>
      <Value lang="sl_SI">7.0</Value>
      <Value lang="sq_AL">7.0</Value>
      <Value lang="sv_SE">7.0</Value>
      <Value lang="th_TH">7.0</Value>
      <Value lang="tr_TR">7.0</Value>
      <Value lang="uk_UA">7.0</Value>
      <Value lang="vi_VN">7.0</Value>
      <Value lang="zh_CN">7.0</Value>
      <Value lang="zh_TW">7.0</Value>
      <Value lang="en_AE">7.0</Value>
      <Value lang="en_IL">7.0</Value>
      <Value lang="fr_MA">7.0</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="be_BY">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="bg_BG">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ca_ES">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="cs_CZ">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="da_DK">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="de_DE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="el_GR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_GB">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_MX">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_US">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_XC">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_XM">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="es_ES">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="es_MX">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="es_QM">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="et_EE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fi_FI">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_CA">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_FR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_MX">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_XM">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="he_IL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="hi_IN">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="hr_HR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="hu_HU">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="is_IS">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="it_IT">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ja_JP">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ko_KR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="lt_LT">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="lv_LV">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="mk_MK">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="nb_NO">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="nl_NL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="nn_NO">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="no_NO">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="pl_PL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="pt_BR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ro_RO">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="ru_RU">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sh_YU">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sk_SK">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sl_SI">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sq_AL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="sv_SE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="th_TH">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="tr_TR">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="uk_UA">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="vi_VN">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="zh_CN">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="zh_TW">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_AE">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="en_IL">Photoshop Camera Raw 7 (64 bit)</Value>
      <Value lang="fr_MA">Photoshop Camera Raw 7 (64 bit)</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{55F0AFED-606D-476A-A07A-134291002FBA}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{55F0AFED-606D-476A-A07A-134291002FBA}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{55F0AFED-606D-476A-A07A-134291002FBA}", "0", "AMTConfigPath", "[INSTALLDIR]\Camera Raw 7\AMT\component.xml")
INSERT INTO PayloadData VALUES("{55F0AFED-606D-476A-A07A-134291002FBA}", "0", "LEID", "")
INSERT INTO PayloadData VALUES("{55F0AFED-606D-476A-A07A-134291002FBA}", "0", "ChannelID", "PhotoshopCameraRaw764bit-7.0")
INSERT INTO PayloadData VALUES("{55F0AFED-606D-476A-A07A-134291002FBA}", "0", "ChannelInfo", '<Channel enable="1" id="PhotoshopCameraRaw764bit-7.0">
    <DisplayName>Photoshop Camera Raw 7 (64 bit)</DisplayName>
  </Channel>')
