CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{26E18390-51C1-440C-A601-F341F50A96FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{804026E6-A48C-4CBF-ACF1-FEE50E05150D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{DCF1A8EC-9988-4520-B4EE-0C05C06002D1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E6E128B0-303C-492B-9BF5-0F92DD0A008C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6EE275C6-9EB6-403A-9F63-C7CEE378DFBE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9C7850F7-6335-4EF8-A106-54E4922607DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{03133E1C-0F61-4001-A8B1-49345FA9A6C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9C5FF803-B5CE-401E-9F7C-66D971C67C1E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6F094D22-256D-4C57-A6E2-C4AABB739EBC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9CAF9208-F682-4076-87B7-7748E6C4EEAC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{698D3377-4233-43EE-9701-8680CB9DF61C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{328E681B-CF93-4B00-B2BC-152A9EAA06D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{8ECE30D8-7F2F-413D-BE83-A8213F9AC551}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6DDBF02C-63AF-4D33-9B9E-B35BA9FAC464}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{53780583-C5C8-4DEC-9452-51DF37AEE691}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{042AEB13-DBD2-4175-B769-7C3887BB75B6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{684C81D7-E1FC-43E4-8D87-12E626F75DAD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{151AFBA1-15DD-4B2B-85D3-3886CD589EDD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{039D925B-3CD4-4D0C-A86C-D0D3B5995137}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{CC9F0A42-3A4D-4E3D-98BC-697A142E4C3B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{4F6FB942-FF50-4C08-9749-DD38DE9959FD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{47822D9E-666B-4065-9F9D-0FD7BE066F91}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{10584E72-2D74-478A-B181-642898F76352}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B537237C-8934-4612-9033-72C70D28E495}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9228D1FE-6F6E-4A59-804B-DD901F938780}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{70E7D58B-24C1-43E2-9889-1B6AA9F0F628}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{4DAD218E-389F-44CC-B68C-2319C5CB60D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{AA0734FF-2529-47DE-8934-DD543CBE25C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D58913C9-A3FC-44FC-BACC-020C81DD8732}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E17DA149-F0FB-4B34-8C89-929B98D2023A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{3E5EB7BE-33CA-4310-B98B-8FCD9A1833B7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1FB86A1A-77F6-474F-BA5F-127A75DDC125}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F0CD3F7D-C1FA-4D85-9889-3A0A6D091F77}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6DCA1224-7B8D-4C4B-8816-290FA0EA404F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B3F810A9-F24B-4A06-814A-18E9C6271506}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1EFA2DC3-F60F-448A-B376-9DB516500C38}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B42337F9-8BE6-4C21-9DBA-D622E6258DBB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C04C4CB5-4114-48A3-9177-9914285C5A12}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{147FD86E-02C4-4444-8E6E-A126CA8F084E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{5CDF0608-69AC-479E-8219-5017C0D808C4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{0567243F-7D7B-4987-914C-96BC99E5ACFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{37FE33D5-A0F3-4FC5-AB77-442D1FB0186E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{BF5FDF4F-1C53-4955-9FB7-9CC47B02F2A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6A5D4A69-208F-4423-8017-433C85AE2D05}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C4F7AA95-9AC9-480E-B70E-2F49007A55DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F5DD766E-3573-44D0-B3DB-38BCCA40219C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{3A045C9F-6DF5-4661-AE50-905DEDEB7579}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B749A374-CDAC-4FC2-9C23-29C695F770A0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C589168C-05ED-4A57-B274-5BA2D1F5C1CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{DEE90902-CA2D-4CBC-BEA4-80025250FE75}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{98C60F4E-7D68-436A-8DBE-6E8BC15137C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E1851390-E41A-4725-9FE1-C9E5E03ECA8C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{19CF8374-EAEA-438B-801F-E3D6D86829A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{779CC1EC-86AD-4BB5-98CF-EE4FD0BEB3F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6AE58495-6EE9-4624-BDB4-3D36EABC1869}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{74E38210-3285-4F83-ADDA-386BABE8A4DF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{125B3D4E-A340-427D-BD85-5C2CEBCF7943}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{529E7612-04E1-46DE-A5FB-F5013EC4A7FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{403447DE-E3F7-435F-8047-E3210D4FCB98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D766A5EA-DAC6-4399-98F6-D5E1D3D96B3E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{7477B059-AC6B-4922-B876-6B28F7E60439}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{DE9FAAD8-5E8C-47B5-A417-4B7D4E3E2A47}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9DDE5B7A-2E6E-4D9B-A3CE-4674F52A5566}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1A35C53E-F81F-4BDF-B06B-33E07A4579BB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C70784B0-931C-4A64-B4DB-27F4B0B46D81}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{BD188278-49AA-4966-8AE8-F28B295A1C9F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{3A3ADA7D-772C-4040-9C39-5F079C8F3C9F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{82B465B5-D714-4D4B-8748-3EE05847C262}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{0499CB50-AB9D-453B-9625-38D9572BC69B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{743F0477-A514-4857-8610-559B8438B214}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{0F266E1B-046D-4645-AAB6-A1097FE22283}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D1ABA877-9F4C-45AD-89B5-F961777F02F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{FAFC9279-3924-4BC8-BA37-75499FCAC950}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{2299BA27-B7A5-475D-A3E3-2EEFD9EACAF0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{AE76531E-B01A-4586-9E77-0E04C5718C3A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{43706F3A-D966-44BA-9819-D1471EA9CB04}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B47CCEB9-75D5-4B9F-A301-84FE6003A2E9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F3782302-E662-4A56-B963-393A6BDD13B8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{965D8499-97C3-41D3-B026-4C1BA58790C3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B97B08FB-E834-4672-A42B-B76B75025CD2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{43C4AA51-8779-4DB8-8AB1-9F250A6722C5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{642396EA-3F24-4846-9D0F-7F4FB6DEEFFF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{4BF99399-8162-4F5D-BE5C-3F67BB5655B8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{0C4C598E-690B-404A-A113-CCF4DCB6469E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{5052E0A8-F47A-46CE-BDE2-1A7C9980EC93}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C7F82F23-3672-4E9E-813C-5634283909A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{ABA31685-7468-46BA-8503-E153C13DAD63}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1EAC48D9-A0DE-43C7-867B-8931432D039D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{40416315-1F22-4C28-9335-A63FC73579E8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{58E75357-F003-4A82-8C3F-C2D90C052A95}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{7C560565-E7DF-4952-B810-E62210BEAD07}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{FBA29457-4D82-42FA-81EF-A3B8D89B8411}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1058CFFD-6F5E-45B4-A6DF-FC90CB8909D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{972FEA07-7F60-49A4-8AE1-A465361DE389}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{EFEDCA7E-E883-465D-971D-5F7D29A2F122}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E6F21BB3-5CA0-466A-98CF-A28BCDC447B7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{A3025F3C-7F48-4D8D-A064-B4386A4C923A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{DEB491FB-D613-40C4-9B9D-B74EBF6715B2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{09D63153-2127-485E-89D8-C40442B5068C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1299B6CE-D5A2-479B-B400-098F980D7BC1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{4E5701BA-0F0F-41D6-A430-623FDDB06B97}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{ACE3E26B-8232-48C0-BD02-A0EDED739D4A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{22824C5A-836F-4A58-B270-3BC92CDD55ED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F86559D4-AE7C-4EDB-BA92-3F15EFA57582}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C1FECBE8-A38F-4BFB-9056-19FE7E4E4E52}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E8BC0A92-BC83-4D99-ADFB-91653639142C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{4F8DE136-6073-4537-BB01-DB48F79664E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{239B6D7D-3454-473A-9B62-B5DF8FD2DB6B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{8B07BEC5-D691-4FD9-BB5F-47BED57DD015}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{697ED581-F026-4F32-9832-C8BA6A8F7CBB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9CB52D05-45F4-452D-9105-011E49C79391}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B07A7B2C-A257-481A-B99E-6A3EA98D83B7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{756CCA11-F8EC-445A-95FE-E7BCCE3E20A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{A26CBBBE-FE80-4F47-A381-A2B141421F96}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{FFABD007-FDF2-4BA9-ADA9-626DB5919B29}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C16F1A9C-BD1C-425D-9553-77429891F94F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{30C3DB16-AD6F-451A-B9FE-3D977171B99C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{60CC62AA-3291-4BC6-AD42-BF0675F2A417}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{5C653CF4-FD42-4967-BCD8-BA18097FE3A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{CFA0D7E6-7CF2-4C99-8582-20FDEFFD789E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{BAAF928F-26B3-41AC-B3A7-130F01F984D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{5B7C1D8D-3043-42A6-9153-F400810E654D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1EBD5895-2F64-414A-B81C-A48310AA3410}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{FFC3CE1B-8295-41D0-A36E-02F8547D7371}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1B47DCC4-BD81-411D-9F5C-E54CD04FE861}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6AE78B8B-19E9-48D9-A4E7-CF9DBA77017F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1B19E0EE-7809-4BEB-915F-7755447ED994}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F1C07B99-A1C6-4200-8F68-B82A5C448882}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{7FCDC224-7A44-46E3-AD9C-975920BBCCAE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{64A0A431-39E0-42A0-ACC1-F2C15E4B80DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{8F7AD3AB-9F37-4259-8244-EB499F7905E3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{FAED8AEB-EFA8-4CDB-932F-C3AA8FFD6B38}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{813EFD2E-6D64-4CB1-B652-64A67FD8FC08}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D7AA6874-89CF-415A-A536-D09EC27E697E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{CF8A7963-187D-4F49-B900-72A42DDE18F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{AF7A9663-AA45-4E92-BEF0-3DD337F44C4D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C35CD136-4F9E-41CE-AF27-D5ACFA68E769}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{11B48001-4B8E-4D69-BE5B-AE8044DA4712}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E0D2937C-AB24-4C3F-95A4-6C8C455E6697}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B4ADDACE-B5EA-4267-97B6-9F61A711395A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{3F1827A1-C7F6-40A5-95BA-7E93689BB22B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E9153DCA-E62A-4499-A0B5-83A918175A27}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{317D741E-DC43-4C5B-B0E0-2001D6C9F1D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{89F8DB7F-390E-4DDA-8B0D-E2190A8A2883}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{EBB1C4EA-EFCA-42D8-B060-2B4B7877BB31}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9844162A-7415-4490-91E2-66A9191DA7A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{93437442-F5E1-4040-83C7-53A4774A683F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{3DF37D95-78A9-4D7D-AAF1-A239C5519131}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{88681AB4-CDBE-4653-83B1-5CC0B8B8DDAE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E6BA5C4F-1446-4422-AEA8-A855D1123C01}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E69E618E-9081-421E-9141-97E433C25A4A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{15F7393F-87E0-49A1-8AFD-A9D35C896F08}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{27F00867-2A2C-4DBE-ADB7-A4FDBB3275AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{459B2D23-875A-4D87-BFFC-9EA280FA0B94}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{12F775F1-9D94-4301-81A4-47015C231A4A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{A016970E-935D-4AD1-8943-23C22327760C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{79B907BB-78F0-494C-BBF1-7ED31D8A0D6E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{09ABCD2B-3D6F-4DD0-80E5-08A8F3335527}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{193982C1-ED7C-4C3E-A772-4D9019C390D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{257A6FE7-93DD-4EFF-8B6B-9775EE5E34DF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{CD8110FE-AA69-4798-82A0-2C99D5DFEE2C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E6FEF145-4BCB-424B-8000-E4AFB487FE39}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{16A0B115-D387-494F-9F30-5C87623BDCF4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C1CAD8D3-6641-4F7C-8FEE-19CEFD658868}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{EA568A79-D131-4CA5-924B-0C7BE6B13B8C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6943D528-87F8-485A-8A48-89DCF58E821B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1E6F4B61-96F7-4E8F-9553-387B7CF7015B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{64A6E56D-524A-428D-9413-DE2380B50BB4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{01A2DBAB-267B-4B79-B96A-B8014BEB5C52}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D3BAB4CA-AE7D-4B0D-9BF7-C340A586D3FA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D8C6CF94-56EA-41FA-B55F-3324E80F5985}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{39D7D7DF-0204-4C17-873B-3D09E4D4B867}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{29AB6C72-02C5-49F9-930E-A719DC064989}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{2C534BC9-4A14-4817-8738-6D7ABAD2D70D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{5E54AC3A-DB92-49E1-A747-27C7C65A104E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{CA684998-2AEC-47AF-AF87-DA274EAD48F6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D20AE2C3-FA4D-4FB2-9C7B-0FCD35434B23}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E2F697B5-3818-4721-86F3-A90C73583985}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{906B2307-2E78-4811-B280-27BE2885C231}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{18435A6E-99FC-4616-9E46-B8AD6BE0FFED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{CED174BE-EF87-44D2-9FF8-2AB61002CFEC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D1250D11-105A-4DC7-A853-D71B2B6AFEC9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{32E56799-5426-44BC-9173-3AFEED618CBE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{034F2EEF-7BAF-4E2B-8655-BA15CF303B7A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{3A6967D9-6EEC-4E8F-AFDA-2FBE9B864EB8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{36ED9E51-70B5-4AA9-B99B-D21F5BA2B1D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{22D58FCD-101F-42B7-B6CD-9125C88DF858}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D369B034-968E-4E16-9813-35A9E392DD37}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F74297FC-A426-4F36-8AE9-219B2355D320}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{54312C6A-088C-4BBB-885A-447E84244E57}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{839A5AD5-9E9A-4DCD-AC15-A04487075F7E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{71AD555A-E6C4-4364-97D5-1B4D1896FAFB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{EBFA07E6-CCF2-46C8-A0DF-1FBDA6D4D513}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{DF1D9E5C-05B0-4D02-8A06-3E8BAC591497}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C5C111DD-089A-4B56-A096-DFF9C489DDE1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{51C7133D-C1A4-4A11-9636-F909C126637B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{68B66795-CEC1-499A-B60C-9BF98DCFC8A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{4178604A-7D3C-4585-BC9C-5202C0A079C4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{21476931-07AD-4A22-B564-7289DD77FC09}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{325321C0-E475-4C10-B24E-BE00DA99FA31}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F6989485-0D8E-405B-A9EB-92590E64B955}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9FDED640-9680-4D7C-9B26-6FB6824C25DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{421EF8A5-6DE9-4F33-9CBB-1C900AB6D27D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E2DFD3F0-6E02-46A6-A580-8295A949056D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{1F9D2DAC-4A1F-4379-8AD4-DF8F537134F2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B8DCC03E-4D36-40A4-A1B4-4A01E3C77D35}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{477D5196-BC84-4998-A676-266523F0D7D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6D32CAC3-C6E2-419F-8D79-3D406EB5B749}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F29DC26A-534F-4167-978F-025B2EC3F47D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{3D9BAD97-AFAB-4B61-80E0-5BB2BEC30A1F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{45DD5CD5-495B-467C-A07E-1C6048EB210D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6BC965F3-215C-4BA1-A9CD-D1B7BD85ADF1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{A04B0086-82C8-4E8A-897F-918BE26BCCE1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{582B5493-BC85-4A79-ABFD-9ED02BF8FEAD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{91735C63-982B-4FE7-AA4D-F9C580300729}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D882892F-7AD3-4D5F-B35C-4B6530585406}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{0F193D0E-0340-4EAF-A8FE-57EF6E766F5C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9582E887-D8E8-43C6-8071-F5ABD83D9764}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{ADEF570A-E280-455D-9FBB-4DAB8647A97A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{345C2F60-15C5-4051-AC58-F61D5FBBD5A1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{30DB7CDD-6C6A-4C79-8C61-65D28A128FDD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{563EC2B5-CEA7-4344-929F-61CBD12338C2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{39AB309A-1155-4E7E-995C-D05D14569AEF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6461A37A-3F6A-46BD-9C1B-F844E5FB5010}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{BA1B548C-3443-4639-9055-EA9F33259F17}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6C9CC996-F10B-4161-9180-F8059598A15D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{FEBD5404-2CBA-40BF-8533-06664CEA6E35}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D54F4978-40BD-4978-8628-384FF2F56FB5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F0AB2088-52B3-4CE4-959B-C787878ABF82}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{88700B1C-559E-4705-84DC-63C5EF7A3CD9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{7157B22D-7586-4A8C-AB16-27B64185C40E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{345E5878-969F-42BF-8321-BC734A58ED92}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{8B3B6E28-D044-49B9-89A8-3DC159ECE6D1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{76E0ED8A-9C6F-4669-BE0E-DE5FEA1FAA00}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{7E796B04-0519-4251-A8A7-A2D03647411B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{896BDA75-80F1-461F-9BEE-C690A8DD8F95}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{33BFC97F-A11F-40CE-B865-B20D628FDBBF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{2D2C6F96-EE2D-4030-B49C-E424A60EAF34}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{BC972A71-CDCC-4E89-9040-D51B81A9F4D9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F2600F01-AC26-46A8-A9D8-C683C677DD19}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{608D20DC-8F6C-41C3-BB6D-EDE3093A86EE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D54B5E2F-AB72-49E9-9C9F-0E6A82380258}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{B5C8F8C4-C6DF-48B2-94A0-6DB8D7DEA83A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{95D88680-55B6-4771-AD87-0827358B8902}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{89EF02B8-D72C-4A61-8D04-E74B0B06DB1B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{72C72D0F-2393-4982-876B-22F8A531361F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{10061ADD-836E-4E46-B96F-C43C6374B8A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{F7EFA39F-AB55-4B73-B963-11F651DA2F01}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E2E68755-3FC3-48B2-B10B-4237C6671AE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{63A1AE27-5A22-4D0E-8D4D-14DD7CF6D8A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{7D8CFC5B-B376-4B62-BFEB-13FBA634A5AD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{60351D12-038C-4857-9C0E-2CB313F86DFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{7060F6C0-6BCC-4E45-8570-1E671328D480}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{FD3B4CAE-CA0A-4C6C-A988-9E81AA7AAE7C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{4EC7563B-8B13-49A6-8883-5C5AADBF9D7B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{BD321672-643D-44F6-9544-9476FB3D7902}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{80770000-AB0D-4022-9F7C-A738DE562FAC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{6938016A-27C4-4EFE-AAB4-F57D979F58F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{AAFC05A8-867E-4A5A-9F6E-3DA4A4630232}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9A72086B-3121-47D1-9DF8-2D208A29DF85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{A1FE3E90-3C48-432E-A976-4D26CE9FF276}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{49CC1379-A817-464E-9ED6-EEB41BC5C0FF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{33A8C261-5E72-4B8D-9CCC-23D41954D574}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{40F90221-5596-47B5-9432-21BC78CECD16}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D1F30B07-7CDB-4B23-A15A-CA18E2C01863}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{95A7E108-3FB4-402E-AAC3-91DD45A2D81C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{3C064D98-05DF-4912-8828-300653E55B22}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{D4789449-CA09-42FA-82F7-6AA238F60334}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{7DBC0F3A-4437-44B5-8791-307E45D04DCF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{90F922C9-62B8-4978-974C-99F5A3B7E4FF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{C2C3148B-CCF4-4978-8B59-6185CBE644DE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{E4F5FC4E-A9B1-4BAE-9B3B-BAF51CC57BBE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{0A23917A-D7EA-4634-BB05-9EEB2272FF61}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{79C8B2C8-8EF4-42A9-A006-574FDC447CAC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{9DA1EF20-5D0D-4489-BBF9-36F0C26AB403}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{91448EB0-F8F1-4815-8BF2-93059D684EB1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{DA05F075-FC84-43A8-8C63-0043F8573383}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{999045D3-5A10-4AE2-98A3-21BA6C984E0F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "{835A0A89-7541-407A-9342-476E3811F685}", "upgrade", "", "", "")
INSERT INTO PayloadData VALUES("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}"/>')
INSERT INTO PayloadData VALUES("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "0" , "ValidationSig", "OfN8AfN0k7oqSiSO4bPMD+2sUqXRiDsldIsSK5DvW6EeXprUUk3uMRb3Fe258KkXGSJz2D1vgNbBtb9sCext7M/+cWP6H72+3G/tiQvpW85op7wLAtcku7Md6cUQV8TgzsTJW4ZN1tf7lekdQiUdmlmXR/Z078Q0+/x1OmHCMOOxpkaEs0VdzQIHYzr9ZCrwI/T01C8kBsn/IpXlqDQr0tjggstBoVfhDOjPFVxzg6X0Pj5gpVYntFRnxqm3qH/hLLqQB7b2yF17Uv3Bip0AM0GvMDbL9LwU6hEfE9bRHOLjnXfJVygssU6mKWqWwc57ii93IUM0EbZsyYEoOAt8XfxpcL6kSbMW/3HF9Ub4cYNCrMOPfGk5DH9wLUhKB9bLv+zw3NC0vjcOgiBAKTMeivW3yww6U99EZ0wEFBl6blaFx/i1VdBooo3m69uWE7OWOTbFfMl20K+oSkDNip3hceoY49Izozott4YLrThSkAgyoPaCtKrYAa3fKk2u0s7Y")
INSERT INTO Payloads VALUES	("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "Creative Suite", "Adobe CSXS Extensions CS6", "3", "normal")
INSERT INTO PayloadData VALUES("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.29.0"><BuildInfo>
    <Property name="Created">2012-01-25 14:12:31.291000</Property>
    <Property name="TargetName">AdobeCSXSExtensions3-mul</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}</Property>
    <Property name="ProductName">Adobe CSXS Extensions CS6</Property>
    <Property name="ProductVersion">3</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="1" name="Default" folderName="">[AdobeCommon]\CS6ServiceManager\</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
		<Family>Creative Suite</Family>
		<!-- MAJOR-VERSION-UPDATE-MARKER (please do not remove this comment, required for automatic search) -->
		<ProductName>Adobe CSXS Extensions CS6</ProductName>
	<ProductVersion>3</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{26E18390-51C1-440C-A601-F341F50A96FB}</AdobeCode>
    <AdobeCode>{804026E6-A48C-4CBF-ACF1-FEE50E05150D}</AdobeCode>
    <AdobeCode>{DCF1A8EC-9988-4520-B4EE-0C05C06002D1}</AdobeCode>
    <AdobeCode>{E6E128B0-303C-492B-9BF5-0F92DD0A008C}</AdobeCode>
    <AdobeCode>{6EE275C6-9EB6-403A-9F63-C7CEE378DFBE}</AdobeCode>
    <AdobeCode>{9C7850F7-6335-4EF8-A106-54E4922607DD}</AdobeCode>
    <AdobeCode>{03133E1C-0F61-4001-A8B1-49345FA9A6C8}</AdobeCode>
    <AdobeCode>{9C5FF803-B5CE-401E-9F7C-66D971C67C1E}</AdobeCode>
    <AdobeCode>{6F094D22-256D-4C57-A6E2-C4AABB739EBC}</AdobeCode>
    <AdobeCode>{9CAF9208-F682-4076-87B7-7748E6C4EEAC}</AdobeCode>
    <AdobeCode>{698D3377-4233-43EE-9701-8680CB9DF61C}</AdobeCode>
    <AdobeCode>{328E681B-CF93-4B00-B2BC-152A9EAA06D5}</AdobeCode>
    <AdobeCode>{8ECE30D8-7F2F-413D-BE83-A8213F9AC551}</AdobeCode>
    <AdobeCode>{6DDBF02C-63AF-4D33-9B9E-B35BA9FAC464}</AdobeCode>
    <AdobeCode>{53780583-C5C8-4DEC-9452-51DF37AEE691}</AdobeCode>
    <AdobeCode>{042AEB13-DBD2-4175-B769-7C3887BB75B6}</AdobeCode>
    <AdobeCode>{684C81D7-E1FC-43E4-8D87-12E626F75DAD}</AdobeCode>
    <AdobeCode>{151AFBA1-15DD-4B2B-85D3-3886CD589EDD}</AdobeCode>
    <AdobeCode>{039D925B-3CD4-4D0C-A86C-D0D3B5995137}</AdobeCode>
    <AdobeCode>{CC9F0A42-3A4D-4E3D-98BC-697A142E4C3B}</AdobeCode>
    <AdobeCode>{4F6FB942-FF50-4C08-9749-DD38DE9959FD}</AdobeCode>
    <AdobeCode>{47822D9E-666B-4065-9F9D-0FD7BE066F91}</AdobeCode>
    <AdobeCode>{10584E72-2D74-478A-B181-642898F76352}</AdobeCode>
    <AdobeCode>{B537237C-8934-4612-9033-72C70D28E495}</AdobeCode>
    <AdobeCode>{9228D1FE-6F6E-4A59-804B-DD901F938780}</AdobeCode>
    <AdobeCode>{70E7D58B-24C1-43E2-9889-1B6AA9F0F628}</AdobeCode>
    <AdobeCode>{4DAD218E-389F-44CC-B68C-2319C5CB60D7}</AdobeCode>
    <AdobeCode>{AA0734FF-2529-47DE-8934-DD543CBE25C1}</AdobeCode>
    <AdobeCode>{D58913C9-A3FC-44FC-BACC-020C81DD8732}</AdobeCode>
    <AdobeCode>{E17DA149-F0FB-4B34-8C89-929B98D2023A}</AdobeCode>
    <AdobeCode>{3E5EB7BE-33CA-4310-B98B-8FCD9A1833B7}</AdobeCode>
    <AdobeCode>{1FB86A1A-77F6-474F-BA5F-127A75DDC125}</AdobeCode>
    <AdobeCode>{F0CD3F7D-C1FA-4D85-9889-3A0A6D091F77}</AdobeCode>
    <AdobeCode>{6DCA1224-7B8D-4C4B-8816-290FA0EA404F}</AdobeCode>
    <AdobeCode>{B3F810A9-F24B-4A06-814A-18E9C6271506}</AdobeCode>
    <AdobeCode>{1EFA2DC3-F60F-448A-B376-9DB516500C38}</AdobeCode>
    <AdobeCode>{B42337F9-8BE6-4C21-9DBA-D622E6258DBB}</AdobeCode>
    <AdobeCode>{C04C4CB5-4114-48A3-9177-9914285C5A12}</AdobeCode>
    <AdobeCode>{147FD86E-02C4-4444-8E6E-A126CA8F084E}</AdobeCode>
    <AdobeCode>{5CDF0608-69AC-479E-8219-5017C0D808C4}</AdobeCode>
    <AdobeCode>{0567243F-7D7B-4987-914C-96BC99E5ACFE}</AdobeCode>
    <AdobeCode>{37FE33D5-A0F3-4FC5-AB77-442D1FB0186E}</AdobeCode>
    <AdobeCode>{BF5FDF4F-1C53-4955-9FB7-9CC47B02F2A5}</AdobeCode>
    <AdobeCode>{6A5D4A69-208F-4423-8017-433C85AE2D05}</AdobeCode>
    <AdobeCode>{C4F7AA95-9AC9-480E-B70E-2F49007A55DE}</AdobeCode>
    <AdobeCode>{F5DD766E-3573-44D0-B3DB-38BCCA40219C}</AdobeCode>
    <AdobeCode>{3A045C9F-6DF5-4661-AE50-905DEDEB7579}</AdobeCode>
    <AdobeCode>{B749A374-CDAC-4FC2-9C23-29C695F770A0}</AdobeCode>
    <AdobeCode>{C589168C-05ED-4A57-B274-5BA2D1F5C1CD}</AdobeCode>
    <AdobeCode>{DEE90902-CA2D-4CBC-BEA4-80025250FE75}</AdobeCode>
    <AdobeCode>{98C60F4E-7D68-436A-8DBE-6E8BC15137C8}</AdobeCode>
    <AdobeCode>{E1851390-E41A-4725-9FE1-C9E5E03ECA8C}</AdobeCode>
    <AdobeCode>{19CF8374-EAEA-438B-801F-E3D6D86829A4}</AdobeCode>
    <AdobeCode>{779CC1EC-86AD-4BB5-98CF-EE4FD0BEB3F3}</AdobeCode>
    <AdobeCode>{6AE58495-6EE9-4624-BDB4-3D36EABC1869}</AdobeCode>
    <AdobeCode>{74E38210-3285-4F83-ADDA-386BABE8A4DF}</AdobeCode>
    <AdobeCode>{125B3D4E-A340-427D-BD85-5C2CEBCF7943}</AdobeCode>
    <AdobeCode>{529E7612-04E1-46DE-A5FB-F5013EC4A7FB}</AdobeCode>
    <AdobeCode>{403447DE-E3F7-435F-8047-E3210D4FCB98}</AdobeCode>
    <AdobeCode>{D766A5EA-DAC6-4399-98F6-D5E1D3D96B3E}</AdobeCode>
    <AdobeCode>{7477B059-AC6B-4922-B876-6B28F7E60439}</AdobeCode>
    <AdobeCode>{DE9FAAD8-5E8C-47B5-A417-4B7D4E3E2A47}</AdobeCode>
    <AdobeCode>{9DDE5B7A-2E6E-4D9B-A3CE-4674F52A5566}</AdobeCode>
    <AdobeCode>{1A35C53E-F81F-4BDF-B06B-33E07A4579BB}</AdobeCode>
    <AdobeCode>{C70784B0-931C-4A64-B4DB-27F4B0B46D81}</AdobeCode>
    <AdobeCode>{BD188278-49AA-4966-8AE8-F28B295A1C9F}</AdobeCode>
    <AdobeCode>{3A3ADA7D-772C-4040-9C39-5F079C8F3C9F}</AdobeCode>
    <AdobeCode>{82B465B5-D714-4D4B-8748-3EE05847C262}</AdobeCode>
    <AdobeCode>{0499CB50-AB9D-453B-9625-38D9572BC69B}</AdobeCode>
    <AdobeCode>{743F0477-A514-4857-8610-559B8438B214}</AdobeCode>
    <AdobeCode>{0F266E1B-046D-4645-AAB6-A1097FE22283}</AdobeCode>
    <AdobeCode>{D1ABA877-9F4C-45AD-89B5-F961777F02F2}</AdobeCode>
    <AdobeCode>{FAFC9279-3924-4BC8-BA37-75499FCAC950}</AdobeCode>
    <AdobeCode>{2299BA27-B7A5-475D-A3E3-2EEFD9EACAF0}</AdobeCode>
    <AdobeCode>{AE76531E-B01A-4586-9E77-0E04C5718C3A}</AdobeCode>
    <AdobeCode>{43706F3A-D966-44BA-9819-D1471EA9CB04}</AdobeCode>
    <AdobeCode>{B47CCEB9-75D5-4B9F-A301-84FE6003A2E9}</AdobeCode>
    <AdobeCode>{F3782302-E662-4A56-B963-393A6BDD13B8}</AdobeCode>
    <AdobeCode>{965D8499-97C3-41D3-B026-4C1BA58790C3}</AdobeCode>
    <AdobeCode>{B97B08FB-E834-4672-A42B-B76B75025CD2}</AdobeCode>
    <AdobeCode>{43C4AA51-8779-4DB8-8AB1-9F250A6722C5}</AdobeCode>
    <AdobeCode>{642396EA-3F24-4846-9D0F-7F4FB6DEEFFF}</AdobeCode>
    <AdobeCode>{4BF99399-8162-4F5D-BE5C-3F67BB5655B8}</AdobeCode>
    <AdobeCode>{0C4C598E-690B-404A-A113-CCF4DCB6469E}</AdobeCode>
    <AdobeCode>{5052E0A8-F47A-46CE-BDE2-1A7C9980EC93}</AdobeCode>
    <AdobeCode>{C7F82F23-3672-4E9E-813C-5634283909A5}</AdobeCode>
    <AdobeCode>{ABA31685-7468-46BA-8503-E153C13DAD63}</AdobeCode>
    <AdobeCode>{1EAC48D9-A0DE-43C7-867B-8931432D039D}</AdobeCode>
    <AdobeCode>{40416315-1F22-4C28-9335-A63FC73579E8}</AdobeCode>
    <AdobeCode>{58E75357-F003-4A82-8C3F-C2D90C052A95}</AdobeCode>
    <AdobeCode>{7C560565-E7DF-4952-B810-E62210BEAD07}</AdobeCode>
    <AdobeCode>{FBA29457-4D82-42FA-81EF-A3B8D89B8411}</AdobeCode>
    <AdobeCode>{1058CFFD-6F5E-45B4-A6DF-FC90CB8909D8}</AdobeCode>
    <AdobeCode>{972FEA07-7F60-49A4-8AE1-A465361DE389}</AdobeCode>
    <AdobeCode>{EFEDCA7E-E883-465D-971D-5F7D29A2F122}</AdobeCode>
    <AdobeCode>{E6F21BB3-5CA0-466A-98CF-A28BCDC447B7}</AdobeCode>
    <AdobeCode>{A3025F3C-7F48-4D8D-A064-B4386A4C923A}</AdobeCode>
    <AdobeCode>{DEB491FB-D613-40C4-9B9D-B74EBF6715B2}</AdobeCode>
    <AdobeCode>{09D63153-2127-485E-89D8-C40442B5068C}</AdobeCode>
    <AdobeCode>{1299B6CE-D5A2-479B-B400-098F980D7BC1}</AdobeCode>
    <AdobeCode>{4E5701BA-0F0F-41D6-A430-623FDDB06B97}</AdobeCode>
    <AdobeCode>{ACE3E26B-8232-48C0-BD02-A0EDED739D4A}</AdobeCode>
    <AdobeCode>{22824C5A-836F-4A58-B270-3BC92CDD55ED}</AdobeCode>
    <AdobeCode>{F86559D4-AE7C-4EDB-BA92-3F15EFA57582}</AdobeCode>
    <AdobeCode>{C1FECBE8-A38F-4BFB-9056-19FE7E4E4E52}</AdobeCode>
    <AdobeCode>{E8BC0A92-BC83-4D99-ADFB-91653639142C}</AdobeCode>
    <AdobeCode>{4F8DE136-6073-4537-BB01-DB48F79664E5}</AdobeCode>
    <AdobeCode>{239B6D7D-3454-473A-9B62-B5DF8FD2DB6B}</AdobeCode>
    <AdobeCode>{8B07BEC5-D691-4FD9-BB5F-47BED57DD015}</AdobeCode>
    <AdobeCode>{697ED581-F026-4F32-9832-C8BA6A8F7CBB}</AdobeCode>
    <AdobeCode>{9CB52D05-45F4-452D-9105-011E49C79391}</AdobeCode>
    <AdobeCode>{B07A7B2C-A257-481A-B99E-6A3EA98D83B7}</AdobeCode>
    <AdobeCode>{756CCA11-F8EC-445A-95FE-E7BCCE3E20A2}</AdobeCode>
    <AdobeCode>{A26CBBBE-FE80-4F47-A381-A2B141421F96}</AdobeCode>
    <AdobeCode>{FFABD007-FDF2-4BA9-ADA9-626DB5919B29}</AdobeCode>
    <AdobeCode>{C16F1A9C-BD1C-425D-9553-77429891F94F}</AdobeCode>
    <AdobeCode>{30C3DB16-AD6F-451A-B9FE-3D977171B99C}</AdobeCode>
    <AdobeCode>{60CC62AA-3291-4BC6-AD42-BF0675F2A417}</AdobeCode>
    <AdobeCode>{5C653CF4-FD42-4967-BCD8-BA18097FE3A9}</AdobeCode>
    <AdobeCode>{CFA0D7E6-7CF2-4C99-8582-20FDEFFD789E}</AdobeCode>
    <AdobeCode>{BAAF928F-26B3-41AC-B3A7-130F01F984D7}</AdobeCode>
    <AdobeCode>{5B7C1D8D-3043-42A6-9153-F400810E654D}</AdobeCode>
    <AdobeCode>{1EBD5895-2F64-414A-B81C-A48310AA3410}</AdobeCode>
    <AdobeCode>{FFC3CE1B-8295-41D0-A36E-02F8547D7371}</AdobeCode>
    <AdobeCode>{1B47DCC4-BD81-411D-9F5C-E54CD04FE861}</AdobeCode>
    <AdobeCode>{6AE78B8B-19E9-48D9-A4E7-CF9DBA77017F}</AdobeCode>
    <AdobeCode>{1B19E0EE-7809-4BEB-915F-7755447ED994}</AdobeCode>
    <AdobeCode>{F1C07B99-A1C6-4200-8F68-B82A5C448882}</AdobeCode>
    <AdobeCode>{7FCDC224-7A44-46E3-AD9C-975920BBCCAE}</AdobeCode>
    <AdobeCode>{64A0A431-39E0-42A0-ACC1-F2C15E4B80DD}</AdobeCode>
    <AdobeCode>{8F7AD3AB-9F37-4259-8244-EB499F7905E3}</AdobeCode>
    <AdobeCode>{FAED8AEB-EFA8-4CDB-932F-C3AA8FFD6B38}</AdobeCode>
    <AdobeCode>{813EFD2E-6D64-4CB1-B652-64A67FD8FC08}</AdobeCode>
    <AdobeCode>{D7AA6874-89CF-415A-A536-D09EC27E697E}</AdobeCode>
    <AdobeCode>{CF8A7963-187D-4F49-B900-72A42DDE18F3}</AdobeCode>
    <AdobeCode>{AF7A9663-AA45-4E92-BEF0-3DD337F44C4D}</AdobeCode>
    <AdobeCode>{C35CD136-4F9E-41CE-AF27-D5ACFA68E769}</AdobeCode>
    <AdobeCode>{11B48001-4B8E-4D69-BE5B-AE8044DA4712}</AdobeCode>
    <AdobeCode>{E0D2937C-AB24-4C3F-95A4-6C8C455E6697}</AdobeCode>
    <AdobeCode>{B4ADDACE-B5EA-4267-97B6-9F61A711395A}</AdobeCode>
    <AdobeCode>{3F1827A1-C7F6-40A5-95BA-7E93689BB22B}</AdobeCode>
    <AdobeCode>{E9153DCA-E62A-4499-A0B5-83A918175A27}</AdobeCode>
    <AdobeCode>{317D741E-DC43-4C5B-B0E0-2001D6C9F1D2}</AdobeCode>
    <AdobeCode>{89F8DB7F-390E-4DDA-8B0D-E2190A8A2883}</AdobeCode>
    <AdobeCode>{EBB1C4EA-EFCA-42D8-B060-2B4B7877BB31}</AdobeCode>
    <AdobeCode>{9844162A-7415-4490-91E2-66A9191DA7A2}</AdobeCode>
    <AdobeCode>{93437442-F5E1-4040-83C7-53A4774A683F}</AdobeCode>
    <AdobeCode>{3DF37D95-78A9-4D7D-AAF1-A239C5519131}</AdobeCode>
    <AdobeCode>{88681AB4-CDBE-4653-83B1-5CC0B8B8DDAE}</AdobeCode>
    <AdobeCode>{E6BA5C4F-1446-4422-AEA8-A855D1123C01}</AdobeCode>
    <AdobeCode>{E69E618E-9081-421E-9141-97E433C25A4A}</AdobeCode>
    <AdobeCode>{15F7393F-87E0-49A1-8AFD-A9D35C896F08}</AdobeCode>
    <AdobeCode>{27F00867-2A2C-4DBE-ADB7-A4FDBB3275AE}</AdobeCode>
    <AdobeCode>{459B2D23-875A-4D87-BFFC-9EA280FA0B94}</AdobeCode>
    <AdobeCode>{12F775F1-9D94-4301-81A4-47015C231A4A}</AdobeCode>
    <AdobeCode>{A016970E-935D-4AD1-8943-23C22327760C}</AdobeCode>
    <AdobeCode>{79B907BB-78F0-494C-BBF1-7ED31D8A0D6E}</AdobeCode>
    <AdobeCode>{09ABCD2B-3D6F-4DD0-80E5-08A8F3335527}</AdobeCode>
    <AdobeCode>{193982C1-ED7C-4C3E-A772-4D9019C390D0}</AdobeCode>
    <AdobeCode>{257A6FE7-93DD-4EFF-8B6B-9775EE5E34DF}</AdobeCode>
    <AdobeCode>{CD8110FE-AA69-4798-82A0-2C99D5DFEE2C}</AdobeCode>
    <AdobeCode>{E6FEF145-4BCB-424B-8000-E4AFB487FE39}</AdobeCode>
    <AdobeCode>{16A0B115-D387-494F-9F30-5C87623BDCF4}</AdobeCode>
    <AdobeCode>{C1CAD8D3-6641-4F7C-8FEE-19CEFD658868}</AdobeCode>
    <AdobeCode>{EA568A79-D131-4CA5-924B-0C7BE6B13B8C}</AdobeCode>
    <AdobeCode>{6943D528-87F8-485A-8A48-89DCF58E821B}</AdobeCode>
    <AdobeCode>{1E6F4B61-96F7-4E8F-9553-387B7CF7015B}</AdobeCode>
    <AdobeCode>{64A6E56D-524A-428D-9413-DE2380B50BB4}</AdobeCode>
    <AdobeCode>{01A2DBAB-267B-4B79-B96A-B8014BEB5C52}</AdobeCode>
    <AdobeCode>{D3BAB4CA-AE7D-4B0D-9BF7-C340A586D3FA}</AdobeCode>
    <AdobeCode>{D8C6CF94-56EA-41FA-B55F-3324E80F5985}</AdobeCode>
    <AdobeCode>{39D7D7DF-0204-4C17-873B-3D09E4D4B867}</AdobeCode>
    <AdobeCode>{29AB6C72-02C5-49F9-930E-A719DC064989}</AdobeCode>
    <AdobeCode>{2C534BC9-4A14-4817-8738-6D7ABAD2D70D}</AdobeCode>
    <AdobeCode>{5E54AC3A-DB92-49E1-A747-27C7C65A104E}</AdobeCode>
    <AdobeCode>{CA684998-2AEC-47AF-AF87-DA274EAD48F6}</AdobeCode>
    <AdobeCode>{D20AE2C3-FA4D-4FB2-9C7B-0FCD35434B23}</AdobeCode>
    <AdobeCode>{E2F697B5-3818-4721-86F3-A90C73583985}</AdobeCode>
    <AdobeCode>{906B2307-2E78-4811-B280-27BE2885C231}</AdobeCode>
    <AdobeCode>{18435A6E-99FC-4616-9E46-B8AD6BE0FFED}</AdobeCode>
    <AdobeCode>{CED174BE-EF87-44D2-9FF8-2AB61002CFEC}</AdobeCode>
    <AdobeCode>{D1250D11-105A-4DC7-A853-D71B2B6AFEC9}</AdobeCode>
    <AdobeCode>{32E56799-5426-44BC-9173-3AFEED618CBE}</AdobeCode>
    <AdobeCode>{034F2EEF-7BAF-4E2B-8655-BA15CF303B7A}</AdobeCode>
    <AdobeCode>{3A6967D9-6EEC-4E8F-AFDA-2FBE9B864EB8}</AdobeCode>
    <AdobeCode>{36ED9E51-70B5-4AA9-B99B-D21F5BA2B1D6}</AdobeCode>
    <AdobeCode>{22D58FCD-101F-42B7-B6CD-9125C88DF858}</AdobeCode>
    <AdobeCode>{D369B034-968E-4E16-9813-35A9E392DD37}</AdobeCode>
    <AdobeCode>{F74297FC-A426-4F36-8AE9-219B2355D320}</AdobeCode>
    <AdobeCode>{54312C6A-088C-4BBB-885A-447E84244E57}</AdobeCode>
    <AdobeCode>{839A5AD5-9E9A-4DCD-AC15-A04487075F7E}</AdobeCode>
    <AdobeCode>{71AD555A-E6C4-4364-97D5-1B4D1896FAFB}</AdobeCode>
    <AdobeCode>{EBFA07E6-CCF2-46C8-A0DF-1FBDA6D4D513}</AdobeCode>
    <AdobeCode>{DF1D9E5C-05B0-4D02-8A06-3E8BAC591497}</AdobeCode>
    <AdobeCode>{C5C111DD-089A-4B56-A096-DFF9C489DDE1}</AdobeCode>
    <AdobeCode>{51C7133D-C1A4-4A11-9636-F909C126637B}</AdobeCode>
    <AdobeCode>{68B66795-CEC1-499A-B60C-9BF98DCFC8A8}</AdobeCode>
    <AdobeCode>{4178604A-7D3C-4585-BC9C-5202C0A079C4}</AdobeCode>
    <AdobeCode>{21476931-07AD-4A22-B564-7289DD77FC09}</AdobeCode>
    <AdobeCode>{325321C0-E475-4C10-B24E-BE00DA99FA31}</AdobeCode>
    <AdobeCode>{F6989485-0D8E-405B-A9EB-92590E64B955}</AdobeCode>
    <AdobeCode>{9FDED640-9680-4D7C-9B26-6FB6824C25DC}</AdobeCode>
    <AdobeCode>{421EF8A5-6DE9-4F33-9CBB-1C900AB6D27D}</AdobeCode>
    <AdobeCode>{E2DFD3F0-6E02-46A6-A580-8295A949056D}</AdobeCode>
    <AdobeCode>{1F9D2DAC-4A1F-4379-8AD4-DF8F537134F2}</AdobeCode>
    <AdobeCode>{B8DCC03E-4D36-40A4-A1B4-4A01E3C77D35}</AdobeCode>
    <AdobeCode>{477D5196-BC84-4998-A676-266523F0D7D8}</AdobeCode>
    <AdobeCode>{6D32CAC3-C6E2-419F-8D79-3D406EB5B749}</AdobeCode>
    <AdobeCode>{F29DC26A-534F-4167-978F-025B2EC3F47D}</AdobeCode>
    <AdobeCode>{3D9BAD97-AFAB-4B61-80E0-5BB2BEC30A1F}</AdobeCode>
    <AdobeCode>{45DD5CD5-495B-467C-A07E-1C6048EB210D}</AdobeCode>
    <AdobeCode>{6BC965F3-215C-4BA1-A9CD-D1B7BD85ADF1}</AdobeCode>
    <AdobeCode>{A04B0086-82C8-4E8A-897F-918BE26BCCE1}</AdobeCode>
    <AdobeCode>{582B5493-BC85-4A79-ABFD-9ED02BF8FEAD}</AdobeCode>
    <AdobeCode>{91735C63-982B-4FE7-AA4D-F9C580300729}</AdobeCode>
    <AdobeCode>{D882892F-7AD3-4D5F-B35C-4B6530585406}</AdobeCode>
    <AdobeCode>{0F193D0E-0340-4EAF-A8FE-57EF6E766F5C}</AdobeCode>
    <AdobeCode>{9582E887-D8E8-43C6-8071-F5ABD83D9764}</AdobeCode>
    <AdobeCode>{ADEF570A-E280-455D-9FBB-4DAB8647A97A}</AdobeCode>
    <AdobeCode>{345C2F60-15C5-4051-AC58-F61D5FBBD5A1}</AdobeCode>
    <AdobeCode>{30DB7CDD-6C6A-4C79-8C61-65D28A128FDD}</AdobeCode>
    <AdobeCode>{563EC2B5-CEA7-4344-929F-61CBD12338C2}</AdobeCode>
    <AdobeCode>{39AB309A-1155-4E7E-995C-D05D14569AEF}</AdobeCode>
    <AdobeCode>{6461A37A-3F6A-46BD-9C1B-F844E5FB5010}</AdobeCode>
    <AdobeCode>{BA1B548C-3443-4639-9055-EA9F33259F17}</AdobeCode>
    <AdobeCode>{6C9CC996-F10B-4161-9180-F8059598A15D}</AdobeCode>
    <AdobeCode>{FEBD5404-2CBA-40BF-8533-06664CEA6E35}</AdobeCode>
    <AdobeCode>{D54F4978-40BD-4978-8628-384FF2F56FB5}</AdobeCode>
    <AdobeCode>{F0AB2088-52B3-4CE4-959B-C787878ABF82}</AdobeCode>
    <AdobeCode>{88700B1C-559E-4705-84DC-63C5EF7A3CD9}</AdobeCode>
    <AdobeCode>{7157B22D-7586-4A8C-AB16-27B64185C40E}</AdobeCode>
    <AdobeCode>{345E5878-969F-42BF-8321-BC734A58ED92}</AdobeCode>
    <AdobeCode>{8B3B6E28-D044-49B9-89A8-3DC159ECE6D1}</AdobeCode>
    <AdobeCode>{76E0ED8A-9C6F-4669-BE0E-DE5FEA1FAA00}</AdobeCode>
    <AdobeCode>{7E796B04-0519-4251-A8A7-A2D03647411B}</AdobeCode>
    <AdobeCode>{896BDA75-80F1-461F-9BEE-C690A8DD8F95}</AdobeCode>
    <AdobeCode>{33BFC97F-A11F-40CE-B865-B20D628FDBBF}</AdobeCode>
    <AdobeCode>{2D2C6F96-EE2D-4030-B49C-E424A60EAF34}</AdobeCode>
    <AdobeCode>{BC972A71-CDCC-4E89-9040-D51B81A9F4D9}</AdobeCode>
    <AdobeCode>{F2600F01-AC26-46A8-A9D8-C683C677DD19}</AdobeCode>
    <AdobeCode>{608D20DC-8F6C-41C3-BB6D-EDE3093A86EE}</AdobeCode>
    <AdobeCode>{D54B5E2F-AB72-49E9-9C9F-0E6A82380258}</AdobeCode>
    <AdobeCode>{B5C8F8C4-C6DF-48B2-94A0-6DB8D7DEA83A}</AdobeCode>
    <AdobeCode>{95D88680-55B6-4771-AD87-0827358B8902}</AdobeCode>
    <AdobeCode>{89EF02B8-D72C-4A61-8D04-E74B0B06DB1B}</AdobeCode>
    <AdobeCode>{72C72D0F-2393-4982-876B-22F8A531361F}</AdobeCode>
    <AdobeCode>{10061ADD-836E-4E46-B96F-C43C6374B8A8}</AdobeCode>
    <AdobeCode>{F7EFA39F-AB55-4B73-B963-11F651DA2F01}</AdobeCode>
    <AdobeCode>{E2E68755-3FC3-48B2-B10B-4237C6671AE4}</AdobeCode>
    <AdobeCode>{63A1AE27-5A22-4D0E-8D4D-14DD7CF6D8A7}</AdobeCode>
    <AdobeCode>{7D8CFC5B-B376-4B62-BFEB-13FBA634A5AD}</AdobeCode>
    <AdobeCode>{60351D12-038C-4857-9C0E-2CB313F86DFE}</AdobeCode>
    <AdobeCode>{7060F6C0-6BCC-4E45-8570-1E671328D480}</AdobeCode>
    <AdobeCode>{FD3B4CAE-CA0A-4C6C-A988-9E81AA7AAE7C}</AdobeCode>
    <AdobeCode>{4EC7563B-8B13-49A6-8883-5C5AADBF9D7B}</AdobeCode>
    <AdobeCode>{BD321672-643D-44F6-9544-9476FB3D7902}</AdobeCode>
    <AdobeCode>{80770000-AB0D-4022-9F7C-A738DE562FAC}</AdobeCode>
    <AdobeCode>{6938016A-27C4-4EFE-AAB4-F57D979F58F5}</AdobeCode>
    <AdobeCode>{AAFC05A8-867E-4A5A-9F6E-3DA4A4630232}</AdobeCode>
    <AdobeCode>{9A72086B-3121-47D1-9DF8-2D208A29DF85}</AdobeCode>
    <AdobeCode>{A1FE3E90-3C48-432E-A976-4D26CE9FF276}</AdobeCode>
    <AdobeCode>{49CC1379-A817-464E-9ED6-EEB41BC5C0FF}</AdobeCode>
    <AdobeCode>{33A8C261-5E72-4B8D-9CCC-23D41954D574}</AdobeCode>
    <AdobeCode>{40F90221-5596-47B5-9432-21BC78CECD16}</AdobeCode>
    <AdobeCode>{D1F30B07-7CDB-4B23-A15A-CA18E2C01863}</AdobeCode>
    <AdobeCode>{95A7E108-3FB4-402E-AAC3-91DD45A2D81C}</AdobeCode>
    <AdobeCode>{3C064D98-05DF-4912-8828-300653E55B22}</AdobeCode>
    <AdobeCode>{D4789449-CA09-42FA-82F7-6AA238F60334}</AdobeCode>
    <AdobeCode>{7DBC0F3A-4437-44B5-8791-307E45D04DCF}</AdobeCode>
    <AdobeCode>{90F922C9-62B8-4978-974C-99F5A3B7E4FF}</AdobeCode>
    <AdobeCode>{C2C3148B-CCF4-4978-8B59-6185CBE644DE}</AdobeCode>
    <AdobeCode>{E4F5FC4E-A9B1-4BAE-9B3B-BAF51CC57BBE}</AdobeCode>
    <AdobeCode>{0A23917A-D7EA-4634-BB05-9EEB2272FF61}</AdobeCode>
    <AdobeCode>{79C8B2C8-8EF4-42A9-A006-574FDC447CAC}</AdobeCode>
    <AdobeCode>{9DA1EF20-5D0D-4489-BBF9-36F0C26AB403}</AdobeCode>
    <AdobeCode>{91448EB0-F8F1-4815-8BF2-93059D684EB1}</AdobeCode>
    <AdobeCode>{DA05F075-FC84-43A8-8C63-0043F8573383}</AdobeCode>
    <AdobeCode>{999045D3-5A10-4AE2-98A3-21BA6C984E0F}</AdobeCode>
    <AdobeCode>{835A0A89-7541-407A-9342-476E3811F685}</AdobeCode>
  </Upgrades><Channel enable="1" id="AdobeCSXSExtensionsCS6-3">
    <DisplayName>Adobe CSXS Extensions CS6</DisplayName>
  </Channel><InstallDestinationMetadata relocatableSize="0" sysDriveSize="1285278"><Destination>
      <Root>[UserRoamingAppData]</Root>
      <TotalSize>0</TotalSize>
      <MaxPathComponent>/Adobe/CS6ServiceManager/extensions</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>1285278</TotalSize>
      <MaxPathComponent>/CS6ServiceManager/extensions/KulerPanelBundle/META-INF\signatures.xml</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="1285278"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	<Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr][Ff][Xx].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Aa][Uu][Dd][Ii][Tt][Ii][Oo][Nn].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee][Cc][Aa][Pp][Tt][Ii][Vv][Aa][Tt][Ee].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Cc][Oo][Nn][Tt][Rr][Ii][Bb][Uu][Tt][Ee].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ff][Ii][Rr][Ee][Ww][Oo][Rr][Kk][Ss].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ii][Ll][Ll][Uu][Ss][Tt][Rr][Aa][Tt][Oo][Rr].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Pp][Rr][Oo].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Dd][Ee][Vv][Ii][Cc][Ee][Cc][Ee][Nn][Tt][Rr][Aa][Ll].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Dd][Rr][Ee][Aa][Mm][Ww][Ee][Aa][Vv][Ee][Rr].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ff][Ll][Aa][Ss][Hh].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ii][Nn][Cc][Oo][Pp][Yy].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Ii][Nn][Dd][Ee][Ss][Ii][Gg][Nn].[Ee][Xx][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp].[Ee][Xx][Ee]</Process>
    </Win32>
<OSX>
      <Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr] [Ee][Ff][Ff][Ee][Cc][Tt][Ss]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Aa][Uu][Dd][Ii][Tt][Ii][Oo][Nn]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Cc][Aa][Pp][Tt][Ii][Vv][Aa][Tt][Ee]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Cc][Oo][Nn][Tt][Rr][Ii][Bb][Uu][Tt][Ee] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ff][Ii][Rr][Ee][Ww][Oo][Rr][Kk][Ss] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ii][Ll][Ll][Uu][Ss][Tt][Rr][Aa][Tt][Oo][Rr]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Rr][Ee][Mm][Ii][Ee][Rr][Ee] [Pp][Rr][Oo] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Dd][Ee][Vv][Ii][Cc][Ee] [Cc][Ee][Nn][Tt][Rr][Aa][Ll] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Dd][Rr][Ee][Aa][Mm][Ww][Ee][Aa][Vv][Ee][Rr]</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ff][Ll][Aa][Ss][Hh] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ii][Nn][Cc][Oo][Pp][Yy] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Ii][Nn][Dd][Ee][Ss][Ii][Gg][Nn] [Cc][Ss]6</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp] [Cc][Ss]6</Process>
    </OSX>
  </ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">3</Value>
      <Value lang="be_BY">3</Value>
      <Value lang="bg_BG">3</Value>
      <Value lang="ca_ES">3</Value>
      <Value lang="cs_CZ">3</Value>
      <Value lang="da_DK">3</Value>
      <Value lang="de_DE">3</Value>
      <Value lang="el_GR">3</Value>
      <Value lang="en_GB">3</Value>
      <Value lang="en_MX">3</Value>
      <Value lang="en_US">3</Value>
      <Value lang="en_XC">3</Value>
      <Value lang="en_XM">3</Value>
      <Value lang="es_ES">3</Value>
      <Value lang="es_MX">3</Value>
      <Value lang="es_QM">3</Value>
      <Value lang="et_EE">3</Value>
      <Value lang="fi_FI">3</Value>
      <Value lang="fr_CA">3</Value>
      <Value lang="fr_FR">3</Value>
      <Value lang="fr_MX">3</Value>
      <Value lang="fr_XM">3</Value>
      <Value lang="he_IL">3</Value>
      <Value lang="hi_IN">3</Value>
      <Value lang="hr_HR">3</Value>
      <Value lang="hu_HU">3</Value>
      <Value lang="is_IS">3</Value>
      <Value lang="it_IT">3</Value>
      <Value lang="ja_JP">3</Value>
      <Value lang="ko_KR">3</Value>
      <Value lang="lt_LT">3</Value>
      <Value lang="lv_LV">3</Value>
      <Value lang="mk_MK">3</Value>
      <Value lang="nb_NO">3</Value>
      <Value lang="nl_NL">3</Value>
      <Value lang="nn_NO">3</Value>
      <Value lang="no_NO">3</Value>
      <Value lang="pl_PL">3</Value>
      <Value lang="pt_BR">3</Value>
      <Value lang="ro_RO">3</Value>
      <Value lang="ru_RU">3</Value>
      <Value lang="sh_YU">3</Value>
      <Value lang="sk_SK">3</Value>
      <Value lang="sl_SI">3</Value>
      <Value lang="sq_AL">3</Value>
      <Value lang="sv_SE">3</Value>
      <Value lang="th_TH">3</Value>
      <Value lang="tr_TR">3</Value>
      <Value lang="uk_UA">3</Value>
      <Value lang="vi_VN">3</Value>
      <Value lang="zh_CN">3</Value>
      <Value lang="zh_TW">3</Value>
      <Value lang="en_AE">3</Value>
      <Value lang="en_IL">3</Value>
      <Value lang="fr_MA">3</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">Adobe CSXS Extensions CS6</Value>
      <Value lang="be_BY">Adobe CSXS Extensions CS6</Value>
      <Value lang="bg_BG">Adobe CSXS Extensions CS6</Value>
      <Value lang="ca_ES">Adobe CSXS Extensions CS6</Value>
      <Value lang="cs_CZ">Adobe CSXS Extensions CS6</Value>
      <Value lang="da_DK">Adobe CSXS Extensions CS6</Value>
      <Value lang="de_DE">Adobe CSXS Extensions CS6</Value>
      <Value lang="el_GR">Adobe CSXS Extensions CS6</Value>
      <Value lang="en_GB">Adobe CSXS Extensions CS6</Value>
      <Value lang="en_MX">Adobe CSXS Extensions CS6</Value>
      <Value lang="en_US">Adobe CSXS Extensions CS6</Value>
      <Value lang="en_XC">Adobe CSXS Extensions CS6</Value>
      <Value lang="en_XM">Adobe CSXS Extensions CS6</Value>
      <Value lang="es_ES">Adobe CSXS Extensions CS6</Value>
      <Value lang="es_MX">Adobe CSXS Extensions CS6</Value>
      <Value lang="es_QM">Adobe CSXS Extensions CS6</Value>
      <Value lang="et_EE">Adobe CSXS Extensions CS6</Value>
      <Value lang="fi_FI">Adobe CSXS Extensions CS6</Value>
      <Value lang="fr_CA">Adobe CSXS Extensions CS6</Value>
      <Value lang="fr_FR">Adobe CSXS Extensions CS6</Value>
      <Value lang="fr_MX">Adobe CSXS Extensions CS6</Value>
      <Value lang="fr_XM">Adobe CSXS Extensions CS6</Value>
      <Value lang="he_IL">Adobe CSXS Extensions CS6</Value>
      <Value lang="hi_IN">Adobe CSXS Extensions CS6</Value>
      <Value lang="hr_HR">Adobe CSXS Extensions CS6</Value>
      <Value lang="hu_HU">Adobe CSXS Extensions CS6</Value>
      <Value lang="is_IS">Adobe CSXS Extensions CS6</Value>
      <Value lang="it_IT">Adobe CSXS Extensions CS6</Value>
      <Value lang="ja_JP">Adobe CSXS Extensions CS6</Value>
      <Value lang="ko_KR">Adobe CSXS Extensions CS6</Value>
      <Value lang="lt_LT">Adobe CSXS Extensions CS6</Value>
      <Value lang="lv_LV">Adobe CSXS Extensions CS6</Value>
      <Value lang="mk_MK">Adobe CSXS Extensions CS6</Value>
      <Value lang="nb_NO">Adobe CSXS Extensions CS6</Value>
      <Value lang="nl_NL">Adobe CSXS Extensions CS6</Value>
      <Value lang="nn_NO">Adobe CSXS Extensions CS6</Value>
      <Value lang="no_NO">Adobe CSXS Extensions CS6</Value>
      <Value lang="pl_PL">Adobe CSXS Extensions CS6</Value>
      <Value lang="pt_BR">Adobe CSXS Extensions CS6</Value>
      <Value lang="ro_RO">Adobe CSXS Extensions CS6</Value>
      <Value lang="ru_RU">Adobe CSXS Extensions CS6</Value>
      <Value lang="sh_YU">Adobe CSXS Extensions CS6</Value>
      <Value lang="sk_SK">Adobe CSXS Extensions CS6</Value>
      <Value lang="sl_SI">Adobe CSXS Extensions CS6</Value>
      <Value lang="sq_AL">Adobe CSXS Extensions CS6</Value>
      <Value lang="sv_SE">Adobe CSXS Extensions CS6</Value>
      <Value lang="th_TH">Adobe CSXS Extensions CS6</Value>
      <Value lang="tr_TR">Adobe CSXS Extensions CS6</Value>
      <Value lang="uk_UA">Adobe CSXS Extensions CS6</Value>
      <Value lang="vi_VN">Adobe CSXS Extensions CS6</Value>
      <Value lang="zh_CN">Adobe CSXS Extensions CS6</Value>
      <Value lang="zh_TW">Adobe CSXS Extensions CS6</Value>
      <Value lang="en_AE">Adobe CSXS Extensions CS6</Value>
      <Value lang="en_IL">Adobe CSXS Extensions CS6</Value>
      <Value lang="fr_MA">Adobe CSXS Extensions CS6</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>1</UserPreferences><SystemRequirements>
					 	<OS>
					 		<Macintosh>
					 			<Require lowerBound="1">
					 				<Version>10.5.0</Version>
					 				<Need64Bit>0</Need64Bit>
					 				<NeedServer>0</NeedServer>
					 			</Require>
					 		</Macintosh>
					 		<Windows>
					 			<XP>
					 				<Require>
					 					<MinServicePack servicePack64Bit="1">2</MinServicePack>
					 					<Need64Bit>0</Need64Bit>
					 				</Require>
					 			</XP>
					 			<Vista>
					 				<Require lowerBound="1"/>
					 			</Vista>
					 		</Windows>
					 	</OS>
					</SystemRequirements><CustomHook fileName="customaction.data"/></PayloadInfo>')
INSERT INTO PayloadData VALUES("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "0", "ChannelID", "AdobeCSXSExtensionsCS6-3")
INSERT INTO PayloadData VALUES("{EB2A8CD4-B247-4810-A294-E3DB8EDC6060}", "0", "ChannelInfo", '<Channel enable="1" id="AdobeCSXSExtensionsCS6-3">
    <DisplayName>Adobe CSXS Extensions CS6</DisplayName>
  </Channel>')
