CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
CREATE TABLE EULA_Ref( productID TEXT NOT NULL, langCode TEXT NOT NULL, eula_hash TEXT NOT NULL, PRIMARY KEY (productID, langCode) )
CREATE TABLE EULA_Content(eula_hash TEXT NOT NULL, Content TEXT NOT NULL, PRIMARY KEY (eula_hash))
CREATE TABLE IF NOT EXISTS pcd_meta ( key TEXT NOT NULL, value TEXT NOT NULL, PRIMARY KEY (key) )
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_version', 2)
INSERT OR REPLACE INTO pcd_meta (key, value) VALUES ('schema_compatibility_version', 1)
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{BCBA22DC-FC5D-461B-BB17-E48ECC9ED16B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{D0FC1C60-A305-4FF6-9042-9A00F726363A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{7953011D-83BB-4832-8C0F-10BEB18B661E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{0B6C60E4-AE77-4EC5-8D58-E8B6B82BB394}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F93FA872-7ACD-4E8E-BFCE-D628796FDDFB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9CA365CA-4F9F-49DD-8E0B-9B4E06F03C69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{2A8DE3CB-E033-40C0-87F0-F48825C84D17}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8AD335DC-5B4F-49ED-8A52-BCA7307ABA25}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{545ADEEA-18EB-4EA7-A219-991E3642FACC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{C66A620C-BC3C-40CD-AD22-0189087F11E0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{7A9CAED5-6C8A-4E7B-93E5-328226DDB3F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{20F12B28-23C3-48F3-8CC5-B8725377EC18}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{154697AC-2831-4F29-8FCA-A690B0544C9A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{39D91E5A-3305-4F69-9E55-AD2CEAF80048}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{4B170667-577F-4F45-9F31-41CD835366F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{7BD9E266-D674-4BDD-B5F1-9AAC9964BCCD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{BD21FE12-37B1-4ABE-B09D-91CCF7BE38AC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F05376C7-3F0C-4A6F-91B0-2C308D8EF82C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8C40815C-91F1-4531-BA2B-11948CB4CD73}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{5580041B-64D6-4728-B02D-00402291A480}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{4F10553F-7A98-4372-82BF-4A82D460E833}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{C56A0451-2F69-45E1-B402-28428A35B37C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{D3704EDC-ED94-4240-926F-FA3037979BDE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{C51662B0-8824-4F2A-92E6-B4DDF2B012CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{FB68FF86-F67D-479A-8D55-9F199A776246}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{12010FF2-1887-4DD6-93DF-4AA3F9533122}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{B2B2CCD5-4907-4189-9C52-588C52939019}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{AE46C227-2E67-4A64-A371-DF5E9362173E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{DCA39D51-BBF3-4E1E-B5B2-583C99EB11F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{2928B735-E7D6-4BC9-8CD3-6889E6964EF1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{5BC9E477-9971-4954-BF3F-31FD6AB6AC32}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{B8D68BF6-29E1-46F7-A408-D93B09D5606A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{54E03B72-F1CB-4481-8366-0D02D5259A75}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{AD37BFB8-4EAF-4AAF-BED3-3FEC4A6CA1B4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{BE51DCB3-C09A-4398-8F63-8FCD728C7881}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9D5E4441-89B6-4210-8778-4E99BEA22833}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{DC704AA4-1219-4A62-B0BA-BDF6F67F8AD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F1FEE8F4-0F02-4038-B946-C30CD971B192}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{0DC7DA6F-0CD7-4CE7-A951-7AFAA3594D96}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{E0630BC1-8920-4FBB-A952-BDEC10BB84A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F91656FD-15AF-4978-8782-D377AD5C8167}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{4EC6A457-E0CE-4634-98C4-21A2A9838FCC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{AB47C1A9-4271-46DB-8A29-9EA305C2BED9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{29B9DA21-B5C5-45DC-9A51-402A8CA79C1B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{2EF419AD-9BA9-4FA4-9160-732615D75201}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{58B8EDBE-93ED-4ECB-BD82-03C3314AF379}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{05EF126E-0005-4E76-ACC3-FA9FC543C3D0}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{28427F5E-532C-430D-9B40-93AF20C1E7E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{31A297E6-8470-40C0-8D26-9B97C0E6418A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{4EA90F3A-46AC-4976-AB26-87539032F863}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{67286838-EA9C-41E7-B1CA-21049FCF52FE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{2DA76D14-A224-4E4D-AE0D-E05B12476C69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{0447F4A6-2AF0-474B-80CD-040E3284DE1A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{FAF06286-AF6D-4B80-A0D1-B45FFA907FFE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{19AC133D-1783-42EB-8D1D-1521DCB4EB35}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{509FB41D-1403-42D0-BC6A-34D264B13F0F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{E5780FB9-84FB-4AF7-8732-7E8375D2FAEE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{73192529-B0DE-4B43-9506-6EC124C5D22F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8EABD2DE-EBC6-4FF9-9A17-EFF272693BD6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{EF4BAB95-F9A9-4587-99CE-0BF5165309C5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{08B2D1D8-D1BF-423F-B4E8-2A5FAB1A47BD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{71ACD215-7940-43CA-9D1A-918B7E3EB891}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{732DF82B-5E72-42FB-8B71-5F5525A0EBDB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9EB80B78-94A2-4EEF-8222-D17777E4B2B8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9C3ADCD5-C538-432D-9CA6-9C465977C10C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{46E8B2FE-184F-4A3A-AB77-8727A1F6F28E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9D54D567-8FFF-4283-95D7-2EBD3EF2B13A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{11407FAE-B094-42E9-9B5C-545323A9EAC6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{BBB1447E-C261-4E14-A56C-27645FF266E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{A0E2778A-F2FA-4D2F-AE0A-18BA48894C71}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{50709ADB-87D8-4A1F-B772-2B3F36B494A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{A9C7739F-B95B-42C6-A5DD-4274169B155E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{DE39F292-41FC-4D33-B168-BC918614A395}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{56E5AC54-CA84-4F69-AE4C-A6E18D7E6D58}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{FE170052-6D1A-4CCB-98DA-8F419074279A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{D9C5A551-209D-40BA-A5B8-E9C8756AA63C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8D21E7EF-7A32-4417-B036-B559EA1952EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9774E33D-9C5A-4C3B-89CB-2416D1ACE6A2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{199F4DBF-B9E7-48E1-A586-4014D5166621}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{A8D8349C-4C09-43A0-A247-667257972BF4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F1226BD8-AECA-4D17-8A29-86985AA79920}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{C1E9396B-AC99-482D-AAEE-3BD9FAC5E281}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{0A7C7914-94FE-4DBD-BDF1-86F8E41D1D9C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{E0BE5590-A44A-4A08-BB59-9519E8ED78D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{CC91AFB5-B6BC-4144-87CF-6B3B98C83105}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{28114487-B14D-480A-8F5B-BFF27DB25B8F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{E7754F4B-48F6-4631-8DAB-22E9E65A8893}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{AE365F3B-B519-449D-A4D0-09552357FD94}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{636F71D0-9D51-45EC-A71D-2991ECDA621F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{7DC5A847-7357-4E7C-B16C-BE7D351C2697}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{AF97FBFF-E8ED-430A-A896-7F8BCF613279}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{7A462B9D-837A-4187-BA17-F86E5F640DAD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{C72FF72D-9869-4FCE-9FEB-5583B648852B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{70554A78-00DD-448A-9124-757B1C0FDBED}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{65D62FA9-735D-4CB2-ACE3-62A441D068EA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{7358E66E-37B3-4CAB-9715-35D515D091E4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{3F1573EF-DFA7-49CB-A4DF-99CE7C6F8274}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{49521325-F5E2-4974-9341-65712B82C0E6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{6982FF19-FF18-45CF-BC55-532CC9BBB4C5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{16EC6473-C722-49EE-8265-2746F7E8E3FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{B52802D0-1EDA-45F7-A78D-0974DD6A0826}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F380B4E3-5F6C-4933-8D0A-5FAC5F1F3704}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{6407B38F-10EC-4043-96A9-53437C491C70}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{C08EAD8D-3F3E-4BF5-A78B-16E9CAEF2B94}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{0ABCEAB7-9B2D-45E8-947A-78B7CD1B5233}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{419E6336-81A7-4656-9F92-6823BEE1F800}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{85CD0CFD-3CFF-4ABA-8734-579A03395528}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{DB4FB13D-898E-4FF8-9700-161D0E7D07CC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{FDB71FC4-39BB-473A-9C9E-B66041A4FD5A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{82FFE0E3-3429-497D-8891-084F61CFA02D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9F192483-3081-4585-A9BC-CA93F7952B2A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9EB7E802-1E13-4AF8-9E10-C033AE28812C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{42680A54-C36E-40B0-9028-0FC558493082}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{5EB5B89F-8657-496E-BBE3-C0DECC500161}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{0802E740-F9E2-4759-8375-7498E8E7ABF9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9A196EA3-4C65-4FBB-9084-3CCA8375750E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{72343C76-250C-49A4-94C2-1C4B95316293}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{7F861C81-D3FF-47D2-A9AD-387698D4AD41}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{2BBC5606-231A-4F90-AA3D-08A585249DF6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{CEC0FEE6-857A-4262-A849-F71A7CC2B11E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8188C700-D1D0-4A58-B592-95C196D03407}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{669076A1-6DAA-49C6-8C33-C704E3105A55}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{36D325B0-2CE2-4B95-907D-16645066F2E7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{D9B71BD5-1A86-4D75-9873-607C6A403E2F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{764E0F3D-ED9B-47E8-BFC6-AE6907F642DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{92DD3C30-B201-4913-834C-BCA2DD1C3081}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{CF5A861E-4E73-4C3B-ABDE-E735C49A8CCF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{DC4289E1-79E0-4621-A1DA-8CB60ABE0933}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{7FBA61EB-A91A-4983-8C99-E632D5BCECF6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{2AD6FACE-6446-41F4-93A0-48ACACB9D92A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{2A597A07-06AA-4F9C-B22D-FF38317E1D77}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{65E5CA8F-645E-445A-8481-AF2E325D0929}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{E1F37C4E-C338-4D44-AA01-AA4BC4B48BD5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{536CB5C2-8764-4B3D-BDFB-745067C06709}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{425D255B-DC4E-47A2-92A8-D25FD60BAAE1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{CFA7DC9B-CF70-4E49-8851-47531A1DC22C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{D76D29BC-021B-4475-87B5-6D7932E3691C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{1D965BB3-7173-475C-A042-83AF61EDD503}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{E28103DE-A1F1-46E8-B7FB-CD241B3D8E2F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{6B2DC1F8-9A2A-4C6E-AA48-11A3C677D520}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{D375EF16-86F3-4214-AB91-9438763EC10C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8BF20CE9-B0DA-4C24-9A10-C0896A87248B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{7989B26B-8614-4500-A372-4E87477E7E71}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{849D7DA0-02B9-4312-912D-477532AF55A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{5897312A-274A-468F-8D95-4258D8EF4537}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8164DF5B-9C84-4D28-B4CA-C7910776B6C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{AF791D0A-DD51-493C-A5E9-7DFD8917FB36}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8BCC33F9-62EF-4AF5-A4C2-AA0B88906D10}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{587D0468-A649-4736-8CBF-D4DF561FEB26}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{C27FB99F-2D3C-455E-9A26-6437C9A8B988}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{01493179-445E-429C-AE8E-8EB13DECD92F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F4E3D34B-DD22-46AE-AAE0-41ADAF764679}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F174CFAA-1A27-4959-A5AD-BEA2451E2E49}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{2FDCF190-A23A-4616-B4BF-91CD57B2673D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{09DBEE71-9A86-4A9D-A0B6-236EF603BBC7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{1B342472-4354-417F-B9D1-AEA20CCAFE5A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{EF1D48B8-9EB3-4028-86AA-DC243B5CE5A6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{6E411DBD-5F54-4122-9CE6-9D9966AC48AF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{79E36644-2DBB-45D7-AB00-F7F9ACDAD42E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{21394D76-CF4C-4579-9F16-5B9A3473EFB9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8A56924B-AE0F-43E3-9BF9-F7D02A9AD5AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{DAFE0407-B855-4119-BC3A-C71078DAA306}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{5FFDD0DF-772C-4EDE-AE49-403AD9AB96D9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{4BF9A8E0-BA86-437B-99EF-D62F18D574C6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{B2F5F0F3-1FC6-4ADA-90E9-CF317485EB30}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{CF625628-A76B-42A7-B6C1-16D337C36ECB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{208929A7-8373-4B3B-8799-A5883FC9B1DB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{823BF296-DAC0-4AC7-8A90-3EC96BBC75FC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8871D0FD-5360-48A5-A6B9-9BC4DF2B18E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{3CF41D18-A139-478A-B0E9-2E0C84F073C9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{B659AD97-368D-47EB-9BB1-AEC6DB068716}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{DAB342EA-A4A9-4E16-BAE5-D1D797A0C99B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{3A34495A-BA5D-433B-924E-ACB7BAD7F169}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{86E52748-4486-49B7-A5AE-6D72DE732846}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{D600B94C-C460-419A-B4BD-BCB81D7002E5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{8CBC250C-ABE4-4002-8CFD-538C2C7702DC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{0846CC39-F772-4844-A1E7-BD93A5777809}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{1F9DB494-E27E-4935-8BCA-95DC3376FF37}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{63566063-A63D-4D5B-BB93-7BCC5C807E79}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{E4FAD8FE-2785-427A-8E30-77789813B973}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{3049B15E-D102-4B6C-B0BC-B9CFDC566814}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F140ECF2-386F-4FF2-B61A-88211FB42EC4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{AF57B438-88F9-4F8C-94D0-82F6E82AE41D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{1DA8A828-D6B9-4B93-842A-FE112FA5E340}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{D9F5E1E0-3346-4DE0-9020-699295597704}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{05D7DBF3-8AB4-4360-BF01-B98F275CE7E2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{9109F37E-D997-49E8-88F1-F4C82FA512E9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{B21E519D-8E6F-4CF9-878A-9B10A0FEB0EB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{5E6C59B3-C636-424E-9AFF-63D61E326EA9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{F403E95A-F21B-4FE6-AAE6-3AA286737ABE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{C2E5E5CC-7C97-4F48-8EF4-6DD0A0EB2DB2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{618706AE-9497-47E5-934B-F300B6EB28FF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{616A2F66-88B3-4681-9A35-417C7FBF2896}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{04E9E15C-771E-4535-AEE9-F97C2434A8EB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{50B0C9FA-3BA8-40E4-9615-7A6536D6B1DB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{067AC297-7875-415F-B7D4-0F28D6C6190B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{4BDA2EF8-2C12-4ED9-AE9F-0B147DDB1712}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "{74AED914-0785-40C3-ADBD-7B416B24458D}", "conflict", "", "", "")
INSERT INTO PayloadData VALUES("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "0" , "ValidationInfo", '<ValidationInfo payloadID="{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}"><File><InstallPath>[INSTALLDIR]\Adobe Flash CS6\AIR3.2\lib\aot\bin\as\arm-apple-darwin9-as.exe</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2009-2 CA{|}Class 3 Public Primary Certification Authority</SignatureInfo></File><File><InstallPath>[INSTALLDIR]\Adobe Flash CS6\AIR3.2\lib\aot\bin\strip\strip.exe</InstallPath><SignatureType>DigitalSignature</SignatureType><SignatureInfo>Adobe Systems Incorporated{|}VeriSign Class 3 Code Signing 2009-2 CA{|}Class 3 Public Primary Certification Authority</SignatureInfo></File></ValidationInfo>')
INSERT INTO PayloadData VALUES("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "0" , "ValidationSig", "xmuJZYwDO8Xr3ZbBcm6vx6VblJgOixmu9ZBQK9+Fj6i21TyHc0wZg+0tRFgks6vbcd8qnRytwmF9st+XjcrpKH+IqN1BGEzkwxwzBJKNNasGj6IWY8Xo4/Jgg06mGb+/vHQokuxAxm/i81+3G5yfvlQy/9X9WCsDTOXfGcBvjbP2ztk9aQABIQvH8ROf7uHIXg1PMe4hT2ZgTVi0xGzEjR9KQlYaNPAiHOYOlXdAPGdslsAlqQei7qz0FJDGbYyt4iPxMNmhwcAhg6gzPbdwXcuzT7avxJ12/tR+Biyw/GbnVsLaAvUzT7vFQwU5B4S6ZFbxH4once68hbcypftGR2a70jZPSwFfZXwTEbVF6BkryVqDBZqXvLkXo5Im3Z6Yx+Y81nKtXirWJFy6gWok/xsmSSFVw7z0+gx/Imlu6KQPhU05NJOWTbDKnexgtV3qUhxRPSpftPkeo2CFvxmZfnD61H/rrYeXOeaSbYhx7pfutMkh43a2X0/U3mBV8IEc")
INSERT INTO Branding VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "ProductIcon", 'iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlz
AAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNXG14zYAAAAW
dEVYdENyZWF0aW9uIFRpbWUAMTAvMzAvMDZ8tDgbAAADVklEQVRIibWVz2sUSRTHP9XTk8mMO93K
hMWYjGDYBLOJAQ8uuRgURJGIoOAhx/UUZNfbuBL8BxYRBGFz8ZybuXhYRHAPgog5x1FwcUwOC0tc
ZiabH93TVc/DdHe6e1y9ZB88qrqq+/t99er7XsP/bAoorl6/vv3d4iK5XA6lFCKC1hqtNcaYeP6l
teT61NRUCdgBsIDKX0tL1G/cQCmFZVmpCESkJyoRif1z60AleYKx3/v73/rA6WIRK2S1wk0FqBBI
Em4SY+wiGEAHQUeA6taWawN0gCDcjAB0CB5FEcUqAK6LPTuLArylpRjYJIh19/VKl0AkJlGAUhE0
kEmDVa1y6PlzLNcFoDA/z9+XLqFbrRR4mKqSFZ0g6b7IZ90Tof/27RgcIH/iBIW5OfzEd1HAADaA
H0bvJ9KSjV4A5boUZ2fJmrgufiLF0RgTBCFjJ5mODLgAA/PzKMdJqUcpxe7aGn4ELIIRSRPE6cnK
LuEH5+Y4VKux8/49nfV18tUqfUePAvBvo9FzAnoIwhxnrTA5ybe1Gs7Fi/zz+DFrN28StFoAHK7V
GLx1C1Wt4mUCMiGWBd3LCejeReS5iQlGXr3i2NOnHDh/Hq01jTt32G216AAe0Lh7l+1Gg+L0dK8o
sieICCIbffiQ3JEjaK3jtZ1mEx3mN/LtDx9wLlzAOA6ddjtOTzTuyTQTgTU4SBAEqV7jXruGF0bv
AfmJCUqnTkGpxLF792KJeiEGQA6ozFjWzwEwaNsEdAulcvUqVrmMMQZjDCKCMzODDk9bnp5m9MED
VD6PiNA/MoIGNl6+JDDGaGBZ698UMLZg22818EOhEKejND7O+OIiheHhnouHTLWHFrTbPDt5Et3p
dAB+9P3JVC/y2SsQr17nxZkzHDh+nM03byDcs8tlBs6dY3RhAdtxUkS7zSZeQq57dxAWmie9reFj
vR7PfRG22m0ay8s8O3uW5uoqQRDEd/X6/v2UEiGhIk1aRUKmg2ZG2dzkjytXGLp8mdLQEBsrK2ys
rMQ1EKnIBvx3xvw6rNQvXtjHIf2jSQFn5n8+epSSrWTes4HmE5EnM9A3LvJTEvBr4KnnTH1Ee4qu
VAeA74Ex4Bv2x9aBF5EEckAZOAj07RPBNvBxn7D+2z4B54lDydVVOsgAAAAASUVORK5CYII=')
INSERT INTO Branding VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "ProductIcon24", 'iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlz
AAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNXG14zYAAAAW
dEVYdENyZWF0aW9uIFRpbWUAMTAvMzAvMDZ8tDgbAAADVklEQVRIibWVz2sUSRTHP9XTk8mMO93K
hMWYjGDYBLOJAQ8uuRgURJGIoOAhx/UUZNfbuBL8BxYRBGFz8ZybuXhYRHAPgog5x1FwcUwOC0tc
ZiabH93TVc/DdHe6e1y9ZB88qrqq+/t99er7XsP/bAoorl6/vv3d4iK5XA6lFCKC1hqtNcaYeP6l
teT61NRUCdgBsIDKX0tL1G/cQCmFZVmpCESkJyoRif1z60AleYKx3/v73/rA6WIRK2S1wk0FqBBI
Em4SY+wiGEAHQUeA6taWawN0gCDcjAB0CB5FEcUqAK6LPTuLArylpRjYJIh19/VKl0AkJlGAUhE0
kEmDVa1y6PlzLNcFoDA/z9+XLqFbrRR4mKqSFZ0g6b7IZ90Tof/27RgcIH/iBIW5OfzEd1HAADaA
H0bvJ9KSjV4A5boUZ2fJmrgufiLF0RgTBCFjJ5mODLgAA/PzKMdJqUcpxe7aGn4ELIIRSRPE6cnK
LuEH5+Y4VKux8/49nfV18tUqfUePAvBvo9FzAnoIwhxnrTA5ybe1Gs7Fi/zz+DFrN28StFoAHK7V
GLx1C1Wt4mUCMiGWBd3LCejeReS5iQlGXr3i2NOnHDh/Hq01jTt32G216AAe0Lh7l+1Gg+L0dK8o
sieICCIbffiQ3JEjaK3jtZ1mEx3mN/LtDx9wLlzAOA6ddjtOTzTuyTQTgTU4SBAEqV7jXruGF0bv
AfmJCUqnTkGpxLF792KJeiEGQA6ozFjWzwEwaNsEdAulcvUqVrmMMQZjDCKCMzODDk9bnp5m9MED
VD6PiNA/MoIGNl6+JDDGaGBZ698UMLZg22818EOhEKejND7O+OIiheHhnouHTLWHFrTbPDt5Et3p
dAB+9P3JVC/y2SsQr17nxZkzHDh+nM03byDcs8tlBs6dY3RhAdtxUkS7zSZeQq57dxAWmie9reFj
vR7PfRG22m0ay8s8O3uW5uoqQRDEd/X6/v2UEiGhIk1aRUKmg2ZG2dzkjytXGLp8mdLQEBsrK2ys
rMQ1EKnIBvx3xvw6rNQvXtjHIf2jSQFn5n8+epSSrWTes4HmE5EnM9A3LvJTEvBr4KnnTH1Ee4qu
VAeA74Ex4Bv2x9aBF5EEckAZOAj07RPBNvBxn7D+2z4B54lDydVVOsgAAAAASUVORK5CYII=')
INSERT INTO Payloads VALUES	("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "Standard", "AIR for Apple iOS support (FP)", "3.0.0", "normal")
INSERT INTO PayloadData VALUES("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "0" , "KeyFolder", "[INSTALLDIR]/Adobe Flash CS6/AIR3.2/lib/aot")
INSERT INTO PayloadData VALUES("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "0" , "PayloadInfo", '<PayloadInfo version="6.0.29.0"><BuildInfo>
    <Property name="Created">2012-03-30 16:36:12.596000</Property>
    <Property name="TargetName">AIRforIOS_Flash12.0-mul</Property>
    <Property name="ProcessorFamily">All</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}</Property>
    <Property name="ProductName">AIR for Apple iOS support (FP)</Property>
    <Property name="ProductVersion">3.0.0</Property>
    <Property name="KeyFolder">[INSTALLDIR]/Adobe Flash CS6/AIR3.2/lib/aot</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeProgramFiles]\Adobe Flash CS6</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
    <Family>Standard</Family>
    <ProductName>AIR for Apple iOS support (FP)</ProductName>
  <ProductVersion>3.0.0</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{BCBA22DC-FC5D-461B-BB17-E48ECC9ED16B}</AdobeCode>
    <AdobeCode>{D0FC1C60-A305-4FF6-9042-9A00F726363A}</AdobeCode>
    <AdobeCode>{7953011D-83BB-4832-8C0F-10BEB18B661E}</AdobeCode>
    <AdobeCode>{0B6C60E4-AE77-4EC5-8D58-E8B6B82BB394}</AdobeCode>
    <AdobeCode>{F93FA872-7ACD-4E8E-BFCE-D628796FDDFB}</AdobeCode>
    <AdobeCode>{9CA365CA-4F9F-49DD-8E0B-9B4E06F03C69}</AdobeCode>
    <AdobeCode>{2A8DE3CB-E033-40C0-87F0-F48825C84D17}</AdobeCode>
    <AdobeCode>{8AD335DC-5B4F-49ED-8A52-BCA7307ABA25}</AdobeCode>
    <AdobeCode>{545ADEEA-18EB-4EA7-A219-991E3642FACC}</AdobeCode>
    <AdobeCode>{C66A620C-BC3C-40CD-AD22-0189087F11E0}</AdobeCode>
    <AdobeCode>{7A9CAED5-6C8A-4E7B-93E5-328226DDB3F9}</AdobeCode>
    <AdobeCode>{20F12B28-23C3-48F3-8CC5-B8725377EC18}</AdobeCode>
    <AdobeCode>{154697AC-2831-4F29-8FCA-A690B0544C9A}</AdobeCode>
    <AdobeCode>{39D91E5A-3305-4F69-9E55-AD2CEAF80048}</AdobeCode>
    <AdobeCode>{4B170667-577F-4F45-9F31-41CD835366F5}</AdobeCode>
    <AdobeCode>{7BD9E266-D674-4BDD-B5F1-9AAC9964BCCD}</AdobeCode>
    <AdobeCode>{BD21FE12-37B1-4ABE-B09D-91CCF7BE38AC}</AdobeCode>
    <AdobeCode>{F05376C7-3F0C-4A6F-91B0-2C308D8EF82C}</AdobeCode>
    <AdobeCode>{8C40815C-91F1-4531-BA2B-11948CB4CD73}</AdobeCode>
    <AdobeCode>{5580041B-64D6-4728-B02D-00402291A480}</AdobeCode>
    <AdobeCode>{4F10553F-7A98-4372-82BF-4A82D460E833}</AdobeCode>
    <AdobeCode>{C56A0451-2F69-45E1-B402-28428A35B37C}</AdobeCode>
    <AdobeCode>{D3704EDC-ED94-4240-926F-FA3037979BDE}</AdobeCode>
    <AdobeCode>{C51662B0-8824-4F2A-92E6-B4DDF2B012CC}</AdobeCode>
    <AdobeCode>{FB68FF86-F67D-479A-8D55-9F199A776246}</AdobeCode>
    <AdobeCode>{12010FF2-1887-4DD6-93DF-4AA3F9533122}</AdobeCode>
    <AdobeCode>{B2B2CCD5-4907-4189-9C52-588C52939019}</AdobeCode>
    <AdobeCode>{AE46C227-2E67-4A64-A371-DF5E9362173E}</AdobeCode>
    <AdobeCode>{DCA39D51-BBF3-4E1E-B5B2-583C99EB11F4}</AdobeCode>
    <AdobeCode>{2928B735-E7D6-4BC9-8CD3-6889E6964EF1}</AdobeCode>
    <AdobeCode>{5BC9E477-9971-4954-BF3F-31FD6AB6AC32}</AdobeCode>
    <AdobeCode>{B8D68BF6-29E1-46F7-A408-D93B09D5606A}</AdobeCode>
    <AdobeCode>{54E03B72-F1CB-4481-8366-0D02D5259A75}</AdobeCode>
    <AdobeCode>{AD37BFB8-4EAF-4AAF-BED3-3FEC4A6CA1B4}</AdobeCode>
    <AdobeCode>{BE51DCB3-C09A-4398-8F63-8FCD728C7881}</AdobeCode>
    <AdobeCode>{9D5E4441-89B6-4210-8778-4E99BEA22833}</AdobeCode>
    <AdobeCode>{DC704AA4-1219-4A62-B0BA-BDF6F67F8AD4}</AdobeCode>
    <AdobeCode>{F1FEE8F4-0F02-4038-B946-C30CD971B192}</AdobeCode>
    <AdobeCode>{0DC7DA6F-0CD7-4CE7-A951-7AFAA3594D96}</AdobeCode>
    <AdobeCode>{E0630BC1-8920-4FBB-A952-BDEC10BB84A7}</AdobeCode>
    <AdobeCode>{F91656FD-15AF-4978-8782-D377AD5C8167}</AdobeCode>
    <AdobeCode>{4EC6A457-E0CE-4634-98C4-21A2A9838FCC}</AdobeCode>
    <AdobeCode>{AB47C1A9-4271-46DB-8A29-9EA305C2BED9}</AdobeCode>
    <AdobeCode>{29B9DA21-B5C5-45DC-9A51-402A8CA79C1B}</AdobeCode>
    <AdobeCode>{2EF419AD-9BA9-4FA4-9160-732615D75201}</AdobeCode>
    <AdobeCode>{58B8EDBE-93ED-4ECB-BD82-03C3314AF379}</AdobeCode>
    <AdobeCode>{05EF126E-0005-4E76-ACC3-FA9FC543C3D0}</AdobeCode>
    <AdobeCode>{28427F5E-532C-430D-9B40-93AF20C1E7E5}</AdobeCode>
    <AdobeCode>{31A297E6-8470-40C0-8D26-9B97C0E6418A}</AdobeCode>
    <AdobeCode>{4EA90F3A-46AC-4976-AB26-87539032F863}</AdobeCode>
    <AdobeCode>{67286838-EA9C-41E7-B1CA-21049FCF52FE}</AdobeCode>
    <AdobeCode>{2DA76D14-A224-4E4D-AE0D-E05B12476C69}</AdobeCode>
    <AdobeCode>{0447F4A6-2AF0-474B-80CD-040E3284DE1A}</AdobeCode>
    <AdobeCode>{FAF06286-AF6D-4B80-A0D1-B45FFA907FFE}</AdobeCode>
    <AdobeCode>{19AC133D-1783-42EB-8D1D-1521DCB4EB35}</AdobeCode>
    <AdobeCode>{509FB41D-1403-42D0-BC6A-34D264B13F0F}</AdobeCode>
    <AdobeCode>{E5780FB9-84FB-4AF7-8732-7E8375D2FAEE}</AdobeCode>
    <AdobeCode>{73192529-B0DE-4B43-9506-6EC124C5D22F}</AdobeCode>
    <AdobeCode>{8EABD2DE-EBC6-4FF9-9A17-EFF272693BD6}</AdobeCode>
    <AdobeCode>{EF4BAB95-F9A9-4587-99CE-0BF5165309C5}</AdobeCode>
    <AdobeCode>{08B2D1D8-D1BF-423F-B4E8-2A5FAB1A47BD}</AdobeCode>
    <AdobeCode>{71ACD215-7940-43CA-9D1A-918B7E3EB891}</AdobeCode>
    <AdobeCode>{732DF82B-5E72-42FB-8B71-5F5525A0EBDB}</AdobeCode>
    <AdobeCode>{9EB80B78-94A2-4EEF-8222-D17777E4B2B8}</AdobeCode>
    <AdobeCode>{9C3ADCD5-C538-432D-9CA6-9C465977C10C}</AdobeCode>
    <AdobeCode>{46E8B2FE-184F-4A3A-AB77-8727A1F6F28E}</AdobeCode>
    <AdobeCode>{9D54D567-8FFF-4283-95D7-2EBD3EF2B13A}</AdobeCode>
    <AdobeCode>{11407FAE-B094-42E9-9B5C-545323A9EAC6}</AdobeCode>
    <AdobeCode>{BBB1447E-C261-4E14-A56C-27645FF266E5}</AdobeCode>
    <AdobeCode>{A0E2778A-F2FA-4D2F-AE0A-18BA48894C71}</AdobeCode>
    <AdobeCode>{50709ADB-87D8-4A1F-B772-2B3F36B494A8}</AdobeCode>
    <AdobeCode>{A9C7739F-B95B-42C6-A5DD-4274169B155E}</AdobeCode>
    <AdobeCode>{DE39F292-41FC-4D33-B168-BC918614A395}</AdobeCode>
    <AdobeCode>{56E5AC54-CA84-4F69-AE4C-A6E18D7E6D58}</AdobeCode>
    <AdobeCode>{FE170052-6D1A-4CCB-98DA-8F419074279A}</AdobeCode>
    <AdobeCode>{D9C5A551-209D-40BA-A5B8-E9C8756AA63C}</AdobeCode>
    <AdobeCode>{8D21E7EF-7A32-4417-B036-B559EA1952EA}</AdobeCode>
    <AdobeCode>{9774E33D-9C5A-4C3B-89CB-2416D1ACE6A2}</AdobeCode>
    <AdobeCode>{199F4DBF-B9E7-48E1-A586-4014D5166621}</AdobeCode>
    <AdobeCode>{A8D8349C-4C09-43A0-A247-667257972BF4}</AdobeCode>
    <AdobeCode>{F1226BD8-AECA-4D17-8A29-86985AA79920}</AdobeCode>
    <AdobeCode>{C1E9396B-AC99-482D-AAEE-3BD9FAC5E281}</AdobeCode>
    <AdobeCode>{0A7C7914-94FE-4DBD-BDF1-86F8E41D1D9C}</AdobeCode>
    <AdobeCode>{E0BE5590-A44A-4A08-BB59-9519E8ED78D6}</AdobeCode>
    <AdobeCode>{CC91AFB5-B6BC-4144-87CF-6B3B98C83105}</AdobeCode>
    <AdobeCode>{28114487-B14D-480A-8F5B-BFF27DB25B8F}</AdobeCode>
    <AdobeCode>{E7754F4B-48F6-4631-8DAB-22E9E65A8893}</AdobeCode>
    <AdobeCode>{AE365F3B-B519-449D-A4D0-09552357FD94}</AdobeCode>
    <AdobeCode>{636F71D0-9D51-45EC-A71D-2991ECDA621F}</AdobeCode>
    <AdobeCode>{7DC5A847-7357-4E7C-B16C-BE7D351C2697}</AdobeCode>
    <AdobeCode>{AF97FBFF-E8ED-430A-A896-7F8BCF613279}</AdobeCode>
    <AdobeCode>{7A462B9D-837A-4187-BA17-F86E5F640DAD}</AdobeCode>
    <AdobeCode>{C72FF72D-9869-4FCE-9FEB-5583B648852B}</AdobeCode>
    <AdobeCode>{70554A78-00DD-448A-9124-757B1C0FDBED}</AdobeCode>
    <AdobeCode>{65D62FA9-735D-4CB2-ACE3-62A441D068EA}</AdobeCode>
    <AdobeCode>{7358E66E-37B3-4CAB-9715-35D515D091E4}</AdobeCode>
    <AdobeCode>{3F1573EF-DFA7-49CB-A4DF-99CE7C6F8274}</AdobeCode>
    <AdobeCode>{49521325-F5E2-4974-9341-65712B82C0E6}</AdobeCode>
    <AdobeCode>{6982FF19-FF18-45CF-BC55-532CC9BBB4C5}</AdobeCode>
    <AdobeCode>{16EC6473-C722-49EE-8265-2746F7E8E3FB}</AdobeCode>
    <AdobeCode>{B52802D0-1EDA-45F7-A78D-0974DD6A0826}</AdobeCode>
    <AdobeCode>{F380B4E3-5F6C-4933-8D0A-5FAC5F1F3704}</AdobeCode>
    <AdobeCode>{6407B38F-10EC-4043-96A9-53437C491C70}</AdobeCode>
    <AdobeCode>{C08EAD8D-3F3E-4BF5-A78B-16E9CAEF2B94}</AdobeCode>
    <AdobeCode>{0ABCEAB7-9B2D-45E8-947A-78B7CD1B5233}</AdobeCode>
    <AdobeCode>{419E6336-81A7-4656-9F92-6823BEE1F800}</AdobeCode>
    <AdobeCode>{85CD0CFD-3CFF-4ABA-8734-579A03395528}</AdobeCode>
    <AdobeCode>{DB4FB13D-898E-4FF8-9700-161D0E7D07CC}</AdobeCode>
    <AdobeCode>{FDB71FC4-39BB-473A-9C9E-B66041A4FD5A}</AdobeCode>
    <AdobeCode>{82FFE0E3-3429-497D-8891-084F61CFA02D}</AdobeCode>
    <AdobeCode>{9F192483-3081-4585-A9BC-CA93F7952B2A}</AdobeCode>
    <AdobeCode>{9EB7E802-1E13-4AF8-9E10-C033AE28812C}</AdobeCode>
    <AdobeCode>{42680A54-C36E-40B0-9028-0FC558493082}</AdobeCode>
    <AdobeCode>{5EB5B89F-8657-496E-BBE3-C0DECC500161}</AdobeCode>
    <AdobeCode>{0802E740-F9E2-4759-8375-7498E8E7ABF9}</AdobeCode>
    <AdobeCode>{9A196EA3-4C65-4FBB-9084-3CCA8375750E}</AdobeCode>
    <AdobeCode>{72343C76-250C-49A4-94C2-1C4B95316293}</AdobeCode>
    <AdobeCode>{7F861C81-D3FF-47D2-A9AD-387698D4AD41}</AdobeCode>
    <AdobeCode>{2BBC5606-231A-4F90-AA3D-08A585249DF6}</AdobeCode>
    <AdobeCode>{CEC0FEE6-857A-4262-A849-F71A7CC2B11E}</AdobeCode>
    <AdobeCode>{8188C700-D1D0-4A58-B592-95C196D03407}</AdobeCode>
    <AdobeCode>{669076A1-6DAA-49C6-8C33-C704E3105A55}</AdobeCode>
    <AdobeCode>{36D325B0-2CE2-4B95-907D-16645066F2E7}</AdobeCode>
    <AdobeCode>{D9B71BD5-1A86-4D75-9873-607C6A403E2F}</AdobeCode>
    <AdobeCode>{764E0F3D-ED9B-47E8-BFC6-AE6907F642DC}</AdobeCode>
    <AdobeCode>{92DD3C30-B201-4913-834C-BCA2DD1C3081}</AdobeCode>
    <AdobeCode>{CF5A861E-4E73-4C3B-ABDE-E735C49A8CCF}</AdobeCode>
    <AdobeCode>{DC4289E1-79E0-4621-A1DA-8CB60ABE0933}</AdobeCode>
    <AdobeCode>{7FBA61EB-A91A-4983-8C99-E632D5BCECF6}</AdobeCode>
    <AdobeCode>{2AD6FACE-6446-41F4-93A0-48ACACB9D92A}</AdobeCode>
    <AdobeCode>{2A597A07-06AA-4F9C-B22D-FF38317E1D77}</AdobeCode>
    <AdobeCode>{65E5CA8F-645E-445A-8481-AF2E325D0929}</AdobeCode>
    <AdobeCode>{E1F37C4E-C338-4D44-AA01-AA4BC4B48BD5}</AdobeCode>
    <AdobeCode>{536CB5C2-8764-4B3D-BDFB-745067C06709}</AdobeCode>
    <AdobeCode>{425D255B-DC4E-47A2-92A8-D25FD60BAAE1}</AdobeCode>
    <AdobeCode>{CFA7DC9B-CF70-4E49-8851-47531A1DC22C}</AdobeCode>
    <AdobeCode>{D76D29BC-021B-4475-87B5-6D7932E3691C}</AdobeCode>
    <AdobeCode>{1D965BB3-7173-475C-A042-83AF61EDD503}</AdobeCode>
    <AdobeCode>{E28103DE-A1F1-46E8-B7FB-CD241B3D8E2F}</AdobeCode>
    <AdobeCode>{6B2DC1F8-9A2A-4C6E-AA48-11A3C677D520}</AdobeCode>
    <AdobeCode>{D375EF16-86F3-4214-AB91-9438763EC10C}</AdobeCode>
    <AdobeCode>{8BF20CE9-B0DA-4C24-9A10-C0896A87248B}</AdobeCode>
    <AdobeCode>{7989B26B-8614-4500-A372-4E87477E7E71}</AdobeCode>
    <AdobeCode>{849D7DA0-02B9-4312-912D-477532AF55A7}</AdobeCode>
    <AdobeCode>{5897312A-274A-468F-8D95-4258D8EF4537}</AdobeCode>
    <AdobeCode>{8164DF5B-9C84-4D28-B4CA-C7910776B6C7}</AdobeCode>
    <AdobeCode>{AF791D0A-DD51-493C-A5E9-7DFD8917FB36}</AdobeCode>
    <AdobeCode>{8BCC33F9-62EF-4AF5-A4C2-AA0B88906D10}</AdobeCode>
    <AdobeCode>{587D0468-A649-4736-8CBF-D4DF561FEB26}</AdobeCode>
    <AdobeCode>{C27FB99F-2D3C-455E-9A26-6437C9A8B988}</AdobeCode>
    <AdobeCode>{01493179-445E-429C-AE8E-8EB13DECD92F}</AdobeCode>
    <AdobeCode>{F4E3D34B-DD22-46AE-AAE0-41ADAF764679}</AdobeCode>
    <AdobeCode>{F174CFAA-1A27-4959-A5AD-BEA2451E2E49}</AdobeCode>
    <AdobeCode>{2FDCF190-A23A-4616-B4BF-91CD57B2673D}</AdobeCode>
    <AdobeCode>{09DBEE71-9A86-4A9D-A0B6-236EF603BBC7}</AdobeCode>
    <AdobeCode>{1B342472-4354-417F-B9D1-AEA20CCAFE5A}</AdobeCode>
    <AdobeCode>{EF1D48B8-9EB3-4028-86AA-DC243B5CE5A6}</AdobeCode>
    <AdobeCode>{6E411DBD-5F54-4122-9CE6-9D9966AC48AF}</AdobeCode>
    <AdobeCode>{79E36644-2DBB-45D7-AB00-F7F9ACDAD42E}</AdobeCode>
    <AdobeCode>{21394D76-CF4C-4579-9F16-5B9A3473EFB9}</AdobeCode>
    <AdobeCode>{8A56924B-AE0F-43E3-9BF9-F7D02A9AD5AB}</AdobeCode>
    <AdobeCode>{DAFE0407-B855-4119-BC3A-C71078DAA306}</AdobeCode>
    <AdobeCode>{5FFDD0DF-772C-4EDE-AE49-403AD9AB96D9}</AdobeCode>
    <AdobeCode>{4BF9A8E0-BA86-437B-99EF-D62F18D574C6}</AdobeCode>
    <AdobeCode>{B2F5F0F3-1FC6-4ADA-90E9-CF317485EB30}</AdobeCode>
    <AdobeCode>{CF625628-A76B-42A7-B6C1-16D337C36ECB}</AdobeCode>
    <AdobeCode>{208929A7-8373-4B3B-8799-A5883FC9B1DB}</AdobeCode>
    <AdobeCode>{823BF296-DAC0-4AC7-8A90-3EC96BBC75FC}</AdobeCode>
    <AdobeCode>{8871D0FD-5360-48A5-A6B9-9BC4DF2B18E1}</AdobeCode>
    <AdobeCode>{3CF41D18-A139-478A-B0E9-2E0C84F073C9}</AdobeCode>
    <AdobeCode>{B659AD97-368D-47EB-9BB1-AEC6DB068716}</AdobeCode>
    <AdobeCode>{DAB342EA-A4A9-4E16-BAE5-D1D797A0C99B}</AdobeCode>
    <AdobeCode>{3A34495A-BA5D-433B-924E-ACB7BAD7F169}</AdobeCode>
    <AdobeCode>{86E52748-4486-49B7-A5AE-6D72DE732846}</AdobeCode>
    <AdobeCode>{D600B94C-C460-419A-B4BD-BCB81D7002E5}</AdobeCode>
    <AdobeCode>{8CBC250C-ABE4-4002-8CFD-538C2C7702DC}</AdobeCode>
    <AdobeCode>{0846CC39-F772-4844-A1E7-BD93A5777809}</AdobeCode>
    <AdobeCode>{1F9DB494-E27E-4935-8BCA-95DC3376FF37}</AdobeCode>
    <AdobeCode>{63566063-A63D-4D5B-BB93-7BCC5C807E79}</AdobeCode>
    <AdobeCode>{E4FAD8FE-2785-427A-8E30-77789813B973}</AdobeCode>
    <AdobeCode>{3049B15E-D102-4B6C-B0BC-B9CFDC566814}</AdobeCode>
    <AdobeCode>{F140ECF2-386F-4FF2-B61A-88211FB42EC4}</AdobeCode>
    <AdobeCode>{AF57B438-88F9-4F8C-94D0-82F6E82AE41D}</AdobeCode>
    <AdobeCode>{1DA8A828-D6B9-4B93-842A-FE112FA5E340}</AdobeCode>
    <AdobeCode>{D9F5E1E0-3346-4DE0-9020-699295597704}</AdobeCode>
    <AdobeCode>{05D7DBF3-8AB4-4360-BF01-B98F275CE7E2}</AdobeCode>
    <AdobeCode>{9109F37E-D997-49E8-88F1-F4C82FA512E9}</AdobeCode>
    <AdobeCode>{B21E519D-8E6F-4CF9-878A-9B10A0FEB0EB}</AdobeCode>
    <AdobeCode>{5E6C59B3-C636-424E-9AFF-63D61E326EA9}</AdobeCode>
    <AdobeCode>{F403E95A-F21B-4FE6-AAE6-3AA286737ABE}</AdobeCode>
    <AdobeCode>{C2E5E5CC-7C97-4F48-8EF4-6DD0A0EB2DB2}</AdobeCode>
    <AdobeCode>{618706AE-9497-47E5-934B-F300B6EB28FF}</AdobeCode>
    <AdobeCode>{616A2F66-88B3-4681-9A35-417C7FBF2896}</AdobeCode>
    <AdobeCode>{04E9E15C-771E-4535-AEE9-F97C2434A8EB}</AdobeCode>
    <AdobeCode>{50B0C9FA-3BA8-40E4-9615-7A6536D6B1DB}</AdobeCode>
    <AdobeCode>{067AC297-7875-415F-B7D4-0F28D6C6190B}</AdobeCode>
    <AdobeCode>{4BDA2EF8-2C12-4ED9-AE9F-0B147DDB1712}</AdobeCode>
  </Upgrades><Conflicts>
    <AdobeCode>{74AED914-0785-40C3-ADBD-7B416B24458D}</AdobeCode>
  </Conflicts><Channel enable="1" id="AIRForAppleIOSFlashPro12.0">
    <DisplayName>AIR for Apple iOS support (FP)</DisplayName>
  </Channel><InstallDestinationMetadata relocatableSize="951019" sysDriveSize="1022"><Destination>
      <Root>[INSTALLDIR]</Root>
      <TotalSize>951019</TotalSize>
      <MaxPathComponent>/Adobe Flash CS6/AIR3.2/lib/aot/bin/as\arm-apple-darwin9-as.exe</MaxPathComponent>
    </Destination>
    <Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>1022</TotalSize>
      <MaxPathComponent>/Adobe Flash CS6\air_app_24.png</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="1022"/>
      <Asset flag="1" name="Assets1_1" size="951019"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	</Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="ar_AE">3.0.0</Value>
      <Value lang="be_BY">3.0.0</Value>
      <Value lang="bg_BG">3.0.0</Value>
      <Value lang="ca_ES">3.0.0</Value>
      <Value lang="cs_CZ">3.0.0</Value>
      <Value lang="da_DK">3.0.0</Value>
      <Value lang="de_DE">3.0.0</Value>
      <Value lang="el_GR">3.0.0</Value>
      <Value lang="en_GB">3.0.0</Value>
      <Value lang="en_MX">3.0.0</Value>
      <Value lang="en_US">3.0.0</Value>
      <Value lang="en_XC">3.0.0</Value>
      <Value lang="en_XM">3.0.0</Value>
      <Value lang="es_ES">3.0.0</Value>
      <Value lang="es_MX">3.0.0</Value>
      <Value lang="es_QM">3.0.0</Value>
      <Value lang="et_EE">3.0.0</Value>
      <Value lang="fi_FI">3.0.0</Value>
      <Value lang="fr_CA">3.0.0</Value>
      <Value lang="fr_FR">3.0.0</Value>
      <Value lang="fr_MX">3.0.0</Value>
      <Value lang="fr_XM">3.0.0</Value>
      <Value lang="he_IL">3.0.0</Value>
      <Value lang="hi_IN">3.0.0</Value>
      <Value lang="hr_HR">3.0.0</Value>
      <Value lang="hu_HU">3.0.0</Value>
      <Value lang="is_IS">3.0.0</Value>
      <Value lang="it_IT">3.0.0</Value>
      <Value lang="ja_JP">3.0.0</Value>
      <Value lang="ko_KR">3.0.0</Value>
      <Value lang="lt_LT">3.0.0</Value>
      <Value lang="lv_LV">3.0.0</Value>
      <Value lang="mk_MK">3.0.0</Value>
      <Value lang="nb_NO">3.0.0</Value>
      <Value lang="nl_NL">3.0.0</Value>
      <Value lang="nn_NO">3.0.0</Value>
      <Value lang="no_NO">3.0.0</Value>
      <Value lang="pl_PL">3.0.0</Value>
      <Value lang="pt_BR">3.0.0</Value>
      <Value lang="ro_RO">3.0.0</Value>
      <Value lang="ru_RU">3.0.0</Value>
      <Value lang="sh_YU">3.0.0</Value>
      <Value lang="sk_SK">3.0.0</Value>
      <Value lang="sl_SI">3.0.0</Value>
      <Value lang="sq_AL">3.0.0</Value>
      <Value lang="sv_SE">3.0.0</Value>
      <Value lang="th_TH">3.0.0</Value>
      <Value lang="tr_TR">3.0.0</Value>
      <Value lang="uk_UA">3.0.0</Value>
      <Value lang="vi_VN">3.0.0</Value>
      <Value lang="zh_CN">3.0.0</Value>
      <Value lang="zh_TW">3.0.0</Value>
      <Value lang="en_AE">3.0.0</Value>
      <Value lang="en_IL">3.0.0</Value>
      <Value lang="fr_MA">3.0.0</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="ar_AE">AIR for Apple iOS support (FP)</Value>
      <Value lang="be_BY">AIR for Apple iOS support (FP)</Value>
      <Value lang="bg_BG">AIR for Apple iOS support (FP)</Value>
      <Value lang="ca_ES">AIR for Apple iOS support (FP)</Value>
      <Value lang="cs_CZ">AIR for Apple iOS support (FP)</Value>
      <Value lang="da_DK">AIR for Apple iOS support (FP)</Value>
      <Value lang="de_DE">AIR for Apple iOS support (FP)</Value>
      <Value lang="el_GR">AIR for Apple iOS support (FP)</Value>
      <Value lang="en_GB">AIR for Apple iOS support (FP)</Value>
      <Value lang="en_MX">AIR for Apple iOS support (FP)</Value>
      <Value lang="en_US">AIR for Apple iOS support (FP)</Value>
      <Value lang="en_XC">AIR for Apple iOS support (FP)</Value>
      <Value lang="en_XM">AIR for Apple iOS support (FP)</Value>
      <Value lang="es_ES">AIR for Apple iOS support (FP)</Value>
      <Value lang="es_MX">AIR for Apple iOS support (FP)</Value>
      <Value lang="es_QM">AIR for Apple iOS support (FP)</Value>
      <Value lang="et_EE">AIR for Apple iOS support (FP)</Value>
      <Value lang="fi_FI">AIR for Apple iOS support (FP)</Value>
      <Value lang="fr_CA">AIR for Apple iOS support (FP)</Value>
      <Value lang="fr_FR">AIR for Apple iOS support (FP)</Value>
      <Value lang="fr_MX">AIR for Apple iOS support (FP)</Value>
      <Value lang="fr_XM">AIR for Apple iOS support (FP)</Value>
      <Value lang="he_IL">AIR for Apple iOS support (FP)</Value>
      <Value lang="hi_IN">AIR for Apple iOS support (FP)</Value>
      <Value lang="hr_HR">AIR for Apple iOS support (FP)</Value>
      <Value lang="hu_HU">AIR for Apple iOS support (FP)</Value>
      <Value lang="is_IS">AIR for Apple iOS support (FP)</Value>
      <Value lang="it_IT">AIR for Apple iOS support (FP)</Value>
      <Value lang="ja_JP">AIR for Apple iOS support (FP)</Value>
      <Value lang="ko_KR">AIR for Apple iOS support (FP)</Value>
      <Value lang="lt_LT">AIR for Apple iOS support (FP)</Value>
      <Value lang="lv_LV">AIR for Apple iOS support (FP)</Value>
      <Value lang="mk_MK">AIR for Apple iOS support (FP)</Value>
      <Value lang="nb_NO">AIR for Apple iOS support (FP)</Value>
      <Value lang="nl_NL">AIR for Apple iOS support (FP)</Value>
      <Value lang="nn_NO">AIR for Apple iOS support (FP)</Value>
      <Value lang="no_NO">AIR for Apple iOS support (FP)</Value>
      <Value lang="pl_PL">AIR for Apple iOS support (FP)</Value>
      <Value lang="pt_BR">AIR for Apple iOS support (FP)</Value>
      <Value lang="ro_RO">AIR for Apple iOS support (FP)</Value>
      <Value lang="ru_RU">AIR for Apple iOS support (FP)</Value>
      <Value lang="sh_YU">AIR for Apple iOS support (FP)</Value>
      <Value lang="sk_SK">AIR for Apple iOS support (FP)</Value>
      <Value lang="sl_SI">AIR for Apple iOS support (FP)</Value>
      <Value lang="sq_AL">AIR for Apple iOS support (FP)</Value>
      <Value lang="sv_SE">AIR for Apple iOS support (FP)</Value>
      <Value lang="th_TH">AIR for Apple iOS support (FP)</Value>
      <Value lang="tr_TR">AIR for Apple iOS support (FP)</Value>
      <Value lang="uk_UA">AIR for Apple iOS support (FP)</Value>
      <Value lang="vi_VN">AIR for Apple iOS support (FP)</Value>
      <Value lang="zh_CN">AIR for Apple iOS support (FP)</Value>
      <Value lang="zh_TW">AIR for Apple iOS support (FP)</Value>
      <Value lang="en_AE">AIR for Apple iOS support (FP)</Value>
      <Value lang="en_IL">AIR for Apple iOS support (FP)</Value>
      <Value lang="fr_MA">AIR for Apple iOS support (FP)</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "0" , "WorkflowVersion", "CS6")
INSERT INTO PayloadData VALUES("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "0" , "DEVersion", "6.0")
INSERT INTO PayloadData VALUES("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "0", "ChannelID", "AIRForAppleIOSFlashPro12.0")
INSERT INTO PayloadData VALUES("{D2583A3E-399C-45D7-8AF1-FE5BAFC946CF}", "0", "ChannelInfo", '<Channel enable="1" id="AIRForAppleIOSFlashPro12.0">
    <DisplayName>AIR for Apple iOS support (FP)</DisplayName>
  </Channel>')
